/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.InputStream;

public class LengthCheckingInputStream
extends InputStream {
    private static final String STREAM_IS_LONGER_THAN_SPECIFIED = "Stream is longer than specified";
    private static final String EOF_REACHED_PREMATURELY = "EOF reached prematurely";
    private long remaining;
    private long readSinceMark;
    private final InputStream in;

    public LengthCheckingInputStream(InputStream in, long length) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        if (length < 0L) {
            throw new IllegalArgumentException();
        }
        this.in = in;
        this.remaining = length;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r == -1) {
            if (this.remaining > 0L) {
                throw new IOException(EOF_REACHED_PREMATURELY);
            }
        } else {
            ++this.readSinceMark;
            --this.remaining;
            if (this.remaining < 0L) {
                throw new IOException(STREAM_IS_LONGER_THAN_SPECIFIED);
            }
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r == -1) {
            if (this.remaining > 0L) {
                throw new IOException(EOF_REACHED_PREMATURELY);
            }
        } else {
            this.readSinceMark += (long)r;
            this.remaining -= (long)r;
            if (this.remaining < 0L) {
                throw new IOException(STREAM_IS_LONGER_THAN_SPECIFIED);
            }
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.in.skip(n);
        this.remaining -= r;
        this.readSinceMark += r;
        if (this.remaining < 0L) {
            throw new IOException(STREAM_IS_LONGER_THAN_SPECIFIED);
        }
        return r;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.remaining += this.readSinceMark;
        this.readSinceMark = 0L;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.readSinceMark = 0L;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

