/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def.http;

import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.vc.xml.XMLVCHelper;
import com.urbancode.commons.xml.DOMUtils;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPropInfoVCHelper
extends XMLVCHelper<HttpPropInfo> {
    public static final String HTTP_PROP_INFO_ELEMENT = "httpPropInfo";
    public static final String HTTP_PROP_INFO_ELEMENTS = "httpPropInfos";
    public static final String ID_ELEMENT = "id";
    public static final String PROP_DEF_ID_ELEMENT = "prop_def_id";
    public static final String URL_ELEMENT = "url";
    public static final String FORMAT_ELEMENT = "format";
    public static final String USERNAME_ELEMENT = "username";
    public static final String PASSWORD_ELEMENT = "password";
    public static final String BASE_PATH_ELEMENT = "basePath";
    public static final String VALUE_PATH_ELEMENT = "valuePath";
    public static final String LABEL_PATH_ELEMENT = "labelPath";
    public static final String AUTHENTICATION_TYPE_ELEMENT = "authType";
    public static final String RESOLVE_HTTP_VALUES_ELEMENT = "resolveHttpUrl";

    public HttpPropInfo toObject(Element element) {
        HttpPropInfo result = new HttpPropInfo();
        result.id = UUID.fromString(DOMUtils.getFirstChild((Element)element, (String)ID_ELEMENT).getTextContent());
        result.url = DOMUtils.getFirstChild((Element)element, (String)URL_ELEMENT).getTextContent();
        result.formatName = DOMUtils.getFirstChild((Element)element, (String)FORMAT_ELEMENT).getTextContent();
        result.username = DOMUtils.getFirstChild((Element)element, (String)USERNAME_ELEMENT).getTextContent();
        result.password = DOMUtils.getFirstChild((Element)element, (String)PASSWORD_ELEMENT).getTextContent();
        result.basePath = DOMUtils.getFirstChild((Element)element, (String)BASE_PATH_ELEMENT).getTextContent();
        result.valuePath = DOMUtils.getFirstChild((Element)element, (String)VALUE_PATH_ELEMENT).getTextContent();
        result.labelPath = DOMUtils.getFirstChild((Element)element, (String)LABEL_PATH_ELEMENT).getTextContent();
        result.resolveHttpValuesUrl = DOMUtils.getFirstChild((Element)element, (String)RESOLVE_HTTP_VALUES_ELEMENT) != null ? DOMUtils.getFirstChild((Element)element, (String)RESOLVE_HTTP_VALUES_ELEMENT).getTextContent() : "";
        result.authenticationType = DOMUtils.getFirstChild((Element)element, (String)AUTHENTICATION_TYPE_ELEMENT) != null ? DOMUtils.getFirstChild((Element)element, (String)AUTHENTICATION_TYPE_ELEMENT).getTextContent() : HttpPropInfo.HttpAuthenticationType.BASIC.toString();
        return result;
    }

    public Element toXML(HttpPropInfo hpi, Document doc) {
        Element httpInfoElement = doc.createElement(this.getObjectElementName());
        Element id = this.createTextElement(doc, ID_ELEMENT, hpi.getId().toString());
        httpInfoElement.appendChild(id);
        Element propDefId = this.createTextElement(doc, PROP_DEF_ID_ELEMENT, hpi.getPropDef().getId().toString());
        httpInfoElement.appendChild(propDefId);
        Element url = this.createTextElement(doc, URL_ELEMENT, hpi.getUrl());
        httpInfoElement.appendChild(url);
        Element username = this.createTextElement(doc, USERNAME_ELEMENT, hpi.getUsername());
        httpInfoElement.appendChild(username);
        Element password = this.createTextElement(doc, PASSWORD_ELEMENT, hpi.getPassword());
        httpInfoElement.appendChild(password);
        Element format = this.createTextElement(doc, FORMAT_ELEMENT, hpi.getFormatName());
        httpInfoElement.appendChild(format);
        Element basePath = this.createTextElement(doc, BASE_PATH_ELEMENT, hpi.getBasePath());
        httpInfoElement.appendChild(basePath);
        Element valuePath = this.createTextElement(doc, VALUE_PATH_ELEMENT, hpi.getValuePath());
        httpInfoElement.appendChild(valuePath);
        Element labelPath = this.createTextElement(doc, LABEL_PATH_ELEMENT, hpi.getLabelPath());
        httpInfoElement.appendChild(labelPath);
        Element authType = this.createTextElement(doc, AUTHENTICATION_TYPE_ELEMENT, hpi.getAuthenticationType());
        httpInfoElement.appendChild(authType);
        Element resolveUrl = this.createTextElement(doc, RESOLVE_HTTP_VALUES_ELEMENT, hpi.getResolveHttpValuesUrl());
        httpInfoElement.appendChild(resolveUrl);
        return httpInfoElement;
    }

    public String getObjectCollectionElementName() {
        return HTTP_PROP_INFO_ELEMENTS;
    }

    public String getObjectElementName() {
        return HTTP_PROP_INFO_ELEMENT;
    }

    public Class<HttpPropInfo> getPersistentClass() {
        return HttpPropInfo.class;
    }
}

