/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.DeliverUtil;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SuspendResumeDiscardChangeSetUtil;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliver;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPreOperationRefresh;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSuspendChangeSets;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemRestClient;
import com.ibm.team.filesystem.client.workitems.IWorkItemOperationFactory;
import com.ibm.team.filesystem.client.workitems.internal.LocateChangeSetsUtil;
import com.ibm.team.filesystem.client.workitems.operations.DeliverAndFixDilemmaHandler;
import com.ibm.team.filesystem.client.workitems.operations.DeliverAndFixParameter;
import com.ibm.team.filesystem.client.workitems.operations.IDeliverAndFixOperation;
import com.ibm.team.filesystem.client.workitems.operations.ISubmitForReviewOperation;
import com.ibm.team.filesystem.client.workitems.operations.SubmitForReviewDilemmaHandler;
import com.ibm.team.filesystem.client.workitems.operations.SubmitForReviewParameter;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsChangeSetsToSource;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsPostChangeSetWorkItem;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsPostDeliverAndResolve;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsPostSubmitForReview;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsWorkItem;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsWorkItemHierarchy;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliverResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ChangeSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ContributorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.CommitDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.UpdateDilemmaDTO;
import com.ibm.team.filesystem.common.workitems.internal.hierarchy.FilesystemWorkItemsRestDTOhierarchyFactory;
import com.ibm.team.filesystem.common.workitems.internal.hierarchy.WorkItemHierarchyNodeDTO;
import com.ibm.team.filesystem.common.workitems.internal.hierarchy.WorkItemHierarchyRootDTO;
import com.ibm.team.filesystem.common.workitems.internal.rest.DeliverAndResolveResultDTO;
import com.ibm.team.filesystem.common.workitems.internal.rest.FilesystemWorkItemsRestDTOFactory;
import com.ibm.team.filesystem.common.workitems.internal.rest.SubmitForReviewResultDTO;
import com.ibm.team.filesystem.common.workitems.internal.rest.WorkItemDTO;
import com.ibm.team.filesystem.common.workitems.internal.rest.WorkItemResultDTO;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.util.RestUtils;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class FileSystemWorkItemRestClient
implements IFileSystemWorkItemRestClient {
    private static final UUID NULL_STATE = null;

    @Override
    public void postAddWorkItem(ParmsPostChangeSetWorkItem parms, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        if (!repo.loggedIn()) {
            repo.login(null);
        }
        IWorkspace workspace = null;
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.changeSetId), NULL_STATE);
        IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.workItemItemId), NULL_STATE);
        if (RestUtils.isSet((String)parms.workspaceId)) {
            IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.workspaceId), NULL_STATE);
            IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(wsHandle, monitor);
            workspace = connection.getResolvedWorkspace();
        }
        IFileSystemWorkItemManager manager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        manager.createLink((IWorkspaceHandle)workspace, changeSetHandle, new IWorkItemHandle[]{workItemHandle}, monitor);
    }

    @Override
    public void postRemoveWorkItem(ParmsPostChangeSetWorkItem parms, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        if (!repo.loggedIn()) {
            repo.login(null);
        }
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.changeSetId), NULL_STATE);
        IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.workItemItemId), NULL_STATE);
        IFileSystemWorkItemManager manager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        ProviderFactory providerFactory = (ProviderFactory)repo.getClientLibrary(ProviderFactory.class);
        List links = ChangeSetLinks.findLinks((ProviderFactory)providerFactory, (IChangeSetHandle)changeSetHandle, (String[])new String[]{"com.ibm.team.filesystem.workitems.change_set"}, (IProgressMonitor)monitor);
        ILink linkToRemove = null;
        for (ILink link : links) {
            IItemHandle refHandle;
            IReference targetRef = link.getTargetRef();
            if (!targetRef.isItemReference() || !((refHandle = ((IItemReference)targetRef).getReferencedItem()) instanceof IWorkItemHandle) || !refHandle.sameItemId((IItemHandle)workItemHandle)) continue;
            linkToRemove = link;
        }
        manager.deleteLinks(Collections.singletonList(linkToRemove), monitor);
    }

    @Override
    public DeliverAndResolveResultDTO postDeliverAndResolve(ParmsPostDeliverAndResolve parms, IProgressMonitor progress) throws TeamRepositoryException {
        ParmsWorkItem[] changeSetHandle;
        int n;
        int n2;
        String[] stringArray;
        ITeamRepository repo;
        boolean addReview;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection source = parms.source.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        IWorkspaceConnection target = parms.target.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        HashSet<IChangeSetHandle> changeSetHandles = new HashSet<IChangeSetHandle>();
        ArrayList<IWorkItemHandle> workItemHandles = new ArrayList<IWorkItemHandle>();
        HashSet<IContributorHandle> reviewers = new HashSet<IContributorHandle>();
        boolean shouldResolve = parms.shouldResolve;
        boolean bl = addReview = parms.reviewers != null;
        if (addReview) {
            repo = parms.reviewers.getTeamRepository();
            stringArray = parms.reviewers.contributorItemIds;
            n2 = parms.reviewers.contributorItemIds.length;
            n = 0;
            while (n < n2) {
                String reviewer = stringArray[n];
                reviewers.add((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)reviewer), null));
                ++n;
            }
        }
        repo = CommonUtil.getTeamRepository((String)parms.source.repositoryUrl);
        stringArray = parms.changeSets;
        n2 = parms.changeSets.length;
        n = 0;
        while (n < n2) {
            String changeSetId = stringArray[n];
            changeSetHandle = (ParmsWorkItem[])IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)changeSetId), NULL_STATE);
            changeSetHandles.add((IChangeSetHandle)changeSetHandle);
            ++n;
        }
        SubMonitor iterMonitor = monitor.newChild(10);
        iterMonitor.setWorkRemaining(parms.workItemIds.length);
        changeSetHandle = parms.workItemIds;
        int n3 = parms.workItemIds.length;
        n2 = 0;
        while (n2 < n3) {
            ParmsWorkItem parmWorkItem = changeSetHandle[n2];
            workItemHandles.add(parmWorkItem.getWorkItem((IProgressMonitor)iterMonitor.newChild(1)));
            ++n2;
        }
        IChangeHistorySyncReport syncReport = source.compareTo((IFlowNodeConnection)target, 1, Collections.EMPTY_LIST, null);
        repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.source.repositoryUrl);
        IContributorHandle[] reviewList = new IContributorHandle[reviewers.size()];
        DeliverAndFixParameter opParms = new DeliverAndFixParameter(changeSetHandles, parms.workItemComment, parms.approvalSubject, reviewers.toArray(reviewList), workItemHandles, syncReport, source, target, shouldResolve, parms.dueDate != null ? new Timestamp(parms.dueDate) : null);
        ParmsDeliver deliverParms = new ParmsDeliver();
        deliverParms.sandboxUpdateDilemmaHandler = parms.sandboxUpdateDilemmaHandler;
        deliverParms.deliverDilemmaHandler = parms.deliverHandler;
        deliverParms.updateDilemmaHandler = parms.updateDilemmaHandler;
        deliverParms.pendingChangesDilemmaHandler = parms.pendingChangesHandler;
        final DeliverAndResolveResultDTO result = FilesystemWorkItemsRestDTOFactory.eINSTANCE.createDeliverAndResolveResultDTO();
        final DeliverDilemmaHandler deliverDilemmaHandler = DeliverUtil.getDeliverDilemmaHandler((ParmsDeliver)deliverParms, (DeliverResultDTO)result, (IProgressMonitor)monitor.newChild(10));
        int wiAction = 2;
        if (parms.workItemHandler != null) {
            String action = parms.workItemHandler.unreachableWorkItemInstruction;
            if ("continue".equals(action)) {
                wiAction = 0;
            } else if ("cancel".equals(action)) {
                wiAction = 1;
            }
        }
        final int unreachableWorkItemAction = wiAction;
        DeliverAndFixDilemmaHandler dilemmaHandler = new DeliverAndFixDilemmaHandler(){

            @Override
            public DeliverDilemmaHandler getDeliverDilemmaHandler() {
                return deliverDilemmaHandler;
            }

            @Override
            public int workItemsUnreachable(int numUnreachable, int total) {
                WorkItemResultDTO workItemResult = FilesystemWorkItemsRestDTOFactory.eINSTANCE.createWorkItemResultDTO();
                workItemResult.setNumberOfUnreachableWorkItems(numUnreachable);
                workItemResult.setTotalWorkItems(total);
                result.setWorkItemResult(workItemResult);
                return unreachableWorkItemAction;
            }
        };
        IDeliverAndFixOperation deliverAndFixOperation = IWorkItemOperationFactory.instance.getDeliverAndResolveOperation(dilemmaHandler);
        deliverAndFixOperation.deliverAndFix(opParms);
        RefreshUtil.configureRefresh((ParmsPreOperationRefresh)parms.preOpRefresh, (IRefreshingOperation)deliverAndFixOperation);
        CommitUtil.configureCommit((ParmsPendingChangesDilemmaHandler)parms.pendingChangesHandler, (ICheckinOptions)deliverAndFixOperation);
        try {
            deliverAndFixOperation.run((IProgressMonitor)monitor.newChild(60));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    @Override
    public SubmitForReviewResultDTO postSubmitForReview(ParmsPostSubmitForReview parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        HashSet<IContributorHandle> reviewers = new HashSet<IContributorHandle>();
        HashSet<IChangeSetHandle> changeSetHandles = new HashSet<IChangeSetHandle>();
        HashSet<SubmitForReviewParameter.ChangeSetReview> changeSetReviews = new HashSet<SubmitForReviewParameter.ChangeSetReview>();
        ArrayList<IWorkItemHandle> workItemHandles = new ArrayList<IWorkItemHandle>();
        ITeamRepository repo = parms.reviewers.getTeamRepository();
        Object[] objectArray = parms.reviewers.contributorItemIds;
        int n = parms.reviewers.contributorItemIds.length;
        int n2 = 0;
        while (n2 < n) {
            String reviewer = objectArray[n2];
            reviewers.add((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)reviewer), null));
            ++n2;
        }
        objectArray = parms.changeSetsToReview;
        n = parms.changeSetsToReview.length;
        n2 = 0;
        while (n2 < n) {
            Object changeSetsToReview = objectArray[n2];
            String[] stringArray = ((ParmsChangeSetsToSource)changeSetsToReview).changeSetIds;
            int n3 = ((ParmsChangeSetsToSource)changeSetsToReview).changeSetIds.length;
            int n4 = 0;
            while (n4 < n3) {
                String changeSetId = stringArray[n4];
                IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)changeSetId), NULL_STATE);
                IWorkspaceConnection source = ((ParmsChangeSetsToSource)changeSetsToReview).source.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
                SubmitForReviewParameter.ChangeSetReview changeSetReview = new SubmitForReviewParameter.ChangeSetReview(changeSetHandle, source);
                changeSetReviews.add(changeSetReview);
                changeSetHandles.add(changeSetHandle);
                ++n4;
            }
            ++n2;
        }
        objectArray = parms.workItemIds;
        n = parms.workItemIds.length;
        n2 = 0;
        while (n2 < n) {
            Object parmWorkItem = objectArray[n2];
            workItemHandles.add(((ParmsWorkItem)parmWorkItem).getWorkItem((IProgressMonitor)monitor.newChild(5)));
            ++n2;
        }
        IContributorHandle[] reviewList = new IContributorHandle[reviewers.size()];
        final SubmitForReviewResultDTO result = FilesystemWorkItemsRestDTOFactory.eINSTANCE.createSubmitForReviewResultDTO();
        SubmitForReviewParameter opParms = new SubmitForReviewParameter(parms.workItemComment, reviewers.toArray(reviewList), parms.suspendChangeSets, parms.approvalSubject, workItemHandles, changeSetReviews, repo, parms.dueDate != null ? new Timestamp(parms.dueDate) : null);
        ParmsSuspendChangeSets suspendParms = new ParmsSuspendChangeSets();
        suspendParms.sandboxUpdateDilemmaHandler = parms.sandboxUpdateDilemmaHandler;
        suspendParms.outOfSyncInstructions = parms.outOfSyncInstructions;
        suspendParms.pendingChangesDilemmaHandler = parms.pendingChangesHandler;
        final SuspendDilemmaHandler suspendDilemmaHandler = SuspendResumeDiscardChangeSetUtil.getSuspendDilemmaHandler((ParmsSuspendChangeSets)suspendParms, (List)result.getOutOfSyncShares(), (List)result.getConfigurationsWithUncheckedInChanges(), (CommitDilemmaDTO)result.getCommitDilemma(), (SandboxUpdateDilemmaDTO)result.getSandboxUpdateDilemma(), (UpdateDilemmaDTO)result.getUpdateDilemma(), (IProgressMonitor)monitor.newChild(5));
        int wiAction = 2;
        if (parms.workItemHandler != null) {
            String action = parms.workItemHandler.unreachableWorkItemInstruction;
            if ("continue".equals(action)) {
                wiAction = 0;
            } else if ("cancel".equals(action)) {
                wiAction = 1;
            }
        }
        final int unreachableWorkItemAction = wiAction;
        SubmitForReviewDilemmaHandler dilemmaHandler = new SubmitForReviewDilemmaHandler(){

            @Override
            public SuspendDilemmaHandler getSuspendDilemmaHandler() {
                return suspendDilemmaHandler;
            }

            @Override
            public int workItemsUnreachable(int numUnreachable, int total) {
                WorkItemResultDTO workItemResult = FilesystemWorkItemsRestDTOFactory.eINSTANCE.createWorkItemResultDTO();
                workItemResult.setNumberOfUnreachableWorkItems(numUnreachable);
                workItemResult.setTotalWorkItems(total);
                result.setWorkItemResult(workItemResult);
                return unreachableWorkItemAction;
            }
        };
        ISubmitForReviewOperation submitOp = IWorkItemOperationFactory.instance.getSubmitForReviewOperation(dilemmaHandler);
        submitOp.submitForReview(opParms);
        RefreshUtil.configureRefresh((ParmsPreOperationRefresh)parms.preOpRefresh, (IRefreshingOperation)submitOp);
        CommitUtil.configureCommit((ParmsPendingChangesDilemmaHandler)parms.pendingChangesHandler, (ICheckinOptions)submitOp);
        try {
            submitOp.run((IProgressMonitor)monitor.newChild(85));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    @Override
    public WorkItemHierarchyRootDTO getWorkItemHierarchy(ParmsWorkItemHierarchy parms, IProgressMonitor monitor) throws TeamRepositoryException {
        Collection<LocateChangeSetsUtil.LcsEditorWorkItemEntry> rootEntries;
        Collection<LocateChangeSetsUtil.LcsEditorEntry> unassignedRoots;
        int n;
        int n2;
        Object[] objectArray;
        parms.validate("getWorkItemHierarchy", new Object[0]);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        LocateChangeSetsUtil.ParmsGetLcsEditorChangeSets lcsParms = new LocateChangeSetsUtil.ParmsGetLcsEditorChangeSets();
        lcsParms.repo = CommonUtil.getTeamRepository((String)parms.repositoryUrl);
        lcsParms.maxChildWorkItemsDepth = parms.searchDepth;
        lcsParms.maxChangeSets = -1;
        lcsParms.maxWorkItems = -1;
        lcsParms.changeSets = new ArrayList<IChangeSetHandle>();
        if (parms.changeSets != null) {
            objectArray = parms.changeSets;
            n2 = parms.changeSets.length;
            n = 0;
            while (n < n2) {
                ParmsChangeSet changeSet = objectArray[n];
                lcsParms.changeSets.add(CommonUtil.createChangeSetHandle((ITeamRepository)lcsParms.repo, (String)changeSet.changeSetItemId));
                ++n;
            }
        }
        lcsParms.workItems = new ArrayList<IWorkItemHandle>();
        if (parms.workItems != null) {
            objectArray = parms.workItems;
            n2 = parms.workItems.length;
            n = 0;
            while (n < n2) {
                ParmsChangeSet workItem = objectArray[n];
                lcsParms.workItems.add((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)lcsParms.repo, UUID.valueOf((String)workItem.workItemId), null));
                ++n;
            }
        }
        progress.worked(5);
        LocateChangeSetsUtil.LcsEditorChangeSetsResult result = LocateChangeSetsUtil.getLcsEditorChangeSets(lcsParms, (IProgressMonitor)progress.newChild(60));
        HashMap<UUID, IContributor> contributors = new HashMap<UUID, IContributor>();
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        this.collectItems(lcsParms.repo, result, contributors, components, (IProgressMonitor)progress.newChild(30));
        WorkItemHierarchyRootDTO rootNode = FilesystemWorkItemsRestDTOhierarchyFactory.eINSTANCE.createWorkItemHierarchyRootDTO();
        LocateChangeSetsUtil.LcsEditorUnassignedWorkItemEntry uaEntry = result.getUnassignedRoot();
        if (uaEntry != null && (unassignedRoots = uaEntry.getChildren()) != null) {
            for (LocateChangeSetsUtil.LcsEditorEntry entry : unassignedRoots) {
                if (!(entry instanceof LocateChangeSetsUtil.LcsEditorChangeSetEntry)) continue;
                LocateChangeSetsUtil.LcsEditorChangeSetEntry csEntry = (LocateChangeSetsUtil.LcsEditorChangeSetEntry)entry;
                ChangeSetDTO changeSet = this.createChangeSetDTO(lcsParms.repo, csEntry, contributors, components);
                rootNode.getChangeSets().add(changeSet);
            }
        }
        if ((rootEntries = result.getRoots()) != null) {
            for (LocateChangeSetsUtil.LcsEditorWorkItemEntry wiEntry : rootEntries) {
                WorkItemHierarchyNodeDTO wiNode = this.createWorkItemNode(lcsParms.repo, wiEntry, contributors, components);
                rootNode.getChildren().add(wiNode);
            }
        }
        progress.worked(5);
        return rootNode;
    }

    private void collectItems(ITeamRepository repo, LocateChangeSetsUtil.LcsEditorChangeSetsResult result, Map<UUID, IContributor> contributorsMap, Map<UUID, IComponent> componentsMap, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IContributorHandle> contributorHandles = new ArrayList<IContributorHandle>();
        ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
        this.collectHandles(result, contributorHandles, componentHandles);
        List contributors = repo.itemManager().fetchCompleteItems(contributorHandles, 0, (IProgressMonitor)progress.newChild(50));
        List components = repo.itemManager().fetchCompleteItems(componentHandles, 0, (IProgressMonitor)progress.newChild(50));
        for (IContributor contributor : contributors) {
            contributorsMap.put(contributor.getItemId(), contributor);
        }
        for (IComponent component : components) {
            componentsMap.put(component.getItemId(), component);
        }
    }

    private void collectHandles(LocateChangeSetsUtil.LcsEditorChangeSetsResult result, List<IContributorHandle> contributorHandles, List<IComponentHandle> componentHandles) throws TeamRepositoryException {
        this.collectHandles(new ArrayList<LocateChangeSetsUtil.LcsEditorEntry>(result.getRoots()), contributorHandles, componentHandles);
        LocateChangeSetsUtil.LcsEditorUnassignedWorkItemEntry unassignedRoot = result.getUnassignedRoot();
        if (unassignedRoot != null) {
            this.collectHandles(unassignedRoot.getChildren(), contributorHandles, componentHandles);
        }
    }

    private void collectHandles(Collection<LocateChangeSetsUtil.LcsEditorEntry> entries, List<IContributorHandle> contributorHandles, List<IComponentHandle> componentHandles) {
        for (LocateChangeSetsUtil.LcsEditorEntry entry : entries) {
            if (entry instanceof LocateChangeSetsUtil.LcsEditorWorkItemEntry) {
                LocateChangeSetsUtil.LcsEditorWorkItemEntry wiEntry = (LocateChangeSetsUtil.LcsEditorWorkItemEntry)entry;
                this.collectHandles(wiEntry.getChildren(), contributorHandles, componentHandles);
                continue;
            }
            if (!(entry instanceof LocateChangeSetsUtil.LcsEditorChangeSetEntry)) continue;
            LocateChangeSetsUtil.LcsEditorChangeSetEntry csEntry = (LocateChangeSetsUtil.LcsEditorChangeSetEntry)entry;
            IChangeSet changeSet = csEntry.getChangeSet();
            contributorHandles.add(changeSet.getAuthor());
            componentHandles.add(changeSet.getComponent());
            this.collectHandles(csEntry.getChildren(), contributorHandles, componentHandles);
        }
    }

    private WorkItemHierarchyNodeDTO createWorkItemNode(ITeamRepository repo, LocateChangeSetsUtil.LcsEditorWorkItemEntry wiEntry, Map<UUID, IContributor> contributors, Map<UUID, IComponent> components) throws TeamRepositoryException {
        WorkItemHierarchyNodeDTO node = FilesystemWorkItemsRestDTOhierarchyFactory.eINSTANCE.createWorkItemHierarchyNodeDTO();
        WorkItemDTO workItem = this.createWorkItemDTO(wiEntry);
        node.setWorkItem(workItem);
        this.addChildren(repo, node, wiEntry, contributors, components);
        return node;
    }

    private WorkItemDTO createWorkItemDTO(LocateChangeSetsUtil.LcsEditorWorkItemEntry wiEntry) {
        WorkItemDTO workItem = FilesystemWorkItemsRestDTOFactory.eINSTANCE.createWorkItemDTO();
        workItem.setItemId(wiEntry.getWorkItem().getItemId().getUuidValue());
        workItem.setId(wiEntry.getWorkItem().getId());
        workItem.setSummary(wiEntry.getWorkItem().getHTMLSummary().getPlainText());
        return workItem;
    }

    private void addChildren(ITeamRepository repo, WorkItemHierarchyNodeDTO parentNode, LocateChangeSetsUtil.LcsEditorWorkItemEntry parentEntry, Map<UUID, IContributor> contributors, Map<UUID, IComponent> components) throws TeamRepositoryException {
        for (LocateChangeSetsUtil.LcsEditorEntry entry : parentEntry.getChildren()) {
            if (entry instanceof LocateChangeSetsUtil.LcsEditorWorkItemEntry) {
                LocateChangeSetsUtil.LcsEditorWorkItemEntry wiEntry = (LocateChangeSetsUtil.LcsEditorWorkItemEntry)entry;
                WorkItemHierarchyNodeDTO wiNode = this.createWorkItemNode(repo, wiEntry, contributors, components);
                parentNode.getChildren().add(wiNode);
                continue;
            }
            if (!(entry instanceof LocateChangeSetsUtil.LcsEditorChangeSetEntry)) continue;
            LocateChangeSetsUtil.LcsEditorChangeSetEntry csEntry = (LocateChangeSetsUtil.LcsEditorChangeSetEntry)entry;
            ChangeSetDTO changeSet = this.createChangeSetDTO(repo, csEntry, contributors, components);
            parentNode.getChangeSets().add(changeSet);
        }
    }

    private ChangeSetDTO createChangeSetDTO(ITeamRepository repo, LocateChangeSetsUtil.LcsEditorChangeSetEntry csEntry, Map<UUID, IContributor> contributors, Map<UUID, IComponent> components) throws TeamRepositoryException {
        ChangeSetDTO changeSetDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createChangeSetDTO();
        changeSetDTO.setItemId(csEntry.getChangeSet().getItemId().getUuidValue());
        changeSetDTO.setComment(csEntry.getChangeSet().getComment());
        changeSetDTO.setLastChangeDate(csEntry.getChangeSet().getLastChangeDate().getTime());
        IContributorHandle contributorHandle = csEntry.getChangeSet().getAuthor();
        IContributor contributor = contributors.get(contributorHandle.getItemId());
        ContributorDTO contributorDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createContributorDTO();
        contributorDTO.setFullName(contributor.getName());
        contributorDTO.setEmailAddress(contributor.getEmailAddress());
        contributorDTO.setUserId(contributor.getUserId());
        contributorDTO.setContributorItemId(contributor.getItemId().getUuidValue());
        changeSetDTO.setAuthor(contributorDTO);
        IComponentHandle componentHandle = csEntry.getChangeSet().getComponent();
        IComponent component = components.get(componentHandle.getItemId());
        ComponentDTO componentDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
        componentDTO.setItemId(component.getItemId().getUuidValue());
        componentDTO.setName(component.getName());
        changeSetDTO.setComponent(componentDTO);
        return changeSetDTO;
    }
}

