/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.operations;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.TeamBuildStateException;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.operations.Messages;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class BuildResultUpdater {
    private static final String ELIPSIS = "...";
    private static final int MAX_LABEL_LENGTH = 250 - "...".length();
    private IBuildResultHandle _buildResultHandle;
    private ITeamRepository _repo;
    private UUID _buildResultUuid;
    private int _stackTraces = 0;
    private String _topLevelActivityId = null;

    public BuildResultUpdater(ITeamRepository repo, String buildResultUuidString) {
        this._repo = repo;
        this._buildResultUuid = UUID.valueOf((String)buildResultUuidString);
        this._buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(this._buildResultUuid, null);
    }

    public void contribute(String label, String fileName, BuildStatus status, Contributor contributor) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(outputStream);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ps, "UTF-8");
        PrintWriter printer = new PrintWriter(new BufferedWriter(writer));
        contributor.writeContribution(printer);
        printer.flush();
        ByteArrayInputStream contribution = new ByteArrayInputStream(outputStream.toByteArray());
        IContent traceContent = this._repo.contentManager().storeContent("text/plain", "UTF-8", LineDelimiter.LINE_DELIMITER_NONE, (InputStream)contribution, null, null);
        this.contributeContent(traceContent, label, fileName, status);
    }

    public void contributeExceptionStackTrace(final Throwable exceptionToContribute) {
        try {
            String tag = Messages.BuildResultUpdater_SYNC_STACK_TRACE;
            String fileName = NLS.bind((String)Messages.BuildResultUpdater_SYNC_STACK_TRACE_WITH_FILENAME, (Object)String.valueOf(this._stackTraces++));
            this.contribute(tag, fileName, BuildStatus.ERROR, new Contributor(){

                @Override
                public void writeContribution(PrintWriter writer) throws WvcmException {
                    exceptionToContribute.printStackTrace(writer);
                }
            });
        }
        catch (Exception exceptionToLog) {
            exceptionToLog.printStackTrace();
        }
    }

    private void contributeContent(IContent content, String label, String fileName, BuildStatus status) throws Exception {
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setLabel(label);
        contribution.setImpactsPrimaryResult(true);
        contribution.setStatus(status);
        contribution.setExtendedContributionTypeId(IBuildResultContribution.LOG_EXTENDED_CONTRIBUTION_ID);
        contribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME, fileName);
        contribution.setExtendedContributionData(content);
        this.getTeamBuildClient().addBuildResultContribution(this.getBuildResultHandle(), contribution, null);
    }

    public void setCompletionStatus(boolean syncEndedWithoutConflicts) throws WvcmException {
        try {
            ITeamBuildClient teamBuildClient = this.getTeamBuildClient();
            if (!syncEndedWithoutConflicts) {
                IBuildResult result = (IBuildResult)this.getBuildResult(null).getWorkingCopy();
                result.setStatus(BuildStatus.WARNING);
                teamBuildClient.save(result, null);
            }
            teamBuildClient.completeBuildActivity(this.getBuildResultHandle(), this._topLevelActivityId, null);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
    }

    private ITeamBuildClient getTeamBuildClient() {
        return (ITeamBuildClient)this._repo.getClientLibrary(ITeamBuildClient.class);
    }

    private String startActivity(String parent, String name) throws WvcmException {
        String activityId = null;
        if (name != null) {
            activityId = this.startBuildActivity(parent, name);
            if (parent == null) {
                this._topLevelActivityId = activityId;
            }
        }
        return activityId;
    }

    private String startBuildActivity(String parentId, String label) throws WvcmException {
        if (label.length() > MAX_LABEL_LENGTH) {
            label = String.valueOf(label.substring(0, MAX_LABEL_LENGTH)) + ELIPSIS;
        }
        try {
            String activityId = this.getTeamBuildClient().startBuildActivity(this.getBuildResultHandle(), label, parentId, true, null);
            return activityId;
        }
        catch (TeamBuildStateException e) {
            throw new WvcmException(Messages.BuildResultUpdater_BUILD_IS_NOT_ACTIVE_QUITTING, null, WvcmException.ReasonCode.ABORTED, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String startTopLevelActivity(String name) throws WvcmException {
        return this.startActivity(null, name);
    }

    public String startNestedActivity(String name) throws WvcmException {
        String activityId = null;
        if (this._topLevelActivityId != null) {
            activityId = this.startActivity(this._topLevelActivityId, name);
        }
        return activityId;
    }

    protected final IBuildResult getBuildResult(String[] properties) throws WvcmException {
        try {
            IBuildResultHandle resultHandle = this.getBuildResultHandle();
            IItemManager itemManager = this._repo.itemManager();
            if (properties == IBuildResult.PROPERTIES_COMPLETE) {
                return (IBuildResult)itemManager.fetchCompleteItem((IItemHandle)resultHandle, 1, null);
            }
            return (IBuildResult)itemManager.fetchPartialItem((IItemHandle)resultHandle, 1, Arrays.asList(properties), null);
        }
        catch (TeamRepositoryException e) {
            String msg = NLS.bind((String)Messages.BuildResultUpdater_ERROR_ITEM_WITH_ID_NOT_FOUND, (Object)IBuildResult.ITEM_TYPE.getName(), (Object)this._buildResultUuid);
            throw JzProvider.wrapExceptionGivenExternalizedMsg((String)msg, (Exception)((Object)e));
        }
    }

    private IBuildResultHandle getBuildResultHandle() {
        return this._buildResultHandle;
    }

    final boolean isBuildStillActive() {
        try {
            IBuildResult buildResult = this.getBuildResult(IBuildResult.PROPERTIES_COMPLETE);
            BuildState buildState = buildResult.getState();
            return buildState == BuildState.NOT_STARTED || buildState == BuildState.IN_PROGRESS;
        }
        catch (WvcmException wvcmException) {
            return true;
        }
    }

    public static interface Contributor {
        public void writeContribution(PrintWriter var1) throws WvcmException;
    }
}

