/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.rest.internal;

import com.ibm.team.repository.transport.client.SSLContextUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class LenientSecureProtocolSocketFactory
implements ProtocolSocketFactory,
SecureProtocolSocketFactory {
    private static final LenientSecureProtocolSocketFactory factory = new LenientSecureProtocolSocketFactory();
    private static final SSLContext sslContext = SSLContextUtil.createSSLContext((TrustManager)new NaiveTrustManager());

    public static ProtocolSocketFactory getFactory() {
        return factory;
    }

    private LenientSecureProtocolSocketFactory() {
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        SocketChannel channel = SocketChannel.open();
        Socket socket = channel.socket();
        if (localAddress != null || localPort != 0) {
            socket.bind(new InetSocketAddress(localAddress, localPort));
        }
        this.doConnect(channel, host, port);
        return sslContext.getSocketFactory().createSocket(socket, host, port, true);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SocketChannel channel = SocketChannel.open();
        this.doConnect(channel, host, port);
        Socket socket = channel.socket();
        return sslContext.getSocketFactory().createSocket(socket, host, port, true);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SocketChannel channel = SocketChannel.open();
        Socket socket = channel.socket();
        if (params.isParameterSet("http.tcp.nodelay")) {
            socket.setTcpNoDelay(params.getTcpNoDelay());
        }
        if (params.isParameterSet("http.socket.sendbuffer")) {
            socket.setSendBufferSize(params.getSendBufferSize());
        }
        if (params.isParameterSet("http.socket.receivebuffer")) {
            socket.setReceiveBufferSize(params.getReceiveBufferSize());
        }
        if (params.isParameterSet("http.socket.timeout")) {
            socket.setSoTimeout(params.getSoTimeout());
        }
        if (localAddress != null || localPort != 0) {
            socket.bind(new InetSocketAddress(localAddress, localPort));
        }
        this.doConnect(channel, host, port);
        return this.createSocket(socket, host, port, true);
    }

    protected void doConnect(SocketChannel channel, String remoteHost, int remotePort) throws IOException {
        channel.configureBlocking(true);
        channel.connect(new InetSocketAddress(remoteHost, remotePort));
    }

    static final class NaiveTrustManager
    implements X509TrustManager {
        NaiveTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

