/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.client.handlers.InputStreamAdapter;
import org.apache.wink.client.handlers.OutputStreamAdapter;

public class DeflateHandler
implements ClientHandler {
    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        request.getHeaders().add("Accept-Encoding", "deflate");
        if (request.getEntity() != null) {
            request.getHeaders().add("Content-Encoding", "deflate");
        }
        context.addInputStreamAdapter(new DeflateAdapter());
        context.addOutputStreamAdapter(new DeflateAdapter());
        return context.doChain(request);
    }

    private static class DeflateAdapter
    implements InputStreamAdapter,
    OutputStreamAdapter {
        private DeflateAdapter() {
        }

        public OutputStream adapt(OutputStream os, ClientRequest request) throws IOException {
            return new DeflaterOutputStream(os);
        }

        public InputStream adapt(InputStream is, ClientResponse response) throws IOException {
            String header = response.getHeaders().getFirst("Content-Encoding");
            if (header != null && header.equalsIgnoreCase("deflate")) {
                return new InflaterInputStream(is);
            }
            return is;
        }
    }
}

