/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.atom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.wink.common.RestException;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.model.ModelUtils;
import org.apache.wink.common.internal.utils.JAXBUtils;
import org.apache.wink.common.model.atom.AtomCategory;
import org.apache.wink.common.model.atom.AtomCommonAttributes;
import org.apache.wink.common.model.atom.AtomEntry;
import org.apache.wink.common.model.atom.AtomGenerator;
import org.apache.wink.common.model.atom.AtomLink;
import org.apache.wink.common.model.atom.AtomPerson;
import org.apache.wink.common.model.atom.AtomText;
import org.apache.wink.common.model.atom.ObjectFactory;
import org.apache.wink.common.model.opensearch.OpenSearchDescription;
import org.apache.wink.common.model.opensearch.OpenSearchQuery;
import org.apache.wink.common.model.synd.SyndCategory;
import org.apache.wink.common.model.synd.SyndEntry;
import org.apache.wink.common.model.synd.SyndFeed;
import org.apache.wink.common.model.synd.SyndGenerator;
import org.apache.wink.common.model.synd.SyndLink;
import org.apache.wink.common.model.synd.SyndPerson;
import org.apache.wink.common.model.synd.SyndText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlAccessorOrder(value=XmlAccessOrder.UNDEFINED)
@XmlType(name="atomFeed", propOrder={"id", "updated", "title", "subtitle", "itemsPerPage", "startIndex", "totalResults", "opensearchQuery", "link", "author", "contributor", "category", "generator", "icon", "logo", "rights", "any", "entry"})
@XmlSeeAlso(value={OpenSearchQuery.class})
public class AtomFeed
extends AtomCommonAttributes {
    @XmlElement(required=true)
    protected String id;
    @XmlElement(required=true)
    protected XMLGregorianCalendar updated;
    @XmlElement(required=true)
    protected AtomText title;
    protected AtomText subtitle;
    protected List<AtomLink> link;
    protected List<AtomPerson> author;
    protected List<AtomPerson> contributor;
    protected List<AtomCategory> category;
    protected AtomGenerator generator;
    protected String icon;
    protected String logo;
    protected AtomText rights;
    @XmlAnyElement
    protected List<Object> any;
    protected List<AtomEntry> entry;
    @XmlElement(namespace="http://a9.com/-/spec/opensearch/1.1/")
    protected BigInteger totalResults;
    @XmlElement(namespace="http://a9.com/-/spec/opensearch/1.1/")
    protected BigInteger itemsPerPage;
    @XmlElement(namespace="http://a9.com/-/spec/opensearch/1.1/")
    protected BigInteger startIndex;
    @XmlElement(name="Query", namespace="http://a9.com/-/spec/opensearch/1.1/")
    protected List<OpenSearchQuery> opensearchQuery;
    @XmlTransient
    private static final JAXBContext atomContext;
    @XmlTransient
    protected org.apache.wink.common.model.opensearch.ObjectFactory opensearchFactory;

    public AtomFeed() {
        this.opensearchFactory = new org.apache.wink.common.model.opensearch.ObjectFactory();
    }

    public AtomFeed(SyndFeed value) {
        super(value);
        if (value == null) {
            return;
        }
        this.setUpdated(value.getUpdated());
        this.setGenerator(value.getGenerator() != null ? new AtomGenerator(value.getGenerator()) : null);
        this.setIcon(value.getIcon());
        this.setId(value.getId());
        this.setItemsPerPage(value.getItemsPerPage());
        this.setLogo(value.getLogo());
        this.setRights(value.getRights() != null ? new AtomText(value.getRights()) : null);
        this.setStartIndex(value.getStartIndex());
        this.setSubtitle(value.getSubtitle() != null ? new AtomText(value.getSubtitle()) : null);
        this.setTitle(value.getTitle() != null ? new AtomText(value.getTitle()) : null);
        this.setTotalResults(value.getTotalResults());
        this.setAuthors(value.getAuthors());
        this.setCategories(value.getCategories());
        this.setLinks(value.getLinks());
        this.setEntries(value.getEntries());
    }

    public SyndFeed toSynd(SyndFeed value) {
        if (value == null) {
            return value;
        }
        super.toSynd(value);
        value.setUpdated(this.getUpdated());
        value.setGenerator(this.getGenerator() != null ? this.getGenerator().toSynd(new SyndGenerator()) : null);
        value.setIcon(this.getIcon());
        value.setId(this.getId());
        value.setItemsPerPage(this.getItemsPerPage());
        value.setLogo(this.getLogo());
        value.setRights(this.getRights() != null ? this.getRights().toSynd(new SyndText()) : null);
        value.setStartIndex(this.getStartIndex());
        value.setSubtitle(this.getSubtitle() != null ? this.getSubtitle().toSynd(new SyndText()) : null);
        value.setTitle(this.getTitle() != null ? this.getTitle().toSynd(new SyndText()) : null);
        value.setTotalResults(this.getTotalResults());
        value.getAuthors().addAll(this.getAuthorsAsSynd());
        value.getCategories().addAll(this.getCategoriesAsSynd());
        value.getLinks().addAll(this.getLinksAsSynd());
        value.getEntries().addAll(this.getEntriesAsSynd());
        return value;
    }

    public static Marshaller getMarshaller() {
        return JAXBUtils.createMarshaller(atomContext);
    }

    public static Unmarshaller getUnmarshaller() {
        return JAXBUtils.createUnmarshaller(atomContext);
    }

    public static AtomFeed unmarshal(Reader reader) throws IOException {
        return (AtomFeed)ModelUtils.unmarshal(AtomFeed.getUnmarshaller(), reader);
    }

    public static void marshal(AtomFeed feed, OutputStream os) throws IOException {
        JAXBElement<AtomFeed> feedElement = new ObjectFactory().createFeed(feed);
        Marshaller marshaller = AtomFeed.getMarshaller();
        ModelUtils.marshal(marshaller, feedElement, os);
    }

    private List<SyndPerson> getAuthorsAsSynd() {
        ArrayList<SyndPerson> authors = new ArrayList<SyndPerson>();
        for (AtomPerson value : this.getAuthors()) {
            if (value == null) continue;
            authors.add(value.toSynd(new SyndPerson()));
        }
        return authors;
    }

    private List<SyndCategory> getCategoriesAsSynd() {
        ArrayList<SyndCategory> authors = new ArrayList<SyndCategory>();
        for (AtomCategory value : this.getCategories()) {
            if (value == null) continue;
            authors.add(value.toSynd(new SyndCategory()));
        }
        return authors;
    }

    private List<SyndLink> getLinksAsSynd() {
        ArrayList<SyndLink> authors = new ArrayList<SyndLink>();
        for (AtomLink value : this.getLinks()) {
            if (value == null) continue;
            authors.add(value.toSynd(new SyndLink()));
        }
        return authors;
    }

    private List<SyndEntry> getEntriesAsSynd() {
        ArrayList<SyndEntry> authors = new ArrayList<SyndEntry>();
        for (AtomEntry value : this.getEntries()) {
            if (value == null) continue;
            authors.add(value.toSynd(new SyndEntry()));
        }
        return authors;
    }

    private void setAuthors(List<SyndPerson> values) {
        this.getAuthors().clear();
        if (values == null) {
            return;
        }
        for (SyndPerson value : values) {
            if (value == null) continue;
            this.author.add(new AtomPerson(value));
        }
    }

    private void setCategories(List<SyndCategory> values) {
        this.getCategories().clear();
        if (values == null) {
            return;
        }
        for (SyndCategory value : values) {
            if (value == null) continue;
            this.category.add(new AtomCategory(value));
        }
    }

    private void setLinks(List<SyndLink> values) {
        this.getLinks().clear();
        if (values == null) {
            return;
        }
        for (SyndLink value : values) {
            if (value == null) continue;
            this.link.add(new AtomLink(value));
        }
    }

    private void setEntries(List<SyndEntry> values) {
        this.getEntries().clear();
        if (values == null) {
            return;
        }
        for (SyndEntry value : values) {
            if (value == null) continue;
            this.entry.add(new AtomEntry(value));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public long getUpdatedAsTime() {
        return ModelUtils.xmlGregorianCalendarToTime(this.updated);
    }

    public Date getUpdated() {
        long updatedAsTime = this.getUpdatedAsTime();
        if (updatedAsTime == -1L) {
            return null;
        }
        return new Date(updatedAsTime);
    }

    public void setUpdated(XMLGregorianCalendar value) {
        this.updated = value;
    }

    public void setUpdated(long value) {
        this.setUpdated(ModelUtils.timeToXmlGregorianCalendar(value));
    }

    public void setUpdated(Date value) {
        if (value == null) {
            this.updated = null;
            return;
        }
        this.setUpdated(value.getTime());
    }

    public AtomText getTitle() {
        return this.title;
    }

    public void setTitle(AtomText value) {
        this.title = value;
    }

    public AtomText getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(AtomText value) {
        this.subtitle = value;
    }

    public List<AtomLink> getLinks() {
        if (this.link == null) {
            this.link = new ArrayList<AtomLink>();
        }
        return this.link;
    }

    public List<AtomPerson> getAuthors() {
        if (this.author == null) {
            this.author = new ArrayList<AtomPerson>();
        }
        return this.author;
    }

    public List<AtomPerson> getContributors() {
        if (this.contributor == null) {
            this.contributor = new ArrayList<AtomPerson>();
        }
        return this.contributor;
    }

    public List<AtomCategory> getCategories() {
        if (this.category == null) {
            this.category = new ArrayList<AtomCategory>();
        }
        return this.category;
    }

    public AtomGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(AtomGenerator value) {
        this.generator = value;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String value) {
        this.icon = value;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String value) {
        this.logo = value;
    }

    public AtomText getRights() {
        return this.rights;
    }

    public void setRights(AtomText value) {
        this.rights = value;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }

    public List<AtomEntry> getEntries() {
        if (this.entry == null) {
            this.entry = new ArrayList<AtomEntry>();
        }
        return this.entry;
    }

    public long getTotalResults() {
        if (this.totalResults == null) {
            return -1L;
        }
        return this.totalResults.longValue();
    }

    public void setTotalResults(long totalResults) {
        this.totalResults = totalResults >= 0L ? BigInteger.valueOf(totalResults) : null;
    }

    public long getStartIndex() {
        if (this.startIndex == null) {
            return -1L;
        }
        return this.startIndex.longValue();
    }

    public void setStartIndex(long startIndex) {
        this.startIndex = startIndex >= 0L ? BigInteger.valueOf(startIndex) : null;
    }

    public long getItemsPerPage() {
        if (this.itemsPerPage == null) {
            return -1L;
        }
        return this.itemsPerPage.longValue();
    }

    public void setItemsPerPage(long itemsPerPage) {
        this.itemsPerPage = itemsPerPage >= 0L ? BigInteger.valueOf(itemsPerPage) : null;
    }

    public List<OpenSearchQuery> getOpenSearchQueries() {
        if (this.opensearchQuery == null) {
            this.opensearchQuery = new ArrayList<OpenSearchQuery>();
        }
        return this.opensearchQuery;
    }

    public void setOpenSearchQueries(List<OpenSearchQuery> queries) {
        this.opensearchQuery = queries;
    }

    public void addOpenSearchQuery(OpenSearchQuery query2) {
        if (query2 != null) {
            this.getOpenSearchQueries().add(query2);
        }
    }

    static {
        try {
            atomContext = JAXBContext.newInstance(AtomFeed.class.getPackage().getName() + ":" + OpenSearchDescription.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new RestException(Messages.getMessage("failedToCreateJAXBContextFor", "AtomFeed"), e);
        }
    }
}

