/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.linkdetection.AttachmentLinkDetector;
import com.ibm.team.workitem.common.internal.linkdetection.WorkItemTextLinkDetector;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ClientLinkDetectorHelper
implements WorkItemTextLinkDetector.ILinkDetectorHelper {
    private static final String WORK_ITEM_TEXT_LINK_DETECTOR_COMMENT = "WorkItemTextLinkDetector.COMMENT";
    private static final String ATTACHMENT_LINK_DETECTOR_ATTACHMENT = "AttachmentLinkDetector.ATTACHMENT";
    private static ClientLinkDetectorHelper fgInstance;
    private static final HashMap<ITeamRepository, List<String>> fgRepositoryToTypes;
    private static final HashMap<ITeamRepository, Set<String>> fgRepositoryToAttachments;
    private static final HashMap<ITeamRepository, Set<String>> fgRepositoryToComments;
    private static final HashMap<UUID, List<String>> fgProjectAreaToTypes;
    private static final HashMap<UUID, String> fgProjectAreaToAttachment;
    private static final HashMap<UUID, String> fgProjectAreaToComment;
    private static TypeUpdater fgTypeUpdater;
    private ITeamRepository fTeamRepository;
    private FallBackConnectionStateManager fgFallBackConnectionStateManager = new FallBackConnectionStateManager();
    private IConnectionStateManager fgConnectionStateManager;

    static {
        fgRepositoryToTypes = new HashMap();
        fgRepositoryToAttachments = new HashMap();
        fgRepositoryToComments = new HashMap();
        fgProjectAreaToTypes = new HashMap();
        fgProjectAreaToAttachment = new HashMap();
        fgProjectAreaToComment = new HashMap();
        fgTypeUpdater = new TypeUpdater(Messages.ClientLinkDetectorHelper_UPDATE_WORK_ITEM_TYPES);
    }

    public static ClientLinkDetectorHelper getInstance() {
        if (fgInstance == null) {
            fgInstance = new ClientLinkDetectorHelper();
        }
        return fgInstance;
    }

    private ClientLinkDetectorHelper() {
    }

    public Collection<String> getAllTypeNames(IProjectAreaHandle projectArea) {
        return ClientLinkDetectorHelper.getTypeNames(projectArea);
    }

    public Collection<String> getAttachmentNames(IProjectAreaHandle projectArea) {
        return ClientLinkDetectorHelper.getAllAttachmentNames(projectArea);
    }

    public Collection<String> getComments(IProjectAreaHandle projectArea) {
        return ClientLinkDetectorHelper.getAllComments(projectArea);
    }

    public IAuditableCommon getAuditableCommon(IProjectAreaHandle projectArea) {
        for (IAuditableCommon au : this.getAuditableCommons()) {
            if (!au.getRepositoryURI().equals(((ITeamRepository)projectArea.getOrigin()).getRepositoryURI())) continue;
            return au;
        }
        return null;
    }

    public List<IAuditableCommon> getAuditableCommons() {
        ArrayList<IAuditableCommon> commons = new ArrayList<IAuditableCommon>();
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            commons.add((IAuditableClient)repo.getClientLibrary(IAuditableClient.class));
            ++n2;
        }
        return commons;
    }

    private ITeamRepository getTeamRepository(TextLinkDetector linkDetector) {
        if (this.fTeamRepository == null && linkDetector.getBaseURI() != null) {
            this.fTeamRepository = URIService.findTeamRepository(linkDetector.getBaseURI());
        }
        return this.fTeamRepository;
    }

    private static Collection<String> getTypeNames(IProjectAreaHandle projectArea) {
        if (projectArea == null) {
            HashSet<String> allTypes = new HashSet<String>();
            for (List<String> types : fgRepositoryToTypes.values()) {
                allTypes.addAll(types);
            }
            return allTypes;
        }
        List<String> list = fgProjectAreaToTypes.get(projectArea.getItemId());
        if (list == null) {
            IWorkItemClient workItemClient = ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
            List cachedWorkItemTypes = workItemClient.findCachedWorkItemTypes(projectArea);
            list = ClientLinkDetectorHelper.getAliases(cachedWorkItemTypes);
            for (IWorkItemType type : cachedWorkItemTypes) {
                list.add(type.getDisplayName());
            }
        }
        return list;
    }

    private static Set<String> getAllAttachmentNames(IProjectAreaHandle projectArea) {
        if (projectArea == null) {
            HashSet<String> allAttachments = new HashSet<String>();
            for (Set<String> attachments : fgRepositoryToAttachments.values()) {
                allAttachments.addAll(attachments);
            }
            return allAttachments;
        }
        String attachmentName = fgProjectAreaToAttachment.get(projectArea.getItemId());
        if (attachmentName == null) {
            attachmentName = ClientLinkDetectorHelper.getLocalizedName(projectArea, ATTACHMENT_LINK_DETECTOR_ATTACHMENT);
        }
        return Collections.singleton(attachmentName);
    }

    private static Set<String> getAllComments(IProjectAreaHandle projectArea) {
        if (projectArea == null) {
            HashSet<String> allComments = new HashSet<String>();
            for (Set<String> comments : fgRepositoryToComments.values()) {
                allComments.addAll(comments);
            }
            return allComments;
        }
        String comment = fgProjectAreaToComment.get(projectArea.getItemId());
        if (comment == null) {
            comment = ClientLinkDetectorHelper.getLocalizedName(projectArea, WORK_ITEM_TEXT_LINK_DETECTOR_COMMENT);
        }
        return Collections.singleton(comment);
    }

    private static String getLocalizedName(IProjectAreaHandle projectArea, String name) {
        IAuditableClient auditableClient = ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
        IProjectArea p = (IProjectArea)auditableClient.findCachedAuditable((IAuditableHandle)projectArea, ItemProfile.PROJECT_AREA_DEFAULT);
        LocalizationContext projectAreaContext = LocalizationContext.createProjectAreaContext((IAuditableCommon)auditableClient, (IProjectArea)p);
        String comment = ClientLinkDetectorHelper.getLocalizedName(projectAreaContext, name);
        return comment;
    }

    private static List<String> getAliases(List<IWorkItemType> cachedWorkItemTypes) {
        ArrayList<String> list = new ArrayList<String>();
        for (IWorkItemType type : cachedWorkItemTypes) {
            for (String alias : type.getAliases()) {
                list.add(alias);
            }
        }
        return list;
    }

    public boolean isManaged(IProjectAreaHandle handle) {
        if (handle == null) {
            return true;
        }
        return fgProjectAreaToTypes.containsKey(handle.getItemId());
    }

    public void cleanUp(TextLinkDetector linkDetector) {
        ClientLinkDetectorHelper.fgTypeUpdater.removeDetector(linkDetector);
    }

    public void initialize(TextLinkDetector linkDetector) {
        ClientLinkDetectorHelper.fgTypeUpdater.addDetector(linkDetector);
    }

    public void setConnectionStateManager(IConnectionStateManager manager) {
        this.fgConnectionStateManager = manager;
        ClientLinkDetectorHelper.fgTypeUpdater.initializeAllRepositories();
    }

    private IConnectionStateManager getManager() {
        if (this.fgConnectionStateManager == null) {
            return this.fgFallBackConnectionStateManager;
        }
        return this.fgConnectionStateManager;
    }

    public void connectionEventOccurred(ITeamRepository repository) {
        ClientLinkDetectorHelper.fgTypeUpdater.updateListener(repository);
        ClientLinkDetectorHelper.fgTypeUpdater.updateTypes(repository);
    }

    private static String getLocalizedName(LocalizationContext projectAreaContext, String string) {
        return com.ibm.team.workitem.common.internal.linkdetection.Messages.getString((LocalizationContext)projectAreaContext, (String)string);
    }

    private static class FallBackConnectionStateManager
    implements IConnectionStateManager {
        private static HashMap<ITeamRepository, List<? extends IProjectAreaHandle>> fgProjectAreas = new HashMap();
        private static HashMap<UUID, String> fgProjectAreaNames = new HashMap();
        private static Object fgPALock = new Object();
        private static RepositoryListener fgRepoListener = new RepositoryListener();

        static {
            TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)fgRepoListener);
        }

        private FallBackConnectionStateManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<? extends IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository repository) {
            List<Object> result;
            if (repository == null) {
                ArrayList pas = new ArrayList();
                Object object = fgPALock;
                synchronized (object) {
                    for (List<? extends IProjectAreaHandle> value : fgProjectAreas.values()) {
                        pas.addAll(value);
                    }
                }
                result = pas;
            } else {
                Object object = fgPALock;
                synchronized (object) {
                    List<? extends IProjectAreaHandle> pas = fgProjectAreas.get(repository);
                    result = pas == null ? Collections.emptyList() : pas;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<? extends IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository repository, IProgressMonitor monitor) {
            List<? extends IProjectAreaHandle> result;
            if (repository == null) {
                ArrayList<? extends IProjectAreaHandle> pas = new ArrayList<IProjectAreaHandle>();
                Object object = fgPALock;
                synchronized (object) {
                    for (List<? extends IProjectAreaHandle> value : fgProjectAreas.values()) {
                        pas.addAll(value);
                    }
                }
                result = pas;
            } else {
                List<? extends IProjectAreaHandle> pas;
                try {
                    pas = FallBackConnectionStateManager.getProjectAreas(repository, monitor);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    pas = this.getConnectedProjectAreas(repository);
                }
                Object object = fgPALock;
                synchronized (object) {
                    fgProjectAreas.put(repository, pas);
                }
                result = pas;
            }
            return result;
        }

        private static void initialize() {
            FoundationJob job = new FoundationJob(Messages.ClientLinkDetectorHelper_RETRIEVE_PROJECT_AREAS){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    HashMap<ITeamRepository, List> newValues = new HashMap<ITeamRepository, List>();
                    ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
                    int n = iTeamRepositoryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITeamRepository repo = iTeamRepositoryArray[n2];
                        try {
                            newValues.put(repo, FallBackConnectionStateManager.getProjectAreas(repo, monitor));
                        }
                        catch (TeamRepositoryException teamRepositoryException) {}
                        ++n2;
                    }
                    Object object = fgPALock;
                    synchronized (object) {
                        fgProjectAreas = newValues;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }

        private static List<? extends IProjectAreaHandle> getProjectAreas(ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
            IWorkItemClient workItemClient = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
            String nameProperty = ProcessCommon.getPropertyName(IProjectArea.class, (String)"name");
            ItemProfile profile = ItemProfile.createProfile((IItemType)IProjectArea.ITEM_TYPE, (String[])new String[]{nameProperty});
            List allAreas = workItemClient.getAuditableCommon().findAuditables(profile, monitor);
            for (IProjectArea pa : allAreas) {
                if (pa == null) continue;
                fgProjectAreaNames.put(pa.getItemId(), pa.getName());
            }
            return allAreas;
        }

        @Override
        public String getProjectAreaName(IProjectAreaHandle handle) {
            String name = fgProjectAreaNames.get(handle.getItemId());
            if (name == null) {
                return "";
            }
            return name;
        }

        private static class RepositoryListener
        implements ITeamRepositoryService.IRepositoryServiceListener {
            private RepositoryListener() {
            }

            public void addedRepository(ITeamRepository repository) {
                FallBackConnectionStateManager.initialize();
                if (ClientLinkDetectorHelper.getInstance().getManager() instanceof FallBackConnectionStateManager) {
                    ClientLinkDetectorHelper.getInstance().connectionEventOccurred(repository);
                }
            }

            public void removedRepository(ITeamRepository repository) {
                FallBackConnectionStateManager.initialize();
                if (ClientLinkDetectorHelper.getInstance().getManager() instanceof FallBackConnectionStateManager) {
                    ClientLinkDetectorHelper.getInstance().connectionEventOccurred(repository);
                }
            }
        }
    }

    public static interface IConnectionStateManager {
        public List<? extends IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository var1);

        public List<? extends IProjectAreaHandle> getConnectedProjectAreas(ITeamRepository var1, IProgressMonitor var2);

        public String getProjectAreaName(IProjectAreaHandle var1);
    }

    private static class ProjectAreaListener
    implements ISharedItemChangeListener {
        private ProjectAreaListener() {
        }

        public void itemsChanged(List events) {
            HashSet<ITeamRepository> affectedRepositories = new HashSet<ITeamRepository>();
            for (ISharedItemChangeEvent shEvent : events) {
                if (!(shEvent.getSharedItem() instanceof IProjectArea)) continue;
                affectedRepositories.add((ITeamRepository)((IProjectArea)shEvent.getSharedItem()).getOrigin());
            }
            for (ITeamRepository repo : affectedRepositories) {
                fgTypeUpdater.updateTypes(repo);
            }
        }
    }

    private static class TypeUpdater
    extends FoundationJob {
        private final List<ITeamRepository> fRepositoriesToProcess = new ArrayList<ITeamRepository>();
        private final List<TextLinkDetector> fDetectors = new ArrayList<TextLinkDetector>();
        private final ProjectAreaListener fProjectListener = new ProjectAreaListener();
        private boolean initialized = false;

        private TypeUpdater(String name) {
            super(name);
            this.setSystem(true);
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int n = iTeamRepositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository repo = iTeamRepositoryArray[n2];
                repo.itemManager().addItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)this.fProjectListener);
                ++n2;
            }
            List<ITeamRepository> list = this.fRepositoriesToProcess;
            synchronized (list) {
                this.fRepositoriesToProcess.addAll(Arrays.asList(TeamPlatform.getTeamRepositoryService().getTeamRepositories()));
            }
        }

        private void updateListener(ITeamRepository repository) {
            if (!fgRepositoryToTypes.containsKey(repository)) {
                repository.itemManager().addItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)this.fProjectListener);
            }
        }

        private void addDetector(TextLinkDetector detector) {
            this.fDetectors.add(detector);
        }

        private void removeDetector(TextLinkDetector detector) {
            this.fDetectors.remove(detector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTypes(ITeamRepository teamRepository) {
            List<ITeamRepository> list = this.fRepositoriesToProcess;
            synchronized (list) {
                this.fRepositoriesToProcess.add(teamRepository);
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ITeamRepository getRepository() {
            ITeamRepository repository = null;
            List<ITeamRepository> list = this.fRepositoriesToProcess;
            synchronized (list) {
                if (this.fRepositoriesToProcess.size() > 0) {
                    repository = this.fRepositoriesToProcess.get(0);
                    this.fRepositoriesToProcess.remove(0);
                }
            }
            return repository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeAllRepositories() {
            fgRepositoryToTypes.clear();
            fgProjectAreaToTypes.clear();
            List<ITeamRepository> list = this.fRepositoriesToProcess;
            synchronized (list) {
                this.fRepositoriesToProcess.clear();
                this.fRepositoriesToProcess.addAll(Arrays.asList(TeamPlatform.getTeamRepositoryService().getTeamRepositories()));
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            TypeUpdater typeUpdater = this;
            synchronized (typeUpdater) {
                if (!this.initialized) {
                    this.init();
                    this.initialized = true;
                }
            }
            ITeamRepository repository = this.getRepository();
            while (repository != null) {
                fgRepositoryToTypes.remove(repository);
                fgRepositoryToAttachments.remove(repository);
                fgRepositoryToComments.remove(repository);
                if (repository.loggedIn()) {
                    try {
                        ArrayList<String> typeNames = new ArrayList<String>();
                        HashSet<String> attachments = new HashSet<String>();
                        HashSet<String> comments = new HashSet<String>();
                        IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                        for (IProjectAreaHandle iProjectAreaHandle : fgInstance.getManager().getConnectedProjectAreas(repository, monitor)) {
                            UUID projectAreaUUID = iProjectAreaHandle.getItemId();
                            ArrayList<String> list = (ArrayList<String>)fgProjectAreaToTypes.get(projectAreaUUID);
                            if (list == null) {
                                list = new ArrayList<String>();
                                fgProjectAreaToTypes.put(projectAreaUUID, list);
                            }
                            list.clear();
                            fgProjectAreaToComment.remove(projectAreaUUID);
                            fgProjectAreaToAttachment.remove(projectAreaUUID);
                            List workItemTypes = workItemClient.findWorkItemTypes(iProjectAreaHandle, monitor);
                            for (IWorkItemType workItemType : workItemTypes) {
                                List aliases = workItemType.getAliases();
                                typeNames.add(workItemType.getDisplayName());
                                list.add(workItemType.getDisplayName());
                                for (String alias : aliases) {
                                    typeNames.add(alias);
                                    list.add(alias);
                                }
                            }
                            LocalizationContext projectAreaContext = LocalizationContext.createProjectAreaContext((IAuditableCommon)workItemClient.getAuditableCommon(), (IProjectAreaHandle)iProjectAreaHandle, (IProgressMonitor)monitor);
                            String attachment = ClientLinkDetectorHelper.getLocalizedName(projectAreaContext, ClientLinkDetectorHelper.ATTACHMENT_LINK_DETECTOR_ATTACHMENT);
                            attachments.add(attachment);
                            String comment = ClientLinkDetectorHelper.getLocalizedName(projectAreaContext, ClientLinkDetectorHelper.WORK_ITEM_TEXT_LINK_DETECTOR_COMMENT);
                            comments.add(comment);
                            fgProjectAreaToComment.put(projectAreaUUID, comment);
                            fgProjectAreaToAttachment.put(projectAreaUUID, attachment);
                        }
                        fgRepositoryToTypes.put(repository, typeNames);
                        fgRepositoryToAttachments.put(repository, attachments);
                        fgRepositoryToComments.put(repository, comments);
                    }
                    catch (TeamRepositoryException e) {
                        WorkItemCommonPlugin.log((String)("Could not add Work Item types for Projects on Repository " + repository.getName()), (Exception)((Object)e));
                    }
                } else {
                    repository.itemManager().removeItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)this.fProjectListener);
                }
                repository = this.getRepository();
            }
            WorkItemTextLinkDetector.invalidatePattern();
            AttachmentLinkDetector.invalidatePattern();
            for (TextLinkDetector detector : this.fDetectors) {
                detector.linkDetectorChanged();
            }
            return Status.OK_STATUS;
        }
    }
}

