/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.util;

import com.ibm.team.workitem.client.internal.util.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class InternalContentTypeUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IContentType getContentType(File file) throws CoreException {
        IContentType iContentType;
        if (!Platform.isRunning()) {
            return null;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            iContentType = Platform.getContentTypeManager().findContentTypeFor((InputStream)stream, file.getName());
            if (stream == null) return iContentType;
        }
        catch (IOException x) {
            try {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.client", 4, Messages.InternalContentTypeUtils_EXCEPTION_READING_EXTERNAL_FILE, (Throwable)x));
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return iContentType;
        }
        catch (IOException iOException) {}
        return iContentType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IContentDescription getContentDescription(IFileStore file) throws CoreException {
        IContentDescription iContentDescription;
        if (!Platform.isRunning()) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = file.openInputStream(0, null);
            iContentDescription = Platform.getContentTypeManager().getDescriptionFor(stream, file.getName(), IContentDescription.ALL);
            if (stream == null) return iContentDescription;
        }
        catch (IOException x) {
            try {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.client", 4, Messages.InternalContentTypeUtils_EXCEPTION_READING_EXTERNAL_FILE, (Throwable)x));
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return iContentDescription;
        }
        catch (IOException iOException) {}
        return iContentDescription;
    }

    public static String getMIMEType(String filename, IContentDescription contentDescription) {
        if (contentDescription == null) {
            return InternalContentTypeUtils.getMIMEType(filename);
        }
        return InternalContentTypeUtils.getMIMEType(filename, contentDescription.getContentType());
    }

    public static String getMIMEType(String filename, IContentType contentType) {
        String type = InternalContentTypeUtils.internalGetMIMEType(filename);
        if (type != null) {
            return type;
        }
        return InternalContentTypeUtils.internalGetMIMEType(filename, contentType);
    }

    private static String internalGetMIMEType(String filename, IContentType contentType) {
        if (contentType == null) {
            return InternalContentTypeUtils.getMIMEType(filename);
        }
        if ("org.eclipse.core.runtime.text".equals(contentType.getId())) {
            return "text/plain";
        }
        if ("org.eclipse.core.runtime.xml".equals(contentType.getId())) {
            return "text/xml";
        }
        return InternalContentTypeUtils.internalGetMIMEType(filename, contentType.getBaseType());
    }

    private static String getMIMEType(String filename) {
        String type = InternalContentTypeUtils.internalGetMIMEType(filename);
        if (type != null) {
            return type;
        }
        return "application/unknown";
    }

    private static String internalGetMIMEType(String filename) {
        if (filename == null) {
            return null;
        }
        if ((filename = filename.toLowerCase()).endsWith(".jpg") || filename.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (filename.endsWith(".gif")) {
            return "image/gif";
        }
        if (filename.endsWith(".png")) {
            return "image/png";
        }
        if (filename.endsWith(".html") || filename.endsWith(".htm")) {
            return "text/html";
        }
        return null;
    }

    public static String guessFileExtension(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        if ("text/plain".equals(mimeType)) {
            return "txt";
        }
        int index = mimeType.lastIndexOf(47);
        if (index == -1 || index == mimeType.length() - 1) {
            return null;
        }
        return mimeType.substring(index + 1);
    }

    public static String getCharSet(IContentDescription contentDescription, String mimeType) {
        if (!InternalContentTypeUtils.isTextType(mimeType)) {
            return null;
        }
        String charset = null;
        if (contentDescription != null) {
            charset = contentDescription.getCharset();
        }
        if (charset == null || charset.length() == 0) {
            charset = System.getProperty("file.encoding");
        }
        if (charset == null || charset.length() == 0) {
            charset = "UTF-8";
        }
        return charset;
    }

    private static boolean isTextType(String mimeType) {
        return mimeType != null && mimeType.trim().toLowerCase().startsWith("text");
    }
}

