/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.XPathQuery;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.ResourceUpdater;
import com.ibm.team.calm.foundation.common.oslc.RDFIdentifiers;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RMVersion1ResourceUpdater
extends ResourceUpdater {
    private static final Property RDF_DESCRIPTION = RDFIdentifiers.DESCRIPTION;
    private static final Property RDF_ABOUT = RDFIdentifiers.ABOUT;
    private static final Property RDF_RESOURCE = RDFIdentifiers.RESOURCE;
    private static final Property RDFS_LABEL = new Property("http://www.w3.org/2000/01/rdf-schema#", "label");

    @Override
    protected ResourceUpdater.ResourceContent loadExistingContent(OSLCResource resource, Set<OSLCResourceDescription.ResourcePropertyDescription> propertyDescriptions) throws TeamRepositoryException, UnsupportedVersionException {
        ResourceUpdater.ResourceContent result = new ResourceUpdater.ResourceContent(resource);
        CALMDocument document = new CALMDocument(resource.getContent());
        for (OSLCResourceDescription.ResourcePropertyDescription propertyDescription : propertyDescriptions) {
            if (propertyDescription.getType() == OSLCResourceDescription.PropertyType.LINK) {
                NodeList nodes = document.getNodes(this.getLinkPath(propertyDescription));
                List<ResourceUpdater.LinkProperty> parseLinks = this.parseLinks(propertyDescription, nodes, document);
                result.putLinkProperties(propertyDescription, parseLinks);
                continue;
            }
            String value = document.getText(this.getLinkPath(propertyDescription));
            result.putSimpleProperty(propertyDescription, new ResourceUpdater.SimpleProperty(propertyDescription.getId(), value));
        }
        return result;
    }

    private List<ResourceUpdater.LinkProperty> parseLinks(OSLCResourceDescription.ResourcePropertyDescription propertyDescription, NodeList nodes, CALMDocument document) throws CALMDocument.DocumentParseException {
        ArrayList<ResourceUpdater.LinkProperty> result = new ArrayList<ResourceUpdater.LinkProperty>(nodes.getLength());
        int idx = 0;
        while (idx < nodes.getLength()) {
            Node curNode = nodes.item(idx);
            String curTarget = this.parseLinkURI(curNode, document);
            String curLabel = this.parseLinkLabel(curNode, document);
            if (curTarget != null && curTarget.length() > 0 && curLabel != null) {
                result.add(new ResourceUpdater.LinkProperty(propertyDescription.getId(), curTarget, curLabel));
            }
            ++idx;
        }
        return result;
    }

    private XPathQuery getLinkPath(OSLCResourceDescription.ResourcePropertyDescription propertyDescription) {
        return new XPathQuery().add('/').addRef(this.getResourceVersion().getElementName()).add('/').addRef(propertyDescription.getProperty());
    }

    private String parseLinkLabel(Node node, CALMDocument document) throws CALMDocument.DocumentParseException {
        XPathQuery path = new XPathQuery("./").addRef(RDF_DESCRIPTION).add('/').addRef(RDFS_LABEL);
        return document.getText(path, (Object)node);
    }

    private String parseLinkURI(Node node, CALMDocument document) throws CALMDocument.DocumentParseException {
        XPathQuery pathV1 = new XPathQuery("@").addRef(RDF_RESOURCE);
        XPathQuery pathPreV1 = new XPathQuery("./").addRef(RDF_DESCRIPTION).add("/@").addRef(RDF_ABOUT);
        String result = document.getText(pathV1, (Object)node);
        if (result != null && result.length() > 0) {
            return result;
        }
        return document.getText(pathPreV1, (Object)node);
    }

    @Override
    protected String storeContent(ResourceUpdater.ResourceContent loadedContent) throws TeamRepositoryException {
        CALMDocument document = new CALMDocument(loadedContent.getOSLCResource().getContent());
        for (Map.Entry<OSLCResourceDescription.ResourcePropertyDescription, List<ResourceUpdater.LinkProperty>> entry : loadedContent.getLinkPropertySet()) {
            OSLCResourceDescription.ResourcePropertyDescription propertyDescription = entry.getKey();
            List<ResourceUpdater.LinkProperty> updatedLinks = entry.getValue();
            this.replaceResourceContent(propertyDescription, updatedLinks, document);
        }
        return this.writeDocumentContent(document.getRoot());
    }

    private void replaceResourceContent(OSLCResourceDescription.ResourcePropertyDescription propertyDescription, List<ResourceUpdater.LinkProperty> newLinks, CALMDocument document) throws CALMDocument.DocumentParseException {
        XPathQuery nodesPath = new XPathQuery(this.getResourceVersion().getElementName());
        NodeList roots = document.getNodes(nodesPath);
        if (roots.getLength() == 1) {
            Element root = (Element)roots.item(0);
            Property property = propertyDescription.getProperty();
            NodeList nodes = root.getElementsByTagNameNS(property.getNamespaceURI(), property.getName());
            int idx = nodes.getLength() - 1;
            while (idx >= 0) {
                root.removeChild(nodes.item(idx));
                --idx;
            }
            for (ResourceUpdater.LinkProperty curLink : newLinks) {
                Element linkElem = document.addNewElement(root, property.getNamespaceURI(), property.getName(), propertyDescription.getPreferredNamespacePrefix());
                CALMDocument.setAttribute(linkElem, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", RDFIdentifiers.RESOURCE.getName(), "rdf", curLink.getLinkUri());
            }
        } else {
            throw new CALMDocument.DocumentParseException(NLS.bind((String)Messages.getString("RMVersion1ResourceUpdater_ERROR_UNEXPECTED_RESOURCE_FORMAT"), (Object[])new String[]{this.getResourceURL(), nodesPath.getXPath()}));
        }
    }

    protected String writeDocumentContent(Document doc) throws TeamRepositoryException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(doc), result);
            return result.getWriter().toString();
        }
        catch (TransformerConfigurationException ex) {
            throw new TeamRepositoryException((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TeamRepositoryException((Throwable)ex);
        }
        catch (TransformerFactoryConfigurationError ex) {
            throw new TeamRepositoryException((Throwable)ex);
        }
        catch (TransformerException ex) {
            throw new TeamRepositoryException((Throwable)ex);
        }
    }
}

