/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.process;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.internal.process.IFauxXmlNode;
import com.ibm.team.scm.common.internal.process.PCD_asObject;
import com.ibm.team.scm.common.internal.process.ProcessConfigDeserializer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public class ProcessConfigSerializer {
    public void serialize(IFauxXmlNode node, Object toSerialize) throws SerializationException {
        Field[] fieldArray = toSerialize.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!ProcessConfigDeserializer.shouldSkipSerialize(f)) {
                Object val;
                try {
                    val = f.get(toSerialize);
                }
                catch (IllegalArgumentException e) {
                    throw new SerializationException(e);
                }
                catch (IllegalAccessException e) {
                    throw new SerializationException(e);
                }
                if (val != null) {
                    if (ProcessConfigDeserializer.isAttributeType(f.getType())) {
                        String serialized = this.serializeForAttribute(f, val);
                        String name = ProcessConfigDeserializer.findSerializationNameFor(f);
                        this.serializeFieldInto(node, f, name, serialized);
                    } else {
                        this.serializeForNode(node, f, val);
                    }
                }
            }
            ++n2;
        }
    }

    private void serializeForNode(IFauxXmlNode node, Field f, Object val) throws SerializationException {
        if (List.class.isInstance(val)) {
            ParameterizedType generic = (ParameterizedType)f.getGenericType();
            Type[] args = generic.getActualTypeArguments();
            if (args == null) {
                throw new SerializationException("Missing generic arguments for " + f);
            }
            Class type = (Class)args[0];
            for (Object obj : (List)val) {
                String name = ProcessConfigDeserializer.findSerializationNameFor(f);
                IFauxXmlNode newChild = node.createChild(name);
                if (ProcessConfigDeserializer.isAttributeType(type)) {
                    String attr = this.serializeForAttribute(f, obj);
                    if (attr == null) {
                        throw new SerializationException("Don't know how to serialize null list values: " + f);
                    }
                    this.serializeFieldInto(newChild, f, "value", attr);
                    continue;
                }
                this.serialize(newChild, obj);
            }
            return;
        }
        IFauxXmlNode newChild = node.createChild(ProcessConfigDeserializer.findSerializationNameFor(f));
        this.serialize(newChild, val);
    }

    private void serializeFieldInto(IFauxXmlNode node, Field f, String suggestedFieldName, String value) {
        if (f.getAnnotation(PCD_asObject.class) == null) {
            node.setAttribute(suggestedFieldName, value);
        } else {
            IFauxXmlNode child = node.createChild(suggestedFieldName);
            child.setAttribute("value", value);
        }
    }

    private String serializeForAttribute(Field f, Object value) throws SerializationException {
        if (value == null) {
            return null;
        }
        if (Boolean.TYPE.isInstance(value) || Boolean.class.isInstance(value)) {
            return Boolean.toString((Boolean)value);
        }
        if (Integer.TYPE.isInstance(value) || Integer.class.isInstance(value)) {
            return Integer.toString((Integer)value);
        }
        if (Double.TYPE.isInstance(value) || Double.class.isInstance(value)) {
            return Double.toString((Double)value);
        }
        if (value.getClass().isEnum()) {
            return ((Enum)value).name();
        }
        if (UUID.class.isInstance(value)) {
            return ((UUID)value).getUuidValue();
        }
        if (String.class.isInstance(value)) {
            return (String)value;
        }
        throw new SerializationException("Unknown type for " + f);
    }

    public static class SerializationException
    extends Exception {
        public SerializationException(String msg) {
            super(msg);
        }

        public SerializationException(Exception e) {
            super(e);
        }
    }
}

