/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.MarshallerImpl;
import com.ibm.team.repository.common.serialize.internal.nls.Messages;
import com.ibm.team.repository.common.transport.internal.services.DataArg;
import com.ibm.team.repository.common.transport.internal.services.DataArgType;
import com.ibm.team.repository.common.transport.internal.services.NullDataArg;
import com.ibm.team.repository.common.transport.internal.services.ObjectArrayDataArg;
import com.ibm.team.repository.common.transport.internal.services.ServicesFactory;
import com.ibm.team.repository.common.util.NLS;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;

public class BooleanArrayMarshaller
extends MarshallerImpl {
    public BooleanArrayMarshaller() {
        this.setSupportedType(Boolean.TYPE);
        this.setMarshallerType(MarshallerType.OBJECT_ARRAY_LITERAL);
    }

    @Override
    public DataArgType getSupportedDataArgType() {
        return DataArgType.OBJECT_ARRAY_LITERAL;
    }

    @Override
    public boolean canMarshal(Class type) {
        if (type.isArray()) {
            return Boolean.class.equals(type.getComponentType());
        }
        return false;
    }

    @Override
    public void marshalObjectToOutputStream(Object object, OutputStream outputStream) throws MarshallingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void marshalObjectToOutputStream(Object object, OutputStream outputStream, Charset charset) throws MarshallingException {
        throw new UnsupportedOperationException();
    }

    public DataArgType getDataArgType() {
        return DataArgType.OBJECT_ARRAY_LITERAL;
    }

    @Override
    public String marshalObjectToString(Object object) throws MarshallingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object demarshalInputStreamToObject(InputStream inputStream) throws MarshallingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object demarshalInputStreamToObject(InputStream inputStream, Charset charset) throws MarshallingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataArg marshalObjectToDataArg(Object object) {
        if (object == null) {
            return this.createNullDataArg();
        }
        ObjectArrayDataArg objectArrayDataArg = ServicesFactory.eINSTANCE.createObjectArrayDataArg();
        objectArrayDataArg.setType(DataArgType.OBJECT_ARRAY_LITERAL);
        Boolean[] objectArray = (Boolean[])object;
        Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(Boolean.TYPE);
        if (marshaller == null) {
            String pattern = Messages.getServerString("BooleanArrayMarshaller.CannotMarshalObject");
            String message = NLS.bind((String)pattern, (Object)(objectArray.length > 0 ? objectArray[0] : objectArray), (Object[])new Object[0]);
            LogFactory.getLog((String)this.getClass().getName()).warn((Object)message);
            String clientPattern = Messages.getServerString("BooleanArrayMarshaller.CannotMarshalObject");
            String clientMessage = NLS.bind((String)clientPattern, (Object)(objectArray.length > 0 ? objectArray[0] : objectArray), (Object[])new Object[0]);
            throw new IllegalStateException(clientMessage);
        }
        int i = 0;
        while (i < objectArray.length) {
            objectArrayDataArg.getDataArgs().add((Object)marshaller.marshalObjectToDataArg(objectArray[i]));
            ++i;
        }
        return objectArrayDataArg;
    }

    private DataArg createNullDataArg() {
        NullDataArg nullDataArg = ServicesFactory.eINSTANCE.createNullDataArg();
        nullDataArg.setType(DataArgType.NULL_LITERAL);
        return nullDataArg;
    }

    @Override
    public Object demarshalDataArgToObject(DataArg dataArg, Class type) {
        ObjectArrayDataArg objectArrayDataArg = (ObjectArrayDataArg)dataArg;
        Boolean[] objectArray = new Boolean[objectArrayDataArg.getDataArgs().size()];
        int k = 0;
        for (DataArg dataArg2 : objectArrayDataArg.getDataArgs()) {
            Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(dataArg2.getType());
            if (marshaller == null) continue;
            objectArray[k++] = (Boolean)marshaller.demarshalDataArgToObject(dataArg2, Boolean.TYPE);
        }
        return objectArray;
    }

    public Object demarshalDataArgToObject(DataArg dataArg, Class type, List containedReferences) {
        return this.demarshalDataArgToObject(dataArg, type);
    }
}

