/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ISimpleItem;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.IVirtual;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.SimpleItem;
import com.ibm.team.repository.common.serialize.IPrimitiveHandler;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.serialize.MessagePlaceholder;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.StackUtil;
import com.ibm.team.repository.common.serialize.internal.AbstractSerializer;
import com.ibm.team.repository.common.serialize.internal.nls.Messages;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JSONSerializer
extends AbstractSerializer {
    public static final String KEY_URI = "uri";
    public static final String KEY_ETAG = "etag";
    public static final String KEY_ITEMID = "itemId";
    public static final String KEY_STATEID = "stateId";
    public static final String KEY_TYPE = "com.ibm.team.repository.typeName";
    public static final String ERROR_CLASSNAME_KEY = "errorClass";
    public static final String ERROR_CODE_KEY = "errorCode";
    public static final String ERROR_DATA = "errorData";
    public static final String ERROR_ALLDATA = "errorAllData";
    public static final String ERROR_DATA_PROCESS = "processData";
    public static final String KEY_EPACKAGE = "-hint-epackage-1";
    public static final String KEY_ECLASS = "-hint-eclass-1";
    public static final String ERROR_MSG_KEY = "errorMessage";
    public static final String ERROR_TRACE_KEY = "errorTrace";
    public static final String ERROR_TRACE_MARSHALL_KEY = "errorTraceMarshall";
    public static final String ERROR_TRACE_CLASSNAME = "errorTraceClassName";
    public static final String ERROR_TRACE_METHODNAME = "errorTraceMethodName";
    public static final String ERROR_TRACE_FILENAME = "errorTraceFileName";
    public static final String ERROR_TRACE_LINENUM = "errorTraceLineNumber";
    public static final String NESTED_ERROR_KEY = "nestedError";
    public static final String NLS_EXCEPTION_PLACEHOLDER_LOGGED_MESSAGE = "JSONSerializer.ExceptionPlaceholderLoggedMessage";
    public static final String NLS_EXCEPTION_PLACEHOLDER_USER_MESSAGE = "JSONSerializer.ExceptionPlaceholderUserMessage";
    private static final Log LOG = LogFactory.getLog(JSONSerializer.class);

    public JSONSerializer(HttpUtil.MediaType type, String repoUri, boolean format, IURISerializer uriSerializer) {
        super(type, repoUri, format, uriSerializer);
    }

    @Override
    public void serialize(IItem item, Writer writer) throws TeamRepositoryException, IOException {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        EObject eObject = (EObject)item.getAdapter(EObject.class);
        JSONObject obj = null;
        try {
            obj = this.toJSONObject(eObject, item.getClass(), new SerializationContext());
        }
        catch (SerializeException e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONSerializer.ErrorSerializingItem"), (Object)e.getMessage(), (Object[])new Object[0]);
            throw new TeamRepositoryException(msg, (Throwable)e);
        }
        obj.serialize(writer, this.format());
    }

    @Override
    public void serialize(IVirtual item, Writer writer) throws TeamRepositoryException, IOException {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        EObject eObject = (EObject)item.getAdapter(EObject.class);
        JSONObject obj = null;
        try {
            obj = this.toJSONObject(eObject, item.getClass(), new SerializationContext());
        }
        catch (SerializeException e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONSerializer.ErrorSerializingItem"), (Object)e.getMessage(), (Object[])new Object[0]);
            throw new TeamRepositoryException(msg, (Throwable)e);
        }
        obj.serialize(writer, this.format());
    }

    @Override
    public void serialize(List<IItem> items, Writer writer) throws TeamRepositoryException, IOException {
        if (items == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        JSONArray members = null;
        try {
            members = this.internalSerializeList(items, IItem.class, new SerializationContext());
        }
        catch (SerializeException e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONSerializer.ErrorSerializingItem"), (Object)e.getMessage(), (Object[])new Object[0]);
            throw new TeamRepositoryException(msg, (Throwable)e);
        }
        members.serialize(writer, this.format());
    }

    @Override
    public void serializeVirtuals(List<IVirtual> items, Writer writer) throws TeamRepositoryException, IOException {
        if (items == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        JSONArray members = null;
        try {
            members = this.internalSerializeList(items, IVirtual.class, new SerializationContext());
        }
        catch (SerializeException e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONSerializer.ErrorSerializingItem"), (Object)e.getMessage(), (Object[])new Object[0]);
            throw new TeamRepositoryException(msg, (Throwable)e);
        }
        members.serialize(writer, this.format());
    }

    @Override
    public void serializeList(List items, Writer writer) throws TeamRepositoryException, IOException {
        if (items == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        JSONArray members = null;
        try {
            members = this.internalSerializeList(items, null, new SerializationContext());
        }
        catch (SerializeException e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONSerializer.ErrorSerializingItem"), (Object)e.getMessage(), (Object[])new Object[0]);
            throw new TeamRepositoryException(msg, (Throwable)e);
        }
        members.serialize(writer, this.format());
    }

    @Override
    public void serialize(EObject object, Writer writer) throws TeamRepositoryException, IOException {
        if (object == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        JSONObject obj = null;
        try {
            obj = this.toJSONObject(object, object.getClass(), new SerializationContext());
        }
        catch (SerializeException e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONSerializer.ErrorSerializingObject"), (Object)e.getMessage(), (Object[])new Object[0]);
            throw new TeamRepositoryException(msg, (Throwable)e);
        }
        obj.serialize(writer, this.format());
    }

    private JSONObject toJSONObject(EObject eObject, Class expectedType, SerializationContext ctx) throws SerializeException {
        Location loc;
        if (eObject == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        boolean itemsToHandles = this.shouldMorphItemToHandle(eObject, expectedType);
        if (itemsToHandles) {
            eObject = this.morphItemToHandle(eObject);
        }
        EClass eClass = eObject.eClass();
        if (ctx.include_etype) {
            jsonObject.put((Object)KEY_EPACKAGE, (Object)eClass.getEPackage().getNsURI());
            jsonObject.put((Object)KEY_ECLASS, (Object)eClass.getName());
        }
        boolean isItemHandle = eObject instanceof IItemHandle;
        boolean isVirtual = eObject instanceof IVirtual;
        boolean isContent = eObject instanceof IContent;
        if (isItemHandle) {
            IItem item;
            IItemHandle handle = (IItemHandle)eObject;
            loc = null;
            try {
                loc = Location.location((URI)this._uriSerializer.getUri(handle));
            }
            catch (TeamRepositoryException e) {
                throw new SerializeException(e.getMessage(), e);
            }
            jsonObject.put((Object)KEY_URI, (Object)loc.toRelativeUri().toString());
            jsonObject.put((Object)KEY_ITEMID, (Object)handle.getItemId().getUuidValue());
            jsonObject.put((Object)KEY_TYPE, (Object)ItemUtil.typeToName((IType)handle.getItemType()));
            if (handle.getStateId() != null) {
                jsonObject.put((Object)KEY_ETAG, (Object)handle.getStateId().getUuidValue());
                jsonObject.put((Object)KEY_STATEID, (Object)handle.getStateId().getUuidValue());
            }
            if ((item = handle.getFullState()) == null) {
                return jsonObject;
            }
            if (item.isWorkingCopy()) {
                SimpleItem simple;
                if (item instanceof IAuditable) {
                    Auditable audit = (Auditable)item;
                    if (audit.getWorkingCopyPredecessor() != null) {
                        jsonObject.put((Object)KEY_ETAG, (Object)audit.getWorkingCopyPredecessor().getUuidValue());
                    }
                } else if (item instanceof ISimpleItem && (simple = (SimpleItem)item).getPredecessor() != null) {
                    jsonObject.put((Object)KEY_ETAG, (Object)simple.getPredecessor().getUuidValue());
                }
            }
        } else if (isVirtual) {
            IVirtual virtual = (IVirtual)eObject;
            jsonObject.put((Object)KEY_TYPE, (Object)ItemUtil.typeToName((IType)virtual.getVirtualType()));
            jsonObject.put((Object)KEY_URI, (Object)this.getVirtualLocation(virtual));
            jsonObject.put((Object)KEY_ETAG, (Object)virtual.getEtag());
        } else if (isContent) {
            IContent content = (IContent)eObject;
            loc = Location.contentLocation((IContent)content, null);
            jsonObject.put((Object)KEY_URI, (Object)loc.toRelativeUri().toString());
        }
        EList features = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            if (!eObject.eIsSet(feature) || !ItemUtil.isPersistent((EClass)eClass, (EStructuralFeature)feature) && isItemHandle || this.isItemId(feature)) continue;
            Object value = eObject.eGet(feature);
            String key = feature.getName();
            Class valueExpectedType = feature.getEType().getInstanceClass();
            Object serializedValue = this.serializeObject(value, valueExpectedType, ctx);
            jsonObject.put((Object)key, serializedValue);
        }
        return jsonObject;
    }

    private Object serializeObject(Object value, Class expectedType, SerializationContext ctx) throws SerializeException {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (value instanceof EObject) {
            Class<?> type = expectedType;
            EObject eValue = (EObject)value;
            if (type == null) {
                type = eValue.getClass();
            }
            return this.toJSONObject(eValue, type, ctx);
        }
        if (value instanceof List) {
            return this.internalSerializeList((List)value, expectedType, ctx);
        }
        if (valueClass.isArray()) {
            return this.serializeArray(value, expectedType, ctx);
        }
        if (PrimitiveReg.isPrimitive(valueClass)) {
            return this.serializePrimitive(value, valueClass);
        }
        if (value instanceof Enumerator) {
            return ((Enumerator)value).getLiteral();
        }
        throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONSerializer.ErrorSerializingValue"), (Object)value, (Object[])new Object[0]));
    }

    private Object serializePrimitive(Object value, Class valueClass) throws SerializeException {
        if (value == null) {
            return null;
        }
        if (valueClass == Boolean.class) {
            return value;
        }
        if (valueClass == String.class) {
            return value;
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return value;
        }
        IPrimitiveHandler primHandler = IPrimitiveRegistry.INSTANCE.getHandler(valueClass);
        if (primHandler == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONSerializer.MissingPrimitiveHandler"), (Object)valueClass.getName(), (Object[])new Object[0]));
        }
        return primHandler.objectToString(value);
    }

    private JSONArray internalSerializeList(List list, Class expectedType, SerializationContext ctx) throws SerializeException {
        JSONArray result = new JSONArray(list.size());
        for (Object element : list) {
            Object serializedElement = this.serializeObject(element, expectedType, ctx);
            result.add(serializedElement);
        }
        return result;
    }

    private JSONArray serializeArray(Object array, Class expectedType, SerializationContext ctx) throws SerializeException {
        int length = Array.getLength(array);
        JSONArray result = new JSONArray(length);
        int i = 0;
        while (i < length) {
            Object element = Array.get(array, i);
            Object serializedElement = this.serializeObject(element, expectedType, ctx);
            result.add(serializedElement);
            ++i;
        }
        return result;
    }

    private boolean isItemId(EStructuralFeature feature) {
        if (!(feature instanceof EAttribute)) {
            return false;
        }
        return feature.equals(RepositoryPackage.eINSTANCE.getItemHandle_ItemId()) || feature.equals(RepositoryPackage.eINSTANCE.getItemHandle_StateId());
    }

    @Override
    public void serializeException(Throwable exception, Integer errorCode, Writer writer) throws TeamRepositoryException, IOException {
        if (exception == null) {
            throw new IllegalArgumentException("exception must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        if (StackUtil.shouldAvoidSerializingExceptions()) {
            this.serializeExceptionPlaceholder(exception, writer, errorCode);
            return;
        }
        JSONObject obj = new JSONObject();
        this.formatErrorObj(obj, exception, errorCode);
        if (exception instanceof TeamRepositoryException && ((TeamRepositoryException)exception).getData() instanceof EObject) {
            EObject data = (EObject)((TeamRepositoryException)exception).getData();
            try {
                obj.put((Object)ERROR_DATA, (Object)this.toJSONObject(data, data.getClass(), new SerializationContext()));
            }
            catch (SerializeException serializeException) {}
        }
        obj.serialize(writer, this.format());
    }

    private void serializeExceptionPlaceholder(Throwable exception, Writer writer, Integer errorCode) throws IOException {
        if (exception == null) {
            throw new IllegalArgumentException("exception must not be null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        JSONObject obj = this.convertToJSON(exception);
        if (errorCode != null) {
            obj.put((Object)ERROR_CODE_KEY, (Object)errorCode);
        }
        obj.serialize(writer, this.format());
    }

    public final JSONObject convertToJSON(Throwable exception) {
        UUID identifyingUUID = UUID.randomUUID();
        if (!(exception instanceof MessagePlaceholder)) {
            String logPattern = Messages.getServerString(NLS_EXCEPTION_PLACEHOLDER_LOGGED_MESSAGE);
            String logMessage = NLS.bind((String)logPattern, (Object)identifyingUUID, (Object[])new Object[0]);
            LOG.error((Object)logMessage, exception);
        }
        String userPattern = Messages.getClientString(NLS_EXCEPTION_PLACEHOLDER_USER_MESSAGE);
        String userMessage = NLS.bind((String)userPattern, (Object)identifyingUUID, (Object[])new Object[]{exception.getMessage()});
        JSONObject obj = new JSONObject();
        obj.put((Object)ERROR_MSG_KEY, (Object)userMessage);
        obj.put((Object)ERROR_CLASSNAME_KEY, (Object)exception.getClass().getCanonicalName());
        Throwable place = exception.getCause();
        JSONObject parent = obj;
        while (place != null) {
            JSONObject nestedObj = new JSONObject();
            parent.put((Object)NESTED_ERROR_KEY, (Object)nestedObj);
            nestedObj.put((Object)ERROR_CLASSNAME_KEY, (Object)place.getClass().getCanonicalName());
            nestedObj.put((Object)ERROR_MSG_KEY, (Object)place.getMessage());
            this.serializeTeamRepositoryExceptionExtraData(nestedObj, place);
            parent = nestedObj;
            place = place.getCause();
        }
        this.serializeTeamRepositoryExceptionExtraData(obj, exception);
        return obj;
    }

    private void formatErrorObj(JSONObject obj, Throwable ex, Integer errorCode) {
        if (obj == null) {
            throw new IllegalArgumentException("obj must not be null");
        }
        if (ex == null) {
            throw new IllegalArgumentException("ex must not be null");
        }
        StackTraceElement[] stackTraceElems = ex.getStackTrace();
        JSONArray stackTrace = new JSONArray();
        JSONArray formattedStackTrace = new JSONArray();
        StackTraceElement[] stackTraceElementArray = stackTraceElems;
        int n = stackTraceElems.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement elem = stackTraceElementArray[n2];
            stackTrace.add((Object)elem.toString());
            JSONObject traceObj = new JSONObject();
            traceObj.put((Object)ERROR_TRACE_CLASSNAME, (Object)elem.getClassName());
            traceObj.put((Object)ERROR_TRACE_METHODNAME, (Object)elem.getMethodName());
            traceObj.put((Object)ERROR_TRACE_FILENAME, (Object)elem.getFileName());
            traceObj.put((Object)ERROR_TRACE_LINENUM, (Object)elem.getLineNumber());
            formattedStackTrace.add((Object)traceObj);
            ++n2;
        }
        obj.put((Object)ERROR_CLASSNAME_KEY, (Object)ex.getClass().getCanonicalName());
        obj.put((Object)ERROR_CODE_KEY, (Object)errorCode);
        obj.put((Object)ERROR_MSG_KEY, (Object)ex.getMessage());
        obj.put((Object)ERROR_TRACE_KEY, (Object)stackTrace);
        obj.put((Object)ERROR_TRACE_MARSHALL_KEY, (Object)formattedStackTrace);
        Throwable source = ex.getCause();
        if (source != null) {
            JSONObject nestedObj = new JSONObject();
            obj.put((Object)NESTED_ERROR_KEY, (Object)nestedObj);
            this.formatErrorObj(nestedObj, source, null);
        }
        this.serializeTeamRepositoryExceptionExtraData(obj, ex);
    }

    private void serializeTeamRepositoryExceptionExtraData(JSONObject obj, Throwable ex) {
        if (ex instanceof TeamRepositoryException) {
            TeamRepositoryException tre = (TeamRepositoryException)ex;
            JSONObject extraData = new JSONObject();
            SerializationContext ctx = new SerializationContext();
            ctx.include_etype = true;
            for (Map.Entry entry : tre.getSerializableData().entrySet()) {
                if (!(entry.getValue() instanceof EObject)) continue;
                try {
                    EObject value = (EObject)entry.getValue();
                    Class<?> eClass = null;
                    if (value != null) {
                        eClass = value.getClass();
                    }
                    extraData.put(entry.getKey(), (Object)this.toJSONObject(value, eClass, ctx));
                }
                catch (SerializeException serializeException) {}
            }
            if (extraData.size() > 0) {
                obj.put((Object)ERROR_ALLDATA, (Object)extraData);
            }
        }
    }

    private String getVirtualLocation(IVirtual virtual) throws SerializeException {
        String uriString = virtual.getLocation();
        if (uriString == null) {
            try {
                URI uri = this._uriSerializer.getUri(virtual);
                if (uri != null) {
                    uriString = uri.toString();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return uriString;
    }

    private static class SerializationContext {
        boolean include_etype = false;

        private SerializationContext() {
        }
    }
}

