/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTSymbolicLink;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CTWvcmConfiguration;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.ControllableResourceImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.SymbolicLinkVersion;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class CTControllableResource
extends CTResource {
    final CCaseLib cc;
    private String _myPathname = null;

    CTControllableResource(Location location, CTProvider provider) throws WvcmException {
        super(location, provider);
        provider.activateView();
        this.cc = provider.getCCaseLib();
    }

    protected void readProperties(ResourceImpl resource, SrvcResource configuration, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        this.readThisProperty(resource, Resource.PATHNAME_LOCATION, null, configuration, feedback);
        super.readProperties(resource, configuration, propertyRequest, feedback);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableResourceImpl.class;
    }

    public void doCheckin(ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        String comment = null;
        this.checkinHelper(comment, flags, Collections.singletonList(this.getPathname(feedback)), this.getViewTag(feedback), feedback);
    }

    public void doCheckout(ControllableResource.CheckoutFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CTView view = this.getView(feedback);
        this.cc.checkout(this.getPathname(feedback), view.getViewTag(), view.getStreamSelector(feedback), feedback);
        this.flush(feedback);
    }

    public void doUncheckout(SrvcFeedback feedback) throws WvcmException {
        this.cc.uncheckout(this.getPathname(feedback), feedback);
        this.flush(feedback);
    }

    public void doWriteContent(InputStream content, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        String pathname = this.getPathname(feedback);
        this.prepareToWrite(feedback);
        HashMap supportedUpdates = new HashMap(updates);
        for (PropertyNameList.PropertyName propertyName : VERSION_HISTORY_PROPERTIES) {
            if (!supportedUpdates.containsKey(propertyName)) continue;
            supportedUpdates.remove(propertyName);
            updated.add(propertyName);
        }
        this.doWriteProperties(supportedUpdates, updated, feedback);
        try {
            FileOutputStream sink = new FileOutputStream(pathname);
            int count = 0;
            byte[] buffer = new byte[100000];
            do {
                if ((count = content.read(buffer)) <= 0) continue;
                sink.write(buffer, 0, count);
            } while (count != -1);
            sink.close();
        }
        catch (Exception e) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableResource_DO_WRITE_CONTENT_ERROR, (Object)this.location().string()), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public void prepareToWrite(SrvcFeedback feedback) throws WvcmException {
        CTView view = this.getView(feedback);
        view.prepareToWrite(this.getPathname(feedback), feedback);
    }

    public void doReadContent(OutputStream content, Resource accept, SrvcFeedback feedback) throws WvcmException {
        this.readContentInternal(this.getPathname(null), content, feedback);
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)ControllableResource.IS_EXECUTABLE)) {
            boolean isExecutable = (Boolean)value;
            if (isExecutable) {
                this.cc.setExecutePermission(this.location().getDisplayName(), isExecutable, feedback);
                this.flush(feedback);
            }
        } else if (propertyName.equals((Object)Resource.COMMENT)) {
            this.cc.setComment(this.getPathname(feedback), (String)value, feedback);
        } else if (!VERSION_HISTORY_PROPERTIES.contains(propertyName)) {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.location().string();
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.location().getDisplayName();
        }
        if (propertyName.equals((Object)ControllableResource.VERSION_HISTORY)) {
            return this.lookupVersionHistory(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.CONFIGURATION)) {
            return this.lookupConfiguration(feedback);
        }
        if (propertyName.equals((Object)ControllableFolder.CHILD_MAP)) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableResource_CHILD_MAP_NYI, (Object)this.location().string()), WvcmException.ReasonCode.PROPERTY_NOT_DEFINED_FOR_RESOURCE);
        }
        if (propertyName.equals((Object)ControllableResource.CHECKED_IN)) {
            return this.lookupCurrentVersion(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.IS_CHECKED_OUT)) {
            return this.cc.isCheckedout(this.getObjInfo(feedback).getPathName(), feedback);
        }
        if (propertyName.equals((Object)ControllableResource.IS_VERSION_CONTROLLED)) {
            return this.getIsVersionControlled(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.WORKSPACE)) {
            return this.getView(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.COMMENT)) {
            return this.getComment(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.IS_EXECUTABLE)) {
            return this.cc.getExecutePermission(this.getObjInfo(feedback).getPathName(), feedback);
        }
        if (propertyName.equals((Object)Resource.CREATOR_DISPLAY_NAME)) {
            return this.getOwner(feedback);
        }
        if (VERSION_HISTORY_PROPERTIES.contains(propertyName)) {
            return this.lookupVersionHistory(feedback).getThisProperty(propertyName, configuration, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public Object lookupConfiguration(SrvcFeedback feedback) throws WvcmException {
        String compPath;
        CTProvider p = this.provider();
        String crPath = this.getPathname(feedback);
        CTLocation configLoc = null;
        CTLocation viewLocation = this.getViewLocation(feedback);
        if (viewLocation != null && viewLocation.hasKind(CTLocation.Kind.BASE_CC_VIEW)) {
            compPath = null;
            if (this.cc.isVOBUCMEnabledFromGPath(crPath, feedback)) {
                compPath = this.cc.lookupFriendlyUcmComponentSelectorFromGPath(crPath, feedback);
                if (compPath != null) {
                    compPath = this.cc.getUniversalSelector(compPath, feedback);
                }
            } else {
                compPath = this.getBaseCcComponentSelectorFromGPath(crPath, feedback);
            }
            if (compPath == null) {
                return null;
            }
            CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, compPath);
            configLoc = CTLocation.createBaseConfigurationLoc(viewLocation, compLoc);
        } else {
            compPath = this.cc.lookupComponentSelectorFromGPath(crPath, feedback);
            if (compPath == null) {
                return null;
            }
            CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.COMPONENT, compPath);
            configLoc = CTLocation.createConfigurationLoc(viewLocation, compLoc);
        }
        CTWvcmConfiguration result = (CTWvcmConfiguration)p.lookup((Location)configLoc, feedback);
        if (result == null) {
            result = new CTWvcmConfiguration((Location)configLoc, this.provider());
        }
        return result;
    }

    private String getComment(SrvcFeedback feedback) throws WvcmException {
        return this.cc.getComment(this.getPathname(feedback), feedback);
    }

    public CTLocation getViewLocation(SrvcFeedback feedback) throws WvcmException {
        CTLocation location = this.location();
        CTLocation viewLoc = location.lookupContextLocation(CTLocation.Kind.WORKSPACE);
        if (viewLoc == null) {
            viewLoc = location.lookupContextLocation(CTLocation.Kind.BASE_CC_VIEW);
            if (viewLoc != null) {
                CTLocation lbtypeLoc;
                CTLocation brtypeLoc = location.lookupContextLocation(CTLocation.Kind.BRTYPE);
                if (brtypeLoc == null) {
                    brtypeLoc = viewLoc.lookupContextLocation(CTLocation.Kind.BRTYPE);
                }
                if ((lbtypeLoc = location.lookupContextLocation(CTLocation.Kind.LBTYPE)) == null) {
                    lbtypeLoc = viewLoc.lookupContextLocation(CTLocation.Kind.LBTYPE);
                }
                viewLoc = CTLocation.createBaseViewLocation(viewLoc.getDisplayName(), brtypeLoc, lbtypeLoc);
            } else {
                viewLoc = this.computeViewLocation(feedback);
            }
        }
        return viewLoc;
    }

    private CTLocation computeViewLocation(SrvcFeedback feedback) throws WvcmException {
        String viewTag = ObjSelUtils.getViewTag(CCaseLib.getMvfsRoot(), this.location().getDisplayName());
        CTLocation result = null;
        String info = this.cc.getBaseCCInfo(viewTag, feedback);
        if (info != null) {
            String brtype = CTLocation.getBrtypeFromInfo(info);
            CTLocation brtypeLoc = brtype != null ? CTLocation.valueOf(CTLocation.Kind.BRTYPE, brtype) : null;
            String lbtype = CTLocation.getLbtypeFromInfo(info);
            CTLocation lbtypeLoc = lbtype != null ? CTLocation.valueOf(CTLocation.Kind.LBTYPE, lbtype) : null;
            result = CTLocation.createBaseViewLocation(viewTag, brtypeLoc, lbtypeLoc);
        } else {
            result = CTLocation.valueOf(CTLocation.Kind.WORKSPACE, viewTag);
        }
        return result;
    }

    protected CTView getView(SrvcFeedback feedback) throws WvcmException {
        return (CTView)this.provider().get((Location)this.getViewLocation(feedback), feedback);
    }

    protected String getViewTag(SrvcFeedback feedback) throws WvcmException {
        return this.getView(feedback).getViewTag();
    }

    private boolean getIsVersionControlled(SrvcFeedback feedback) throws WvcmException {
        CCaseObjInfo ccaseObjInfo = this.getObjInfo(feedback);
        return !ccaseObjInfo.getMtype().equals("view private object");
    }

    public CTResource lookupCurrentVersion(SrvcFeedback feedback) throws WvcmException {
        CCaseObjInfo objInfo = this.getObjInfo(feedback);
        if (objInfo.getUniversalSelector() == null || objInfo.getUniversalSelector().isEmpty()) {
            return null;
        }
        CTProvider p = this.provider();
        CTView view = this.getView(feedback);
        boolean isBaseCc = view instanceof CTBaseCCView;
        CTLocation resultLocation = CTVersion.lookupVersionLocation(p, isBaseCc, view.getViewTag(), this.getPathname(feedback), objInfo, feedback);
        CTResource result = p.lookup((Location)resultLocation, feedback);
        if (this._myPathname != null && result != null && !result.getObjInfo(feedback).getPathName().startsWith(String.valueOf(this._myPathname) + "@@")) {
            result.clearPathname();
        }
        return result;
    }

    public CTLocation stripTrailingDot(CTLocation location) {
        if (".".equals(location.lastSegment())) {
            return this.stripTrailingDot(location.parent());
        }
        return location;
    }

    @Override
    public CTLocation getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        CTLocation result = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, this.getPathname(feedback));
        return this.stripTrailingDot(result);
    }

    public CTElement lookupVersionHistory(SrvcFeedback feedback) throws WvcmException {
        CTElement result;
        CTResource currentVersion = this.lookupCurrentVersion(feedback);
        if (currentVersion == null) {
            return null;
        }
        if (currentVersion instanceof CTVersion) {
            CTVersion ver = (CTVersion)currentVersion;
            result = ver.getVersionHistory(feedback);
        } else if (currentVersion instanceof CTElement) {
            result = (CTElement)currentVersion;
        } else {
            throw new IllegalStateException(NLS.bind((String)"current version's class is unsupported {0}", (Object)((Object)((Object)currentVersion)).getClass().toString()));
        }
        return result;
    }

    public static CTControllableResource doCreate(CTProvider provider, Location loc, SrvcFeedback feedback) throws WvcmException {
        CTLocation location = (CTLocation)loc;
        CTLocation parentLoc = location.parent();
        CTControllableFolder parentFolder = new CTControllableFolder((Location)parentLoc, provider);
        parentFolder.prepareToWrite(feedback);
        String pathname = location.getDisplayName();
        File file = new File(pathname);
        try {
            boolean created = file.createNewFile();
            if (!created) {
                throw new WvcmException(NLS.bind((String)Messages.CTControllableResource_FILE_EXISTS_ERROR, (Object)pathname), WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
            }
        }
        catch (IOException e) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableResource_CREATE_FILE_ERROR, (Object)pathname), null, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION, (Throwable)e);
        }
        CTControllableResource result = (CTControllableResource)provider.lookup(loc, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableResource_CREATE_FILE_ERROR, (Object)pathname), null, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        return result;
    }

    public String getPathname(SrvcFeedback feedback) throws WvcmException {
        if (this._myPathname == null) {
            this._myPathname = this.computePathname(feedback);
        }
        return this._myPathname;
    }

    protected String computePathname(SrvcFeedback feedback) throws WvcmException {
        String rawPath = this.location().getDisplayName();
        String path = CommonUtils.canonicalizePathname(rawPath);
        return path;
    }

    public void doVersionControl(SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CTLocation location = this.location();
        CTLocation parentLoc = location.parent();
        CTControllableFolder parentFolder = new CTControllableFolder((Location)parentLoc, provider);
        parentFolder.prepareToWrite(feedback);
        String pathname = this.getPathname(feedback);
        this.cc.makeElement(false, pathname, feedback);
        this.flush(feedback);
    }

    public static CTControllableResource doCreateVersionControlledResource(CTProvider provider, CTLocation location, CTLocation versionLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = provider.getCCaseLib();
        CTControllableFolder parentFolder = CTControllableFolder.getParentFolder(provider, location.parent(), feedback);
        String oldVersionPathname = cc.getVerExtendedPathnameInView(parentFolder.getViewLocation(feedback).getViewTag(), versionLoc.getDisplayName(), feedback);
        String myNewParentPathname = parentFolder.getPathname(feedback);
        String myNewPathname = String.valueOf(myNewParentPathname) + '/' + location.lastSegment();
        parentFolder.prepareToWrite(feedback);
        PropValue pval = updates.get(SymbolicLinkVersion.LINK_TARGET);
        if (pval != null) {
            updated.add(SymbolicLinkVersion.LINK_TARGET);
            CTLocation ltLoc = (CTLocation)((Object)pval.get_value());
            cc.symLink(ltLoc.getDisplayName(), myNewPathname, feedback);
        } else {
            try {
                cc.link(oldVersionPathname, myNewPathname, feedback);
            }
            catch (WvcmException e) {
                if (e.getMessage().contains("cleartool: Error: Cannot link directory")) {
                    cc.fixInvisibleElementPaths(parentFolder.getViewLocation(feedback).getViewTag(), oldVersionPathname, myNewPathname, myNewParentPathname, feedback);
                }
                if (e.getMessage().contains("because it is in lost+found")) {
                    cc.moveName(oldVersionPathname, myNewPathname, feedback);
                }
                throw e;
            }
        }
        CTControllableResource result = (CTControllableResource)provider.get((Location)location, feedback);
        return result;
    }

    public static CTControllableResource valueOf(CTProvider provider, String name, CCaseObjInfo versObjInfo, SrvcFeedback feedback) throws WvcmException {
        CTLocation resultLoc = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, name);
        CTControllableResource result = (CTControllableResource)provider.createAndCacheCTResource(resultLoc, versObjInfo, feedback);
        return result;
    }

    @Override
    public void setObjInfo(CCaseObjInfo objInfo) {
        if (objInfo != null) {
            String mtype = objInfo.getMtype();
            if (this instanceof CTSymbolicLink) {
                if (!mtype.endsWith("symbolic link")) {
                    throw new IllegalArgumentException("The metatype being used for a symbolic link controllable resource is incorrect: " + mtype);
                }
            } else if (mtype.endsWith("element")) {
                throw new IllegalArgumentException("The metatype being used for a controllable resource is incorrect: " + mtype);
            }
        }
        super.setObjInfo(objInfo);
    }

    private String getBaseCcComponentSelectorFromGPath(String myPath, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        String result = null;
        String[] selector = new String[1];
        boolean hasSubVobComponents = CTControllableResource.baseCcComponentSelectorFromGPathLookup(selector, p, this.getViewTag(feedback), myPath, feedback);
        result = hasSubVobComponents ? (selector[0] == null ? null : selector[0]) : this.getVobSelector(myPath, feedback);
        return result;
    }

    protected String getVobSelector(String path, SrvcFeedback feedback) throws WvcmException {
        if (path == null) {
            path = this.getPathname(feedback);
        }
        String vobTag = this.cc.getVobTagFromGpath(path, feedback);
        String result = this.cc.getVobSelector(vobTag, feedback);
        return result;
    }
}

