/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.ICertificateHandler;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.IExternalUserRegistryManager;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ILoginHandler2;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.IRetryPolicy;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ServerStateCheckException;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.internal.CertificateHandlerExtensionReader;
import com.ibm.team.repository.client.internal.ClientLibraryFactoryRegistry;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.internal.ContributorManager;
import com.ibm.team.repository.client.internal.ExternalUserRegistryManager;
import com.ibm.team.repository.client.internal.ItemManager;
import com.ibm.team.repository.client.internal.LoginHandlerExtensionReader;
import com.ibm.team.repository.client.internal.LoginHandlerWrapper;
import com.ibm.team.repository.client.internal.RawRestServiceClientProxy;
import com.ibm.team.repository.client.internal.RestServiceClientProxy;
import com.ibm.team.repository.client.internal.ServiceInterfaceProxy;
import com.ibm.team.repository.client.internal.Statistics;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.client.util.RepositoryUtil;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IRepositoryRoot;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.ServerVersionCheckException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.IContentRestService;
import com.ibm.team.repository.common.internal.IItemRestService;
import com.ibm.team.repository.common.internal.IRepositoryRemoteService;
import com.ibm.team.repository.common.internal.IRepositoryRestService;
import com.ibm.team.repository.common.internal.util.ComponentConfigurationRegistry;
import com.ibm.team.repository.common.internal.util.ComponentRegistry;
import com.ibm.team.repository.common.internal.util.IComponentElementDescriptor;
import com.ibm.team.repository.common.internal.util.IModelElementDescriptor;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.model.PackageDescription;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.ServerDescription;
import com.ibm.team.repository.common.model.ServerStateDTO;
import com.ibm.team.repository.common.service.IExternalUserRegistryService;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.transport.AbstractTeamServer;
import com.ibm.team.repository.common.transport.CancelableCaller;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.ICancelableRunnable;
import com.ibm.team.repository.common.transport.ICertificateValidator;
import com.ibm.team.repository.common.transport.IDirectWritingContentService;
import com.ibm.team.repository.common.transport.ITeamContentService;
import com.ibm.team.repository.common.transport.ITeamServer;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.InsecureProtocolException;
import com.ibm.team.repository.common.transport.TeamServerConfiguration;
import com.ibm.team.repository.common.transport.VersionMismatchException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.IInternalRawRestServiceClient;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import com.ibm.team.repository.transport.client.TeamRawRestServiceClient;
import com.ibm.team.repository.transport.client.TeamServerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class TeamRepository
extends EventSource
implements ITeamRepository,
IClientLibraryContext {
    private final IItemManager itemManager;
    private IContentManager contentManager;
    private final IContributorManager contributorManager;
    private final IExternalUserRegistryManager externalUserRegistryManager;
    private final IStatistics statistics;
    private ITeamServer teamServer;
    private IRepositoryRemoteService serverRepositoryRemoteService;
    private IQueryService queryService;
    private IExternalUserRegistryService externalRegistryService;
    private ITeamRestServiceClient itemRestService;
    private ITeamRawRestServiceClient rawRestService;
    private ITeamRestServiceClient repositoryRestService;
    private ITeamRestServiceClient contentRestService;
    private final Map loginParticipants = new IdentityHashMap();
    private final Map clientLibraries = new IdentityHashMap();
    private final Object lock = new Object();
    private final Lock loginLock = new ReentrantLock();
    private ILoginHandler2 loginHandler;
    private IContributor loggedInContributor;
    private IRepositoryRoot repositoryRoot;
    private String publicUriRoot;
    private int state = 3;
    private int errorState = 0;
    private Throwable lastError = null;
    private String name = null;
    private UUID id = null;
    private String localRepositoryURI;
    private final Collection aliasRepositoryURIs = new HashSet();
    private String userId = null;
    private boolean rememberPassword = false;
    private boolean autoLogin = false;
    private final boolean autoLoginHander;
    private static final int LOGIN_RETRIES = 3;
    private final Map nsURIToVersionMap = new HashMap();
    private String repositoryBuildId;
    private String repositoryVersion;
    private int debugMode = 0;
    private static boolean acceptAllCertificates = false;
    private boolean mayLogIntoJts = true;
    private ILoginInfo2 loginInfo = null;
    private String serverStateId;
    private IRetryPolicy retryPolicy;
    private static final String FOUNDATION_COMPONENT_TAG = "com.ibm.team.jazz.foundation";
    private static final String RTC_COMPONENT_TAG = "com.ibm.team.rtc";
    private static final String JSON_PROP_COMPATIBLE = "compatible";
    private static final String JSON_PROP_IS_JTS = "isJTS";
    private static final String JSON_PROP_SERVER_VERSION = "serverVersion";
    private static final String JSON_PROP_MESSAGE = "message";
    private static final String JSON_PROP_URI = "uri";
    private static final String DEFAULT_COMPATIBILITY_URL = "https://jazz.net/downloads/rational-team-concert";
    private static final String FORM_AUTH_USER_FIELD = "j_username";
    private static final String FORM_AUTH_PASSWORD_FIELD = "j_password";
    private static final String UTF8_CHARSET_NAME = "UTF-8";

    TeamRepository(String repositoryURI, boolean autoLoginHandler) {
        super((EventSource)((Object)TeamPlatform.getTeamRepositoryService()));
        this.teamServer = TeamServerFactory.INSTANCE.newTeamServerFromURL(repositoryURI, this.getCertificateHandler());
        if (this.teamServer == null) {
            throw new IllegalArgumentException("The server address is not valid.");
        }
        this.initialize(repositoryURI);
        this.teamServer.setCredentials("", "");
        this.serverRepositoryRemoteService = (IRepositoryRemoteService)this.getServiceInterface(IRepositoryRemoteService.class);
        if (this.serverRepositoryRemoteService == null) {
            throw new IllegalArgumentException("Unable to initialize repository service");
        }
        this.queryService = (IQueryService)this.getServiceInterface(IQueryService.class);
        if (this.queryService == null) {
            throw new IllegalArgumentException("Unable to initialize repository query service");
        }
        this.externalRegistryService = (IExternalUserRegistryService)this.getServiceInterface(IExternalUserRegistryService.class);
        if (this.externalRegistryService == null) {
            throw new IllegalArgumentException("Unable to initialize external user registry service");
        }
        ITeamContentService contentService = (ITeamContentService)this.getServiceInterface(IDirectWritingContentService.class);
        if (contentService == null) {
            throw new IllegalArgumentException("Unable to initialize content service");
        }
        this.itemRestService = (ITeamRestServiceClient)this.getServiceInterface(IItemRestService.class);
        this.contentRestService = (ITeamRestServiceClient)this.getServiceInterface(IContentRestService.class);
        this.repositoryRestService = (ITeamRestServiceClient)this.getServiceInterface(IRepositoryRestService.class);
        this.rawRestService = (ITeamRawRestServiceClient)this.getServiceInterface(ITeamRawRestServiceClient.class);
        this.contentManager = new ContentManager(this, contentService, this.contentRestService);
        this.itemManager = new ItemManager(this);
        this.contributorManager = new ContributorManager(this);
        this.statistics = new Statistics(this);
        this.autoLoginHander = autoLoginHandler;
        this.externalUserRegistryManager = new ExternalUserRegistryManager(this);
        this.retryPolicy = IRetryPolicy.DEFAULT;
    }

    private void initialize(String repositoryURI) {
        this.localRepositoryURI = repositoryURI.startsWith("local:/") ? repositoryURI : null;
        this.aliasRepositoryURIs.add(repositoryURI);
        if (repositoryURI.endsWith("/")) {
            this.aliasRepositoryURIs.add(repositoryURI.substring(0, repositoryURI.length() - 1));
        } else {
            this.aliasRepositoryURIs.add(String.valueOf(repositoryURI) + '/');
        }
        String actualRepositoryURI = this.teamServer.getRepositoryURL();
        this.aliasRepositoryURIs.add(actualRepositoryURI);
        if (actualRepositoryURI.endsWith("/")) {
            this.aliasRepositoryURIs.add(actualRepositoryURI.substring(0, actualRepositoryURI.length() - 1));
        } else {
            this.aliasRepositoryURIs.add(String.valueOf(actualRepositoryURI) + '/');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRepositoryRoot root() {
        Object object = this.lock;
        synchronized (object) {
            return this.repositoryRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String publicUriRoot() {
        Object object = this.lock;
        synchronized (object) {
            return this.publicUriRoot;
        }
    }

    @Override
    public IContentManager contentManager() {
        return this.contentManager;
    }

    @Override
    public IItemManager itemManager() {
        return this.itemManager;
    }

    @Override
    public IContributorManager contributorManager() {
        return this.contributorManager;
    }

    @Override
    public IExternalUserRegistryManager externalUserRegistryManager() {
        return this.externalUserRegistryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getClientLibrary(Class interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException();
        }
        Object clientLibrary = null;
        Map map = this.clientLibraries;
        synchronized (map) {
            clientLibrary = this.clientLibraries.get(interfaceClass);
            if (clientLibrary == null) {
                clientLibrary = ClientLibraryFactoryRegistry.INSTANCE.getClientLibrary(this, interfaceClass);
                this.clientLibraries.put(interfaceClass, clientLibrary);
            }
        }
        return clientLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLoginHandler(ITeamRepository.ILoginHandler handler) {
        Object object = this.lock;
        synchronized (object) {
            this.loginHandler = new LoginHandlerWrapper(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLoginHandler(ILoginHandler2 handler) {
        Object object = this.lock;
        synchronized (object) {
            this.loginHandler = handler;
        }
    }

    @Override
    public void registerOAuthHandler(IOAuthHandler handler) {
        if (this.rawRestService == null) {
            throw new IllegalStateException("Setting an OAuth handler on a non-existent RawRestServiceClient");
        }
        ((IInternalRawRestServiceClient)this.rawRestService).setOAuthHandler(handler);
        if (this.teamServer instanceof RemoteTeamServer) {
            ((RemoteTeamServer)this.teamServer).setOAuthHandler(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDefaultLoginHandler() {
        LoginHandlerExtensionReader.Descriptor[] loginHandlers = LoginHandlerExtensionReader.INSTANCE.getLoginHandlers();
        int highestPriority = 0;
        int i = 0;
        while (i < loginHandlers.length) {
            int priority;
            LoginHandlerExtensionReader.Descriptor descriptor = loginHandlers[i];
            ILoginHandler2 loginHandler2 = descriptor.getLoginHandler2();
            IOAuthHandler oauthHandler = descriptor.getOAuthHandler();
            if (loginHandler2 != null && (priority = descriptor.getPriority()) != 0 && (highestPriority == 0 || highestPriority > priority)) {
                highestPriority = priority;
                Object object = this.lock;
                synchronized (object) {
                    this.registerLoginHandler(loginHandler2);
                    this.registerOAuthHandler(oauthHandler);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoginParticipant(ITeamRepository.ILoginParticipant participant) {
        Object object = this.lock;
        synchronized (object) {
            this.loginParticipants.put(participant, participant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLoginParticipant(ITeamRepository.ILoginParticipant participant) {
        Object object = this.lock;
        synchronized (object) {
            this.loginParticipants.remove(participant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void login(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtil.beginMonitor(monitor, -1);
        try {
            Object object = this.lock;
            synchronized (object) {
                block37: {
                    if (this.state != 1 || this.errorState != 0) break block37;
                    return;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                try {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 4, 10] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.setState(0);
                    this.setErrorState(0, null);
                    int i = 1;
                    while (i <= 3) {
                        Object object2 = this.lock;
                        synchronized (object2) {
                            if (this.state == 1 && this.errorState == 0) {
                                break;
                            }
                        }
                        try {
                            monitor.worked(1);
                            this.internalLogin((IProgressMonitor)new SubProgressMonitor(monitor, -1));
                            monitor.worked(1);
                            if (!monitor.isCanceled()) break;
                            throw new OperationCanceledException();
                        }
                        catch (VersionMismatchException versionMismatch) {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            throw versionMismatch;
                        }
                        catch (ServerVersionCheckException serverVersionCheck) {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            throw serverVersionCheck;
                        }
                        catch (ServerStateCheckException serverStateCheck) {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            throw serverStateCheck;
                        }
                        catch (InsecureProtocolException ex) {
                            throw ex;
                        }
                        catch (TeamRepositoryException e) {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            if (i == 3) {
                                throw e;
                            }
                            this.setState(0);
                            if (this.getErrorState() != 2) {
                                this.setErrorState(0, null);
                            }
                            ++i;
                        }
                    }
                    this.getClientLibrary(ILicenseClient.class);
                    ITeamRepository.ILoginParticipant[] participants = null;
                    Object e = this.lock;
                    synchronized (e) {
                        participants = this.loginParticipants.keySet().toArray(new ITeamRepository.ILoginParticipant[this.loginParticipants.size()]);
                    }
                    int i2 = 0;
                    while (i2 < participants.length) {
                        final ITeamRepository.ILoginParticipant participant = participants[i2];
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void handleException(Throwable exception) {
                            }

                            public void run() throws Exception {
                                participant.handleLogin(TeamRepository.this);
                            }
                        });
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++i2;
                    }
                    try {
                        String repoBuildId = RepositoryUtil.getRepositoryBuildId(this, monitor);
                        monitor.worked(1);
                        String repoVersion = RepositoryUtil.getRepositoryVersion(this, monitor);
                        Object object3 = this.lock;
                        synchronized (object3) {
                            this.repositoryBuildId = repoBuildId;
                            this.repositoryVersion = repoVersion;
                        }
                    }
                    catch (ItemNotFoundException itemNotFoundException) {}
                }
                catch (OperationCanceledException e) {
                    this.internalLogout();
                    throw e;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 1) {
                return;
            }
        }
        this.setState(2);
        ITeamRepository.ILoginParticipant[] participants = null;
        Object object2 = this.lock;
        synchronized (object2) {
            participants = this.loginParticipants.keySet().toArray(new ITeamRepository.ILoginParticipant[this.loginParticipants.size()]);
        }
        int i = 0;
        while (i < participants.length) {
            final ITeamRepository.ILoginParticipant participant = participants[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    participant.handleLogout(TeamRepository.this);
                }
            });
            ++i;
        }
        this.internalLogout();
    }

    @Override
    public void logout(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ClientUtil.beginMonitor(monitor, 100);
        try {
            this.logout();
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loggedIn() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == 1 || this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IContributor loggedInContributor() {
        Object object = this.lock;
        synchronized (object) {
            return this.loggedInContributor;
        }
    }

    @Override
    public String getRepositoryURI() {
        return this.localRepositoryURI == null ? this.teamServer.getRepositoryURL() : this.localRepositoryURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int state) {
        Object object = this.lock;
        synchronized (object) {
            if (state == this.state) {
                return;
            }
        }
        try {
            this.acquire();
            int oldState = 3;
            Object object2 = this.lock;
            synchronized (object2) {
                oldState = this.state;
                this.state = state;
            }
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", this, "state", oldState, this.state));
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getErrorState() {
        Object object = this.lock;
        synchronized (object) {
            return this.errorState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorState(int errorState, Throwable lastError) {
        Object object = this.lock;
        synchronized (object) {
            this.lastError = lastError;
            if (errorState == this.errorState) {
                return;
            }
        }
        try {
            this.acquire();
            int oldState = 0;
            Object object2 = this.lock;
            synchronized (object2) {
                oldState = this.errorState;
                this.errorState = errorState;
            }
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", this, "error_state", oldState, this.errorState));
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Throwable getLastError() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSavePassword(boolean rememberPassword) {
        Object object = this.lock;
        synchronized (object) {
            if (rememberPassword == this.rememberPassword) {
                return;
            }
        }
        try {
            this.acquire();
            boolean oldRememberPassword = false;
            Object object2 = this.lock;
            synchronized (object2) {
                oldRememberPassword = this.rememberPassword;
                this.rememberPassword = rememberPassword;
            }
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", this, "savePassword", oldRememberPassword, this.rememberPassword));
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getSavePassword() {
        Object object = this.lock;
        synchronized (object) {
            return this.rememberPassword;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMayLogIntoJts(boolean mayLogIntoJts) {
        Object object = this.lock;
        synchronized (object) {
            if (mayLogIntoJts == this.mayLogIntoJts) {
                return;
            }
        }
        try {
            this.acquire();
            boolean oldMayLogIntoJts = false;
            Object object2 = this.lock;
            synchronized (object2) {
                oldMayLogIntoJts = this.mayLogIntoJts;
                this.mayLogIntoJts = mayLogIntoJts;
            }
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", this, "mayLogIntoJts", oldMayLogIntoJts, this.mayLogIntoJts));
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMayLogIntoJts() {
        Object object = this.lock;
        synchronized (object) {
            return this.mayLogIntoJts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoLogin(boolean autoLogin) {
        Object object = this.lock;
        synchronized (object) {
            if (autoLogin == this.autoLogin) {
                return;
            }
        }
        try {
            this.acquire();
            boolean oldAutoLogin = false;
            Object object2 = this.lock;
            synchronized (object2) {
                oldAutoLogin = this.autoLogin;
                this.autoLogin = autoLogin;
            }
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", this, "autoLogin", oldAutoLogin, this.autoLogin));
            this.teamServer.setLoadSessionState(autoLogin);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoLogin() {
        Object object = this.lock;
        synchronized (object) {
            return this.autoLogin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) {
        Object object = this.lock;
        synchronized (object) {
            if (name == this.name) {
                return;
            }
            if (name != null && name.equals(this.name)) {
                return;
            }
        }
        try {
            this.acquire();
            String oldName = null;
            Object object2 = this.lock;
            synchronized (object2) {
                oldName = this.name;
                this.name = name;
            }
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", this, "name", oldName, this.name));
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(UUID id) {
        IRepositoryRoot root = this.root();
        if (root != null && id != null && !id.equals((Object)root.getItemId())) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (id == this.id) {
                return;
            }
            if (id != null && id.equals((Object)this.id)) {
                return;
            }
        }
        try {
            this.acquire();
            UUID oldId = null;
            Object object2 = this.lock;
            synchronized (object2) {
                oldId = this.id;
                this.id = id;
            }
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", this, "id", oldId, this.id));
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID getId() {
        Object object = this.lock;
        synchronized (object) {
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAliasRepositoryURI(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.acquire();
            boolean added = false;
            Object object = this.lock;
            synchronized (object) {
                if (!this.aliasRepositoryURIs.contains(uri)) {
                    this.aliasRepositoryURIs.add(uri);
                    added = true;
                }
            }
            if (added) {
                this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertyAdd", this, "aliasRepositoryURIs", null, uri));
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAliasRepositoryURI(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.acquire();
            boolean removed = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.aliasRepositoryURIs.contains(uri)) {
                    this.aliasRepositoryURIs.remove(uri);
                    removed = true;
                }
            }
            if (removed) {
                this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertyRemove", this, "aliasRepositoryURIs", uri, null));
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getAliasRepositoryURIs() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableCollection(new HashSet(this.aliasRepositoryURIs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserId(String userId) {
        Object object = this.lock;
        synchronized (object) {
            if (userId == this.userId) {
                return;
            }
            if (userId != null && userId.equals(this.userId)) {
                return;
            }
        }
        try {
            this.acquire();
            String oldUserId = null;
            Object object2 = this.lock;
            synchronized (object2) {
                oldUserId = this.userId;
                this.userId = userId;
            }
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", this, "userId", oldUserId, this.userId));
        }
        finally {
            this.release();
        }
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setConnectionTimeout(int timeoutInSeconds) {
        if (timeoutInSeconds < 0) {
            throw new IllegalArgumentException();
        }
        TeamServerConfiguration config = this.teamServer.getConfiguration();
        config.setSocketTimeout(timeoutInSeconds * 1000);
    }

    @Override
    public int getConnectionTimeout() {
        int timeout = this.teamServer.getConfiguration().getSocketTimeout();
        if (timeout <= 0) {
            return 0;
        }
        return timeout / 1000;
    }

    @Override
    public IStatistics statistics() {
        return this.statistics;
    }

    @Override
    public ITeamRepository teamRepository() {
        return this;
    }

    @Override
    public Object getServiceInterface(Class interfaceClass) {
        ITeamService service = this.getTeamService(interfaceClass);
        if (service == null) {
            return null;
        }
        Object serviceImplementation = service.getImplementation();
        if (serviceImplementation == null) {
            return null;
        }
        Object wrappedServiceProxy = serviceImplementation instanceof ITeamRestServiceClient ? RestServiceClientProxy.newRestServiceClientProxy(interfaceClass, (ITeamRestServiceClient)serviceImplementation, this) : (serviceImplementation instanceof ITeamRawRestServiceClient ? RawRestServiceClientProxy.newRawRestServiceClientProxy((IInternalRawRestServiceClient)new TeamRawRestServiceClient((RemoteTeamServer)this.teamServer), this) : ServiceInterfaceProxy.newServiceInterfaceProxy(interfaceClass, serviceImplementation, this));
        return wrappedServiceProxy;
    }

    @Override
    public <T> T callCancelableService(final IClientLibraryContext.IServiceRunnable<T> runnable, IProgressMonitor monitor) throws TeamRepositoryException {
        final Object[] object = new Object[1];
        IProgressMonitor progress = ClientUtil.getMonitor(monitor);
        try {
            try {
                if (this.getRetryPolicy().autoReLogin() && this.getState() == 3 && this.getErrorState() != 2) {
                    this.login((IProgressMonitor)new SubProgressMonitor(progress, -1));
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {}
            try {
                CancelableCaller.call((IProgressMonitor)new SubProgressMonitor(progress, -1), (ICancelableRunnable)new ICancelableRunnable(){

                    public void run(IProgressMonitor progressMonitor) throws OperationCanceledException {
                        try {
                            object[0] = runnable.run(progressMonitor);
                        }
                        catch (TeamRepositoryException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TeamRepositoryException) {
                    throw (TeamRepositoryException)cause;
                }
                throw e;
            }
        }
        finally {
            progress.done();
        }
        return (T)object[0];
    }

    public IRepositoryRemoteService getServerRepositoryRemoteService() {
        return this.serverRepositoryRemoteService;
    }

    public IQueryService getQueryService() {
        return this.queryService;
    }

    @Deprecated
    public IExternalUserRegistryService getExternalUserRegistryService() {
        return this.externalRegistryService;
    }

    public ITeamRestServiceClient getItemRestService() {
        return this.itemRestService;
    }

    public ITeamRestServiceClient getRepositoryRestService() {
        return this.repositoryRestService;
    }

    public String getLocalVersion(String modelUri) {
        return ComponentRegistry.INSTANCE.getModelVersion(modelUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteVersion(String nsURI) {
        String version = null;
        Object object = this.lock;
        synchronized (object) {
            version = (String)this.nsURIToVersionMap.get(nsURI);
        }
        if (version == null) {
            version = this.getLocalVersion(nsURI);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepositoryBuildId() {
        Object object = this.lock;
        synchronized (object) {
            return this.repositoryBuildId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepositoryVersion() {
        Object object = this.lock;
        synchronized (object) {
            return this.repositoryVersion;
        }
    }

    public int getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(int mode) {
        ITeamRepository[] managedRepos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < managedRepos.length) {
            ITeamRepository repository = managedRepos[i];
            if (repository == this) {
                throw new IllegalStateException("Debug settings are only allowed on unmanaged repository instances.");
            }
            ++i;
        }
        if (mode != 1 && mode != 0) {
            throw new IllegalArgumentException(String.format("%s is not a valid debug mode.", mode));
        }
        this.debugMode = mode;
    }

    @Override
    public void setProxy(String host, int port, String userName, String password) {
        this.teamServer.setProxy(host, port, userName, password);
    }

    /*
     * Exception decompiling
     */
    private void internalLogin(IProgressMonitor monitor) throws TeamRepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ITeamRawRestServiceClient.IRawRestClientConnection buildConnection(String clientVersionString) throws TeamRepositoryException {
        String uriRoot = this.teamServer.getRepositoryURL();
        String uriString = String.valueOf(uriRoot) + "versionCompatibility?clientVersion=" + clientVersionString;
        try {
            java.net.URI uri = new java.net.URI(uriString);
            return this.getRawRestServiceClient().getConnection(uri);
        }
        catch (URISyntaxException e) {
            String pattern = Messages.getClientString("TeamRepository.InvalidVersionCompatibilityUri");
            String message = NLS.bind((String)pattern, (Object)uriRoot, (Object[])new Object[]{e.getMessage()});
            throw new TeamRepositoryException(message);
        }
    }

    private JSONObject fetchClientVersionJSONObject(ITeamRawRestServiceClient.IRawRestClientConnection connection, String clientVersionString, IProgressMonitor monitor) throws TeamRepositoryException {
        JSONObject jSONObject;
        ITeamRawRestServiceClient.IRawRestClientConnection.Response resp = null;
        try {
            resp = connection.doGet();
        }
        catch (InsecureProtocolException ex) {
            throw ex;
        }
        catch (AuthenticationException e) {
            String message = Messages.getClientString("TeamRepository.ServerAuthenticationException");
            throw new ServerVersionCheckException(message, DEFAULT_COMPATIBILITY_URL, "", clientVersionString, (Object)this, (Throwable)e);
        }
        try {
            JSONObject responseObject;
            InputStreamReader responseReader;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            int statusCode = resp.getStatusCode();
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (statusCode != 200) {
                if (statusCode == 404) {
                    String message = NLS.bind((String)Messages.getClientString("TeamRepository.ServerHasNoCompatibilityService"), (Object)this.teamServer.getRepositoryURL(), (Object[])new Object[0]);
                    throw new ConnectionException(message);
                }
                String errorMessage = Integer.toString(resp.getStatusCode());
                if (resp.getStatusText() != null) {
                    errorMessage = String.valueOf(errorMessage) + " " + resp.getStatusText();
                }
                String pattern = Messages.getClientString("TeamRepository.ErrorInvokingVersionCompatibilityService");
                String message = NLS.bind((String)pattern, (Object)errorMessage, (Object[])new Object[0]);
                throw new TeamRepositoryException(message);
            }
            try {
                responseReader = new InputStreamReader(resp.getResponseStream(), UTF8_CHARSET_NAME);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new TeamRepositoryException("UTF-8 encoding is not supported");
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                responseObject = JSONObject.parse((Reader)responseReader);
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
            jSONObject = responseObject;
        }
        catch (Throwable throwable) {
            try {
                InputStream responseStream = resp.getResponseStream();
                if (responseStream != null) {
                    responseStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            InputStream responseStream = resp.getResponseStream();
            if (responseStream != null) {
                responseStream.close();
            }
        }
        catch (IOException iOException) {}
        return jSONObject;
    }

    private void checkServerVersionMatches(IProgressMonitor monitor) throws TeamRepositoryException {
        Boolean isJTS;
        final String clientVersionString = this.getClientVersionString();
        if (clientVersionString == null) {
            throw new TeamRepositoryException("Badly configured client.  Missing a foundation component tag.");
        }
        final ITeamRawRestServiceClient.IRawRestClientConnection connection = this.buildConnection(clientVersionString);
        IClientLibraryContext.IServiceRunnable<JSONObject> r = new IClientLibraryContext.IServiceRunnable<JSONObject>(){

            @Override
            public JSONObject run(IProgressMonitor mon) throws TeamRepositoryException {
                return TeamRepository.this.fetchClientVersionJSONObject(connection, clientVersionString, mon);
            }
        };
        JSONObject responseObject = this.callCancelableService(r, monitor);
        if (!this.mayLogIntoJts && (isJTS = (Boolean)responseObject.get((Object)JSON_PROP_IS_JTS)) != null && isJTS.booleanValue()) {
            String message = Messages.getClientString("TeamRepository.ClientNotAllowedToConnectToJTS");
            throw new TeamRepositoryException(message);
        }
        Boolean compatible = (Boolean)responseObject.get((Object)JSON_PROP_COMPATIBLE);
        if (compatible == null) {
            String message = Messages.getClientString("TeamRepository.InvalidResonseInvokingVersionCompatibilityService");
            throw new TeamRepositoryException(message);
        }
        if (!compatible.booleanValue()) {
            String upgradeURI = (String)responseObject.get((Object)JSON_PROP_URI);
            String upgradeMessage = (String)responseObject.get((Object)JSON_PROP_MESSAGE);
            String serverVersion = (String)responseObject.get((Object)JSON_PROP_SERVER_VERSION);
            if (upgradeURI == null || upgradeMessage == null || serverVersion == null) {
                String message = Messages.getClientString("TeamRepository.InvalidResonseInvokingVersionCompatibilityService");
                throw new TeamRepositoryException(message);
            }
            throw new ServerVersionCheckException(upgradeMessage, upgradeURI, serverVersion, clientVersionString, (Object)this);
        }
    }

    private String getClientVersionString() {
        Map compatibilityMap = ComponentConfigurationRegistry.INSTANCE.getClientCompatibilityMap();
        String version = (String)compatibilityMap.get(RTC_COMPONENT_TAG);
        if (version == null) {
            version = (String)compatibilityMap.get(FOUNDATION_COMPONENT_TAG);
        }
        return version;
    }

    private Throwable getRootCause(TeamRepositoryException e) {
        Throwable th = e;
        while (th.getCause() != null) {
            th = th.getCause();
        }
        return th;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalLogout() {
        Object object = this.lock;
        synchronized (object) {
            this.loggedInContributor = null;
        }
        this.setState(3);
        this.teamServer.closeConnections(this.autoLogin);
    }

    private ITeamService getTeamService(Class serviceInterface) {
        ITeamService result = this.teamServer.getService(serviceInterface);
        if (this.teamServer.isLocal()) {
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPackages(List packageDescriptions, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<String> unknownPackageURIs = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            for (PackageDescription description : packageDescriptions) {
                String localVersion;
                IComponentElementDescriptor componentElementDescriptor;
                IModelElementDescriptor modelElementDescriptor;
                if (!this.isPackageRegistered(description.getNsURI())) {
                    unknownPackageURIs.add(description.getNsURI());
                    continue;
                }
                String nsURI = description.getNsURI();
                if (nsURI == null) continue;
                ComponentRegistry.INSTANCE.registerRemoteModel(null, null, null, nsURI);
                String remoteVersion = description.getVersion();
                if (remoteVersion == null) continue;
                this.nsURIToVersionMap.put(nsURI, remoteVersion);
                Object object2 = EPackage.Registry.INSTANCE.get((Object)nsURI);
                if (object2 != RepositoryPackage.eINSTANCE || (modelElementDescriptor = (componentElementDescriptor = ComponentRegistry.INSTANCE.getComponentDescriptorForModelUri(nsURI)).getModelElementDescriptor()).isClientAndServerCompatible(localVersion = this.getLocalVersion(nsURI), remoteVersion)) continue;
                String message = NLS.bind((String)Messages.getServerString("TeamRepository.VersionMismatch"), (Object)nsURI, (Object[])new Object[]{remoteVersion, localVersion});
                throw new TeamRepositoryException((Object)this, message);
            }
        }
        if (!unknownPackageURIs.isEmpty()) {
            EPackage[] newPackages = this.getPackages(unknownPackageURIs.toArray(new String[unknownPackageURIs.size()]), monitor);
            int i = 0;
            while (i < newPackages.length) {
                this.registerPackage(newPackages[i].getNsURI(), newPackages[i]);
                ++i;
            }
        }
    }

    private EPackage[] getPackages(final String[] nsURIs, IProgressMonitor monitor) throws TeamRepositoryException {
        String[] packageContents = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<String[]>(){

            @Override
            public String[] run(IProgressMonitor progressMonitor) throws TeamRepositoryException, OperationCanceledException {
                return TeamRepository.this.getServerRepositoryRemoteService().fetchDynamicPackages(nsURIs);
            }
        }, monitor);
        EPackage[] dynamicPackages = new EPackage[packageContents.length];
        int i = 0;
        while (i < packageContents.length) {
            try {
                dynamicPackages[i] = this.demarshal(packageContents[i]);
            }
            catch (IOException e) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getServerString("TeamRepository.PackageRetrievalError"), (Object)EPackage.class.getName(), (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            }
            ++i;
        }
        return dynamicPackages;
    }

    private EPackage demarshal(String packageContents) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(packageContents.getBytes(HttpUtil.CharsetEncoding.UTF8.toString()));
        Resource resource = new XMIResourceFactoryImpl().createResource(URI.createURI((String)""));
        resource.load((InputStream)inputStream, new HashMap());
        return (EPackage)resource.getContents().get(0);
    }

    private boolean isPackageRegistered(String nsURI) {
        return EPackage.Registry.INSTANCE.containsKey((Object)nsURI);
    }

    private void registerPackage(String nsURI, EPackage ePackage) {
        if (!this.isPackageRegistered(ePackage.getNsURI())) {
            EPackage.Registry.INSTANCE.put((Object)nsURI, (Object)ePackage);
        }
    }

    private ICertificateValidator getCertificateHandler() {
        final ICertificateHandler handler = CertificateHandlerExtensionReader.INSTANCE.getHighestPriorityHandler();
        return new ICertificateValidator(){

            public ICertificateValidator.Trust validate(X509Certificate certificate, CertificateException problem) {
                if (acceptAllCertificates) {
                    return ICertificateValidator.Trust.ACCEPT_CONNECTION;
                }
                if (handler == null) {
                    return ICertificateValidator.Trust.REJECT;
                }
                ICertificateHandler.Trust result = handler.evaluate(TeamRepository.this, certificate, problem);
                return ICertificateValidator.Trust.valueOf((String)result.name());
            }
        };
    }

    public static void setAcceptAllCertificates(boolean acceptAll) {
        acceptAllCertificates = acceptAll;
    }

    public void formBasedAuthenticate(HttpURLConnection authConnection) throws IOException {
        OutputStream stream = authConnection.getOutputStream();
        try {
            String[] creds = ((RemoteTeamServer)this.teamServer).getHttpCredentials();
            StringBuilder content = new StringBuilder();
            content.append(FORM_AUTH_USER_FIELD);
            content.append('=');
            content.append(URLEncoder.encode(creds[0], UTF8_CHARSET_NAME));
            content.append('&');
            content.append(FORM_AUTH_PASSWORD_FIELD);
            content.append('=');
            content.append(URLEncoder.encode(creds[1], UTF8_CHARSET_NAME));
            stream.write(content.toString().getBytes(UTF8_CHARSET_NAME));
        }
        finally {
            stream.close();
        }
        authConnection.connect();
    }

    @Override
    public X509Certificate[] getServerCertificatePath() {
        return this.teamServer.getServerCertificatePath();
    }

    @Override
    public ITeamRawRestServiceClient getRawRestServiceClient() {
        return this.rawRestService;
    }

    @Override
    public ILoginInfo2 getLoginInfo() {
        return this.loginInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoginInfo(ILoginInfo2 loginInfo) {
        Object object = this.lock;
        synchronized (object) {
            this.loginInfo = loginInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeRepositoryURI(String newURI) {
        if (!newURI.endsWith("/")) {
            newURI = String.valueOf(newURI) + '/';
        }
        Object object = this.lock;
        synchronized (object) {
            String currentURI = this.teamServer.getRepositoryURL();
            if (currentURI.equals(newURI)) {
                return;
            }
        }
        try {
            this.acquire();
            String oldURI = null;
            Object object2 = this.lock;
            synchronized (object2) {
                oldURI = this.teamServer.getRepositoryURL();
                ((AbstractTeamServer)this.teamServer).setRepositoryURL(newURI);
                this.initialize(newURI);
            }
            this.queueEvent(new PropertyChangeEvent(this, "com.ibm.team.repository.PropertySet", this, JSON_PROP_URI, oldURI, newURI));
        }
        finally {
            this.release();
        }
        this.internalLogout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkServerState(ServerDescription serverDescription) throws ServerStateCheckException {
        ServerStateDTO serverState = serverDescription.getServerState();
        final String newServerStateId = serverState.getServerStateId() != null ? serverState.getServerStateId() : "Sentinel-Server-State";
        Object object = this.lock;
        synchronized (object) {
            if (this.serverStateId != null && !this.serverStateId.equals(newServerStateId)) {
                String reason = serverState.getLastStateChangeMessage();
                String message = NLS.bind((String)Messages.getClientString("TeamRepository.ServerStateMismatch"), (Object)reason, (Object[])new Object[0]);
                throw new ServerStateCheckException(this, message, reason);
            }
            this.addLoginParticipant(new ITeamRepository.ILoginParticipant(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleLogin(ITeamRepository repository) {
                    Object object = TeamRepository.this.lock;
                    synchronized (object) {
                        TeamRepository.this.serverStateId = newServerStateId;
                        TeamRepository.this.removeLoginParticipant(this);
                    }
                }

                @Override
                public void handleLogout(ITeamRepository repository) {
                }
            });
        }
    }

    @Override
    public IRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRetryPolicy setRetryPolicy(IRetryPolicy policy) {
        IRetryPolicy oldPolicy;
        Object object = this.lock;
        synchronized (object) {
            oldPolicy = this.retryPolicy;
            this.retryPolicy = policy;
        }
        return oldPolicy;
    }
}

