/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.urbancode.release.rest.framework.Clients;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.Team;
import com.urbancode.release.rest.models.internal.InternalClients;
import com.urbancode.release.rest.models.internal.Lifecycle;
import com.urbancode.release.rest.models.internal.Phase;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;

public class ScheduledDeploymentBuilder {
    private Release release;
    private String releaseName;
    private ReleaseEnvironment env;
    private Integer phaseIndex;
    private Application[] apps;
    private String[] appNames;
    private Team team;
    private Lifecycle lifecycleModel;
    private Long scheduledDate;

    public ScheduledDeploymentBuilder release(Release release) {
        this.release = release;
        return this;
    }

    public ScheduledDeploymentBuilder releaseName(String releaseName) {
        this.releaseName = releaseName;
        return this;
    }

    public ScheduledDeploymentBuilder environment(ReleaseEnvironment env) {
        this.env = env;
        return this;
    }

    public ScheduledDeploymentBuilder phaseIndex(int phaseIndex) {
        this.phaseIndex = phaseIndex;
        return this;
    }

    public ScheduledDeploymentBuilder applications(Application ... apps) {
        this.apps = apps;
        return this;
    }

    public ScheduledDeploymentBuilder applicationNames(String ... appNames) {
        this.appNames = appNames;
        return this;
    }

    public ScheduledDeploymentBuilder team(Team team) {
        this.team = team;
        return this;
    }

    public ScheduledDeploymentBuilder lifecycleModel(Lifecycle lifecycle) {
        this.lifecycleModel = lifecycle;
        return this;
    }

    public ScheduledDeploymentBuilder scheduledDate(Long date) {
        this.scheduledDate = date;
        return this;
    }

    public ScheduledDeployment build() {
        int i;
        Long oneMonth = 2764800000L;
        if (this.team == null) {
            this.team = Team.SAMPLE_TEAM;
        }
        if (this.lifecycleModel == null) {
            this.lifecycleModel = Lifecycle.DEFAULT_LIFECYCLE;
        }
        if (this.release == null) {
            if (this.releaseName == null) {
                this.release = Release.SAMPLE_RELEASE;
            }
            this.release = (Release)((Release)Release.getOrCreateByName(this.releaseName).targetDate(System.currentTimeMillis() + oneMonth).name(this.releaseName)).team(this.team).lifecycleModel(this.lifecycleModel).save();
        }
        if (this.env == null) {
            this.env = ReleaseEnvironment.DEV_1;
        }
        if (((Release)this.release.get()).phases.length == 0) {
            throw new RuntimeException("The Release must have at least one phase to use provisionSimpleDeployment");
        }
        if (this.apps != null) {
            for (i = 0; i < this.apps.length; ++i) {
                this.release.addApplication(this.apps[i]);
            }
        } else if (this.appNames != null) {
            for (i = 0; i < this.appNames.length; ++i) {
                this.release.addApplication((Application)((Application)Clients.application().name(this.appNames[i])).releaseEnvironments(this.env).teams(this.team).save());
            }
        }
        Phase phase = this.phaseIndex == null ? this.release.phases[0] : this.release.phases[this.phaseIndex];
        Clients.environmentReservation().startDate(946702800000L).endDate(4102462800000L).environment(this.env).phase(phase).save();
        if (this.scheduledDate == null) {
            this.scheduledDate = 1402517280000L;
        }
        return (ScheduledDeployment)InternalClients.scheduledDeployment().release(this.release).phase(phase).environment(this.env).deploymentPlan(phase.deploymentPlan).scheduledDate(this.scheduledDate).save();
    }
}

