/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.ant.com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.air.plugin.ant.com.urbancode.commons.util.Check;
import com.urbancode.air.plugin.ant.com.urbancode.commons.util.IO;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.UUID;

@BridgeMethodsAdded
public final class StringUtil {
    private static final int NORMAL_STATE = 0;
    private static final int ESCAPE_STATE = 1;
    private static final int UNICODE_ESCAPE_STATE = 2;
    private static final int OCTAL_ESCAPE_STATE = 3;
    private static final char[] hexDigits = "0123456789ABCDEF".toCharArray();

    public static int compareIgnoreCase(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareToIgnoreCase(str2);
    }

    public static String valueOfObject(Object obj) {
        return obj == null ? null : String.valueOf(obj);
    }

    public static String trimToNull(String s) {
        String trimmed = s == null ? null : s.trim();
        return trimmed == null || trimmed.length() == 0 ? null : trimmed;
    }

    public static String trimToLength(String s, int length) {
        return s != null && s.length() > length ? s.substring(0, length) : s;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String join(String[] stringsToJoin, String joinWith) {
        StringBuffer sb = new StringBuffer();
        int length = stringsToJoin.length;
        if (length == 1) {
            return stringsToJoin[0];
        }
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(StringUtil.keepTrimmingEnd(stringsToJoin[i], joinWith));
                sb.append(joinWith);
                continue;
            }
            if (i == length - 1) {
                sb.append(StringUtil.keepTrimmingStart(stringsToJoin[i], joinWith));
                continue;
            }
            String s = StringUtil.keepTrimmingStart(stringsToJoin[i], joinWith);
            sb.append(StringUtil.keepTrimmingEnd(s, joinWith));
            sb.append(joinWith);
        }
        return sb.toString();
    }

    public static String join(String[] stringsToJoin, char joinWith) {
        return StringUtil.join(stringsToJoin, String.valueOf(joinWith));
    }

    private static String keepTrimmingEnd(String s, String trim) {
        int endIndex = s.length();
        while (s.regionMatches(true, endIndex - trim.length(), trim, 0, trim.length())) {
            endIndex -= trim.length();
        }
        return s.substring(0, endIndex);
    }

    private static String keepTrimmingStart(String s, String trim) {
        int startIndex = 0;
        while (s.regionMatches(true, startIndex, trim, 0, trim.length())) {
            startIndex += trim.length();
        }
        return s.substring(startIndex);
    }

    @Deprecated
    public static String stringReplace(String source, String toReplace, String replaceWith) {
        return StringUtil.replace(source, toReplace, replaceWith);
    }

    public static String replace(String source, String toReplace, String replaceWith) {
        if (source == null || source.length() == 0) {
            return source;
        }
        int toReplaceLength = toReplace.length();
        StringBuffer newString = new StringBuffer();
        int lastIndex = 0;
        int index = source.indexOf(toReplace, lastIndex);
        if (index < 0) {
            return source;
        }
        while (index >= 0) {
            newString.append(source.substring(lastIndex, index));
            newString.append(replaceWith);
            lastIndex = index + toReplaceLength;
            index = source.indexOf(toReplace, lastIndex);
        }
        newString.append(source.substring(lastIndex));
        return newString.toString();
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        return s.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String s, String suffix) {
        return s.regionMatches(true, s.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static int findMatchingPrefixLength(String t, String o) {
        return StringUtil.findMatchingSubstringLength(false, t, 0, o, 0);
    }

    public static int findMatchingPrefixLength(boolean ignoreCase, String t, String o) {
        return StringUtil.findMatchingSubstringLength(false, t, 0, o, 0);
    }

    public static int findMatchingSubstringLength(String t, int toffset, String o, int ooffset) {
        return StringUtil.findMatchingSubstringLength(false, t, toffset, o, ooffset);
    }

    public static int findMatchingSubstringLength(boolean ignoreCase, String t, int toffset, String o, int ooffset) {
        int lastChar = Math.min(t.length() - toffset, o.length() - ooffset);
        for (int i = 0; i < lastChar; ++i) {
            char c1;
            char c0 = t.charAt(i + toffset);
            if (c0 == (c1 = o.charAt(i + ooffset)) || ignoreCase && (Character.toLowerCase(c0) == Character.toLowerCase(c1) || Character.toUpperCase(c0) == Character.toUpperCase(c1))) continue;
            return i;
        }
        return lastChar;
    }

    public static String findCommonSubstring(boolean ignoreCase, String t, int toffset, String o, int ooffset) {
        int subseqLength = StringUtil.findMatchingSubstringLength(ignoreCase, t, toffset, o, ooffset);
        return t.substring(toffset, toffset + subseqLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String escapeJava(String s) {
        String result = null;
        if (s != null) {
            StringBuffer sb;
            StringBuffer stringBuffer = sb = new StringBuffer();
            synchronized (stringBuffer) {
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c == '\\') {
                        sb.append("\\\\");
                        continue;
                    }
                    if (c == '\b') {
                        sb.append("\\b");
                        continue;
                    }
                    if (c == '\t') {
                        sb.append("\\t");
                        continue;
                    }
                    if (c == '\n') {
                        sb.append("\\n");
                        continue;
                    }
                    if (c == '\f') {
                        sb.append("\\f");
                        continue;
                    }
                    if (c == '\r') {
                        sb.append("\\r");
                        continue;
                    }
                    if (c == '\"') {
                        sb.append("\\\"");
                        continue;
                    }
                    if (c == '\'') {
                        sb.append("\\'");
                        continue;
                    }
                    if (c < ' ' || c > '~') {
                        sb.append('\\');
                        sb.append('u');
                        sb.append(hexDigits[c >>> 12 & 0xF]);
                        sb.append(hexDigits[c >>> 8 & 0xF]);
                        sb.append(hexDigits[c >>> 4 & 0xF]);
                        sb.append(hexDigits[c >>> 0 & 0xF]);
                        continue;
                    }
                    sb.append(c);
                }
                result = sb.toString();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unescapeJava(String str) {
        String result = null;
        int state = 0;
        char escapeChar = '\u0000';
        int digitValue = 0;
        int digitCount = 0;
        if (str != null) {
            StringBuffer buffer;
            StringBuffer stringBuffer = buffer = new StringBuffer(str.length());
            synchronized (stringBuffer) {
                block20: for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    switch (state) {
                        case 0: {
                            if (c != '\\') {
                                buffer.append(c);
                                continue block20;
                            }
                            state = 1;
                            continue block20;
                        }
                        case 1: {
                            switch (c) {
                                case 'u': {
                                    state = 2;
                                    continue block20;
                                }
                                case '\"': 
                                case '\'': 
                                case '\\': {
                                    buffer.append(c);
                                    state = 0;
                                    continue block20;
                                }
                                case 'b': {
                                    buffer.append('\b');
                                    state = 0;
                                    continue block20;
                                }
                                case 't': {
                                    buffer.append('\t');
                                    state = 0;
                                    continue block20;
                                }
                                case 'n': {
                                    buffer.append('\n');
                                    state = 0;
                                    continue block20;
                                }
                                case 'f': {
                                    buffer.append('\f');
                                    state = 0;
                                    continue block20;
                                }
                                case 'r': {
                                    buffer.append('\r');
                                    state = 0;
                                    continue block20;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': {
                                    escapeChar = (char)(c - 48);
                                    digitCount = 1;
                                    state = 3;
                                    continue block20;
                                }
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escapeChar = (char)(c - 48);
                                    digitCount = 2;
                                    state = 3;
                                    continue block20;
                                }
                            }
                            throw new IllegalArgumentException("invalid escape");
                        }
                        case 3: {
                            digitValue = Character.digit(c, 8);
                            if (digitValue != -1) {
                                escapeChar = (char)(escapeChar << 3 | digitValue);
                                ++digitCount;
                            }
                            if (digitCount != 3 && digitValue != -1) continue block20;
                            buffer.append(escapeChar);
                            digitCount = 0;
                            escapeChar = '\u0000';
                            state = 0;
                            if (digitValue != -1) continue block20;
                            if (c != '\\') {
                                buffer.append(c);
                                continue block20;
                            }
                            state = 1;
                            continue block20;
                        }
                        case 2: {
                            if (digitCount == 0 && c == 'u') continue block20;
                            digitValue = Character.digit(c, 16);
                            if (digitValue == -1) {
                                throw new IllegalArgumentException("invalid escape");
                            }
                            escapeChar = (char)(escapeChar << 4 | digitValue);
                            if (++digitCount == 4) {
                                buffer.append(escapeChar);
                                digitCount = 0;
                                escapeChar = '\u0000';
                                state = 0;
                                continue block20;
                            }
                            if (digitCount <= 4) continue block20;
                            throw new IllegalArgumentException("invalid escape");
                        }
                    }
                }
                if (state == 3) {
                    buffer.append(escapeChar);
                } else if (state != 0) {
                    throw new IllegalArgumentException("invalid escape");
                }
                result = buffer.toString();
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String x = UUID.randomUUID().toString();
        System.out.println(x);
        System.out.println(StringUtil.escapePercent(x));
    }

    public static String escapePercent(String str) {
        StringBuilder sb = new StringBuilder();
        ByteBuffer bb = IO.utf8().encode(str);
        while (bb.hasRemaining()) {
            byte b = bb.get();
            if (b >= 65 && b <= 90 || b >= 97 && b <= 122 || b >= 48 && b <= 57 || b == 45 || b == 95 || b == 46 || b == 126) {
                sb.append((char)b);
                continue;
            }
            sb.append('%');
            sb.append(hexDigits[b >>> 4 & 0xF]);
            sb.append(hexDigits[b >>> 0 & 0xF]);
        }
        return sb.toString();
    }

    public static int filterEmpty(String[] array, int offset, int length) {
        Check.indexRange(array.length, offset, length);
        int p = offset;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            if (StringUtil.isEmpty(array[i])) continue;
            array[p] = array[i];
            ++p;
        }
        return p;
    }

    private StringUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    public static final class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(String o1, String o2) {
            return StringUtil.compareIgnoreCase(o1, o2);
        }
    }
}

