/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CopyFileAreasLock
implements ICopyFileAreasLock {
    private final Collection<ICopyFileAreaLockRequest> requests;
    AbstractLock lock;

    public CopyFileAreasLock(Collection<ICopyFileAreaLockRequest> requests) {
        this.requests = requests;
    }

    public void acquire(IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        block4: while (true) {
            progress.setWorkRemaining(100);
            HashSet cfaRules = new HashSet();
            SubMonitor subProgress = progress.newChild(10);
            subProgress.setWorkRemaining(this.requests.size());
            for (ICopyFileAreaLockRequest o : this.requests) {
                CopyFileAreaLockRequest r = (CopyFileAreaLockRequest)o;
                r.addLocks(cfaRules, (IProgressMonitor)subProgress.newChild(1));
            }
            subProgress.done();
            AbstractLock l = CopyFileAreaManager.instance.batchingLock.acquire(MultiLock.combine(cfaRules.toArray(new AbstractLock[cfaRules.size()])), CopyFileAreaManager.instance, BatchingLock.NULL_LOCK_PARTICIPANT, true, (IProgressMonitor)progress.newChild(30));
            boolean success = false;
            try {
                subProgress = progress.newChild(10);
                subProgress.setWorkRemaining(this.requests.size());
                for (ICopyFileAreaLockRequest o : this.requests) {
                    CopyFileAreaLockRequest r = (CopyFileAreaLockRequest)o;
                    if (r.validateLocks((IProgressMonitor)subProgress.newChild(1))) continue;
                    subProgress.done();
                    continue block4;
                }
                subProgress.done();
                this.lock = l;
                success = true;
            }
            finally {
                if (success) continue;
                CopyFileAreaManager.instance.batchingLock.release(l, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            break;
        }
        progress.done();
    }

    @Override
    public void release(IProgressMonitor monitor) throws FileSystemException {
        if (this.lock == null) {
            throw new IllegalMonitorStateException();
        }
        CopyFileAreaManager.instance.batchingLock.release(this.lock, monitor);
        this.lock = null;
    }
}

