/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collections;

public class LoadRequest
implements ILoadRequest {
    private final ISandbox sandbox;
    private final IRelativeLocation relativeLoadPath;
    private final String alternativeName;
    private final IConnection connection;
    private final IComponentHandle component;
    private final IVersionableHandle itemToLoad;
    private boolean isReloadRequest;

    public LoadRequest(ISandbox sandbox, IRelativeLocation relativeLoadPath, String alternativeName, IConnection connection, IComponentHandle component, IVersionableHandle itemToLoad, boolean isReloadRequest) {
        this.sandbox = sandbox;
        if (relativeLoadPath == null || relativeLoadPath.segmentCount() == 0) {
            this.relativeLoadPath = new RelativeLocation(Collections.EMPTY_LIST);
        } else {
            this.relativeLoadPath = relativeLoadPath;
            ILocation fullPath = sandbox.getRoot().append(relativeLoadPath);
            if (!sandbox.getRoot().isPrefixOf(fullPath)) {
                throw new IllegalArgumentException("Invalid relative path " + relativeLoadPath);
            }
        }
        this.alternativeName = alternativeName == null ? "" : alternativeName;
        this.connection = connection;
        this.component = component;
        this.itemToLoad = itemToLoad;
        this.isReloadRequest = isReloadRequest;
    }

    @Override
    public IComponentHandle getComponent() {
        return this.component;
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isReloadRequest() {
        return this.isReloadRequest;
    }

    public void setReloadRequest(boolean reloadRequest) {
        this.isReloadRequest = reloadRequest;
    }

    @Override
    public String getAlternativeName() {
        return this.alternativeName;
    }

    @Override
    public ISandbox getSandbox() {
        return this.sandbox;
    }

    @Override
    public IRelativeLocation getRelativeLoadPath() {
        return this.relativeLoadPath;
    }

    @Override
    public IVersionableHandle getVersionableToLoad() {
        return this.itemToLoad;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.sandbox == null ? 0 : this.sandbox.toString().hashCode());
        result = 31 * result + (this.relativeLoadPath == null ? 0 : this.relativeLoadPath.toString().hashCode());
        result = 31 * result + (this.alternativeName == null ? 0 : this.alternativeName.toString().hashCode());
        result = 31 * result + (this.component == null ? 0 : this.component.getItemId().hashCode());
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        result = 31 * result + (this.itemToLoad == null ? 0 : this.itemToLoad.getItemId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadRequest other = (LoadRequest)obj;
        if (this.alternativeName == null ? other.alternativeName != null : !this.alternativeName.equals(other.alternativeName)) {
            return false;
        }
        if (this.component == null ? other.component != null : !this.component.sameItemId((IItemHandle)other.component)) {
            return false;
        }
        if (this.connection == null ? other.connection != null : !this.connection.equals(other.connection)) {
            return false;
        }
        if (this.sandbox == null) {
            if (other.sandbox != null) {
                return false;
            }
        } else {
            if (other.sandbox == null) {
                return false;
            }
            if (!this.sandbox.equals(other.sandbox)) {
                return false;
            }
        }
        if (this.itemToLoad == null ? other.itemToLoad != null : !this.itemToLoad.sameItemId((IItemHandle)other.itemToLoad)) {
            return false;
        }
        if (this.relativeLoadPath == null) {
            if (other.relativeLoadPath != null) {
                return false;
            }
        } else {
            if (other.relativeLoadPath == null) {
                return false;
            }
            if (!this.relativeLoadPath.equals(other.relativeLoadPath)) {
                return false;
            }
        }
        return true;
    }
}

