/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class CreateBaselineOperation
extends ChangeHistoryChangeSetsOperation
implements ICreateBaselineOperation {
    private Map<ConfigurationFacade, CreateBaselineRequest> requests = new HashMap<ConfigurationFacade, CreateBaselineRequest>();
    private List<IBaselineConnection> baselines = new ArrayList<IBaselineConnection>();
    private CreateBaselineDilemmaHandler problemHandler;

    public CreateBaselineOperation(CreateBaselineDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? CreateBaselineDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? CreateBaselineDilemmaHandler.getDefault() : dilemmaHandler;
    }

    @Override
    public void createBaselineRequest(IWorkspaceConnection workspace, IComponentHandle componentHandle, String name, String comment) {
        if (workspace == null) {
            throw new IllegalArgumentException("missing workspace");
        }
        if (componentHandle == null) {
            throw new IllegalArgumentException("missing component");
        }
        CreateBaselineRequest request = new CreateBaselineRequest();
        request.workspace = workspace;
        request.componentHandle = componentHandle;
        request.name = name;
        request.comment = comment;
        this.requests.put(new ConfigurationFacade((IConnection)workspace, componentHandle), request);
    }

    @Override
    protected void execute(IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.CreateBaselineOperation_0, (int)(10 + 30 * this.requests.size()));
        ArrayList determinants = new ArrayList();
        HashSet<ConfigurationFacade> affectedConfigurations = new HashSet<ConfigurationFacade>();
        affectedConfigurations.addAll(this.requests.keySet());
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants, (IProgressMonitor)monitor.newChild(1));
        try {
            this.runPreConditions(affectedConfigurations, (IProgressMonitor)monitor.newChild(9));
            for (CreateBaselineRequest request : this.requests.values()) {
                this.baselines.add(request.workspace.createBaseline(request.componentHandle, request.name, request.comment, (IProgressMonitor)monitor.newChild(30)));
                this.checkCancelled((IProgressMonitor)monitor);
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void runPreConditions(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationFacade configurationFacade : affectedConfigurations) {
                verifyOp.addToVerify(configurationFacade.getConnection(null), configurationFacade.getComponentHandle());
            }
            verifyOp.run((IProgressMonitor)monitor.newChild(50));
        }
        this.checkinPendingChanges(affectedConfigurations, this.problemHandler, false, (IProgressMonitor)monitor.newChild(50));
        ArrayList<ConfigurationFacade> conflictedConfigurations = new ArrayList<ConfigurationFacade>();
        for (Map.Entry entry : this.requests.entrySet()) {
            CreateBaselineRequest request = (CreateBaselineRequest)entry.getValue();
            if (request.workspace.conflictReport(request.componentHandle).conflicts().isEmpty()) continue;
            conflictedConfigurations.add((ConfigurationFacade)((Object)entry.getKey()));
        }
        if (!conflictedConfigurations.isEmpty()) {
            int n = this.problemHandler.conflictedConfigurations(conflictedConfigurations);
            if (n == 1) {
                throw new OperationCanceledException();
            }
            if (n == 0) {
                for (ConfigurationFacade configurationToSkip : conflictedConfigurations) {
                    this.requests.remove((Object)configurationToSkip);
                }
            } else {
                throw new FileSystemException(Messages.CreateBaselineOperation_1);
            }
        }
    }

    @Override
    public Collection<IBaselineConnection> getBaselinesCreated() {
        return this.baselines;
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.CreateBaselineOperation_REFRESHING_LOCAL_FILESYSTEM, (int)affectedAreas.size());
        for (Map.Entry<ISandbox, Set<ConfigurationFacade>> entry : affectedAreas.entrySet()) {
            IShare[] iShareArray = entry.getKey().allShares((IProgressMonitor)monitor);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                refresher.addToRefresh(share.getShareable());
                ++n2;
            }
        }
    }

    private class CreateBaselineRequest {
        IWorkspaceConnection workspace;
        IComponentHandle componentHandle;
        public String name;
        public String comment;

        private CreateBaselineRequest() {
        }
    }
}

