/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ValueSetProvider;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TeamMemberProvider
extends ValueSetProvider {
    public static final String PROVIDER_ID = "com.ibm.team.workitem.common.teamMemberValueSetProvider";

    @Override
    public Object getNullValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return attribute.getNullValue(workItemCommon.getAuditableCommon(), monitor);
    }

    @Override
    public List getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IContributor> values = new ArrayList<IContributor>();
        Object nullValue = attribute.getNullValue(workItemCommon.getAuditableCommon(), monitor);
        values.add((IContributor)nullValue);
        ItemHandleAwareHashSet<IContributorHandle> handles = new ItemHandleAwareHashSet<IContributorHandle>();
        IContributorHandle user = workItemCommon.getAuditableCommon().getUser();
        IContributor contributor = workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)user, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
        List<IProcessArea> processAreas = workItemCommon.getAuditableCommon().getProcessAreas(contributor, null, ItemProfile.createProfile(IProcessArea.ITEM_TYPE, AuditablesHelper.getProcessPropertiesFromIds(IProcessArea.class, "teamMembers")), monitor);
        for (IProcessArea area : processAreas) {
            if (area == null) continue;
            handles.addAll(Arrays.asList(area.getMembers()));
        }
        values.addAll(workItemCommon.getAuditableCommon().resolveAuditablesPermissionAware(handles.toList(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor));
        return values;
    }
}

