/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueSetProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ValueProviderUtil;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.util.CategoriesManager;
import com.ibm.team.workitem.common.internal.util.CategoryTreeNode;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class FilteringValueSetProvider
implements IValueSetProvider<Identifier<? extends ILiteral>> {
    public static final String FILTER_ATTRIBUTE = "filterAttribute";
    public static final String ENUMERATION = "enumeration";
    public static final String SYNTHETIC_TEAM_AREA_ATTRIBUTE_ID = "com.ibm.team.workitem.teamArea";

    @Override
    public List<Identifier<? extends ILiteral>> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItem == null) {
            List<? extends ILiteral> literals = workItemCommon.resolveEnumeration(attribute, monitor).getEnumerationLiterals(false);
            ArrayList<Identifier<? extends ILiteral>> identifiers = new ArrayList<Identifier<? extends ILiteral>>();
            for (ILiteral iLiteral : literals) {
                identifiers.add(iLiteral.getIdentifier2());
            }
            return identifiers;
        }
        Object filterAttributeValue = null;
        IAttribute filterAttribute = null;
        if (this.isSyntheticTeamAreaAttribute(configuration)) {
            IProcessAreaHandle iProcessAreaHandle = workItemCommon.findProcessArea(workItem, monitor);
            if (iProcessAreaHandle instanceof ITeamAreaHandle) {
                filterAttributeValue = iProcessAreaHandle;
            }
        } else {
            filterAttribute = this.findFilterAttribute(attribute, workItem, workItemCommon, configuration, monitor);
            if (filterAttribute == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.getString("FilteringValueSetProvider.FILTER_ATTRIBUTE_NOT_DEFINED"), (Object)workItem.getId(), (Object[])new Object[]{attribute.getDisplayName()}));
            }
            if (!workItem.hasAttribute(filterAttribute)) {
                throw new IllegalStateException(NLS.bind((String)Messages.getString("FilteringValueSetProvider.FILTER_ATTRIBUTE_NOT_FOUND"), (Object)workItem.getId(), (Object[])new Object[]{attribute.getDisplayName()}));
            }
            filterAttributeValue = workItem.getValue(filterAttribute);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        if (filterAttributeValue instanceof Identifier) {
            arrayList.add(((Identifier)filterAttributeValue).getStringIdentifier());
        } else if (filterAttributeValue instanceof String) {
            arrayList.add((String)filterAttributeValue);
        } else if (filterAttributeValue instanceof SeparatedStringList) {
            SeparatedStringList list = (SeparatedStringList)filterAttributeValue;
            arrayList.addAll(list);
        } else if (filterAttributeValue instanceof Timestamp) {
            Timestamp time = (Timestamp)filterAttributeValue;
            arrayList.add(String.valueOf(time.getTime()));
        } else if (filterAttributeValue instanceof Boolean) {
            arrayList.add(String.valueOf(filterAttributeValue));
        } else if (filterAttributeValue instanceof UUID) {
            arrayList.add(((UUID)filterAttributeValue).getUuidValue());
        } else if (filterAttributeValue instanceof Number) {
            arrayList.add(((Number)filterAttributeValue).toString());
        } else if (filterAttributeValue instanceof IItemHandle) {
            IItemHandle handle = (IItemHandle)filterAttributeValue;
            if (filterAttribute != null && filterAttribute.getIdentifier().equals(IWorkItem.TARGET_PROPERTY) && ValueProviderUtil.includeChildrenInMapping(configuration)) {
                this.resolveParents((IIterationHandle)handle, arrayList, workItemCommon, monitor);
            } else if (filterAttribute != null && filterAttribute.getIdentifier().equals(IWorkItem.CATEGORY_PROPERTY) && ValueProviderUtil.includeChildrenInMapping(configuration)) {
                CategoriesManager manager = CategoriesManager.createInstance(workItemCommon.getAuditableCommon(), false, attribute.getProjectArea(), monitor);
                this.resolveParents(manager, (ICategoryHandle)handle, arrayList);
            } else if (this.isSyntheticTeamAreaAttribute(configuration) && ValueProviderUtil.includeChildrenInMapping(configuration) && handle instanceof ITeamAreaHandle) {
                IProjectArea projectArea = workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)attribute.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, monitor);
                this.resolveParents(projectArea, (ITeamAreaHandle)handle, arrayList, workItemCommon, monitor);
            } else {
                arrayList.add(handle.getItemId().getUuidValue());
            }
        }
        final IEnumeration<? extends ILiteral> enumeration = workItemCommon.resolveEnumeration(attribute, monitor);
        if (enumeration == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.getString("FilteringValueSetProvider.ENUMERATION_OF_FILTER_ATTRIBUTE_NOT_FOUND"), (Object)workItem.getId(), (Object[])new Object[]{attribute.getDisplayName()}));
        }
        AttributeType attributeType = AttributeTypes.getAttributeType(attribute.getAttributeType());
        List<String> literalIds = ValueProviderUtil.getMappedLiterals(configuration, arrayList);
        ArrayList<ILiteral> literals = new ArrayList<ILiteral>();
        for (String literalId : literalIds) {
            ILiteral lit = enumeration.findEnumerationLiteral((Identifier)attributeType.valueOf(literalId, null), false);
            if (lit == null) continue;
            literals.add(lit);
        }
        Collections.sort(literals, new Comparator<ILiteral>(){

            @Override
            public int compare(ILiteral o1, ILiteral o2) {
                return enumeration.getEnumerationLiterals().indexOf(o1) - enumeration.getEnumerationLiterals().indexOf(o2);
            }
        });
        ArrayList<Identifier<? extends ILiteral>> filteredValues = new ArrayList<Identifier<? extends ILiteral>>();
        for (ILiteral lit : literals) {
            filteredValues.add(lit.getIdentifier2());
        }
        return filteredValues;
    }

    private boolean isSyntheticTeamAreaAttribute(IConfiguration configuration) {
        return SYNTHETIC_TEAM_AREA_ATTRIBUTE_ID.equals(ValueProviderUtil.getSourceEnumerationId(configuration));
    }

    private void resolveParents(IProjectArea projectArea, ITeamAreaHandle teamAreaHandle, List<String> itemIds, IWorkItemCommon common, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamArea teamArea = common.getAuditableCommon().resolveAuditable((IAuditableHandle)teamAreaHandle, ItemProfile.TEAM_AREA_DEFAULT, monitor);
        itemIds.add(teamArea.getItemId().getUuidValue());
        ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
        if (hierarchy.getParent((ITeamAreaHandle)teamArea) != null) {
            this.resolveParents(projectArea, hierarchy.getParent((ITeamAreaHandle)teamArea), itemIds, common, monitor);
        }
    }

    private void resolveParents(IIterationHandle iterationHandle, List<String> itemIds, IWorkItemCommon common, IProgressMonitor monitor) throws TeamRepositoryException {
        IIteration iteration = common.getAuditableCommon().resolveAuditable((IAuditableHandle)iterationHandle, ItemProfile.ITERATION_DEFAULT, monitor);
        itemIds.add(iteration.getItemId().getUuidValue());
        if (iteration.getDevelopmentLine() != null && !itemIds.contains(iteration.getDevelopmentLine().getItemId().getUuidValue())) {
            itemIds.add(iteration.getDevelopmentLine().getItemId().getUuidValue());
        }
        if (iteration.getParent() != null) {
            this.resolveParents(iteration.getParent(), itemIds, common, monitor);
        }
    }

    private void resolveParents(CategoriesManager manager, ICategoryHandle categoryHandle, List<String> itemIds) throws TeamRepositoryException {
        CategoryTreeNode node = manager.findNode(categoryHandle);
        itemIds.add(node.getCategory().getItemId().getUuidValue());
        if (node.getParent() != null) {
            this.resolveParents(manager, node.getParent().getCategory(), itemIds);
        }
    }

    private IAttribute findFilterAttribute(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        String filterAttributeId;
        IAttribute filterAttribute = null;
        IConfiguration filterAttributeConfiguration = configuration.getChild(FILTER_ATTRIBUTE);
        String string = filterAttributeId = filterAttributeConfiguration == null ? null : filterAttributeConfiguration.getString("id");
        if (filterAttributeId != null) {
            filterAttribute = workItemCommon.findAttribute(workItem.getProjectArea(), WorkItemAttributes.getAttributeId(Identifier.create(IAttribute.class, filterAttributeId)), monitor);
        } else {
            String attributeType = ValueProviderUtil.getSourceEnumerationId(configuration);
            filterAttribute = this.findDependency(attribute.getDependencies(), attributeType, workItemCommon.getAuditableCommon(), monitor);
        }
        return filterAttribute;
    }

    private IAttribute findDependency(List<IAttributeHandle> dependencies, String attributeType, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IAttribute> attributes = auditableCommon.resolveAuditables(dependencies, IAttribute.SMALL_PROFILE, monitor);
        for (IAttribute attribute : attributes) {
            if (!attribute.getAttributeType().equals(attributeType)) continue;
            return attribute;
        }
        return null;
    }
}

