/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IManyItemQueryModel;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ListContainsOperation
extends AttributeOperation {
    private static final String CONTAINS_QUERY_ARGUMENT_FORMAT = "%%%s%%";
    private final boolean fInvert;

    public ListContainsOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    @Override
    public boolean evaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) {
        boolean result = this.internalEvaluate(left, right);
        return this.fInvert ? !result : result;
    }

    private boolean internalEvaluate(Object left, Object right) {
        if (left instanceof List && right != null) {
            for (Object next : (List)left) {
                IItemHandle item;
                if (!(right instanceof IItemHandle ? next instanceof IItemHandle && (item = (IItemHandle)next).sameItemId((IItemHandle)right) : right.equals(next))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IPredicate getPredicate(ITransformationContext context, IProgressMonitor monitor) {
        IPredicate predicate = this.internalGetPredicate(context, monitor);
        return predicate;
    }

    private IPredicate internalGetPredicate(ITransformationContext context, IProgressMonitor monitor) {
        String attributeType = context.getAttribute().getAttributeType();
        if (AttributeTypes.isItemListAttributeType(attributeType)) {
            IItemHandleInputArg inputArg = context.getQuery().newItemHandleArg();
            context.addParameter(context.getValue());
            IPredicate predicate = ((IManyItemQueryModel)context.getReference())._contains(inputArg);
            if (context.getAttribute().isStateExtension()) {
                predicate = context.createOldStateExtensionPredicate(predicate);
            }
            if (this.fInvert) {
                predicate = predicate._not();
            }
            return predicate;
        }
        if (AttributeTypes.isEnumerationListAttributeType(attributeType) || "stringList".equals(attributeType)) {
            SeparatedStringList list = new SeparatedStringList((Collection<String>)Collections.singleton(context.getValue().toString()));
            context.addParameter(String.format(CONTAINS_QUERY_ARGUMENT_FORMAT, list.getSeparatedString()));
            IPredicate predicate = context.getAttribute().isStateExtension() ? context.createLikePredicate() : ((IStringField)context.getField())._like((IString)context.getQuery().newStringArg());
            if (this.fInvert) {
                predicate = predicate._not();
                predicate = context.adaptLikePredicateForInversion(predicate);
            }
            return predicate;
        }
        return null;
    }

    @Override
    public boolean isNegation() {
        return this.fInvert;
    }
}

