/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.common.query.BaseProcessAttachmentQueryModel;
import com.ibm.team.process.internal.common.query.BaseTeamAreaQueryModel;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IChangeEventHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.query.BaseChangeEventQueryModel;
import com.ibm.team.repository.common.model.query.BaseContributorQueryModel;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.IDynamicItemQueryModel;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IItemQueryModel;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.query.ast.IUUIDField;
import com.ibm.team.repository.common.query.ast.IUUIDInputArg;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.internal.model.query.BaseAttributeQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseCategoryQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseDeliverableQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseWorkItemQueryModel;
import com.ibm.team.workitem.common.internal.query.query.BaseQueryDescriptorQueryModel;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class WorkItemQueries {
    private static final char ESCAPE_CHARACTER = '\\';
    private static IItemQuery fgWorkItemByIdRange;
    private static IItemQuery fgAttributeByIdentifier;
    private static IItemQuery fgAttributesByProjectArea;
    private static IItemQuery fgBuiltInAttributes;
    private static IItemQuery fgCategoryByProjectArea;
    private static IItemQuery fgCategoryByIdentifier;
    private static IItemQuery fgCategoryByName;
    private static IItemQuery fgCategoriesByContributor;
    private static IItemQuery fgCategoriesByTeamArea;
    private static IItemQuery fgCategoriesByProjectArea;
    private static IItemQuery fgRootCategory;
    private static IItemQuery fgContributorByName;
    private static IItemQuery fgContributorByEmail;
    private static IItemQuery fgContributorByUserId;
    private static IItemQuery fgTeamsByContributorAndProjectArea;
    private static IItemQuery fgChangeEventsByCategoryName;
    private static IItemQuery fgAllChangeEventsByTimeRangeAndType;
    private static IItemQuery fgTeamAreasByContributor;
    private static IItemQuery fgQueryDescriptorByName;
    private static IItemQuery fgQueryDescriptorById;
    private static IItemQuery fgProcessAttachmentByPath;
    private static IItemQuery fgDeliverableByProjectArea;
    private static IItemQuery fgActiveDeliverableByProjectArea;
    private static IItemQuery fgDeliverableByName;
    private static IItemQuery fgDeliverableByArtifact;
    private static Map<IItemType, IItemQuery> fgAll;
    private static Map<IItemType, IItemQuery> fgExists;
    private static Map<IItemType, IItemQuery> fgNewer;
    private static IDataQuery fgDistinctWorkItemTagsByProjectArea;
    private static IDataQuery fgWorkItemMediumStringCustomAttributeValues;
    private static IDataQuery fgApprovalDescriptorNames;
    private static IDataQuery fgTeamAreaMemberCount;
    private static IItemQuery fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan;
    private static IItemQuery fgWorkItemsByCategory;

    static {
        fgAll = new HashMap<IItemType, IItemQuery>();
        fgExists = new HashMap<IItemType, IItemQuery>();
        fgNewer = new HashMap<IItemType, IItemQuery>();
    }

    public static QueryIterator<IWorkItemHandle> workItemsById(IAuditableCommon auditableCommon, List<Integer> ids) {
        BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        ArrayList<INumericInputArg> args = new ArrayList<INumericInputArg>();
        int i = 0;
        while (i < ids.size()) {
            args.add(query.newIntegerArg());
            ++i;
        }
        query.filter(model.id()._in(args.toArray(new INumeric[args.size()])));
        return auditableCommon.getItemQueryIterator(query, ids.toArray(), null, null);
    }

    public static QueryIterator<IWorkItemHandle> workItemByIdRange(IAuditableCommon auditableCommon, int from, int to) {
        if (fgWorkItemByIdRange == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IPredicate predicate = model.id()._gtOrEq((INumeric)query.newIntegerArg());
            predicate = predicate._and(model.id()._lt((INumeric)query.newIntegerArg()));
            query.filter(predicate);
            fgWorkItemByIdRange = query;
        }
        return auditableCommon.getItemQueryIterator(fgWorkItemByIdRange, new Object[]{from, to}, null, null);
    }

    public static QueryIterator<IAttributeHandle> attributeByIdentifier(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String identifier) {
        if (fgAttributeByIdentifier == null) {
            BaseAttributeQueryModel.AttributeQueryModel model = BaseAttributeQueryModel.AttributeQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.identifier()._eq((IString)query.newStringArg())));
            fgAttributeByIdentifier = query;
        }
        return auditableCommon.getItemQueryIterator(fgAttributeByIdentifier, new Object[]{projectArea, identifier}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<IAttributeHandle> attributesByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgAttributesByProjectArea == null) {
            BaseAttributeQueryModel.AttributeQueryModel model = BaseAttributeQueryModel.AttributeQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            fgAttributesByProjectArea = query;
        }
        return auditableCommon.getItemQueryIterator(fgAttributesByProjectArea, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<IAttributeHandle> builtInAttributes(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgBuiltInAttributes == null) {
            BaseAttributeQueryModel.AttributeQueryModel model = BaseAttributeQueryModel.AttributeQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.builtIn()._isTrue()));
            fgBuiltInAttributes = query;
        }
        return auditableCommon.getItemQueryIterator(fgBuiltInAttributes, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<ICategoryHandle> categoryByIdentifier(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, CategoryId identifier) {
        if (fgCategoryByIdentifier == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.internalCategoryId()._eq((IString)query.newStringArg())));
            fgCategoryByIdentifier = query;
        }
        return auditableCommon.getItemQueryIterator(fgCategoryByIdentifier, new Object[]{projectArea, identifier.getInternalRepresentation()}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<ICategoryHandle> categoryByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgCategoryByProjectArea == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            fgCategoryByProjectArea = query;
        }
        return auditableCommon.getItemQueryIterator(fgCategoryByProjectArea, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<ICategoryHandle> categoryByName(IAuditableCommon auditableCommon, String name) {
        if (fgCategoryByName == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.name()._eq((IString)query.newStringArg()));
            fgCategoryByName = query;
        }
        return auditableCommon.getItemQueryIterator(fgCategoryByName, new Object[]{name}, null, null);
    }

    public static QueryIterator<ICategoryHandle> categoriesByContributor(IAuditableCommon auditableCommon, IContributorHandle contributor) {
        if (fgCategoriesByContributor == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IUUIDInputArg contributorUUIDArg = query.newUUIDArg();
            query.filter(model.defaultTeamArea().contributors().itemId()._eq((IUUID)contributorUUIDArg)._or(model.teamAreas().contributors().itemId()._eq((IUUID)contributorUUIDArg)));
            query.distinct();
            fgCategoriesByContributor = query;
        }
        return auditableCommon.getItemQueryIterator(fgCategoriesByContributor, new Object[]{contributor.getItemId()}, null, null);
    }

    public static QueryIterator<ICategoryHandle> categoriesByProcessArea(IAuditableCommon auditableCommon, IProcessAreaHandle processArea) {
        IItemQuery query;
        BaseCategoryQueryModel.CategoryQueryModel model;
        if (fgCategoriesByTeamArea == null) {
            model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.defaultTeamArea()._eq(query.newItemHandleArg())._or(model.teamAreas().itemId()._eq((IUUID)query.newUUIDArg())));
            query.distinct();
            fgCategoriesByTeamArea = query;
        }
        if (fgCategoriesByProjectArea == null) {
            model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IItemHandleInputArg projectAreaArg = query.newItemHandleArg();
            query.filter(model.projectArea()._eq(projectAreaArg)._and(model.defaultTeamArea()._isNull()._and(model.teamAreas()._isEmpty())));
            query.distinct();
            fgCategoriesByProjectArea = query;
        }
        if (processArea instanceof ITeamAreaHandle) {
            return auditableCommon.getItemQueryIterator(fgCategoriesByTeamArea, new Object[]{processArea, processArea.getItemId()}, null, null);
        }
        return auditableCommon.getItemQueryIterator(fgCategoriesByProjectArea, new Object[]{processArea}, QueryUtils.getContextIds((IProjectAreaHandle)processArea), null);
    }

    public static QueryIterator<ICategoryHandle> rootCategory(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgRootCategory == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            query.orderByAsc((IField)model.internalCategoryId());
            fgRootCategory = query;
        }
        return auditableCommon.getItemQueryIterator(fgRootCategory, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<IContributorHandle> contributorByName(IAuditableCommon auditableCommon, String name) {
        if (fgContributorByName == null) {
            BaseContributorQueryModel.ContributorQueryModel c = BaseContributorQueryModel.ContributorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)c);
            query.filter(c.name()._eq((IString)query.newStringArg()));
            fgContributorByName = query;
        }
        return auditableCommon.getItemQueryIterator(fgContributorByName, new Object[]{name}, QueryUtils.getPublicContextIds(), null);
    }

    public static QueryIterator<IContributorHandle> contributorByEmail(IAuditableCommon auditableCommon, String email) {
        if (fgContributorByEmail == null) {
            BaseContributorQueryModel.ContributorQueryModel c = BaseContributorQueryModel.ContributorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)c);
            query.filter(c.emailAddress()._eq((IString)query.newStringArg()));
            fgContributorByEmail = query;
        }
        return auditableCommon.getItemQueryIterator(fgContributorByEmail, new Object[]{email}, QueryUtils.getPublicContextIds(), null);
    }

    public static QueryIterator<IContributorHandle> contributorByUserId(IAuditableCommon auditableCommon, String userId) {
        if (fgContributorByUserId == null) {
            BaseContributorQueryModel.ContributorQueryModel c = BaseContributorQueryModel.ContributorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)c);
            query.filter(c.userId()._eq((IString)query.newStringArg()));
            fgContributorByUserId = query;
        }
        return auditableCommon.getItemQueryIterator(fgContributorByUserId, new Object[]{userId}, QueryUtils.getPublicContextIds(), null);
    }

    public static QueryIterator<IContributorHandle> contributorsByUserId(IAuditableCommon auditableCommon, String[] userIds) {
        BaseContributorQueryModel.ContributorQueryModel c = BaseContributorQueryModel.ContributorQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)c);
        query.filter(c.userId()._in(userIds));
        return auditableCommon.getItemQueryIterator(query, new Object[0], QueryUtils.getPublicContextIds(), null);
    }

    public static QueryIterator<ITeamAreaHandle> teamAreasByContributorAndProjectArea(IAuditableCommon auditableCommon, IContributorHandle user, IProjectAreaHandle projectArea) {
        if (fgTeamsByContributorAndProjectArea == null) {
            BaseTeamAreaQueryModel.TeamAreaQueryModel teamModel = BaseTeamAreaQueryModel.TeamAreaQueryModel.ROOT;
            IItemQuery teamQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)teamModel);
            teamQuery.filter(teamModel.projectArea()._eq(teamQuery.newItemHandleArg())._and(teamModel.contributors().itemId()._eq((IUUID)teamQuery.newUUIDArg())));
            teamQuery.distinct();
            fgTeamsByContributorAndProjectArea = teamQuery;
        }
        return auditableCommon.getItemQueryIterator(fgTeamsByContributorAndProjectArea, new Object[]{projectArea, user.getItemId()}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<ITeamAreaHandle> teamAreasByContributor(IAuditableCommon auditableCommon, IContributorHandle user) {
        if (fgTeamAreasByContributor == null) {
            BaseTeamAreaQueryModel.TeamAreaQueryModel teamModel = BaseTeamAreaQueryModel.TeamAreaQueryModel.ROOT;
            IItemQuery teamQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)teamModel);
            teamQuery.filter(teamModel.contributors().itemId()._eq((IUUID)teamQuery.newUUIDArg()));
            teamQuery.distinct();
            fgTeamAreasByContributor = teamQuery;
        }
        return auditableCommon.getItemQueryIterator(fgTeamAreasByContributor, new Object[]{user.getItemId()}, null, null);
    }

    public static QueryIterator<IQueryDescriptorHandle> queryDescriptorByName(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String name) {
        if (fgQueryDescriptorByName == null) {
            BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel queryModel = BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
            query.filter(queryModel.projectArea()._eq(query.newItemHandleArg())._and(queryModel.name()._eq((IString)query.newStringArg())));
            fgQueryDescriptorByName = query;
        }
        return auditableCommon.getItemQueryIterator(fgQueryDescriptorByName, new Object[]{projectArea, name}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<IQueryDescriptorHandle> queryDescriptorById(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String identifier) {
        if (fgQueryDescriptorById == null) {
            BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel queryModel = BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
            query.filter(queryModel.projectArea()._eq(query.newItemHandleArg())._and(queryModel.id()._eq((IString)query.newStringArg())));
            fgQueryDescriptorById = query;
        }
        return auditableCommon.getItemQueryIterator(fgQueryDescriptorById, new Object[]{projectArea, identifier}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<IQueryDescriptorHandle> queryDescriptorsById(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String[] ids) {
        BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel queryModel = BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        ArrayList<String> parameters = new ArrayList<String>(ids.length);
        IString[] args = new IString[ids.length];
        int i = 0;
        while (i < ids.length) {
            args[i] = query.newStringArg();
            parameters.add(ids[i]);
            ++i;
        }
        parameters.add((String)projectArea);
        query.filter(queryModel.projectArea()._eq(query.newItemHandleArg())._and(queryModel.id()._in(args)));
        return auditableCommon.getItemQueryIterator(query, parameters.toArray(), QueryUtils.getContextIds(projectArea), null);
    }

    public static <T extends IItemHandle> QueryIterator<T> all(IAuditableCommon auditableCommon, IItemType itemType) {
        IItemQuery query = fgAll.get(itemType);
        if (query == null) {
            IDynamicItemQueryModel model = itemType.getQueryModel();
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)((IItemQueryModel)model));
            fgAll.put(itemType, query);
        }
        return auditableCommon.getItemQueryIterator(query, null, null, null);
    }

    public static QueryIterator<IAuditableHandle> exists(IAuditableCommon auditableCommon, IAuditableHandle handle) {
        IItemQuery query = fgExists.get(handle.getItemType());
        if (query == null) {
            IDynamicItemQueryModel model = handle.getItemType().getQueryModel();
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)((IItemQueryModel)model));
            IUUIDField itemId = (IUUIDField)model.getField(IItem.ITEM_ID_PROPERTY);
            query.filter(itemId._eq((IUUID)query.newUUIDArg()));
            fgExists.put(handle.getItemType(), query);
        }
        return auditableCommon.getItemQueryIterator(query, new Object[]{handle.getItemId()}, null, null);
    }

    public static QueryIterator<IAuditableHandle> newer(IAuditableCommon auditableCommon, IAuditableHandle stateHandle) {
        Assert.isTrue((boolean)stateHandle.hasStateId());
        IItemQuery query = fgNewer.get(stateHandle.getItemType());
        if (query == null) {
            IDynamicItemQueryModel model = stateHandle.getItemType().getQueryModel();
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)((IItemQueryModel)model));
            IUUIDField itemId = (IUUIDField)model.getField(IItem.ITEM_ID_PROPERTY);
            IUUIDField stateId = (IUUIDField)model.getField(IItem.STATE_ID_PROPERTY);
            query.filter(itemId._eq((IUUID)query.newUUIDArg())._and(query.not(stateId._eq((IUUID)query.newUUIDArg()))));
            fgNewer.put(stateHandle.getItemType(), query);
        }
        return auditableCommon.getItemQueryIterator(query, new Object[]{stateHandle.getItemId(), stateHandle.getStateId()}, null, null);
    }

    public static QueryIterator<IChangeEventHandle> allChangeEventsByCategoryName(IAuditableCommon auditableCommon, String categoryName, String ownerNs) {
        if (fgChangeEventsByCategoryName == null) {
            BaseChangeEventQueryModel.ChangeEventQueryModel model = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.eventCategory()._eq((IString)query.newStringArg())._and(model.eventOwnerNS()._eq((IString)query.newStringArg())));
            query.orderByDsc((IField)model.modified());
            fgChangeEventsByCategoryName = query;
        }
        return auditableCommon.getItemQueryIterator(fgChangeEventsByCategoryName, new Object[]{categoryName, ownerNs}, null, null);
    }

    public static QueryIterator<IChangeEventHandle> changeEventsByTimeRangeAndType(IAuditableCommon auditableCommon, Date start, Date end, IItemType type) {
        if (fgAllChangeEventsByTimeRangeAndType == null) {
            BaseChangeEventQueryModel.ChangeEventQueryModel model = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.modified()._gtOrEq((IDateTime)query.newDateTimeArg())._and(model.modified()._lt((IDateTime)query.newDateTimeArg()))._and(model.item()._isTypeOf(query.newItemTypeArg())));
            query.orderByAsc((IField)model.eventTime());
            fgAllChangeEventsByTimeRangeAndType = query;
        }
        return auditableCommon.getItemQueryIterator(fgAllChangeEventsByTimeRangeAndType, new Object[]{start, end, type}, null, null);
    }

    public static QueryIterator<IWorkItemHandle> workitemsContainingOpenApprovalsWithDueDatesEarlierThan(IAuditableCommon auditableCommon, Date maxDueDate) {
        if (fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.internalApprovalDescriptors().cumulativeStateIdentifier()._eq(WorkItemApprovals.PENDING_STATE.getIdentifier())._and(model.internalApprovalDescriptors().dueDate()._lt((IDateTime)query.newDateTimeArg())));
            query.distinct();
            fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan = query;
        }
        return auditableCommon.getItemQueryIterator(fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan, new Object[]{maxDueDate}, null, null);
    }

    public static QueryIterator<IDeliverableHandle> deliverableByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgDeliverableByProjectArea == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            query.orderByAsc((IField)model.creationDate());
            fgDeliverableByProjectArea = query;
        }
        return auditableCommon.getItemQueryIterator(fgDeliverableByProjectArea, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<IDeliverableHandle> activeDeliverableByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgActiveDeliverableByProjectArea == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.archived()._isFalse()));
            query.orderByAsc((IField)model.creationDate());
            fgActiveDeliverableByProjectArea = query;
        }
        return auditableCommon.getItemQueryIterator(fgActiveDeliverableByProjectArea, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<IDeliverableHandle> deliverableByName(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String name) {
        if (fgDeliverableByName == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.name()._eq((IString)query.newStringArg())));
            fgDeliverableByName = query;
        }
        return auditableCommon.getItemQueryIterator(fgDeliverableByName, new Object[]{projectArea, name}, QueryUtils.getContextIds(projectArea), null);
    }

    public static QueryIterator<IDeliverableHandle> deliverableByArtifact(IAuditableCommon auditableCommon, IItemHandle artifact) {
        if (fgDeliverableByArtifact == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.artifact()._eq(query.newItemHandleArg()));
            fgDeliverableByArtifact = query;
        }
        return auditableCommon.getItemQueryIterator(fgDeliverableByArtifact, new Object[]{artifact}, null, null);
    }

    public static QueryIterator<IItemHandle> handleByUUID(IAuditableCommon auditableCommon, IItemType itemType, UUID uuid) {
        Assert.isNotNull((Object)uuid);
        IDynamicItemQueryModel model = itemType.getQueryModel();
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        IUUIDField itemIdfield = (IUUIDField)model.getField(IItem.ITEM_ID_PROPERTY);
        query.filter(itemIdfield._eq((IUUID)query.newUUIDArg()));
        return auditableCommon.getItemQueryIterator(query, new Object[]{uuid}, null, null);
    }

    public static QueryIterator<String> distinctWorkItemTags(IAuditableCommon auditableCommon, IAttribute attribute) {
        IDataQuery query;
        BaseWorkItemQueryModel.WorkItemQueryModel model;
        if (fgDistinctWorkItemTagsByProjectArea == null) {
            model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            query.select((ISelectionElement)model.internalTags()).distinct();
            fgDistinctWorkItemTagsByProjectArea = query;
        }
        if (fgWorkItemMediumStringCustomAttributeValues == null) {
            model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.mediumStringExtensions().key()._eq((IString)query.newStringArg())));
            query.select((ISelectionElement)model.mediumStringExtensions().value()).distinct();
            fgWorkItemMediumStringCustomAttributeValues = query;
        }
        if (IWorkItem.TAGS_PROPERTY.equals(attribute.getIdentifier())) {
            return auditableCommon.getDataQueryIterator(fgDistinctWorkItemTagsByProjectArea, new Object[]{attribute.getProjectArea()}, QueryUtils.getContextIds(attribute.getProjectArea()), null);
        }
        Assert.isLegal((!attribute.isBuiltIn() && "tags".equals(attribute.getAttributeType()) ? 1 : 0) != 0);
        return auditableCommon.getDataQueryIterator(fgWorkItemMediumStringCustomAttributeValues, new Object[]{attribute.getProjectArea(), attribute.getIdentifier()}, QueryUtils.getContextIds(attribute.getProjectArea()), null);
    }

    public static QueryIterator<String> approvalDescriptorNames(IAuditableCommon auditableCommon) {
        if (fgApprovalDescriptorNames == null) {
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)BaseWorkItemQueryModel.WorkItemQueryModel.ROOT);
            query.select((ISelectionElement)BaseWorkItemQueryModel.WorkItemQueryModel.ROOT.internalApprovalDescriptors().name()).distinct().orderByAsc((IField)BaseWorkItemQueryModel.WorkItemQueryModel.ROOT.internalApprovalDescriptors().name());
            fgApprovalDescriptorNames = query;
        }
        return auditableCommon.getDataQueryIterator(fgApprovalDescriptorNames, null, null, null);
    }

    public static QueryIterator<Integer> teamAreaMemberCount(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IContributorHandle contributor) {
        if (fgTeamAreaMemberCount == null) {
            BaseTeamAreaQueryModel.TeamAreaQueryModel model = BaseTeamAreaQueryModel.TeamAreaQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.contributors().itemId()._eq((IUUID)query.newUUIDArg())));
            query.distinct();
            query.select(query.count());
            fgTeamAreaMemberCount = query;
        }
        return auditableCommon.getDataQueryIterator(fgTeamAreaMemberCount, new Object[]{projectArea, contributor.getItemId()}, QueryUtils.getContextIds(projectArea), QueryIterator.ReadMode.COMMITTED);
    }

    public static QueryIterator<Timestamp> lastModified(IAuditableCommon auditableCommon, IItemType itemType) {
        IDataQuery query = WorkItemQueries.createLastModifiedQuery(auditableCommon, itemType);
        return auditableCommon.getDataQueryIterator(query, null, null, null);
    }

    public static IDataQuery createLastModifiedQuery(IAuditableCommon auditableCommon, IItemType itemType) {
        IDynamicItemQueryModel queryModel = itemType.getQueryModel();
        IField modifiedField = queryModel.getField(IItem.MODIFIED_PROPERTY);
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)queryModel);
        query.select(query.max(modifiedField));
        return query;
    }

    public static QueryIterator<IProcessAttachmentHandle> processAttachmentByPath(IAuditableCommon auditableCommon, UUID owningItem, String path) {
        if (fgProcessAttachmentByPath == null) {
            BaseProcessAttachmentQueryModel.ProcessAttachmentQueryModel processAttachment = BaseProcessAttachmentQueryModel.ProcessAttachmentQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)processAttachment);
            query.filter(processAttachment.internalOwningItem().itemId()._eq((IUUID)query.newUUIDArg())._and(processAttachment.path()._like((IString)query.newStringArg(), '\\')));
            fgProcessAttachmentByPath = query;
        }
        return auditableCommon.getItemQueryIterator(fgProcessAttachmentByPath, new Object[]{owningItem, WorkItemQueries.escapeLikeParameter(path)}, null, null);
    }

    public static IItemQuery workItemsByCategory() {
        if (fgWorkItemsByCategory == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel workItem = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)workItem);
            query.filter(workItem.category()._eq(query.newItemHandleArg()));
            fgWorkItemsByCategory = query;
        }
        return fgWorkItemsByCategory;
    }

    private static String escapeLikeParameter(String prefix) {
        return prefix == null ? prefix : prefix.replace("%", "\\%").replace("_", "\\_");
    }
}

