/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.wiki.transformer;

import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.wiki.transformer.IItemReferenceDetector;
import com.ibm.team.workitem.common.internal.wiki.transformer.IReferenceTransformer;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.Arrays;

public class WorkItemAttachmentReferenceTransformer
implements IReferenceTransformer {
    private IAuditableCommon auditableCommon;

    public WorkItemAttachmentReferenceTransformer(IAuditableCommon mgr) {
        this.auditableCommon = mgr;
    }

    @Override
    public void transform(IItemReferenceDetector.Reference reference) {
        if (reference == null) {
            return;
        }
        Location location = reference.getLocation();
        if (location == null) {
            return;
        }
        IItemType type = location.getItemType();
        if (type == IAttachment.ITEM_TYPE) {
            try {
                IAttachment item;
                ItemProfile profile = ItemProfile.createProfile(IAttachment.ITEM_TYPE, AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(Arrays.asList(IAttachment.NAME_PROPERTY, IAttachment.CONTENT_PROPERTY));
                IAttachment attachment = item = (IAttachment)this.auditableCommon.resolveAuditableByLocation(location, profile, null);
                reference.setName(attachment.getName());
                String contentType = this.getContentType(attachment);
                reference.setContentType(contentType);
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
    }

    private String getContentType(IAttachment attachment) {
        String suffix;
        String name = attachment.getName().toLowerCase();
        int suffixIndex = name.lastIndexOf(46);
        if (suffixIndex > 0 && ("png".equals(suffix = name.substring(suffixIndex + 1)) || "gif".equals(suffix) || "jpg".equals(suffix) || "jpeg".equals(suffix))) {
            return "image/" + suffix;
        }
        IContent content = attachment.getContent();
        if (content != null) {
            return content.getContentType();
        }
        return null;
    }
}

