/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SymLinkHelper;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class JavaSymLinkHelper
extends SymLinkHelper {
    private static final String altSeparator = File.separator.equals("\\") ? "/" : null;

    static JavaSymLinkHelper newInstance() {
        return new JavaSymLinkHelper();
    }

    private JavaSymLinkHelper() {
    }

    @Override
    public void createSymlink(String path, String targetPath) throws CoreException {
        throw new CoreException(FileSystemStatusUtil.getStatusFor(4, Messages.ManagedFileStore_5));
    }

    @Override
    public void createSymlink(String path, String targetPath, boolean isDirectory) throws CoreException {
        throw new CoreException(FileSystemStatusUtil.getStatusFor(4, Messages.ManagedFileStore_5));
    }

    @Override
    public String getResolvedPath(String path) throws CoreException {
        if (path.length() == 0) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", "The empty path is not valid"));
        }
        File f = new File(path).getAbsoluteFile();
        File parent = f.getParentFile();
        while (parent != null) {
            if (!parent.isDirectory() && parent.exists()) {
                return null;
            }
            parent = parent.getParentFile();
        }
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor(e));
        }
        String result = f.getPath();
        if (path.endsWith(File.separator) || altSeparator != null && path.endsWith(altSeparator)) {
            if (!f.isDirectory() && f.exists()) {
                return null;
            }
            if (!result.endsWith(File.separator)) {
                result = String.valueOf(result) + File.separator;
            }
        }
        return result;
    }

    @Override
    public boolean supportsSymLinks() {
        return false;
    }

    @Override
    public boolean hasEmbeddedTargetType() {
        return false;
    }

    @Override
    public String normalizeSymlinkTarget(String targetPath) throws CoreException {
        return targetPath;
    }
}

