/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.ChangeTrackingOutputStream;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.JavaSymLinkHelper;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileSystem;
import com.ibm.team.filesystem.client.internal.ManagedFileTree;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.NativeSymLinkHelper;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.SymLinkHelper;
import com.ibm.team.filesystem.client.internal.WindowsNativeSymLinkHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.core.MetadataUpdateJob;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class ManagedFileStore
extends FileStore {
    private static final SymLinkHelper symlinkHelper;
    private static final int MAX_DEPTH = 250;
    private final IFileStore baseStore;
    private ILocation cfaLocation;
    private IRelativeLocation shareableRelativeLocation;
    private static final char SEGMENT_SEPARATOR;
    private static final char ALT_SEGMENT_SEPARATOR;

    static {
        boolean efsSupportsSymLinks;
        SymLinkHelper slh = WindowsNativeSymLinkHelper.newInstance();
        if (slh == null && (slh = NativeSymLinkHelper.newInstance()) == null && (slh = ManagedFileStore.getJava17SymLinkHelper()) == null) {
            slh = JavaSymLinkHelper.newInstance();
        }
        symlinkHelper = slh;
        boolean slhSupportsSymLinks = slh.supportsSymLinks();
        boolean bl = efsSupportsSymLinks = (EFS.getLocalFileSystem().attributes() & 0x20) != 0;
        if (slhSupportsSymLinks != efsSupportsSymLinks) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(2, slhSupportsSymLinks ? Messages.ManagedFileStore_10 : Messages.ManagedFileStore_11));
        }
        ALT_SEGMENT_SEPARATOR = (char)((SEGMENT_SEPARATOR = File.separatorChar) == '/' ? 92 : 47);
    }

    private static SymLinkHelper getJava17SymLinkHelper() {
        try {
            Class<?> cls = ManagedFileStore.class.getClassLoader().loadClass("com.ibm.team.filesystem.client.internal.Java17SymLinkHelper");
            Method m = cls.getDeclaredMethod("newInstance", new Class[0]);
            return (SymLinkHelper)m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (LinkageError linkageError) {
            return null;
        }
    }

    public static boolean supportsSymLinks() {
        return symlinkHelper.supportsSymLinks();
    }

    public static boolean hasEmbeddedTargetType() {
        return symlinkHelper.hasEmbeddedTargetType();
    }

    public LinkType getTargetType(IProgressMonitor monitor) {
        File link = null;
        try {
            link = this.toLocalFile(0, monitor);
        }
        catch (CoreException coreException) {}
        if (link == null) {
            return LinkType.NONE;
        }
        return ManagedFileStore.getTargetType(link);
    }

    private static LinkType getTargetType(File link) {
        if (!link.exists()) {
            return LinkType.NONE;
        }
        if (!ManagedFileStore.hasEmbeddedTargetType()) {
            return LinkType.NONE;
        }
        if (link.isDirectory()) {
            return LinkType.DIRECTORY;
        }
        return LinkType.FILE;
    }

    public static String getResolvedPath(String path) throws CoreException {
        return symlinkHelper.getResolvedPath(path);
    }

    public static void createSymlink(IFileStore file, String targetPath, boolean isDirectory, IProgressMonitor monitor) throws CoreException {
        if (!symlinkHelper.supportsSymLinks()) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor(2, Messages.ManagedFileStore_5));
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        String filePath = file.toLocalFile(0, (IProgressMonitor)progress.newChild(1)).getPath();
        IFileInfo info = file.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
        if (info.exists() || info.getAttribute(32)) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_6, (Object)filePath)));
        }
        IFileStore parent = file.getParent();
        IFileInfo parentInfo = parent.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
        if (!parentInfo.exists()) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_7, (Object)filePath), null));
        }
        if (!parentInfo.isDirectory()) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_8, (Object)filePath), null));
        }
        if (parentInfo.getAttribute(2)) {
            parentInfo.setAttribute(2, false);
            parent.putInfo(parentInfo, 1024, (IProgressMonitor)progress.newChild(1));
        }
        symlinkHelper.createSymlink(filePath, targetPath, isDirectory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void symlink(String targetPath, boolean isDirectory, IProgressMonitor monitor) throws CoreException {
        if (!symlinkHelper.supportsSymLinks()) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor(2, Messages.ManagedFileStore_5, null));
        }
        if (this.trackingChanges()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            try {
                CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaLocation, this.shareableRelativeLocation, false, (IProgressMonitor)progress.newChild(1));
                try {
                    ManagedFileStore.createSymlink(this.baseStore, targetPath, isDirectory, (IProgressMonitor)progress.newChild(1));
                    if (lock.code == 0) {
                        IFileInfo info = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
                        ManagedFileStore.updateMetadata(this, info, (IProgressMonitor)progress.newChild(1));
                        return;
                    }
                    if (lock.code != 2) return;
                    this.requestBackgroundMetadataUpdate(false);
                    return;
                }
                finally {
                    if (lock != null) {
                        CFALockUtil.endBatching(lock, progress.newChild(1));
                    }
                }
            }
            catch (FileSystemException e) {
                throw ManagedFileStore.getCoreExceptionFor(e);
            }
        } else {
            ManagedFileStore.createSymlink(this.baseStore, targetPath, isDirectory, monitor);
        }
    }

    protected void addDatelessItem(IVersionableHandle item, IComponentHandle component, IContextHandle connection) {
        ISchedulingRule rule = SharingManager.getInstance().getTrackingRule(this.cfaLocation);
        LocalChangeTracker tracker = LocalChangeManager.getInstance().getTracker(connection, component, this.cfaLocation, rule);
        tracker.registerDatelessVersionable(this.baseStore.fetchInfo().getLastModified(), item, component, connection);
    }

    public ManagedFileStore(ILocation cfaLocation, IRelativeLocation sharePath, IFileStore baseStore) {
        this.baseStore = baseStore;
        this.cfaLocation = cfaLocation;
        this.shareableRelativeLocation = sharePath;
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IFileInfo[] iFileInfoArray = this.childInfosInternal(false, options, (IProgressMonitor)progress.newChild(100));
            return iFileInfoArray;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    private static void done(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }

    private boolean trackingChanges() {
        return ManagedFileSystem.trackingChanges();
    }

    private IFileInfo[] childInfosInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.childInfos(options, monitor);
    }

    private void requestBackgroundMetadataUpdate(boolean updateChildren) {
        MetadataUpdateJob.queueUpdate(this, updateChildren);
    }

    boolean updateMetadataForChildren(IFileInfo[] infos, SubMonitor progress) throws FileSystemException, CoreException {
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaLocation);
        FileItemInfo baseInfo = cfa.getItemInfo(this.shareableRelativeLocation);
        if (baseInfo != null && (baseInfo.isSymbolicLink() || baseInfo.isFile() && infos.length == 0)) {
            return false;
        }
        SharingManager sm = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(cfa);
        Shareable shareable = sm.findShareable(sandbox, this.shareableRelativeLocation, ResourceType.FOLDER);
        Share share = cfa.getShare(shareable.getLocalPath());
        IFileStorage fileStorage = shareable.getFileStorage();
        boolean isCaseSensitive = cfa.isCaseSensitive();
        HashMap<StringWrapper, IFileInfo> infoMap = new HashMap<StringWrapper, IFileInfo>(infos.length * 4 / 3);
        IFileInfo[] iFileInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo info = iFileInfoArray[n2];
            infoMap.put(new StringWrapper(info.getName(), isCaseSensitive), info);
            ++n2;
        }
        boolean changeFound = false;
        if (share != null) {
            if (fileStorage.shouldBeIgnored((IProgressMonitor)progress.newChild(5))) {
                return false;
            }
            if (!(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle)) {
                if (infos.length != 0) {
                    cfa.deleteTreeInfo(share.getPath(), false, (IProgressMonitor)progress.newChild(53));
                }
                return true;
            }
            if (!(infos.length == 0 || baseInfo != null && baseInfo.isFolder())) {
                IFileInfo parentInfo = this.fetchInfoInternal(true, 0, (IProgressMonitor)progress.newChild(5));
                if (parentInfo.getAttribute(32) || !parentInfo.isDirectory()) {
                    return false;
                }
                baseInfo = cfa.getItemInfo(this.shareableRelativeLocation);
                if (baseInfo == null) {
                    return false;
                }
            }
            progress.setWorkRemaining(52);
            Map<StringWrapper, FileItemInfo> children = cfa.getChildInfos(this.shareableRelativeLocation, (IProgressMonitor)progress.newChild(35));
            HashMap<StringWrapper, IFileStorage> fileStorageChildrenMap = new HashMap<StringWrapper, IFileStorage>();
            Collection<IFileStorage> fileStorageChildren = fileStorage.getChildren(false, (IProgressMonitor)progress.newChild(1));
            for (IFileStorage iFileStorage : fileStorageChildren) {
                fileStorageChildrenMap.put(new StringWrapper(iFileStorage.getName(), isCaseSensitive), iFileStorage);
            }
            SubMonitor comparisonMonitor = progress.newChild(10);
            comparisonMonitor.beginTask(Messages.ManagedFileStore_0, children.size());
            for (Map.Entry<StringWrapper, FileItemInfo> e : children.entrySet()) {
                IFileStorage childFileStorage;
                SubMonitor iterationProgress = comparisonMonitor.newChild(1);
                iterationProgress.setWorkRemaining(3);
                StringWrapper name = e.getKey();
                FileItemInfo info = e.getValue();
                IFileInfo fInfo = (IFileInfo)infoMap.remove(name);
                IRelativeLocation childPath = this.shareableRelativeLocation.append(fInfo == null ? name.toString() : fInfo.getName());
                IFileStorage iFileStorage = childFileStorage = fInfo == null ? null : (IFileStorage)fileStorageChildrenMap.get(name);
                if (childFileStorage == null) {
                    ResourceType hint = fInfo == null ? ResourceType.getResourceType(info.getVersionableHandle()) : (fInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
                    Shareable childShareable = sm.findShareable(sandbox, childPath, hint);
                    childFileStorage = childShareable.getFileStorage();
                }
                if (childFileStorage.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                if (fInfo == null) {
                    iterationProgress.setWorkRemaining(1);
                    changeFound |= cfa.deleteTreeInfo(childPath, false, (IProgressMonitor)iterationProgress.newChild(1));
                    continue;
                }
                if (!ManagedFileStore.isSameType(fInfo, info)) {
                    iterationProgress.setWorkRemaining(1);
                    changeFound |= cfa.deleteTreeInfo(childPath, false, (IProgressMonitor)iterationProgress.newChild(1));
                    infoMap.put(name, fInfo);
                    continue;
                }
                if (info.isFile()) {
                    long checkStamp;
                    iterationProgress.setWorkRemaining(2);
                    ManagedFileStore child = this.getChild(fInfo.getName());
                    boolean contentChanged = ManagedFileStore.contentChanged(child, fInfo, info, share, childFileStorage, iterationProgress.newChild(1));
                    boolean executable = childFileStorage.supportsExecBit() ? fInfo.getAttribute(4) : info.isExecutable();
                    long l = checkStamp = info.getVersionableHandle().hasStateId() ? childFileStorage.getModificationStamp() : -1L;
                    if (name.toString().equals(fInfo.getName()) && contentChanged == info.isContentChanged() && executable == info.isExecutable() && checkStamp == info.getLastContentChangeCheckStamp()) continue;
                    cfa.setItemMetaData(childPath, new FileItemInfo(info.getVersionableHandle(), contentChanged, checkStamp, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), executable, info.isOriginalExecutable(), false, false), ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)iterationProgress.newChild(1));
                    changeFound = true;
                    continue;
                }
                if (info.isSymbolicLink()) {
                    LinkInfo targetInfo = childFileStorage.getLinkInfo((IProgressMonitor)iterationProgress.newChild(1));
                    boolean directory = LinkType.NONE == targetInfo.getType() ? info.isDirectoryLink() : LinkType.DIRECTORY == targetInfo.getType();
                    boolean contentChanged = CopyFileArea.contentChanged(info, targetInfo);
                    if (contentChanged == info.isContentChanged() && directory == info.isDirectoryLink()) continue;
                    cfa.setItemMetaData(childPath, new FileItemInfo((ISymbolicLinkHandle)info.getVersionableHandle(), contentChanged, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getStoredHash(), directory, info.isOriginalDirectoryLink()), ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)iterationProgress.newChild(1));
                    changeFound = true;
                    continue;
                }
                if (name.toString().equals(fInfo.getName())) continue;
                iterationProgress.setWorkRemaining(1);
                cfa.setItemMetaData(childPath, info, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)iterationProgress.newChild(1));
                changeFound = true;
            }
            comparisonMonitor.done();
            SubMonitor subProgress = progress.newChild(5);
            subProgress.setWorkRemaining(infoMap.size());
            for (IFileInfo info : infoMap.values()) {
                SubMonitor iterationProgress = subProgress.newChild(1).setWorkRemaining(3);
                IRelativeLocation childPath = this.shareableRelativeLocation.append(info.getName());
                IFileStorage childStorage = fileStorage.getChild(info.getName(), (IProgressMonitor)iterationProgress.newChild(1));
                Shareable childShareable = childStorage != null ? childStorage.getShareable() : sm.findShareable(sandbox, childPath, this.getResourceType(info));
                if (childShareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                if (info.getAttribute(32)) {
                    cfa.trackSymbolicLinkAddition((IFolderHandle)baseInfo.getVersionableHandle(), childShareable, (IProgressMonitor)iterationProgress.newChild(1));
                } else if (info.isDirectory()) {
                    cfa.trackFolderAddition((IFolderHandle)baseInfo.getVersionableHandle(), childShareable, (IProgressMonitor)iterationProgress.newChild(1));
                } else {
                    cfa.trackFileAddition((IFolderHandle)baseInfo.getVersionableHandle(), childShareable, (IProgressMonitor)iterationProgress.newChild(1));
                }
                changeFound = true;
            }
        } else {
            progress.setWorkRemaining(51);
            Collection<IRelativeLocation> shareRoots = cfa.allSharePaths(this.shareableRelativeLocation);
            int segNum = this.shareableRelativeLocation.segmentCount();
            SubMonitor deletionMonitor = progress.newChild(25);
            deletionMonitor.setWorkRemaining(shareRoots.size());
            for (IRelativeLocation root : shareRoots) {
                Shareable rootShareable;
                SubMonitor iterationProgress = deletionMonitor.newChild(1);
                iterationProgress.setWorkRemaining(2);
                IFileInfo info = (IFileInfo)infoMap.get(new StringWrapper(root.segment(segNum), isCaseSensitive));
                boolean exists = false;
                ISharingDescriptor desc = null;
                if (info != null) {
                    if (root.segmentCount() == segNum + 1) {
                        desc = cfa.getSharingInfo(root);
                        if (this.isSameType(desc.getRootVersionable(), info)) {
                            exists = true;
                        }
                    } else if (info.isDirectory()) {
                        exists = true;
                    }
                }
                if (!exists) {
                    if (desc == null) {
                        desc = cfa.getSharingInfo(root);
                    }
                    if ((rootShareable = sm.findShareable(sandbox, root, ResourceType.getResourceType(desc.getRootVersionable()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                    changeFound |= cfa.deleteTreeInfo(root, false, (IProgressMonitor)iterationProgress.newChild(1));
                    continue;
                }
                if (root.segment(segNum).equals(info.getName())) continue;
                if (desc == null) {
                    desc = cfa.getSharingInfo(root);
                }
                if ((rootShareable = sm.findShareable(sandbox, root, ResourceType.getResourceType(desc.getRootVersionable()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                IRelativeLocation newPath = root.removeLastSegments(root.segmentCount() - segNum).append(info.getName()).append(root.removeFirstSegments(segNum + 1));
                cfa.moveSharingInfo(root, newPath, (IProgressMonitor)iterationProgress.newChild(1));
                changeFound = true;
            }
            deletionMonitor.done();
            SubMonitor additionMonitor = progress.newChild(25);
            additionMonitor.setWorkRemaining(shareRoots.size());
            for (IRelativeLocation root : shareRoots) {
                Shareable rootShareable;
                IFileInfo fInfo;
                SubMonitor iterationProgress = additionMonitor.newChild(1);
                iterationProgress.setWorkRemaining(2);
                if (root.segmentCount() != segNum + 1 || (fInfo = (IFileInfo)infoMap.get(new StringWrapper(root.segment(segNum), isCaseSensitive))) == null || (rootShareable = sm.findShareable(sandbox, root.getParent().append(fInfo.getName()), fInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE)).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                FileItemInfo info = cfa.getItemInfo(root);
                if (info == null) {
                    Share s = cfa.getShare(root);
                    if (!this.isSameType(s.getSharingDescriptor().getRootVersionable(), fInfo)) continue;
                    iterationProgress.setWorkRemaining(1);
                    if (fInfo.getAttribute(32)) {
                        cfa.trackSymbolicLinkAddition(null, rootShareable, (IProgressMonitor)iterationProgress.newChild(1));
                    } else if (fInfo.isDirectory()) {
                        cfa.trackFolderAddition(null, rootShareable, (IProgressMonitor)iterationProgress.newChild(1));
                    } else {
                        cfa.trackFileAddition(null, rootShareable, (IProgressMonitor)iterationProgress.newChild(1));
                    }
                    if (!fInfo.getName().equals(root.segment(segNum))) {
                        iterationProgress.setWorkRemaining(1);
                        cfa.moveSharingInfo(root, root.getParent().append(fInfo.getName()), (IProgressMonitor)iterationProgress.newChild(1));
                    }
                    changeFound = true;
                    continue;
                }
                Assert.isTrue((boolean)ManagedFileStore.isSameType(fInfo, info));
                ManagedFileStore child = this.getChild(fInfo.getName());
                if (info.isFile()) {
                    long checkStamp;
                    Share childShare = share == null ? cfa.getShare(rootShareable.getLocalPath()) : share;
                    iterationProgress.setWorkRemaining(4);
                    boolean contentChanged = ManagedFileStore.contentChanged(child, fInfo, info, childShare, rootShareable.getFileStorage(), iterationProgress.newChild(1));
                    boolean executable = rootShareable.getFileStorage().supportsExecBit() ? fInfo.getAttribute(4) : info.isExecutable();
                    long l = checkStamp = info.getVersionableHandle().hasStateId() ? rootShareable.getFileStorage().getModificationStamp() : -1L;
                    if (contentChanged != info.isContentChanged() || executable != info.isExecutable() || checkStamp != info.getLastContentChangeCheckStamp()) {
                        cfa.setItemMetaData(root, new FileItemInfo(info.getVersionableHandle(), contentChanged, checkStamp, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), executable, info.isOriginalExecutable(), false, false), ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)iterationProgress.newChild(1));
                        changeFound = true;
                    }
                } else if (info.isSymbolicLink()) {
                    LinkType childLinkTargetType = child.getTargetType((IProgressMonitor)iterationProgress.newChild(1));
                    LinkInfo childStoreInfo = new LinkInfo(fInfo.getStringAttribute(64), childLinkTargetType);
                    boolean directoryLink = LinkType.NONE == childLinkTargetType ? info.isDirectoryLink() : LinkType.DIRECTORY == childLinkTargetType;
                    boolean contentChanged = CopyFileArea.contentChanged(info, childStoreInfo);
                    if (contentChanged != info.isContentChanged() || directoryLink != info.isDirectoryLink()) {
                        cfa.setItemMetaData(root, new FileItemInfo((ISymbolicLinkHandle)info.getVersionableHandle(), contentChanged, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getStoredHash(), directoryLink, info.isOriginalDirectoryLink()), ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)iterationProgress.newChild(1));
                        changeFound = true;
                    }
                }
                if (fInfo.getName().equals(root.segment(segNum))) continue;
                iterationProgress.setWorkRemaining(1);
                cfa.moveSharingInfo(root, root.getParent().append(fInfo.getName()), (IProgressMonitor)iterationProgress.newChild(1));
                changeFound = true;
            }
        }
        return changeFound;
    }

    private ResourceType getResourceType(IFileInfo fInfo) {
        if (fInfo.getAttribute(32)) {
            return ResourceType.SYMBOLIC_LINK;
        }
        return fInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
    }

    private boolean isSameType(IVersionableHandle handle, IFileInfo info) {
        if (info.getAttribute(32)) {
            return handle instanceof ISymbolicLinkHandle;
        }
        if (info.isDirectory()) {
            return handle instanceof IFolderHandle;
        }
        return handle instanceof IFileItemHandle;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return this.childNamesInternal(false, options, monitor);
    }

    public String[] childNamesInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (!this.trackingChanges()) {
                String[] stringArray = this.baseStore.childNames(options, (IProgressMonitor)progress.newChild(100));
                return stringArray;
            }
            IFileInfo[] childInfos = this.childInfosInternal(isNested, options, (IProgressMonitor)progress.newChild(100));
            String[] names = new String[childInfos.length];
            int i = childInfos.length - 1;
            while (i >= 0) {
                names[i] = childInfos[i].getName();
                --i;
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        return this.childStoresInternal(false, options, monitor);
    }

    public ManagedFileStore[] childStoresInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            String[] childNames = this.childNamesInternal(isNested, options, (IProgressMonitor)progress.newChild(100));
            ManagedFileStore[] childStores = new ManagedFileStore[childNames.length];
            int i = childStores.length - 1;
            while (i >= 0) {
                childStores[i] = new ManagedFileStore(this.cfaLocation, this.shareableRelativeLocation.append(childNames[i]), this.baseStore.getChild(childNames[i]));
                --i;
            }
            ManagedFileStore[] managedFileStoreArray = childStores;
            return managedFileStoreArray;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        this.baseStore.copy(destination, options, monitor);
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        block13: {
            if (this.trackingChanges()) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaLocation, this.shareableRelativeLocation, true, (IProgressMonitor)progress.newChild(1));
                        try {
                            this.baseStore.delete(options, (IProgressMonitor)progress.newChild(60));
                            if (lock.code == 0) {
                                this.updateMetadataForDeletion(progress);
                            } else if (lock.code == 2) {
                                this.requestBackgroundMetadataUpdate(false);
                            }
                            break block13;
                        }
                        finally {
                            if (lock != null) {
                                CFALockUtil.endBatching(lock, progress.newChild(1));
                            }
                        }
                    }
                    catch (FileSystemException e) {
                        throw ManagedFileStore.getCoreExceptionFor(e);
                    }
                }
                finally {
                    ManagedFileStore.done(monitor);
                }
            }
            this.baseStore.delete(options, monitor);
        }
    }

    private void updateMetadataForDeletion(SubMonitor progress) throws FileSystemException {
        SharingManager sm = SharingManager.getInstance();
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaLocation);
        Sandbox sandbox = new Sandbox(cfa);
        Share share = cfa.getShare(this.shareableRelativeLocation);
        if (share != null) {
            FileItemInfo info = cfa.getItemInfo(this.shareableRelativeLocation);
            if (info != null) {
                Shareable shareable = sm.findShareable(sandbox, this.shareableRelativeLocation, ResourceType.getResourceType(info.getVersionableHandle()));
                if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10))) {
                    return;
                }
                if (share.getPath().segmentCount() == this.shareableRelativeLocation.segmentCount()) {
                    cfa.forget(this.shareableRelativeLocation, (IProgressMonitor)progress.newChild(28));
                } else {
                    cfa.deleteTreeInfo(this.shareableRelativeLocation, false, (IProgressMonitor)progress.newChild(28));
                }
            }
        } else {
            Collection<IRelativeLocation> shareRoots = cfa.allSharePaths(this.shareableRelativeLocation);
            SubMonitor deletionMonitor = progress.newChild(38);
            deletionMonitor.setWorkRemaining(shareRoots.size());
            for (IRelativeLocation root : shareRoots) {
                SubMonitor iterationProgress = deletionMonitor.newChild(1).setWorkRemaining(2);
                FileItemInfo info = cfa.getItemInfo(root);
                IVersionableHandle versionableHandle = null;
                if (info != null) {
                    versionableHandle = info.getVersionableHandle();
                } else {
                    ISharingDescriptor desc = cfa.getSharingInfo(root);
                    versionableHandle = desc.getRootVersionable();
                }
                Shareable shareable = sm.findShareable(sandbox, root, ResourceType.getResourceType(versionableHandle));
                if (shareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                cfa.forget(root, (IProgressMonitor)iterationProgress.newChild(1));
            }
            deletionMonitor.done();
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return this.fetchInfoInternal(false, options, monitor);
    }

    public static IFolderHandle createFolderHierarchyUpToParentOf(IRelativeLocation path, Share share, CopyFileArea cfa, boolean checkIgnore, IProgressMonitor monitor) throws CoreException, FileSystemException {
        SubMonitor iterationProgress;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int numSegInShare = share.getPath().segmentCount();
        int numSegInPath = path.segmentCount();
        int max = numSegInPath - numSegInShare;
        if (max <= 0) {
            progress.done();
            return null;
        }
        SharingManager sm = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(cfa);
        if (share.getSharingDescriptor().getRootVersionable() instanceof ISymbolicLinkHandle) {
            progress.done();
            return null;
        }
        if (!(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle)) {
            Shareable shareable;
            if (checkIgnore && (shareable = (Shareable)share.getShareable()).shouldBeIgnored((IProgressMonitor)progress.newChild(30))) {
                progress.done();
                return null;
            }
            cfa.deleteTreeInfo(share.getPath(), false, (IProgressMonitor)progress.newChild(70));
            progress.done();
            return null;
        }
        IFolderHandle parent = null;
        SubMonitor subProgress = progress.newChild(50);
        subProgress.setWorkRemaining(max);
        int i = 1;
        while (i <= max) {
            iterationProgress = subProgress.newChild(1).setWorkRemaining(2);
            IRelativeLocation parentLocation = path.removeLastSegments(i);
            FileItemInfo parentInfo = cfa.getItemInfo(parentLocation);
            if (parentInfo != null) {
                if (parentInfo.isSymbolicLink()) {
                    progress.done();
                    return null;
                }
                if (!parentInfo.isFolder()) {
                    Shareable shareable;
                    if (checkIgnore && (shareable = (Shareable)share.getSandbox().findShareable(parentLocation, ResourceType.getResourceType(parentInfo.getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) {
                        progress.done();
                        return null;
                    }
                    cfa.deleteTreeInfo(parentLocation, false, (IProgressMonitor)iterationProgress.newChild(1));
                    if (i != max) {
                        parent = (IFolderHandle)cfa.getItemInfo(parentLocation.getParent()).getVersionableHandle();
                    }
                    ++i;
                    break;
                }
                parent = (IFolderHandle)parentInfo.getVersionableHandle();
                break;
            }
            ++i;
        }
        subProgress.done();
        subProgress = progress.newChild(50);
        subProgress.setWorkRemaining(i - 1);
        while (i != 1) {
            iterationProgress = subProgress.newChild(1).setWorkRemaining(2);
            IRelativeLocation parentRelativeLocation = path.removeLastSegments(--i);
            Shareable parentShareable = sm.findShareable(sandbox, parentRelativeLocation, ResourceType.FOLDER);
            if (checkIgnore && parentShareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) {
                progress.done();
                return null;
            }
            if (parentShareable.getFileStorage().getResourceType((IProgressMonitor)iterationProgress.newChild(1)) == ResourceType.SYMBOLIC_LINK) {
                cfa.trackSymbolicLinkAddition(parent, parentShareable, (IProgressMonitor)iterationProgress.newChild(1));
                parent = null;
                break;
            }
            cfa.trackFolderAddition(parent, parentShareable, (IProgressMonitor)iterationProgress.newChild(1));
            parent = (IFolderHandle)cfa.getItemInfo(parentRelativeLocation).getVersionableHandle();
        }
        subProgress.done();
        progress.done();
        return parent;
    }

    public IFileInfo fetchInfoInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.fetchInfo(options, monitor);
    }

    public boolean ensureMetadataUpToDate(boolean includeElement, boolean includeChildren, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaLocation, this.shareableRelativeLocation, true, (IProgressMonitor)progress.newChild(10));
        try {
            int lockCode = lock.code;
            if (lockCode != 0) {
                if (lockCode == 1) {
                    return false;
                }
                throw new OperationCanceledException();
            }
            boolean result = false;
            if (includeElement) {
                IFileInfo info = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(20));
                result |= ManagedFileStore.updateMetadata(this, info, (IProgressMonitor)progress.newChild(20));
            }
            if (includeChildren) {
                IFileInfo[] infos = this.baseStore.childInfos(0, (IProgressMonitor)progress.newChild(20));
                result |= this.updateMetadataForChildren(infos, progress.newChild(20));
            }
            boolean bl = result;
            return bl;
        }
        catch (CoreException e) {
            throw FileSystemStatusException.fromCoreException(null, e);
        }
        finally {
            if (lock != null) {
                CFALockUtil.endBatching(lock, progress.newChild(10));
            }
            progress.done();
        }
    }

    public static boolean updateMetadata(ManagedFileStore store, IFileInfo info, IProgressMonitor monitor) throws CoreException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ILocation cfaPath = store.getCfaPath();
        IRelativeLocation localPath = store.getLocalPath();
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaPath);
        if (cfa.isCorrupted()) {
            return false;
        }
        SharingManager sm = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(cfa);
        Shareable shareable = sm.findShareable(sandbox, localPath, info.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
        Share share = cfa.getShare(localPath);
        if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(30))) {
            if (share != null && info.exists()) {
                if (!info.isDirectory()) {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(localPath, share, cfa, true, (IProgressMonitor)progress.newChild(28));
                } else {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(localPath.append("a"), share, cfa, true, (IProgressMonitor)progress.newChild(28));
                }
            }
            return false;
        }
        if (share != null) {
            if (!info.exists() && !info.getAttribute(32)) {
                return cfa.deleteTreeInfo(localPath, false, (IProgressMonitor)progress.newChild(28));
            }
            FileItemInfo fInfo = cfa.getItemInfo(localPath);
            if (fInfo == null) {
                IRelativeLocation path;
                IFolderHandle parent = null;
                int numSeg = share.getPath().segmentCount();
                if (localPath.segmentCount() != numSeg) {
                    parent = ManagedFileStore.createFolderHierarchyUpToParentOf(localPath, share, cfa, false, (IProgressMonitor)progress.newChild(20));
                    if (parent == null) {
                        return true;
                    }
                    if (!(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle)) {
                        return true;
                    }
                } else if (info.getAttribute(32) ? !(share.getSharingDescriptor().getRootVersionable() instanceof ISymbolicLinkHandle) : (info.isDirectory() ? !(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle) : !(share.getSharingDescriptor().getRootVersionable() instanceof IFileItemHandle))) {
                    return false;
                }
                progress.setWorkRemaining(21);
                IRelativeLocation iRelativeLocation = path = localPath.segmentCount() == 0 ? localPath : localPath.getParent().append(info.getName());
                if (info.getAttribute(32)) {
                    cfa.trackSymbolicLinkAddition(parent, sm.findShareable(sandbox, path, info.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE), (IProgressMonitor)progress.newChild(10));
                } else if (info.isDirectory()) {
                    cfa.trackFolderAddition(parent, sm.findShareable(sandbox, path, ResourceType.FOLDER), (IProgressMonitor)progress.newChild(10));
                } else {
                    cfa.trackFileAddition(parent, sm.findShareable(sandbox, path, ResourceType.FILE), (IProgressMonitor)progress.newChild(10));
                }
                if (numSeg != 0 && numSeg == localPath.segmentCount() && !info.getName().equals(share.getPath().getName())) {
                    cfa.moveSharingInfo(share.getPath(), share.getPath().getParent().append(info.getName()), (IProgressMonitor)progress.newChild(10));
                }
                return true;
            }
            if (!ManagedFileStore.isSameType(info, fInfo)) {
                cfa.deleteTreeInfo(localPath, false, (IProgressMonitor)progress.newChild(18));
                if (localPath.segmentCount() != share.getPath().segmentCount()) {
                    IFolderHandle parent = (IFolderHandle)cfa.getItemInfo(localPath.getParent()).getVersionableHandle();
                    if (info.getAttribute(32)) {
                        cfa.trackSymbolicLinkAddition(parent, sm.findShareable(sandbox, localPath.getParent().append(info.getName()), info.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE), (IProgressMonitor)progress.newChild(10));
                    } else if (info.isDirectory()) {
                        cfa.trackFolderAddition(parent, sm.findShareable(sandbox, localPath.getParent().append(info.getName()), ResourceType.FOLDER), (IProgressMonitor)progress.newChild(10));
                    } else {
                        cfa.trackFileAddition(parent, sm.findShareable(sandbox, localPath.getParent().append(info.getName()), ResourceType.FILE), (IProgressMonitor)progress.newChild(10));
                    }
                }
                return true;
            }
            if (fInfo.isSymbolicLink()) {
                boolean directoryLink;
                ISharingDescriptor desc = share.getSharingDescriptor();
                InverseFileItemInfo inverseInfo = ManagedFileStore.getItemInfo(store, cfa, fInfo, desc);
                LinkType targetType = store.getTargetType((IProgressMonitor)progress.newChild(1));
                LinkInfo storeInfo = new LinkInfo(info.getStringAttribute(64), targetType);
                boolean contentChanged = CopyFileArea.contentChanged(fInfo, storeInfo);
                boolean nonShareRootNameChange = false;
                boolean changed = false;
                boolean bl = LinkType.NONE == targetType ? fInfo.isDirectoryLink() : (directoryLink = LinkType.DIRECTORY == targetType);
                if (localPath.segmentCount() == share.getPath().segmentCount()) {
                    if (localPath.segmentCount() != 0 && !share.getPath().getName().equals(info.getName())) {
                        cfa.moveSharingInfo(share.getPath(), share.getPath().getParent().append(info.getName()), (IProgressMonitor)progress.newChild(1));
                        changed = true;
                    }
                } else {
                    boolean bl2 = nonShareRootNameChange = !inverseInfo.getLocalName().equals(info.getName());
                }
                if (nonShareRootNameChange || contentChanged != fInfo.isContentChanged() || directoryLink != fInfo.isDirectoryLink()) {
                    progress.setWorkRemaining(11);
                    cfa.setItemMetaData(localPath.getParent().append(info.getName()), new FileItemInfo((ISymbolicLinkHandle)fInfo.getVersionableHandle(), contentChanged, fInfo.getParent(), fInfo.getName(), fInfo.isLoadedWithAnotherName(), fInfo.getHash(), fInfo.getStoredHash(), directoryLink, fInfo.isOriginalDirectoryLink()), ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(10));
                    changed = true;
                }
                return changed;
            }
            if (fInfo.isFile()) {
                boolean contentChanged = ManagedFileStore.contentChanged(store, info, fInfo, share, shareable.getFileStorage(), progress.newChild(15));
                boolean executable = shareable.getFileStorage().supportsExecBit() ? info.getAttribute(4) : fInfo.isExecutable();
                long checkStamp = fInfo.getVersionableHandle().hasStateId() ? shareable.getFileStorage().getModificationStamp() : -1L;
                boolean nonShareRootNameChange = false;
                boolean changed = false;
                if (localPath.segmentCount() == share.getPath().segmentCount()) {
                    if (localPath.segmentCount() != 0 && !share.getPath().getName().equals(info.getName())) {
                        cfa.moveSharingInfo(share.getPath(), share.getPath().getParent().append(info.getName()), (IProgressMonitor)progress.newChild(1));
                        changed = true;
                    }
                } else {
                    ISharingDescriptor desc = share.getSharingDescriptor();
                    InverseFileItemInfo inverseInfo = ManagedFileStore.getItemInfo(store, cfa, fInfo, desc);
                    boolean bl = nonShareRootNameChange = !inverseInfo.getLocalName().equals(info.getName());
                }
                if (nonShareRootNameChange || contentChanged != fInfo.isContentChanged() || executable != fInfo.isExecutable() || checkStamp != fInfo.getLastContentChangeCheckStamp()) {
                    progress.setWorkRemaining(11);
                    cfa.setItemMetaData(localPath.getParent().append(info.getName()), new FileItemInfo(fInfo.getVersionableHandle(), contentChanged, checkStamp, fInfo.getParent(), fInfo.getName(), fInfo.isLoadedWithAnotherName(), fInfo.getHash(), fInfo.getContentLength(), fInfo.getOriginalLineDelimiter(), fInfo.getLineDelimiter(), fInfo.getOriginalContentType(), fInfo.getContentType(), fInfo.getStoredPredecessorHintHash(), fInfo.getStoredSize(), fInfo.getStoredEncoding(), fInfo.getStoredHash(), fInfo.getStoredNumLineDelimiters(), executable, fInfo.isOriginalExecutable(), false, false), ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(10));
                    changed = true;
                }
                return changed;
            }
            if (localPath.segmentCount() == share.getPath().segmentCount()) {
                if (localPath.segmentCount() != 0 && !share.getPath().getName().equals(info.getName())) {
                    cfa.moveSharingInfo(share.getPath(), share.getPath().getParent().append(info.getName()), (IProgressMonitor)progress.newChild(28));
                    return true;
                }
            } else {
                ISharingDescriptor desc = share.getSharingDescriptor();
                InverseFileItemInfo inverseInfo = ManagedFileStore.getItemInfo(store, cfa, fInfo, desc);
                if (!inverseInfo.getLocalName().equals(info.getName())) {
                    cfa.setItemMetaData(localPath.getParent().append(info.getName()), fInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(28));
                    return true;
                }
            }
        } else {
            Collection<IRelativeLocation> shareRoots = cfa.allSharePaths(localPath);
            if (!info.exists() || !info.isDirectory()) {
                SubMonitor deletionMonitor = progress.newChild(28);
                deletionMonitor.setWorkRemaining(shareRoots.size());
                for (IRelativeLocation root : shareRoots) {
                    Shareable rootShareable;
                    SubMonitor iterationProgress = deletionMonitor.newChild(1).setWorkRemaining(2);
                    FileItemInfo fInfo = cfa.getItemInfo(root);
                    if (fInfo == null || (rootShareable = sm.findShareable(sandbox, root, ResourceType.getResourceType(fInfo.getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                    cfa.deleteTreeInfo(root, false, (IProgressMonitor)iterationProgress.newChild(1));
                    return true;
                }
                deletionMonitor.done();
            } else {
                int segNum = localPath.segmentCount() - 1;
                boolean changed = false;
                if (segNum >= 0) {
                    SubMonitor shareMoveMonitor = progress.newChild(28);
                    shareMoveMonitor.setWorkRemaining(shareRoots.size());
                    for (IRelativeLocation root : shareRoots) {
                        ISharingDescriptor desc;
                        Shareable rootShareable;
                        SubMonitor iterationProgress = shareMoveMonitor.newChild(1).setWorkRemaining(2);
                        if (root.segment(segNum).equals(info.getName()) || (rootShareable = sm.findShareable(sandbox, root, ResourceType.getResourceType((desc = cfa.getSharingInfo(root)).getRootVersionable()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                        IRelativeLocation newPath = root.removeLastSegments(root.segmentCount() - segNum).append(info.getName()).append(root.removeFirstSegments(segNum + 1));
                        cfa.moveSharingInfo(root, newPath, (IProgressMonitor)iterationProgress.newChild(1));
                        changed = true;
                    }
                }
                return changed;
            }
        }
        return false;
    }

    private static InverseFileItemInfo getItemInfo(ManagedFileStore store, CopyFileArea cfa, FileItemInfo fInfo, ISharingDescriptor desc) throws FileSystemException {
        try {
            return cfa.getItemInfo(fInfo.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), true);
        }
        catch (IllegalStateException e) {
            throw new FileSystemException(NLS.bind((String)Messages.ManagedFileStore_12, (Object)store.getCfaPath().append(store.getLocalPath())), e);
        }
    }

    private static boolean isSameType(IFileInfo info, FileItemInfo fInfo) {
        if (info.getAttribute(32)) {
            return fInfo.isSymbolicLink();
        }
        if (info.isDirectory()) {
            return fInfo.isFolder();
        }
        return fInfo.isFile();
    }

    private static boolean contentChanged(ManagedFileStore store, IFileInfo info, FileItemInfo fiInfo, Share share, IFileStorage storage, SubMonitor progress) throws CoreException, FileSystemException {
        ContentHash newHash;
        if (fiInfo == null || fiInfo.getHash() == null) {
            return false;
        }
        if (info.getLength() != fiInfo.getContentLength()) {
            return true;
        }
        if (fiInfo.getLastContentChangeCheckStamp() != -1L && fiInfo.getLastContentChangeCheckStamp() == storage.getModificationStamp() && storage.getLocalTimeStamp() == info.getLastModified()) {
            return fiInfo.isContentChanged();
        }
        IVersionableHandle item = fiInfo.getVersionableHandle();
        IComponentHandle component = share.getSharingDescriptor().getComponent();
        IContextHandle connection = share.getSharingDescriptor().getConnectionHandle();
        if (share.getTracker().containsDatelessVersionable(info.getLastModified(), item, component, connection)) {
            return fiInfo.isContentChanged();
        }
        progress.beginTask(Messages.ManagedFileStore_1, 100);
        try {
            InputStream in = store.openInputStream(0, (IProgressMonitor)progress.newChild(50));
            try {
                newHash = ContentHash.valueOf((InputStream)in);
                in.close();
                in = null;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (RuntimeException runtimeException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        catch (ContentHashAlgorithmException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)e));
        }
        boolean isSame = newHash.equals((Object)fiInfo.getHash());
        share.getTracker().registerDatelessVersionable(info.getLastModified(), item, component, connection);
        return !isSame;
    }

    public ManagedFileStore getChild(IRelativeLocation path) {
        return new ManagedFileStore(this.cfaLocation, this.shareableRelativeLocation.append(path), this.baseStore.getChild(path.toPath()));
    }

    public ManagedFileStore getChild(String name) {
        return new ManagedFileStore(this.cfaLocation, this.shareableRelativeLocation.append(name), this.baseStore.getChild(name));
    }

    public ManagedFileSystem getFileSystem() {
        return ManagedFileSystem.getInstance();
    }

    public String getName() {
        return this.baseStore.getName();
    }

    public ManagedFileStore getParent() {
        if (this.shareableRelativeLocation.segmentCount() == 0) {
            return null;
        }
        IFileStore baseParent = this.baseStore.getParent();
        if (baseParent == null) {
            return null;
        }
        return new ManagedFileStore(this.cfaLocation, this.shareableRelativeLocation.getParent(), baseParent);
    }

    public boolean isParentOf(IFileStore other) {
        if (!(other instanceof ManagedFileStore)) {
            return false;
        }
        ManagedFileStore otherStore = (ManagedFileStore)other;
        if (!this.cfaLocation.sameLocation(otherStore.cfaLocation, ManagedFileSystem.getInstance().isCaseSensitive()) || !this.shareableRelativeLocation.isPrefixOf(otherStore.shareableRelativeLocation, ManagedFileSystem.getInstance().isCaseSensitive())) {
            return false;
        }
        IFileStore s = this.baseStore;
        if (this.shareableRelativeLocation.segmentCount() != otherStore.shareableRelativeLocation.segmentCount()) {
            s = s.getChild(otherStore.shareableRelativeLocation.removeFirstSegments(this.shareableRelativeLocation.segmentCount()).toPath());
        }
        return otherStore.baseStore.equals(s);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        block13: {
            if (this.shareableRelativeLocation != null && this.shareableRelativeLocation.segmentCount() > 250) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_13));
            }
            if (this.trackingChanges()) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        AbstractLock lock = CFALockUtil.createAndLockForUpdate(this.cfaLocation, this.shareableRelativeLocation, true, (IProgressMonitor)progress.newChild(1));
                        try {
                            this.baseStore.mkdir(options, (IProgressMonitor)progress.newChild(70));
                            if (lock == null) {
                                this.requestBackgroundMetadataUpdate(false);
                            } else {
                                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaLocation);
                                Share share = cfa.getShare(this.shareableRelativeLocation);
                                ManagedFileStore.createFolderHierarchyUpToParentOf(this.shareableRelativeLocation.append("a"), share, cfa, true, (IProgressMonitor)progress.newChild(28));
                            }
                            break block13;
                        }
                        finally {
                            if (lock != null) {
                                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                            }
                        }
                    }
                    catch (FileSystemException e) {
                        throw ManagedFileStore.getCoreExceptionFor(e);
                    }
                }
                finally {
                    ManagedFileStore.done(monitor);
                }
            }
            this.baseStore.mkdir(options, monitor);
        }
        return this;
    }

    private static void moveMetadata(IRelativeLocation sourcePath, Share sourceShare, ManagedFileStore managedDestination, CopyFileArea cfa, IProgressMonitor monitor) throws CoreException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
        IRelativeLocation destinationPath = managedDestination.shareableRelativeLocation;
        SharingManager sm = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(cfa);
        FileItemInfo info = cfa.getItemInfo(sourcePath);
        ResourceType hint = info == null ? ResourceType.FOLDER : ResourceType.getResourceType(info.getVersionableHandle());
        Shareable sourceShareable = sm.findShareable(sandbox, sourcePath, hint);
        Shareable targetShareable = sm.findShareable(sandbox, destinationPath, hint);
        boolean sourceIgnored = sourceShareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10));
        Share targetShare = cfa.getShare(destinationPath);
        boolean moved = false;
        if (!sourceIgnored && targetShare == null) {
            Collection<IRelativeLocation> roots = cfa.allSharePaths(destinationPath);
            if (roots.isEmpty()) {
                if (sourceShare.getPath().segmentCount() == sourcePath.segmentCount() && !targetShareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10))) {
                    cfa.moveSharingInfo(sourcePath, destinationPath, (IProgressMonitor)progress.newChild(90));
                    moved = true;
                }
            } else {
                SubMonitor subProgress = progress.newChild(90);
                subProgress.setWorkRemaining(roots.size());
                for (IRelativeLocation root : roots) {
                    SubMonitor iterationProgress = subProgress.newChild(1).setWorkRemaining(2);
                    ISharingDescriptor desc = cfa.getSharingInfo(root);
                    IRelativeLocation srcPath = sourcePath.append(root.removeFirstSegments(destinationPath.segmentCount()));
                    Shareable rootTargetShareable = sm.findShareable(sandbox, root, ResourceType.getResourceType(desc.getRootVersionable()));
                    if (rootTargetShareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                    FileItemInfo srcInfo = cfa.getItemInfo(srcPath);
                    if (srcInfo == null) {
                        cfa.deleteTreeInfo(root, false, (IProgressMonitor)iterationProgress.newChild(1));
                        continue;
                    }
                    if (desc.getConnectionHandle().sameItemId((IItemHandle)sourceShare.getSharingDescriptor().getConnectionHandle()) && desc.getComponent().sameItemId((IItemHandle)sourceShare.getSharingDescriptor().getComponent())) {
                        if (srcInfo.isFolder() != desc.getRootVersionable() instanceof IFolderHandle) {
                            cfa.deleteTreeInfo(root, false, (IProgressMonitor)iterationProgress.newChild(1));
                            continue;
                        }
                        if (srcInfo.isFolder()) {
                            SubMonitor subSubProgress = iterationProgress.newChild(1);
                            subSubProgress.setWorkRemaining(100);
                            cfa.trackFolderAddition(null, rootTargetShareable, (IProgressMonitor)subSubProgress.newChild(10));
                            Map<StringWrapper, FileItemInfo> infoMap = cfa.getChildInfos(srcPath, (IProgressMonitor)subSubProgress.newChild(10));
                            subSubProgress.setWorkRemaining(infoMap.size());
                            for (Map.Entry<StringWrapper, FileItemInfo> e : infoMap.entrySet()) {
                                FileItemInfo childInfo;
                                SubMonitor subIterationProgress = subSubProgress.newChild(1).setWorkRemaining(2);
                                String name = e.getKey().toString();
                                IRelativeLocation sourceChildPath = srcPath.append(name);
                                IRelativeLocation targetChildPath = root.append(name);
                                Shareable childTargetShareable = sm.findShareable(sandbox, targetChildPath, ResourceType.getResourceType((childInfo = e.getValue()).getVersionableHandle()));
                                if (childTargetShareable.shouldBeIgnored((IProgressMonitor)subIterationProgress.newChild(1))) continue;
                                cfa.moveTreeInfo(sourceChildPath, targetChildPath, false, (IProgressMonitor)subIterationProgress.newChild(1));
                            }
                            continue;
                        }
                        if (srcInfo.isFile()) {
                            cfa.trackFileAddition(null, rootTargetShareable, (IProgressMonitor)iterationProgress.newChild(1));
                            continue;
                        }
                        if (!srcInfo.isSymbolicLink()) continue;
                        cfa.trackSymbolicLinkAddition(null, rootTargetShareable, (IProgressMonitor)iterationProgress.newChild(1));
                        continue;
                    }
                    ManagedFileStore.refreshSubtree(managedDestination.getChild(root.removeFirstSegments(destinationPath.segmentCount())), (IProgressMonitor)iterationProgress.newChild(1));
                }
                subProgress.done();
            }
        } else if (!sourceIgnored && targetShare != null && targetShare.getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)sourceShare.getSharingDescriptor().getConnectionHandle()) && targetShare.getSharingDescriptor().getComponent().sameItemId((IItemHandle)sourceShare.getSharingDescriptor().getComponent())) {
            if (sourcePath.segmentCount() == sourceShare.getPath().segmentCount() && sourceShare.getSharingDescriptor().getRootVersionable().sameItemId((IItemHandle)targetShare.getSharingDescriptor().getRootVersionable())) {
                if (!targetShareable.shouldBeIgnored((IProgressMonitor)progress.newChild(50))) {
                    if (!sourcePath.equals(destinationPath)) {
                        cfa.moveSharingInfo(sourcePath, destinationPath, (IProgressMonitor)progress.newChild(50));
                    }
                    moved = true;
                }
            } else if (sourcePath.segmentCount() == sourceShare.getPath().segmentCount() || destinationPath.segmentCount() == targetShare.getPath().segmentCount()) {
                if (!(targetShareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10)) || info == null || destinationPath.segmentCount() == targetShare.getPath().segmentCount() && info.getVersionableHandle().getItemType() != targetShare.getSharingDescriptor().getRootVersionable().getItemType())) {
                    if (info.isFolder()) {
                        cfa.trackFolderAddition(null, targetShareable, (IProgressMonitor)progress.newChild(10));
                        Map<StringWrapper, FileItemInfo> infoMap = cfa.getChildInfos(sourcePath, (IProgressMonitor)progress.newChild(10));
                        SubMonitor subProgress = progress.newChild(60);
                        subProgress.setWorkRemaining(infoMap.size());
                        for (Map.Entry<StringWrapper, FileItemInfo> e : infoMap.entrySet()) {
                            FileItemInfo childInfo;
                            SubMonitor iterationProgress = subProgress.newChild(1).setWorkRemaining(2);
                            String name = e.getKey().toString();
                            IRelativeLocation sourceChildPath = sourcePath.append(name);
                            IRelativeLocation targetChildPath = destinationPath.append(name);
                            Shareable childTargetShareable = sm.findShareable(sandbox, targetChildPath, ResourceType.getResourceType((childInfo = e.getValue()).getVersionableHandle()));
                            if (childTargetShareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                            cfa.moveTreeInfo(sourceChildPath, targetChildPath, false, (IProgressMonitor)iterationProgress.newChild(1));
                        }
                    } else {
                        cfa.trackFileAddition(null, targetShareable, (IProgressMonitor)progress.newChild(90));
                    }
                }
            } else if (!targetShareable.shouldBeIgnored((IProgressMonitor)progress.newChild(50))) {
                cfa.moveTreeInfo(sourcePath, destinationPath, false, (IProgressMonitor)progress.newChild(50));
                moved = true;
            }
        } else if (targetShare != null) {
            ManagedFileStore.refreshSubtree(managedDestination, (IProgressMonitor)progress.newChild(90));
        } else {
            Collection<IRelativeLocation> roots = cfa.allSharePaths(destinationPath);
            SubMonitor subProgress = progress.newChild(90);
            subProgress.setWorkRemaining(roots.size());
            for (IRelativeLocation root : roots) {
                ManagedFileStore.refreshSubtree(managedDestination.getChild(root.removeFirstSegments(destinationPath.segmentCount())), (IProgressMonitor)subProgress.newChild(1));
            }
            subProgress.done();
        }
        if (!moved && !sourceIgnored && info != null) {
            cfa.deleteTreeInfo(sourcePath, false, (IProgressMonitor)progress.newChild(10));
        }
        progress.done();
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            CFALockUtil.LockResult lock;
            ManagedFileStore managedDestination;
            block33: {
                block34: {
                    IFileInfo baseInfo;
                    IFileStore source = this.getCanonicalFileStore((IFileStore)this, progress.newChild(1));
                    if (!source.equals((Object)this) && !(baseInfo = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(1))).getAttribute(32)) {
                        source.move(destination, options, (IProgressMonitor)progress.newChild(99));
                        return;
                    }
                    destination = this.getCanonicalFileStore(destination, progress.newChild(1));
                    managedDestination = null;
                    if (destination instanceof ManagedFileStore) {
                        managedDestination = (ManagedFileStore)destination;
                        destination = managedDestination.baseStore;
                    }
                    if (!this.trackingChanges()) {
                        this.moveBaseStore(destination, options, progress.newChild(100));
                        return;
                    }
                    lock = managedDestination == null ? CFALockUtil.createAndLockForUpdateOfChildren(this.cfaLocation, this.shareableRelativeLocation, true, (IProgressMonitor)progress.newChild(1)) : CFALockUtil.createAndLockForUpdateOfChildren(Arrays.asList(this.cfaLocation, managedDestination.cfaLocation), Arrays.asList(this.shareableRelativeLocation, managedDestination.shareableRelativeLocation), true, (IProgressMonitor)progress.newChild(1));
                    this.moveBaseStore(destination, options, progress.newChild(50));
                    if (lock.code == 0) break block33;
                    if (lock == null) break block34;
                    CFALockUtil.endBatching(lock, progress.newChild(1));
                }
                return;
            }
            try {
                try {
                    progress.setWorkRemaining(49);
                    SharingManager sm = SharingManager.getInstance();
                    CopyFileArea sourceCFA = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaLocation);
                    Sandbox sourceSandbox = new Sandbox(sourceCFA);
                    Share sourceShare = sourceCFA.getShare(this.shareableRelativeLocation);
                    CopyFileArea targetCFA = null;
                    Share targetShare = null;
                    if (managedDestination != null) {
                        targetCFA = CopyFileAreaManager.instance.getExistingCopyFileArea(managedDestination.cfaLocation);
                        targetShare = targetCFA.getShare(managedDestination.shareableRelativeLocation);
                    }
                    if (sourceShare != null) {
                        ManagedFileStore.createFolderHierarchyUpToParentOf(this.shareableRelativeLocation, sourceShare, sourceCFA, true, (IProgressMonitor)progress.newChild(10));
                    }
                    progress.setWorkRemaining(39);
                    if (targetShare != null) {
                        ManagedFileStore.createFolderHierarchyUpToParentOf(managedDestination.shareableRelativeLocation, targetShare, targetCFA, true, (IProgressMonitor)progress.newChild(10));
                    }
                    progress.setWorkRemaining(29);
                    if (managedDestination == null || sourceCFA != targetCFA) {
                        SubMonitor subProgress;
                        Collection<IRelativeLocation> roots;
                        if (sourceShare == null) {
                            roots = sourceCFA.allSharePaths(this.shareableRelativeLocation);
                            subProgress = progress.newChild(28);
                            subProgress.setWorkRemaining(roots.size());
                            for (IRelativeLocation root : roots) {
                                SubMonitor iterationProgress = subProgress.newChild(1).setWorkRemaining(2);
                                ISharingDescriptor desc = sourceCFA.getSharingInfo(root);
                                Shareable sourceShareable = sm.findShareable(sourceSandbox, this.shareableRelativeLocation, ResourceType.getResourceType(desc.getRootVersionable()));
                                if (sourceShareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                                sourceCFA.deleteTreeInfo(root, false, (IProgressMonitor)iterationProgress.newChild(1));
                            }
                            subProgress.done();
                        } else {
                            Shareable sourceShareable;
                            FileItemInfo info = sourceCFA.getItemInfo(this.shareableRelativeLocation);
                            if (info != null && !(sourceShareable = sm.findShareable(sourceSandbox, this.shareableRelativeLocation, ResourceType.getResourceType(info.getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)progress.newChild(8))) {
                                Share sourceParentShare = sourceCFA.getShare(this.shareableRelativeLocation.removeLastSegments(1));
                                sourceCFA.deleteTreeInfo(this.shareableRelativeLocation, sourceParentShare == null, (IProgressMonitor)progress.newChild(20));
                            }
                        }
                        if (managedDestination != null) {
                            if (targetShare != null) {
                                ManagedFileStore.refreshSubtree(managedDestination, (IProgressMonitor)progress.newChild(28));
                            } else {
                                roots = targetCFA.allSharePaths(managedDestination.shareableRelativeLocation);
                                subProgress = progress.newChild(28);
                                subProgress.setWorkRemaining(roots.size());
                                for (IRelativeLocation root : roots) {
                                    ManagedFileStore.refreshSubtree(managedDestination.getChild(root.removeFirstSegments(managedDestination.shareableRelativeLocation.segmentCount())), (IProgressMonitor)subProgress.newChild(1));
                                }
                                subProgress.done();
                            }
                        } else {
                            sourceCFA.forget(this.shareableRelativeLocation, (IProgressMonitor)progress.newChild(20));
                        }
                    } else if (sourceShare == null) {
                        Collection<IRelativeLocation> roots = sourceCFA.allSharePaths(this.shareableRelativeLocation);
                        SubMonitor subProgress = progress.newChild(28);
                        subProgress.setWorkRemaining(roots.size());
                        for (IRelativeLocation root : roots) {
                            Share share = sourceCFA.getShare(root);
                            ManagedFileStore.moveMetadata(root, share, managedDestination.getChild(root.removeFirstSegments(this.shareableRelativeLocation.segmentCount())), sourceCFA, (IProgressMonitor)subProgress.newChild(1));
                        }
                        subProgress.done();
                    } else {
                        ManagedFileStore.moveMetadata(this.shareableRelativeLocation, sourceShare, managedDestination, sourceCFA, (IProgressMonitor)progress.newChild(28));
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (lock != null) {
                        CFALockUtil.endBatching(lock, progress.newChild(1));
                    }
                }
            }
            catch (FileSystemException e) {
                throw ManagedFileStore.getCoreExceptionFor(e);
            }
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    private void moveBaseStore(IFileStore destination, int options, SubMonitor progress) throws CoreException {
        block8: {
            if (!this.baseStore.toURI().equals(destination.toURI())) {
                progress.setWorkRemaining(100);
                IFileInfo targetInfo = destination.fetchInfo(0, (IProgressMonitor)progress.newChild(10));
                if ((targetInfo.getAttribute(32) || targetInfo.exists()) && !this.isSameFile(this.baseStore, destination, progress.newChild(2))) {
                    throw new CoreException(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_9, (Object)destination.toLocalFile(0, (IProgressMonitor)progress.newChild(10)).getAbsolutePath()), null));
                }
                try {
                    IFileInfo info = this.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
                    if (!info.getAttribute(32)) {
                        this.baseStore.move(destination, options & 0xFFFFFFFD, (IProgressMonitor)progress.newChild(70));
                        break block8;
                    }
                    String linkTarget = info.getStringAttribute(64);
                    boolean isDirectory = this.getTargetType((IProgressMonitor)progress.newChild(1)) == LinkType.DIRECTORY;
                    ManagedFileStore.createSymlink(destination, linkTarget, isDirectory, (IProgressMonitor)progress.newChild(35));
                    try {
                        this.baseStore.delete(0, (IProgressMonitor)progress.newChild(35));
                    }
                    catch (CoreException e) {
                        destination.delete(32, (IProgressMonitor)progress.newChild(1));
                        throw e;
                    }
                }
                catch (CoreException e) {
                    IFileInfo destInfo;
                    IFileInfo sourceInfo;
                    if (e.getStatus().getCode() == 272 && !(sourceInfo = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(10))).exists() && !sourceInfo.getAttribute(32) && !(destInfo = destination.fetchInfo(0, (IProgressMonitor)progress.newChild(10))).exists() && destInfo.getAttribute(32)) {
                        return;
                    }
                    throw e;
                }
            }
        }
    }

    private boolean isSameFile(IFileStore s1, IFileStore s2, SubMonitor monitor) throws CoreException {
        monitor.setWorkRemaining(2);
        File file1 = s1.toLocalFile(0, (IProgressMonitor)monitor.newChild(1));
        if (file1 == null) {
            return false;
        }
        File file2 = s2.toLocalFile(0, (IProgressMonitor)monitor.newChild(1));
        if (file2 == null) {
            return false;
        }
        try {
            return file1.getCanonicalFile().equals(file2.getCanonicalFile());
        }
        catch (IOException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor(e));
        }
    }

    protected IFileStore getCanonicalFileStore(IFileStore destination, SubMonitor progress) throws CoreException {
        try {
            PathLocation path;
            ICopyFileArea cfa;
            File localFile = destination.toLocalFile(0, (IProgressMonitor)progress);
            File cf = localFile.getCanonicalFile();
            if (cf.equals(localFile)) {
                String parentLinkTarget = destination.getParent().fetchInfo().getStringAttribute(64);
                if (parentLinkTarget != null) {
                    cf = new File(String.valueOf(parentLinkTarget) + File.separatorChar + destination.getName());
                } else {
                    return destination;
                }
            }
            if ((cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(path = new PathLocation((IPath)new Path(cf.getAbsolutePath())))) != null) {
                ILocation rootPath = cfa.getRoot();
                return new ManagedFileStore(rootPath, path.getLocationRelativeTo(rootPath), EFS.getLocalFileSystem().fromLocalFile(cf));
            }
            return EFS.getLocalFileSystem().fromLocalFile(cf);
        }
        catch (IOException e) {
            throw new CoreException(FileSystemStatusUtil.getStatusFor(e));
        }
    }

    private static void refreshSubtree(ManagedFileStore root, IProgressMonitor mon) throws FileSystemException, CoreException {
        ManagedFileTree.refreshSubtree(root, mon);
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.openInputStream(options, monitor);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        if (!this.trackingChanges()) {
            return this.baseStore.openOutputStream(options, monitor);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            OutputStream outputStream;
            block18: {
                CFALockUtil.LockResult lock;
                block14: {
                    OutputStream outputStream2;
                    block17: {
                        block15: {
                            FilterOutputStream filterOutputStream;
                            block16: {
                                lock = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaLocation, this.shareableRelativeLocation, true, (IProgressMonitor)progress.newChild(1));
                                try {
                                    if (lock.code == 0) break block14;
                                    if (lock.code != 2) break block15;
                                    OutputStream out = this.baseStore.openOutputStream(options, (IProgressMonitor)progress.newChild(99));
                                    filterOutputStream = new FilterOutputStream(out){

                                        @Override
                                        public void close() throws IOException {
                                            super.close();
                                            ManagedFileStore.this.requestBackgroundMetadataUpdate(true);
                                        }
                                    };
                                    if (lock == null) break block16;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (lock != null) {
                                            CFALockUtil.endBatching(lock, progress.newChild(1));
                                        }
                                        throw throwable;
                                    }
                                    catch (FileSystemException e) {
                                        throw ManagedFileStore.getCoreExceptionFor(e);
                                    }
                                }
                                CFALockUtil.endBatching(lock, progress.newChild(1));
                            }
                            return filterOutputStream;
                        }
                        outputStream2 = this.baseStore.openOutputStream(options, (IProgressMonitor)progress.newChild(99));
                        if (lock == null) break block17;
                        CFALockUtil.endBatching(lock, progress.newChild(1));
                    }
                    return outputStream2;
                }
                outputStream = this.openOutputStreamInternal(options, progress.newChild(99));
                if (lock == null) break block18;
                CFALockUtil.endBatching(lock, progress.newChild(1));
            }
            return outputStream;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    private OutputStream openOutputStreamInternal(int options, SubMonitor progress) throws CoreException, FileSystemException {
        progress.setWorkRemaining(99);
        Object out = this.baseStore.openOutputStream(options, (IProgressMonitor)progress.newChild(70));
        try {
            MessageDigest cs;
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaLocation);
            SharingManager sm = SharingManager.getInstance();
            Sandbox sandbox = new Sandbox(cfa);
            Share share = cfa.getShare(this.shareableRelativeLocation);
            if (share == null) {
                Collection<IRelativeLocation> shareRoots = cfa.allSharePaths(this.shareableRelativeLocation);
                progress.setWorkRemaining(shareRoots.size() * 2);
                for (IRelativeLocation root : shareRoots) {
                    ISharingDescriptor desc;
                    Shareable shareable = sm.findShareable(sandbox, root, ResourceType.getResourceType((desc = cfa.getSharingInfo(root)).getRootVersionable()));
                    if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(1))) continue;
                    cfa.deleteTreeInfo(root, false, (IProgressMonitor)progress.newChild(1));
                }
                OutputStream outputStream = out;
                return outputStream;
            }
            Shareable shareable = sm.findShareable(sandbox, this.shareableRelativeLocation, ResourceType.FILE);
            if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10))) {
                ManagedFileStore.createFolderHierarchyUpToParentOf(this.shareableRelativeLocation, share, cfa, true, (IProgressMonitor)progress.newChild(19));
                OutputStream outputStream = out;
                return outputStream;
            }
            if (share.getPath().segmentCount() == this.shareableRelativeLocation.segmentCount() && share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle) {
                cfa.deleteTreeInfo(this.shareableRelativeLocation, false, (IProgressMonitor)progress.newChild(29));
                OutputStream outputStream = out;
                return outputStream;
            }
            progress.setWorkRemaining(100);
            IFileInfo info = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(5));
            FileItemInfo fInfo = cfa.getItemInfo(this.shareableRelativeLocation);
            IFolderHandle parent = ManagedFileStore.createFolderHierarchyUpToParentOf(this.shareableRelativeLocation, share, cfa, false, (IProgressMonitor)progress.newChild(1));
            if (parent == null && share.getPath().segmentCount() != this.shareableRelativeLocation.segmentCount()) {
                OutputStream outputStream = out;
                return outputStream;
            }
            if (fInfo != null && fInfo.isSymbolicLink()) {
                OutputStream outputStream = out;
                return outputStream;
            }
            if (fInfo == null) {
                if (share.getPath().segmentCount() == this.shareableRelativeLocation.segmentCount()) {
                    ISharingDescriptor desc = share.getSharingDescriptor();
                    InverseFileItemInfo inverse = cfa.getItemInfo(desc.getRootVersionable(), desc.getComponent(), desc.getConnectionHandle(), false);
                    if (inverse != null && inverse.getHash() != null) {
                        fInfo = new FileItemInfo(inverse.getVersionableHandle(), true, -1L, inverse.getParent(), inverse.getName(), inverse.isLoadedWithAnotherName(), inverse.getHash(), inverse.getContentLength(), inverse.getOriginalLineDelimiter(), inverse.getOriginalLineDelimiter(), inverse.getOriginalContentType(), inverse.getOriginalContentType(), inverse.getStoredPredecessorHintHash(), inverse.getStoredSize(), inverse.getStoredEncoding(), inverse.getStoredHash(), inverse.getStoredNumLineDelimiters(), info.getAttribute(4), inverse.isOriginalExecutable(), inverse.isDirectoryLink(), inverse.isOriginalDirectoryLink());
                        cfa.setItemMetaData(this.shareableRelativeLocation, fInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(5));
                    }
                } else {
                    FileItemInfo parentInfo = cfa.getItemInfo(this.shareableRelativeLocation.getParent());
                    if (parentInfo != null && parentInfo.getVersionableHandle().hasStateId() && (fInfo = cfa.getDeletedItem((IFolderHandle)parentInfo.getVersionableHandle(), this.shareableRelativeLocation.getName(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getConnectionHandle(), (IProgressMonitor)progress.newChild(5))) != null) {
                        if (fInfo.getVersionableHandle() instanceof IFileItemHandle) {
                            fInfo = new FileItemInfo(fInfo.getVersionableHandle(), true, -1L, fInfo.getParent(), fInfo.getName(), fInfo.isLoadedWithAnotherName(), fInfo.getHash(), fInfo.getContentLength(), fInfo.getOriginalLineDelimiter(), fInfo.getOriginalLineDelimiter(), fInfo.getOriginalContentType(), fInfo.getOriginalContentType(), fInfo.getStoredPredecessorHintHash(), fInfo.getStoredSize(), fInfo.getStoredEncoding(), fInfo.getStoredHash(), fInfo.getStoredNumLineDelimiters(), info.getAttribute(4), fInfo.isOriginalExecutable(), false, false);
                            cfa.setItemMetaData(this.shareableRelativeLocation, fInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(5));
                        } else {
                            fInfo = null;
                        }
                    }
                }
            }
            try {
                cs = ContentHash.getHashDigest();
            }
            catch (ContentHashAlgorithmException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)e));
            }
            if (fInfo != null && fInfo.getHash() != null && (options & 1) != 0 && info.getLength() < fInfo.getContentLength()) {
                InputStream in = this.baseStore.openInputStream(0, (IProgressMonitor)progress.newChild(5));
                try {
                    try {
                        byte[] buf = new byte[8192];
                        int len = in.read(buf);
                        while (len != -1) {
                            cs.update(buf, 0, len);
                            len = in.read(buf);
                        }
                        in.close();
                        in = null;
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)e));
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            LoggingHelper.error("com.ibm.team.filesystem.client", e.getMessage(), e);
                        }
                    }
                }
                progress.setWorkRemaining(95);
            }
            if (fInfo != null) {
                ContentHash targetHash = fInfo.getHash();
                if (targetHash != null) {
                    if ((options & 1) != 0) {
                        if (info.getLength() <= fInfo.getContentLength()) {
                            out = new ChangeTrackingOutputStream(cs, (OutputStream)out, this, (IFileItemHandle)fInfo.getVersionableHandle(), share, targetHash, fInfo.getContentLength() - info.getLength());
                        } else {
                            Assert.isTrue((boolean)fInfo.isContentChanged());
                        }
                    } else {
                        out = new ChangeTrackingOutputStream(cs, (OutputStream)out, this, (IFileItemHandle)fInfo.getVersionableHandle(), share, targetHash, fInfo.getContentLength());
                    }
                }
            } else {
                cfa.trackFileAddition(parent, shareable, (IProgressMonitor)progress.newChild(25));
            }
            OutputStream outputStream = out;
            return outputStream;
        }
        catch (CoreException e) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
        catch (RuntimeException e) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
        finally {
            progress.done();
        }
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean needRefresh = (options & 0x400) != 0 && this.trackingChanges();
        this.baseStore.putInfo(info, options, (IProgressMonitor)progress.newChild(needRefresh ? 50 : 100));
        if (needRefresh) {
            try {
                ManagedFileTree.refreshMetadata(this, (IProgressMonitor)progress.newChild(50));
            }
            catch (FileSystemException e) {
                throw ManagedFileStore.getCoreExceptionFor(e);
            }
        }
    }

    private static CoreException getCoreExceptionFor(FileSystemException e) {
        if (e.getCause() instanceof CoreException) {
            return (CoreException)e.getCause();
        }
        return new CoreException(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
    }

    public URI toURI() {
        return ManagedFileSystem.getCanonicalManagedURI(this.cfaLocation, this.shareableRelativeLocation, this.baseStore.toURI());
    }

    public IFileStore getBaseStore() {
        return this.baseStore;
    }

    public IRelativeLocation getLocalPath() {
        return this.shareableRelativeLocation;
    }

    public ILocation getCfaPath() {
        return this.cfaLocation;
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.toLocalFile(options, monitor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ManagedFileStore)) {
            return false;
        }
        ManagedFileStore store = (ManagedFileStore)((Object)obj);
        return this.cfaLocation.sameLocation(store.cfaLocation, ManagedFileSystem.getInstance().isCaseSensitive()) && store.shareableRelativeLocation.sameLocation(this.shareableRelativeLocation, ManagedFileSystem.getInstance().isCaseSensitive()) && store.baseStore.equals(this.baseStore);
    }

    public String toString() {
        return this.baseStore.toString();
    }

    public int hashCode() {
        if (!ManagedFileSystem.getInstance().isCaseSensitive()) {
            ILocation p1 = this.cfaLocation.getCanonicalForm(false, true);
            IRelativeLocation p2 = this.shareableRelativeLocation.getCanonicalForm(false, true);
            return p1.hashCode() ^ p2.hashCode() ^ this.baseStore.hashCode();
        }
        return this.cfaLocation.hashCode() ^ this.shareableRelativeLocation.hashCode() ^ this.baseStore.hashCode();
    }

    public boolean isBrokenLink(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress;
        block24: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IFileInfo info = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(50));
            if (!info.exists()) {
                return true;
            }
            if (!ManagedFileStore.hasEmbeddedTargetType()) {
                return false;
            }
            if (info.isDirectory()) {
                try {
                    if (this.baseStore.childStores(0, (IProgressMonitor)progress.newChild(20)).length != 0) {
                        return false;
                    }
                }
                catch (CoreException coreException) {
                    return true;
                }
                File link = this.baseStore.toLocalFile(0, (IProgressMonitor)progress.newChild(20));
                if (link == null) {
                    return false;
                }
                return link.list() == null;
            }
            InputStream fis = null;
            try {
                fis = this.baseStore.openInputStream(0, (IProgressMonitor)progress.newChild(20));
                fis.read();
                progress.worked(20);
            }
            catch (CoreException coreException) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                return true;
            }
            catch (IOException iOException) {
                block23: {
                    try {
                        if (fis == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        fis.close();
                    }
                    catch (IOException iOException3) {}
                }
                return true;
            }
            if (fis == null) break block24;
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        progress.worked(10);
        return false;
    }

    public boolean verifyLinkTargetType(boolean directory, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileInfo info = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(100));
        if (!info.exists()) {
            return true;
        }
        return info.isDirectory() == directory;
    }

    public static String convertTargetToLocal(String target) throws CoreException {
        if (target == null) {
            return null;
        }
        if (target.startsWith("/") || target.startsWith("\\") || target.length() > 1 && target.charAt(1) == ':') {
            return symlinkHelper.normalizeSymlinkTarget(target);
        }
        if (target.indexOf(SEGMENT_SEPARATOR) != -1 && target.indexOf(ALT_SEGMENT_SEPARATOR) != -1) {
            return symlinkHelper.normalizeSymlinkTarget(target);
        }
        return symlinkHelper.normalizeSymlinkTarget(target.replace(ALT_SEGMENT_SEPARATOR, SEGMENT_SEPARATOR));
    }

    public String convertIntoLocalForm(String target) throws CoreException {
        return ManagedFileStore.convertTargetToLocal(target);
    }
}

