/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;

public final class Shareable
implements IShareable,
IShareableInternal {
    private final IRelativeLocation path;
    private final ResourceType resourceTypeHint;
    private final ISandbox sandbox;
    private final int cachedHashCode;
    private IFileStorage fileStorage;
    private ILocation fullPath;

    public Shareable(ILocation copyFileAreaRoot, IRelativeLocation path, ResourceType resourceTypeHint) {
        this.path = path;
        if (resourceTypeHint == null) {
            throw new IllegalArgumentException();
        }
        this.resourceTypeHint = resourceTypeHint;
        this.sandbox = new Sandbox(copyFileAreaRoot);
        this.cachedHashCode = this.calculateHashCode();
    }

    public Shareable(ISandbox sandbox, IRelativeLocation path, ResourceType resourceTypeHint) {
        this.sandbox = sandbox;
        this.path = path;
        if (resourceTypeHint == null) {
            throw new IllegalArgumentException();
        }
        this.resourceTypeHint = resourceTypeHint;
        this.cachedHashCode = this.calculateHashCode();
    }

    public Shareable(ISandbox sandbox, IRelativeLocation path, IFileStorage fileStorage) {
        this.sandbox = sandbox;
        this.path = path;
        this.resourceTypeHint = null;
        this.fileStorage = fileStorage;
        this.cachedHashCode = this.calculateHashCode();
    }

    public final ILocation getCopyFileAreaRoot() {
        return this.getSandbox().getRoot();
    }

    @Override
    public final IRelativeLocation getLocalPath() {
        return this.path;
    }

    @Override
    public final ILocation getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.getCopyFileAreaRoot().append(this.getLocalPath());
        }
        return this.fullPath;
    }

    @Override
    public final IShare getShare(IProgressMonitor monitor) throws FileSystemException {
        return SharingManager.instance.getShare(this.getCopyFileAreaRoot(), this.path, monitor);
    }

    @Override
    public int getState(IProgressMonitor monitor) throws FileSystemException {
        IVersionableHandle versionable;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int mask = 0;
        if (this.exists((IProgressMonitor)progress.newChild(1))) {
            mask |= 8;
        }
        if (this.getShare((IProgressMonitor)progress.newChild(49)) == null) {
            return mask;
        }
        mask |= 1;
        FileItemInfo itemInfo = this.getFileItemInfo((IProgressMonitor)progress.newChild(50));
        if (itemInfo != null && (versionable = itemInfo.getVersionableHandle()).hasStateId()) {
            mask |= 2;
        }
        return mask;
    }

    public final IShare share(ISharingDescriptor descriptor, FileItemInfo fileItemInfo, MetadataProperties properties, boolean overwrite, IProgressMonitor monitor) throws FileSystemException {
        return this.share(descriptor, fileItemInfo, properties, overwrite, true, monitor);
    }

    public IShare share(ISharingDescriptor descriptor, FileItemInfo fileItemInfo, MetadataProperties properties, boolean overwrite, boolean loadChanges, IProgressMonitor monitor) throws FileSystemException {
        int options = 0;
        if (overwrite) {
            options |= 1;
        }
        if (loadChanges) {
            options |= 4;
        }
        return SharingManager.getInstance().share(this, descriptor, fileItemInfo, properties, options, monitor);
    }

    @Override
    public final IVersionableHandle getRemote(IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        return info != null && info.getVersionableHandle().hasStateId() ? info.getVersionableHandle() : null;
    }

    @Override
    public final IVersionableHandle getVersionable(IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        return info != null ? info.getVersionableHandle() : null;
    }

    public void accept(final IShareableVisitor visitor, final int depth, final boolean includeLocal, boolean mutable, IProgressMonitor monitor) throws FileSystemException {
        final ArrayList visitorExceptions = new ArrayList();
        final boolean[] visitedRoot = new boolean[1];
        IVisitor metadataVisitor = new IVisitor(){

            @Override
            public boolean visit(IRelativeLocation path, FileItemInfo fileItem, IProgressMonitor monitor) {
                SubMonitor progress;
                visitedRoot[0] = true;
                IVersionableHandle versionableHandle = fileItem.getVersionableHandle();
                boolean remote = versionableHandle.hasStateId();
                if (!includeLocal) {
                    if (!remote) {
                        return false;
                    }
                    Shareable shareable = new Shareable(Shareable.this.getCopyFileAreaRoot(), path, ResourceType.getResourceType(fileItem.getVersionableHandle()));
                    return visitor.visit(shareable, monitor);
                }
                final Shareable shareable = new Shareable(Shareable.this.getCopyFileAreaRoot(), path, ResourceType.getResourceType(fileItem.getVersionableHandle()));
                boolean visitChildren = visitor.visit(shareable, (IProgressMonitor)(progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100)).newChild(50));
                if (!visitChildren) {
                    return false;
                }
                if (!fileItem.isFolder()) {
                    return false;
                }
                try {
                    shareable.visit(new IShareableVisitor(){

                        @Override
                        public boolean visit(IShareable shareableToVisit, IProgressMonitor monitor) {
                            if (shareable.equals(shareableToVisit)) {
                                return true;
                            }
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            boolean hasMetadata = false;
                            try {
                                FileItemInfo fileItemInfo = ((Shareable)shareableToVisit).getFileItemInfo((IProgressMonitor)progress.newChild(1));
                                boolean bl = hasMetadata = fileItemInfo != null;
                                if (hasMetadata && !shareable.getSandbox().isCaseSensitive()) {
                                    ISharingDescriptor desc = shareable.getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor();
                                    InverseFileItemInfo itemInfo = ICopyFileAreaManager.instance.getExistingCopyFileArea(Shareable.this.getCopyFileAreaRoot()).getItemInfo(fileItemInfo.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), true);
                                    hasMetadata = itemInfo.getLocalName().equals(shareableToVisit.getLocalPath().getName());
                                }
                            }
                            catch (FileSystemException e) {
                                visitorExceptions.add(e);
                            }
                            if (!hasMetadata) {
                                boolean result = visitor.visit(shareableToVisit, (IProgressMonitor)progress.newChild(99));
                                return result;
                            }
                            return false;
                        }
                    }, depth, (IProgressMonitor)progress.newChild(50));
                    progress.done();
                }
                catch (FileSystemException e) {
                    visitorExceptions.add(e);
                }
                return true;
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForUpdate(this.getCopyFileAreaRoot(), this.getLocalPath(), (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            progress.done();
            return;
        }
        try {
            ICopyFileAreaManager.instance.getExistingCopyFileArea(this.getCopyFileAreaRoot()).accept(metadataVisitor, this.getLocalPath(), mutable, depth, (IProgressMonitor)progress.newChild(95));
            if (!visitedRoot[0]) {
                progress.setWorkRemaining(100);
                if (this.exists((IProgressMonitor)progress.newChild(1))) {
                    visitor.visit(this, (IProgressMonitor)progress.newChild(4));
                    this.visit(visitor, depth, (IProgressMonitor)progress.newChild(95));
                }
            }
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
        if (!visitorExceptions.isEmpty()) {
            if (visitorExceptions.size() == 1) {
                throw (FileSystemException)((Object)visitorExceptions.get(0));
            }
            MultiStatus ms = new MultiStatus("com.ibm.team.filesystem.client", 0, NLS.bind((String)Messages.Shareable_0, (Object)this.getLocalPath(), (Object[])new Object[0]), null);
            for (FileSystemException e : visitorExceptions) {
                ms.add(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
            }
            throw new FileSystemStatusException((IStatus)ms);
        }
    }

    @Override
    public IFileStorage getFileStorage() {
        if (this.fileStorage == null) {
            this.fileStorage = new FileStorageWrapper(this, this.resourceTypeHint);
        }
        return this.fileStorage;
    }

    @Override
    public void forget(IProgressMonitor monitor) throws FileSystemException {
        SharingManager.getInstance().forget(this, monitor);
    }

    @Override
    public void unshare(IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.isShare((IProgressMonitor)progress.newChild(10))) {
            throw new IllegalStateException("Only the root of the share can be unshared");
        }
        SharingManager.getInstance().forget(this, (IProgressMonitor)progress.newChild(90));
    }

    @Override
    public boolean isShare(IProgressMonitor monitor) throws FileSystemException {
        IShare share = this.getShare(monitor);
        return share != null && this.getLocalPath().equals(share.getPath());
    }

    public IShareable getParent() {
        IRelativeLocation parentPath = this.getLocalPath().getParent();
        if (parentPath.isEmpty()) {
            return null;
        }
        IFileStorage parent = this.getFileStorage().getParent();
        if (parent == null) {
            return null;
        }
        return parent.getShareable();
    }

    @Override
    public boolean shouldBeIgnored(IProgressMonitor monitor) throws FileSystemException {
        return this.getFileStorage().shouldBeIgnored(monitor);
    }

    @Override
    public ResourceType getResourceType(IProgressMonitor monitor) throws FileSystemException {
        return this.getFileStorage().getResourceType(monitor);
    }

    @Override
    public ILocalChange getChange(IProgressMonitor progress) throws FileSystemException {
        return SharingManager.getInstance().getChange(this, progress);
    }

    @Override
    public FileLineDelimiter getLineDelimiter(IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        if (info != null) {
            return info.getLineDelimiter();
        }
        return FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    @Override
    public String getContentType(IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        if (info != null) {
            return info.getContentType();
        }
        return null;
    }

    @Override
    public FileLineDelimiter getOriginalLineDelimiter(IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        if (info != null) {
            return info.getOriginalLineDelimiter();
        }
        return FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    @Override
    public String getOriginalContentType(IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        if (info != null) {
            return info.getOriginalContentType();
        }
        return null;
    }

    @Override
    public boolean isExecutable(IProgressMonitor monitor) throws FileSystemException {
        return this.getFileStorage().isExecutable(monitor);
    }

    @Override
    public IMetadataProperties getMetadataProperties(IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        MetadataProperties properties = null;
        AbstractLock lock = CFALockUtil.lockExistingForRead(this.getCopyFileAreaRoot(), (IProgressMonitor)progress.newChild(1));
        if (lock != null) {
            try {
                IShare share;
                FileItemInfo info;
                ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.getCopyFileAreaRoot());
                if (cfa != null && (info = cfa.getItemInfo(this.path)) != null && (share = SharingManager.instance.getShare(this.getCopyFileAreaRoot(), this.path, (IProgressMonitor)progress.newChild(1))) != null) {
                    InverseFileItemInfo inverseInfo = cfa.getItemInfo(info.getVersionableHandle(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getConnectionHandle(), true);
                    properties = new MetadataProperties(inverseInfo.getOriginalProperties(), inverseInfo.getChangedProperties(), inverseInfo.getRemovedProperties());
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
        if (properties == null) {
            properties = new MetadataProperties();
        }
        return properties;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    private final int calculateHashCode() {
        return this.getFullPath().getCanonicalForm(this.getSandbox().isCaseSensitive(), true).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Shareable other = (Shareable)obj;
        if (!this.getSandbox().equals(other.getSandbox())) {
            return false;
        }
        return this.getLocalPath().sameLocation(other.getLocalPath(), this.getSandbox().isCaseSensitive() && other.getSandbox().isCaseSensitive());
    }

    public Object getAdapter(Class adaptTo) {
        if (adaptTo.isAssignableFrom(Shareable.class)) {
            return this;
        }
        if (adaptTo.isAssignableFrom(File.class)) {
            return (File)this.getFullPath().getAdapter(File.class);
        }
        IFileStorage fileStorage = this.getFileStorage();
        return fileStorage.getAdapter(adaptTo);
    }

    final void setFileStorage(IFileStorage fileStorageToCache) {
        if (fileStorageToCache.getShareable() == this) {
            this.fileStorage = fileStorageToCache;
        }
    }

    private void visit(IShareableVisitor visitor, int depth, IProgressMonitor monitor) throws FileSystemException {
        IFileStorage fileStorage;
        Collection<IFileStorage> children;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER && depth != 0 && (children = (fileStorage = this.getFileStorage()).getChildren(true, (IProgressMonitor)progress.newChild(1))) != null) {
            progress.setWorkRemaining(children.size());
            for (IFileStorage child : children) {
                SubMonitor subProgress = progress.newChild(1);
                subProgress.setWorkRemaining(100);
                Shareable shareable = child.getShareable();
                boolean visitChildren = visitor.visit(shareable, (IProgressMonitor)subProgress.newChild(5));
                if (!visitChildren) continue;
                shareable.visit(visitor, depth - 1, (IProgressMonitor)subProgress.newChild(95));
            }
        }
    }

    @Override
    public ISandbox getSandbox() {
        return this.sandbox;
    }

    @Override
    public FileItemInfo getFileItemInfo(IProgressMonitor monitor) throws FileSystemException {
        return this.getFileItemInfo(this.path, monitor);
    }

    private FileItemInfo getFileItemInfo(IRelativeLocation localPath, IProgressMonitor monitor) throws FileSystemException {
        FileItemInfo info = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        AbstractLock lock = CFALockUtil.lockExistingForRead(this.getCopyFileAreaRoot(), (IProgressMonitor)progress.newChild(1));
        if (lock != null) {
            try {
                ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.getCopyFileAreaRoot());
                if (cfa != null) {
                    info = cfa.getItemInfo(localPath);
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
        return info;
    }

    public String toString() {
        return String.valueOf(this.getSandbox().getRoot().toString()) + " -> " + this.getLocalPath().toString();
    }

    @Override
    public boolean exists(IProgressMonitor progress) throws FileSystemException {
        return this.getFileStorage().exists(progress);
    }
}

