/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.internal.load.loadRules.ChildLoadFilter;
import com.ibm.team.filesystem.client.internal.load.loadRules.LoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LoadRuleSerializationDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LoadRule2
implements ILoadRule2 {
    private static final String FORMAT = "yyyy-MM-dd HH.mm.ss";
    private final IConnection connection;
    private final ILoadFilter loadFilter;
    private final int eclipseLoadOptions;
    private Collection<LoadRequest> loadRequests;

    public LoadRule2(IConnection connection, ILoadFilter loadFilter2, int loadOptions) {
        this.connection = connection;
        this.loadFilter = loadFilter2;
        this.eclipseLoadOptions = loadOptions;
        this.loadRequests = new ArrayList<LoadRequest>();
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    public ILoadFilter getLoadFilter() {
        return this.loadFilter;
    }

    @Override
    public void serializeToXML(Writer writer, List<String> comments, LoadRuleSerializationDilemmaHandler preferences, IProgressMonitor progress) throws TeamRepositoryException {
        if (preferences == null) {
            preferences = LoadRuleSerializationDilemmaHandler.getDefault();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            if (comments != null) {
                for (String comment : comments) {
                    Comment commentNode = document.createComment(comment);
                    document.appendChild(commentNode);
                }
            }
            SimpleDateFormat formatter = new SimpleDateFormat(FORMAT);
            Comment commentNode = document.createComment(NLS.bind((String)Messages.LoadRule2_2, (Object)formatter.format(new Date(System.currentTimeMillis()))));
            document.appendChild(commentNode);
            this.toRule(document, null, preferences, progress);
            document.getDocumentElement().normalize();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new FileSystemException(Messages.LoadRule2_0, e);
        }
        catch (TransformerException e) {
            throw new FileSystemException(Messages.LoadRule2_1, e);
        }
    }

    public void toRule(Document document, Element parent, LoadRuleSerializationDilemmaHandler preferences, IProgressMonitor progress) throws TeamRepositoryException {
        Element element = document.createElementNS("http://com.ibm.team.scm", "scm:sourceControlLoadRule");
        if (parent != null) {
            parent.appendChild(element);
        } else {
            document.appendChild(element);
        }
        element.setAttribute("version", Integer.toString(1));
        int options = preferences.overrideEclipseLoadOption(this.eclipseLoadOptions);
        if (options != 0) {
            if (options == 2) {
                element.setAttribute("eclipseProjectOptions", "import");
            } else if (options == 1) {
                element.setAttribute("eclipseProjectOptions", "create");
            }
        }
        if (this.loadFilter instanceof LoadFilter) {
            Collection<String> excludePatterns = ((LoadFilter)this.loadFilter).getExcludePatterns();
            ChildLoadFilter filter = new ChildLoadFilter("excludeFilter", false);
            filter.addNames(excludePatterns);
            filter.toRule(document, element, preferences, progress);
        }
        for (LoadRequest request : this.loadRequests) {
            request.toRule(document, element, preferences, progress);
        }
    }

    @Override
    public ILoadOperation getLoadOp(ISandbox sandbox, LoadDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException {
        Collection<Object> components = this.connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)this.connection).getComponents() : Collections.singleton(((IBaselineConnection)this.connection).getComponent());
        return this.getLoadOp(sandbox, components, dilemmaHandler, monitor);
    }

    @Override
    public ILoadOperation getLoadOp(ISandbox sandbox, Collection<IComponentHandle> components, LoadDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException {
        dilemmaHandler = dilemmaHandler == null ? LoadDilemmaHandler.getDefault() : dilemmaHandler;
        ArrayList<IStatus> problems = new ArrayList<IStatus>();
        HashMap<UUID, IComponentHandle> componentIds = new HashMap<UUID, IComponentHandle>();
        for (IComponentHandle componentHandle : components) {
            componentIds.put(componentHandle.getItemId(), componentHandle);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.loadRequests.size() + 1));
        ILoadOperation loadOp = IOperationFactory.instance.getLoadOperation(dilemmaHandler);
        if (this.eclipseLoadOptions != 0) {
            loadOp.setEclipseSpecificLoadOptions(this.eclipseLoadOptions);
        }
        if (this.loadFilter != null) {
            loadOp.setLoadFilter(this.loadFilter);
        }
        this.prepareLoadRequests(componentIds, (IProgressMonitor)progress.newChild(1));
        for (LoadRequest request : this.loadRequests) {
            IStatus status;
            if (!componentIds.containsKey(request.getComponent().getItemId()) || (status = request.configureLoad(loadOp, sandbox, (IProgressMonitor)progress.newChild(1))).isOK()) continue;
            problems.add(status);
        }
        this.handleProblems(dilemmaHandler, problems);
        return loadOp;
    }

    protected void handleProblems(LoadDilemmaHandler dilemmaHandler, ArrayList<IStatus> errors) throws FileSystemException {
        if (errors.isEmpty()) {
            return;
        }
        int direction = dilemmaHandler.loadRuleProblems(errors);
        if (direction == 1) {
            throw new OperationCanceledException();
        }
        if (direction != 0) {
            if (errors.size() == 1) {
                if (errors.get(0).getException() instanceof FileSystemException && errors.get(0).getMessage().equals(errors.get(0).getException().getMessage())) {
                    throw (FileSystemException)((Object)errors.get(0).getException());
                }
                throw new FileSystemStatusException(errors.get(0));
            }
            throw new FileSystemStatusException((IStatus)new MultiStatus("com.ibm.team.filesystem.client", 0, errors.toArray(new IStatus[errors.size()]), NLS.bind((String)Messages.FileSystemOperation_0, (Object)errors.size()), null));
        }
    }

    private void prepareLoadRequests(Map<UUID, IComponentHandle> componentIds, IProgressMonitor progress) throws TeamRepositoryException {
        HashMap requireResolution = new HashMap();
        HashMap<UUID, HashMap<UUID, IVersionableHandle>> toResolve = new HashMap<UUID, HashMap<UUID, IVersionableHandle>>();
        for (LoadRequest request : this.loadRequests) {
            ArrayList requests;
            IVersionableHandle versionableRequiringRepoPathResolution;
            if (!componentIds.containsKey(request.getComponent().getItemId()) || (versionableRequiringRepoPathResolution = request.requireRepoPath()) == null) continue;
            HashMap<UUID, IVersionableHandle> toResolveByComponent = (HashMap<UUID, IVersionableHandle>)toResolve.get(request.getComponent().getItemId());
            if (toResolveByComponent == null) {
                toResolveByComponent = new HashMap<UUID, IVersionableHandle>();
                toResolve.put(request.getComponent().getItemId(), toResolveByComponent);
            }
            toResolveByComponent.put(versionableRequiringRepoPathResolution.getItemId(), versionableRequiringRepoPathResolution);
            HashMap requireResolutionByComponent = (HashMap)requireResolution.get(request.getComponent().getItemId());
            if (requireResolutionByComponent == null) {
                requireResolutionByComponent = new HashMap();
                requireResolution.put(request.getComponent().getItemId(), requireResolutionByComponent);
            }
            if ((requests = (ArrayList)requireResolutionByComponent.get(versionableRequiringRepoPathResolution.getItemId())) != null) continue;
            requests = new ArrayList(2);
            requireResolutionByComponent.put(versionableRequiringRepoPathResolution.getItemId(), requests);
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)toResolve.size());
        for (Map.Entry entry : toResolve.entrySet()) {
            IComponentHandle component = componentIds.get(entry.getKey());
            IConfiguration config = this.getConfiguration(component);
            ArrayList versionableHandles = new ArrayList(((Map)entry.getValue()).values());
            List ancestors = config.locateAncestors(versionableHandles, (IProgressMonitor)monitor.newChild(1));
            Iterator i = ancestors.iterator();
            Map requireResolutionByComponent = (Map)requireResolution.remove(component.getItemId());
            for (IVersionableHandle versionableHandle : versionableHandles) {
                IAncestorReport report = (IAncestorReport)i.next();
                List requests = (List)requireResolutionByComponent.get(versionableHandle.getItemId());
                for (LoadRequest request : requests) {
                    request.setRepoPath(report);
                }
            }
        }
    }

    private IConfiguration getConfiguration(IComponentHandle component) throws TeamRepositoryException {
        IConfiguration config = this.connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)this.connection).configuration(component) : ((IBaselineConnection)this.connection).configuration();
        return config;
    }

    public void addLoadRequest(LoadRequest request) {
        this.loadRequests.add(request);
    }
}

