/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.IgnoresUtil;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSummary;
import com.ibm.team.filesystem.client.rest.parameters.ParmsInvalidMimeTypeDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsInvalidPropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterErrorInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsProperty;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyUpdates;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxPaths;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IChangeSetSummary;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ChangeSummaryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilesystemRestClientDTOresourceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.resource.IgnoreReasonDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.InvalidPropertyDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.MimeTypeErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.PermissionsContextDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.PropertyFailureDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertyChangeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SandboxPathsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SymlinkPropertiesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class ResourceUtil {
    public static ResourcesDTO getResourceProperties(ParmsResourceProperties parms, IProgressMonitor progress) throws TeamRepositoryException {
        boolean computeFully;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(2 * parms.fullResourcePaths.length + 1));
        boolean bl = computeFully = parms.computeFully != null && parms.computeFully != false;
        if (computeFully) {
            monitor.setWorkRemaining(parms.fullResourcePaths.length * 3);
        }
        HashMap<ConfigurationFacade, ArrayList<ResourcePropertiesDTO>> sharePaths = new HashMap<ConfigurationFacade, ArrayList<ResourcePropertiesDTO>>();
        ArrayList<IShareable> shareables = new ArrayList<IShareable>(parms.fullResourcePaths.length);
        String[] stringArray = parms.fullResourcePaths;
        int n = parms.fullResourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String fullResourceStringPath = stringArray[n2];
            PathLocation path = new PathLocation((IPath)new Path(fullResourceStringPath));
            ResourceType resourceType = CommonUtil.getResourceType(path, (IProgressMonitor)monitor.newChild(1));
            if (resourceType == null) {
                resourceType = ResourceType.FILE;
            }
            shareables.add(SharingManager.getInstance().findShareable(path, resourceType));
            ++n2;
        }
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareables, (IProgressMonitor)monitor.newChild(1));
        ResourcesDTO resources = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcesDTO();
        int path = 0;
        for (IShareable iShareable : shareables) {
            SubMonitor resourceMonitor = monitor.newChild(1);
            resourceMonitor.setWorkRemaining(100);
            ResourcePropertiesDTO resourceProperties = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcePropertiesDTO();
            resources.getResourceProperties().add(resourceProperties);
            resourceProperties.setFullPath(parms.fullResourcePaths[path++]);
            if (iShareable != null) {
                resourceProperties.setPath(CoreUtil.translateShareable(iShareable));
                ResourceType type = iShareable.getResourceType((IProgressMonitor)resourceMonitor.newChild(5));
                resourceProperties.setLocal(type != null);
                IShare share = iShareable.getShare((IProgressMonitor)resourceMonitor.newChild(10));
                resourceProperties.setShared(share != null);
                if (!resourceProperties.isShared()) {
                    resourceProperties.setRemote(false);
                } else {
                    FileItemInfo info;
                    IVersionableHandle versionable;
                    assert (share != null);
                    ISharingDescriptor descriptor = share.getSharingDescriptor();
                    resourceProperties.setShare(CoreUtil.translateShare(share, (IProgressMonitor)resourceMonitor.newChild(5)));
                    resourceProperties.setIgnored(iShareable.shouldBeIgnored((IProgressMonitor)resourceMonitor.newChild(10)));
                    if (computeFully && resourceProperties.isIgnored()) {
                        ResourceUtil.getResourceIgnoreProperties(iShareable, resourceProperties, resourceMonitor.newChild(10));
                    }
                    if ((versionable = iShareable.getVersionable((IProgressMonitor)resourceMonitor.newChild(15))) == null) {
                        resourceProperties.setRemote(false);
                    } else {
                        resourceProperties.setItemId(versionable.getItemId().getUuidValue());
                        resourceProperties.setVersionableItemType(CoreUtil.getVersionableItemType(versionable));
                        if (versionable.hasStateId()) {
                            ITeamRepository repo;
                            resourceProperties.setStateId(versionable.getStateId().getUuidValue());
                            resourceProperties.setRemote(true);
                            if (computeFully && (repo = RepositoryUtils.getTeamRepositoryById(descriptor.getRepositoryId())) != null) {
                                ConfigurationFacade configDescriptor = new ConfigurationFacade(repo, descriptor.getConnectionHandle(), descriptor.getComponent());
                                ArrayList<ResourcePropertiesDTO> properties = (ArrayList<ResourcePropertiesDTO>)sharePaths.get((Object)configDescriptor);
                                if (properties == null) {
                                    properties = new ArrayList<ResourcePropertiesDTO>();
                                    sharePaths.put(configDescriptor, properties);
                                }
                                properties.add(resourceProperties);
                            }
                        } else {
                            resourceProperties.setRemote(false);
                        }
                    }
                    ILocalChange pendingChange = LocalChangeManager.getInstance().getPendingChange(iShareable, (IProgressMonitor)resourceMonitor.newChild(15));
                    resourceProperties.setDirty(pendingChange.getType() != 0);
                    IMetadataProperties userProperties = iShareable.getMetadataProperties((IProgressMonitor)resourceMonitor.newChild(5));
                    if (type == ResourceType.FILE) {
                        resourceProperties.setVersionableItemType("file");
                        info = ((Shareable)iShareable).getFileItemInfo((IProgressMonitor)resourceMonitor.newChild(10));
                        if (info != null) {
                            FilePropertiesDTO fileProperties = FilesystemRestClientDTOresourceFactory.eINSTANCE.createFilePropertiesDTO();
                            fileProperties.setContentType(info.getContentType());
                            if (info.getLineDelimiter() != null) {
                                fileProperties.setLineDelimiter(info.getLineDelimiter().toString());
                            }
                            fileProperties.setOriginalContentType(info.getOriginalContentType());
                            if (info.getOriginalLineDelimiter() != null) {
                                fileProperties.setOriginalLineDelimiter(info.getOriginalLineDelimiter().toString());
                            }
                            fileProperties.setExecutable(iShareable.isExecutable((IProgressMonitor)resourceMonitor.newChild(10)));
                            try {
                                fileProperties.setEncoding(SharingManager.getInstance().getContentExaminer(iShareable).getEncoding(iShareable, (IProgressMonitor)resourceMonitor.newChild(5)));
                            }
                            catch (FileSystemException fileSystemException) {}
                            fileProperties.setOriginalExecutable(info.isOriginalExecutable());
                            fileProperties.setOriginalEncoding(info.getStoredEncoding());
                            resourceProperties.setFileProperties(fileProperties);
                        }
                    } else if (type == ResourceType.FOLDER) {
                        resourceProperties.setVersionableItemType("folder");
                    } else if (type == ResourceType.SYMBOLIC_LINK) {
                        info = ((Shareable)iShareable).getFileItemInfo((IProgressMonitor)resourceMonitor.newChild(10));
                        resourceProperties.setVersionableItemType("symbolic_link");
                        SymlinkPropertiesDTO symlinkProperties = FilesystemRestClientDTOresourceFactory.eINSTANCE.createSymlinkPropertiesDTO();
                        if (info != null) {
                            symlinkProperties.setType(info.isDirectoryLink() ? "directory" : "file");
                        } else {
                            symlinkProperties.setType("file");
                        }
                        resourceProperties.setSymlinkProperties(symlinkProperties);
                    }
                    resourceProperties.getUserProperties().putAll(userProperties.getCurrentProperties());
                }
            }
            resourceMonitor.done();
        }
        if (computeFully) {
            monitor = monitor.setWorkRemaining(sharePaths.size() * 30);
            for (Map.Entry entry : sharePaths.entrySet()) {
                IVersionablePermissionsReport[] permissions;
                IConfiguration configuration = ((ConfigurationFacade)((Object)entry.getKey())).getConfiguration((IProgressMonitor)monitor.newChild(10));
                ITeamRepository repository = configuration == null ? null : configuration.teamRepository();
                List properties = (List)entry.getValue();
                ArrayList<Object> versionables = new ArrayList<Object>(properties.size());
                for (ResourcePropertiesDTO resourceProperties : properties) {
                    if ("folder".equals(resourceProperties.getVersionableItemType())) {
                        versionables.add((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repository, UUID.valueOf((String)resourceProperties.getItemId()), null));
                    } else if ("file".equals(resourceProperties.getVersionableItemType())) {
                        versionables.add((IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repository, UUID.valueOf((String)resourceProperties.getItemId()), null));
                    } else if ("file".equals(resourceProperties.getVersionableItemType())) {
                        versionables.add((ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle((Object)repository, UUID.valueOf((String)resourceProperties.getItemId()), null));
                    }
                    PermissionsContextDTO context = FilesystemRestClientDTOresourceFactory.eINSTANCE.createPermissionsContextDTO();
                    context.setAccessible(true);
                    resourceProperties.setPermissionsContext(context);
                }
                if (configuration == null || versionables.isEmpty()) continue;
                List ancestors = configuration.locateAncestors(versionables, (IProgressMonitor)monitor.newChild(15));
                int i = 0;
                for (IAncestorReport report : ancestors) {
                    ResourcePropertiesDTO resourceProperties = (ResourcePropertiesDTO)properties.get(i);
                    ++i;
                    if (report.getNameItemPairs().isEmpty()) continue;
                    resourceProperties.setRemotePath(CoreUtil.translatePath(report));
                }
                IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                IVersionablePermissionsReport[] iVersionablePermissionsReportArray = permissions = wm.getPermissions(versionables.toArray(new IVersionableHandle[versionables.size()]), configuration.component(), (IProgressMonitor)monitor.newChild(5));
                int n3 = permissions.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVersionablePermissionsReport report = iVersionablePermissionsReportArray[n4];
                    if (report.getContext() != null) {
                        for (ResourcePropertiesDTO rp : properties) {
                            if (!report.getItemsIds().contains(UUID.valueOf((String)rp.getItemId()))) continue;
                            rp.getPermissionsContext().setReadContext(report.getContext().getReadContext());
                        }
                    } else if (report.isReportOfInaccessible()) {
                        for (ResourcePropertiesDTO rp : properties) {
                            if (!report.getItemsIds().contains(UUID.valueOf((String)rp.getItemId()))) continue;
                            rp.getPermissionsContext().setAccessible(false);
                        }
                    }
                    ++n4;
                }
            }
        }
        return resources;
    }

    private static void getResourceIgnoreProperties(IShareable shareable, ResourcePropertiesDTO resourceProperties, SubMonitor monitor) {
        IIgnoreManager.IIgnoreReason reasons;
        try {
            reasons = IgnoreManager.getInstance().findIgnoreReasons(shareable, (IProgressMonitor)monitor);
        }
        catch (FileSystemException fileSystemException) {
            return;
        }
        if (reasons == null) {
            return;
        }
        IgnoreReasonDTO reasonDTO = FilesystemRestClientDTOresourceFactory.eINSTANCE.createIgnoreReasonDTO();
        PathDTO inheritPath = null;
        if (reasons.inherited()) {
            inheritPath = CoreUtil.translatePath(reasons.inheritsFrom().getLocalPath());
        }
        reasonDTO.setInheritsFrom(inheritPath);
        for (IIgnoreProvider.IIgnoreRule rule : reasons.getRules()) {
            reasonDTO.getRules().add(IgnoresUtil.translateRule(rule));
        }
        resourceProperties.setIgnoreReason(reasonDTO);
    }

    private static int getDirection(String direction) {
        if ("cancel".equals(direction)) {
            return 1;
        }
        if ("continue".equals(direction)) {
            return 0;
        }
        return 2;
    }

    public static ChangePropertiesDilemmaHandler getChangePropertiesDilemmaHandler(ParmsLineDelimiterDilemmaHandler lineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported, ParmsInvalidPropertiesDilemmaHandler invalidPropertiesDilemmaHandler, List<PropertyFailureDTO> propertyFailuresReported, ParmsInvalidMimeTypeDilemmaHandler invalidMimeTypeDilemmaHandler, List<MimeTypeErrorDTO> mimeTypeFailuresReported, BackupDilemmaHandler backupDilemmaHandler) {
        int invalidPropertyDirection = ResourceUtil.getInvalidPropertyDirection(invalidPropertiesDilemmaHandler);
        int invalidMimeTypeDirection = ResourceUtil.getInvalidMimeTypeDirection(invalidMimeTypeDilemmaHandler);
        return ResourceUtil.getChangePropertiesDilemmaHandler(lineDelimiterDilemmaHandler, lineDelimiterErrorsReported, invalidPropertyDirection, propertyFailuresReported, invalidMimeTypeDirection, mimeTypeFailuresReported, null, backupDilemmaHandler);
    }

    private static ChangePropertiesDilemmaHandler getChangePropertiesDilemmaHandler(ParmsLineDelimiterDilemmaHandler lineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported, final int invalidPropertyDirection, final List<PropertyFailureDTO> propertyFailuresReported, final int invalidMimeTypeDirection, final List<MimeTypeErrorDTO> mimeTypeFailuresReported, final List<ShareableDTO> executableFailuresReported, final BackupDilemmaHandler backupDilemmaHandler) {
        final LineDelimiterErrorHandler lineDelimiterErrorHandler = new LineDelimiterErrorHandler(lineDelimiterDilemmaHandler, lineDelimiterErrorsReported);
        ChangePropertiesDilemmaHandler dilemmaHandler = new ChangePropertiesDilemmaHandler(){

            @Override
            public int inconsistentLineDelimiters(List<? extends IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) throws FileSystemException {
                return lineDelimiterErrorHandler.inconsistentLineDelimiters(inconsistentDelimiters, monitor);
            }

            @Override
            public int invalidProperties(List<? extends IChangePropertiesRequest> invalidPropertyChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                if (propertyFailuresReported != null) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)invalidPropertyChangeRequests.size());
                    for (IChangePropertiesRequest iChangePropertiesRequest : invalidPropertyChangeRequests) {
                        SubMonitor subProgress = progress.newChild(1).setWorkRemaining(100);
                        Map<String, IStatus> invalidProperties = iChangePropertiesRequest.getInvalidProperties();
                        propertyFailuresReported.add(ResourceUtil.translatePropertyFailure(iChangePropertiesRequest.getShareableToChange(), invalidProperties, (IProgressMonitor)subProgress.newChild(70)));
                    }
                }
                return invalidPropertyDirection;
            }

            @Override
            public int invalidContentTypes(List<? extends IChangePropertiesRequest> invalidContentTypeChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                if (mimeTypeFailuresReported != null) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)invalidContentTypeChangeRequests.size());
                    for (IChangePropertiesRequest iChangePropertiesRequest : invalidContentTypeChangeRequests) {
                        SubMonitor subProgress = progress.newChild(1).setWorkRemaining(100);
                        String invalidMineType = iChangePropertiesRequest.getContentType((IProgressMonitor)subProgress.newChild(30));
                        mimeTypeFailuresReported.add(ResourceUtil.translateMineTypeFailure(iChangePropertiesRequest.getShareableToChange(), invalidMineType, (IProgressMonitor)subProgress.newChild(70)));
                    }
                }
                return invalidMimeTypeDirection;
            }

            @Override
            public void executableFailures(List<? extends IChangePropertiesRequest> executableChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                if (executableFailuresReported != null) {
                    for (IChangePropertiesRequest iChangePropertiesRequest : executableChangeRequests) {
                        executableFailuresReported.add(CoreUtil.translateShareable(iChangePropertiesRequest.getShareableToChange()));
                    }
                }
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    protected static PropertyFailureDTO translatePropertyFailure(IShareable shareable, Map<String, IStatus> invalidProperties, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        PropertyFailureDTO propertyFailure = FilesystemRestClientDTOresourceFactory.eINSTANCE.createPropertyFailureDTO();
        propertyFailure.setFileName(CoreUtil.translatePath(shareable.getLocalPath()));
        propertyFailure.setShare(CoreUtil.translateShare(shareable.getShare((IProgressMonitor)progress.newChild(55)), (IProgressMonitor)progress.newChild(45)));
        for (Map.Entry<String, IStatus> entry : invalidProperties.entrySet()) {
            InvalidPropertyDTO invalidProperty = FilesystemRestClientDTOresourceFactory.eINSTANCE.createInvalidPropertyDTO();
            invalidProperty.setPropertyName(entry.getKey());
            invalidProperty.setReason(entry.getValue().getMessage());
            propertyFailure.getInvalidProperties().add(invalidProperty);
        }
        return propertyFailure;
    }

    protected static MimeTypeErrorDTO translateMineTypeFailure(IShareable shareable, String invalidMimeType, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        MimeTypeErrorDTO mimeTypeFailure = FilesystemRestClientDTOresourceFactory.eINSTANCE.createMimeTypeErrorDTO();
        mimeTypeFailure.setFileName(CoreUtil.translatePath(shareable.getLocalPath()));
        mimeTypeFailure.setShare(CoreUtil.translateShare(shareable.getShare((IProgressMonitor)progress.newChild(55)), (IProgressMonitor)progress.newChild(45)));
        mimeTypeFailure.setMimeType(invalidMimeType);
        return mimeTypeFailure;
    }

    public static LineDelimiterErrorDTO translateLineDelimiterError(IShareable shareable, FileLineDelimiter incompatibleLineDelimiterSetting, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        LineDelimiterErrorDTO failedUpload = FilesystemRestClientDTOresourceFactory.eINSTANCE.createLineDelimiterErrorDTO();
        failedUpload.setFileName(CoreUtil.translatePath(shareable.getLocalPath()));
        failedUpload.setShare(CoreUtil.translateShare(shareable.getShare((IProgressMonitor)progress.newChild(55)), (IProgressMonitor)progress.newChild(45)));
        if (incompatibleLineDelimiterSetting != null) {
            failedUpload.setLineDelimiter(ResourceUtil.getLineDelimiter(incompatibleLineDelimiterSetting));
        }
        return failedUpload;
    }

    public static ResourcePropertyChangeResultDTO postResourceProperties(ParmsResourcePropertyUpdates parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ResourcePropertyChangeResultDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcePropertyChangeResultDTO();
        BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        int invalidPropertyDirection = ResourceUtil.getInvalidPropertyDirection(parms.invalidPropertiesDilemmaHandler);
        int invalidMimeTypeDirection = ResourceUtil.getInvalidMimeTypeDirection(parms.invalidMimeTypeDilemmaHandler);
        ChangePropertiesDilemmaHandler dilemmaHandler = ResourceUtil.getChangePropertiesDilemmaHandler(parms.lineDelimiterDilemmaHandler, result.getLineDelimiterFailures(), invalidPropertyDirection, result.getPropertyFailures(), invalidMimeTypeDirection, result.getMimeTypeFailures(), result.getExecutableFailures(), backupDilemmaHandler);
        try {
            IChangePropertiesOperation op = ResourceUtil.prepareChangePropertyOperation(parms, invalidPropertyDirection, dilemmaHandler, result, (IProgressMonitor)monitor.newChild(10));
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static int getInvalidPropertyDirection(ParmsInvalidPropertiesDilemmaHandler invalidPropertiesDilemmaHandler) {
        int invalidPropertyDirection = invalidPropertiesDilemmaHandler == null ? 2 : ResourceUtil.getDirection(invalidPropertiesDilemmaHandler.generalInstruction);
        return invalidPropertyDirection;
    }

    private static int getInvalidMimeTypeDirection(ParmsInvalidMimeTypeDilemmaHandler parmsInvalidMimeTypeDilemmaHandler) {
        int invalidMimeTypeDirection = parmsInvalidMimeTypeDilemmaHandler == null ? 2 : ResourceUtil.getDirection(parmsInvalidMimeTypeDilemmaHandler.generalInstruction);
        return invalidMimeTypeDirection;
    }

    private static IChangePropertiesOperation prepareChangePropertyOperation(ParmsResourcePropertyUpdates parms, int invalidPropertyDirection, ChangePropertiesDilemmaHandler dilemmaHandler, ResourcePropertyChangeResultDTO result, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(2 * parms.resourcePropertyChanges.length * 2));
        IChangePropertiesOperation op = IOperationFactory.instance.getChangePropertiesOperation(dilemmaHandler);
        RefreshUtil.configureRefresh(parms.preOpRefresh, op);
        ParmsResourcePropertyChange[] parmsResourcePropertyChangeArray = parms.resourcePropertyChanges;
        int n = parms.resourcePropertyChanges.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsResourcePropertyChange propertyChangeRequest = parmsResourcePropertyChangeArray[n2];
            IShareable shareable = ResourceUtil.findShareableFor(propertyChangeRequest.sandboxPath, propertyChangeRequest.filePath, (IProgressMonitor)monitor);
            if (propertyChangeRequest.lineDelimiter != null && propertyChangeRequest.lineDelimiter.length() > 0) {
                FileLineDelimiter lineDelimiter = ResourceUtil.getLineDelimiter(propertyChangeRequest.lineDelimiter);
                op.setLineDelimiter(shareable, lineDelimiter);
            }
            if (propertyChangeRequest.linkType != null) {
                op.setIsDirectoryLink(shareable, "directory".equals(propertyChangeRequest.linkType));
            }
            if (propertyChangeRequest.mimeType != null && propertyChangeRequest.mimeType.length() > 0) {
                op.setContentType(shareable, propertyChangeRequest.mimeType);
            }
            if (propertyChangeRequest.executable != null) {
                op.setExecutable(shareable, propertyChangeRequest.executable);
            }
            if (propertyChangeRequest.replacementProperties != null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                ParmsProperty[] parmsPropertyArray = propertyChangeRequest.replacementProperties;
                int n3 = propertyChangeRequest.replacementProperties.length;
                int n4 = 0;
                while (n4 < n3) {
                    ParmsProperty property = parmsPropertyArray[n4];
                    properties.put(property.propertyName, property.propertyValue);
                    ++n4;
                }
                op.setProperties(shareable, properties);
            } else if (propertyChangeRequest.propertyChanges != null || propertyChangeRequest.propertyRemovals != null) {
                int n5;
                IMetadataProperties current = shareable.getMetadataProperties((IProgressMonitor)monitor.newChild(1));
                HashMap<String, String> changes = new HashMap<String, String>();
                HashSet<String> removals = new HashSet<String>();
                if (propertyChangeRequest.propertyChanges != null) {
                    ParmsProperty[] parmsPropertyArray = propertyChangeRequest.propertyChanges;
                    n5 = propertyChangeRequest.propertyChanges.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ParmsProperty property = parmsPropertyArray[n6];
                        changes.put(property.propertyName, property.propertyValue);
                        ++n6;
                    }
                }
                HashMap<String, IStatus> badProperties = new HashMap<String, IStatus>();
                if (propertyChangeRequest.propertyRemovals != null) {
                    String[] stringArray = propertyChangeRequest.propertyRemovals;
                    int n7 = propertyChangeRequest.propertyRemovals.length;
                    n5 = 0;
                    while (n5 < n7) {
                        String property = stringArray[n5];
                        IStatus status = op.validatePropertyName(property);
                        if (!status.isOK()) {
                            badProperties.put(property, status);
                        } else {
                            removals.add(property);
                        }
                        ++n5;
                    }
                }
                if (!badProperties.isEmpty()) {
                    result.getPropertyFailures().add(ResourceUtil.translatePropertyFailure(shareable, badProperties, (IProgressMonitor)monitor.newChild(1)));
                    if (invalidPropertyDirection == 1) {
                        throw new OperationCanceledException();
                    }
                    if (invalidPropertyDirection != 0) {
                        MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 0, badProperties.values().toArray(new IStatus[badProperties.size()]), NLS.bind((String)Messages.ResourceUtil_2, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]), null);
                        throw new FileSystemStatusException((IStatus)status);
                    }
                }
                MetadataProperties delta = new MetadataProperties(current.getCurrentProperties(), changes, removals);
                op.setProperties(shareable, delta.getCurrentProperties());
            }
            ++n2;
        }
        return op;
    }

    private static FileLineDelimiter getLineDelimiter(String lineDelimiterSetting) {
        return CoreUtil.getLineDelimiter(lineDelimiterSetting);
    }

    private static String getLineDelimiter(FileLineDelimiter lineDelimiterSetting) {
        return CoreUtil.getLineDelimiter(lineDelimiterSetting);
    }

    public static IShareable findShareableFor(String sandboxPath, String path, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        ISandbox sandbox = SharingManager.getInstance().getSandbox(new PathLocation((IPath)new Path(sandboxPath)), true);
        if (sandbox == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.ResourceUtil_0, (Object)sandboxPath, (Object[])new Object[0]));
        }
        RelativeLocation resourcePath = new RelativeLocation(new Path(path).segments());
        ResourceType resourceType = CommonUtil.getResourceType(sandbox.getRoot().append(path), progress);
        if (resourceType == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.ResourceUtil_1, (Object)path, (Object[])new Object[0]));
        }
        return sandbox.findShareable(resourcePath, resourceType);
    }

    public static SandboxPathsResultDTO getSandboxPaths(ParmsSandboxPaths parms, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)parms.pathsToResolve.length);
        SandboxPathsResultDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createSandboxPathsResultDTO();
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SharingManager sm = SharingManager.getInstance();
        String[] stringArray = parms.pathsToResolve;
        int n = parms.pathsToResolve.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable shareable;
            ResourceType resourceType;
            String completePath = stringArray[n2];
            PathLocation path = new PathLocation((IPath)new Path(completePath));
            try {
                resourceType = CommonUtil.getResourceType(path, (IProgressMonitor)monitor.newChild(1));
                if (resourceType == null) {
                    resourceType = ResourceType.FILE;
                }
            }
            catch (FileSystemException fileSystemException) {
                resourceType = ResourceType.FILE;
            }
            if ((shareable = sm.findShareable(path, resourceType)) == null && cfaMgr.copyFileAreaExists(path, 0)) {
                shareable = new Shareable(path, (IRelativeLocation)RelativeLocation.EMPTY_LOCATION, ResourceType.FOLDER);
            }
            if (shareable == null && parms.includeNonRegisteredSandboxes) {
                ILocation sandboxPath = path;
                IRelativeLocation relativePath = RelativeLocation.EMPTY_LOCATION;
                while (!sandboxPath.isEmpty() && shareable == null) {
                    if (cfaMgr.copyFileAreaExists(sandboxPath, 2)) {
                        relativePath = path.getLocationRelativeTo(sandboxPath);
                        shareable = new Shareable(sandboxPath, relativePath, resourceType);
                        continue;
                    }
                    sandboxPath = sandboxPath.getParent();
                }
            }
            result.getPaths().add(CoreUtil.translateShareable(shareable));
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
        return result;
    }

    public static ChangeSummaryDTO getChangeSummary(ParmsChangeSummary parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ChangeSummaryDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createChangeSummaryDTO();
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        ITeamRepository repo = wc.teamRepository();
        IChangeSetHandle handle = CommonUtil.createChangeSetHandle(repo, parms.changeSetItemId);
        IChangeSet changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)monitor.newChild(10));
        IFileSystemView fsv = FileSystemCore.getFileSystemManager(repo).getFileSystemView((IConnection)wc);
        List summaries = fsv.interpretChanges(Collections.singletonList(changeSet), (IProgressMonitor)monitor.newChild(80));
        IChangeSetSummary summary = (IChangeSetSummary)summaries.get(0);
        IChangeSummary changeSummary = null;
        for (IChangeSummary cs : summary.changes()) {
            if (!cs.item().getItemId().getUuidValue().equals(parms.versionableItemId)) continue;
            changeSummary = cs;
            break;
        }
        if (changeSummary == null) {
            throw new TeamRepositoryException("Resource not found in given change set");
        }
        if (changeSummary.afterState() != null) {
            result.setAfterStateId(changeSummary.afterState().getStateId().getUuidValue());
        }
        if (changeSummary.beforeState() != null) {
            result.setBeforeStateId(changeSummary.beforeState().getStateId().getUuidValue());
        }
        for (IChange change : changeSet.changes()) {
            IVersionableHandle lastMergeState;
            if (!change.item().getItemId().getUuidValue().equals(parms.versionableItemId)) continue;
            if (change.mergeStates().size() <= 0 || (lastMergeState = (IVersionableHandle)change.mergeStates().get(change.mergeStates().size() - 1)) == null || lastMergeState.getStateId() == null) break;
            result.setLastMergeState(lastMergeState.getStateId().getUuidValue());
            break;
        }
        result.setPathHint(ResourceUtil.toString(changeSummary.getPathHint()));
        String[] newPathHint = changeSummary.getNewPathHint();
        if (newPathHint != null) {
            result.setNewPathHint(ResourceUtil.toString(newPathHint));
        }
        return result;
    }

    private static String toString(String[] path) {
        StringBuffer buffer = new StringBuffer();
        int length = path.length;
        int i = 0;
        while (i < length) {
            buffer.append('/').append(path[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static class LineDelimiterErrorHandler {
        private final Map<String, Boolean> lineDelimiterInstructions;
        private final int generalLineDelimiterDirection;
        private final List<LineDelimiterErrorDTO> lineDelimiterErrorsReported;

        public LineDelimiterErrorHandler(ParmsLineDelimiterDilemmaHandler parmsLineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported) {
            if (parmsLineDelimiterDilemmaHandler == null) {
                this.generalLineDelimiterDirection = 2;
                this.lineDelimiterInstructions = Collections.EMPTY_MAP;
            } else {
                this.generalLineDelimiterDirection = ResourceUtil.getDirection(parmsLineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction);
                this.lineDelimiterInstructions = this.initializeLineDelimiterInstructions(parmsLineDelimiterDilemmaHandler.lineDelimiterErrorInstructions);
            }
            this.lineDelimiterErrorsReported = lineDelimiterErrorsReported;
        }

        private HashMap<String, Boolean> initializeLineDelimiterInstructions(ParmsLineDelimiterErrorInstructions[] lineDelimiterErrorInstructions) {
            HashMap<String, Boolean> instructions = new HashMap<String, Boolean>();
            if (lineDelimiterErrorInstructions != null) {
                int i = 0;
                while (i < lineDelimiterErrorInstructions.length) {
                    ParmsLineDelimiterErrorInstructions instruction = lineDelimiterErrorInstructions[i];
                    IPath path = new Path(instruction.sandboxPath).append(instruction.filePath);
                    path.removeTrailingSeparator();
                    instructions.put(path.toString(), instruction.forceConsistentDelimiters);
                    ++i;
                }
            }
            return instructions;
        }

        public int inconsistentLineDelimiters(List<? extends IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) throws FileSystemException {
            if (this.lineDelimiterErrorsReported != null) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)inconsistentDelimiters.size());
                for (IChangePropertiesRequest iChangePropertiesRequest : inconsistentDelimiters) {
                    SubMonitor subProgress = progress.newChild(1).setWorkRemaining(100);
                    FileLineDelimiter d = iChangePropertiesRequest.getLineDelimiter((IProgressMonitor)subProgress.newChild(30));
                    this.lineDelimiterErrorsReported.add(ResourceUtil.translateLineDelimiterError(iChangePropertiesRequest.getShareableToChange(), d, (IProgressMonitor)subProgress.newChild(70)));
                }
            }
            boolean followGeneralInstruction = false;
            for (IChangePropertiesRequest iChangePropertiesRequest : inconsistentDelimiters) {
                ILocation location = iChangePropertiesRequest.getShareableToChange().getFullPath();
                IPath path = (IPath)location.getAdapter(IPath.class);
                if (path == null) {
                    throw new IllegalStateException("Not a hierarchical location " + location.toOSString());
                }
                path.removeTrailingSeparator();
                Boolean instruction = this.lineDelimiterInstructions.get(path.toString());
                if (instruction == null) {
                    if (this.generalLineDelimiterDirection == 0) {
                        iChangePropertiesRequest.setForceLineDelimiterConversion(false);
                    }
                    followGeneralInstruction = true;
                    continue;
                }
                iChangePropertiesRequest.setForceLineDelimiterConversion(instruction);
            }
            if (followGeneralInstruction) {
                return this.generalLineDelimiterDirection;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemException {
            if (this.lineDelimiterErrorsReported != null) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * failedFiles.size()));
                List<LineDelimiterErrorDTO> list = this.lineDelimiterErrorsReported;
                synchronized (list) {
                    for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                        FileLineDelimiter ld = iLineDelimiterUploadFailure.getShareable().getLineDelimiter((IProgressMonitor)progress.newChild(5));
                        this.lineDelimiterErrorsReported.add(ResourceUtil.translateLineDelimiterError(iLineDelimiterUploadFailure.getShareable(), ld, (IProgressMonitor)progress.newChild(5)));
                    }
                }
            }
            int result = 0;
            for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                ILocation location = iLineDelimiterUploadFailure.getShareable().getFullPath();
                IPath path = (IPath)location.getAdapter(IPath.class);
                if (path == null) {
                    throw new IllegalStateException("Not a hierarchical location " + location.toOSString());
                }
                path.removeTrailingSeparator();
                Boolean instruction = this.lineDelimiterInstructions.get(path.toString());
                if (instruction == null) {
                    if (this.generalLineDelimiterDirection == 0) {
                        iLineDelimiterUploadFailure.setForceConsistentDelimiters(false);
                        continue;
                    }
                    result = this.generalLineDelimiterDirection;
                    break;
                }
                iLineDelimiterUploadFailure.setForceConsistentDelimiters(instruction);
            }
            return result;
        }
    }
}

