/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CommandProvider;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class CCaseLibForTests
extends CCaseLib {
    private static final boolean HAS_MVFS = true;
    protected static final String MKELTYPE = "mkeltype";
    protected static final String MKATTYPE = "mkattype";
    protected static final String MKFOLDER = "mkfolder";
    protected static final String MKHLINK = "mkhlink";
    protected static final String MKLABEL = "mklabel";
    protected static final String MKTRIGGER = "mktrigger";
    protected static final String MKTRTYPE = "mktrtype";
    protected static final String MKVOB = "mkvob";
    protected static final String MOUNT = "mount";
    protected static final String RENAME = "rename";
    protected static final String RMELEM = "rmelem";
    protected static final String RMFOLDER = "rmfolder";
    protected static final String RMVER = "rmver";
    protected static final String RMTAG = "rmtag";
    protected static final String RMTRIGGER = "rmtrigger";
    protected static final String RMVOB = "rmvob";
    protected static final String UMOUNT = "umount";
    protected static final String UNREGISTER = "unregister";
    protected static final String _APPEND = "-append";
    protected static final String _COMMENT = "-c";
    protected static final String _DATA = "-data";
    protected static final String _DEFAULT = "-default";
    protected static final String _ELEM = "-elem";
    protected static final String _EXEC = "-exec";
    protected static final String _EXECUNIX = "-execunix";
    protected static final String _EXECWIN = "-execwin";
    protected static final String _FLEVEL = "-flevel";
    protected static final String _MANAGER = "-manager";
    protected static final String _NLABEL = "-nlabel";
    protected static final String _NROOT = "-nroot";
    protected static final String _POSTOP = "-postop";
    protected static final String _PREOP = "-preop";
    protected static final String _PROP = "-prop";
    protected static final String _SCHEMA = "-schema";
    protected static final String _SUPERTYPE = "-supertype";
    protected static final String _TEXTMODE = "-text_mode";
    protected static final String _UCMOBJECT = "-ucmobject";
    protected static final String _UCMPROJECT = "-ucmproject";
    protected static final String _VOB = "-vob";
    protected static final String _VTYPE = "-vtype";
    protected static final String STRING = "string";
    protected static final String INTEGER = "integer";
    protected static final String MERGE = "Merge";

    public CCaseLibForTests(CommandProvider provider, Map<String, String> initArgs, boolean enableCaching) {
        super(provider, initArgs, enableCaching);
    }

    public final CommandProvider getCommandProvider() {
        return this.ctProvider;
    }

    public static final String getAdminVobName() {
        return "AdminVOB";
    }

    public static final String getLostAndFoundName() {
        return "lost+found";
    }

    public static final String getRootFolderName() {
        return "RootFolder";
    }

    public static final String getCheckoutOpName() {
        return "checkout";
    }

    public static final String getCheckinOpName() {
        return "checkin";
    }

    public static final String getUncheckoutOpName() {
        return "uncheckout";
    }

    public static final String getPreopArgName() {
        return _PREOP;
    }

    public static final String getPostopArgName() {
        return _POSTOP;
    }

    public static final String getReadOnlyPattern() {
        return "read only";
    }

    public static final String getNotFound() throws WvcmException {
        if (NOT_FOUND.equals("Uninitialized IGNORE_NOT_FOUND pattern")) {
            throw new WvcmException("Uninitialized IGNORE_NOT_FOUND pattern", WvcmException.ReasonCode.FORBIDDEN);
        }
        return NOT_FOUND;
    }

    public String[] describeForObjInfo(String pathname, CommandResult.ResultBehaviorFlags flags, SrvcFeedback feedback) throws WvcmException {
        List<String[]> describeOutput = this.describeForObjInfo(Collections.singletonList(pathname), flags, feedback);
        if (describeOutput.isEmpty()) {
            return new String[0];
        }
        return describeOutput.get(0);
    }

    public String getCurrentActivityName(String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, "lsactivity", "-short", "-cact", "-view", viewTag);
    }

    public void startView(String viewTag, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, "startview", viewTag);
    }

    public String makeVob(boolean ucmProjectVob, String vobPrefix, String vobBasename, SrvcFeedback feedback) throws WvcmException {
        return this.makeVob(ucmProjectVob, vobPrefix, vobBasename, null, null, feedback);
    }

    public String makeVob(boolean ucmProjectVob, String vobPrefix, String vobBasename, String schema, String featureLevel, SrvcFeedback feedback) throws WvcmException {
        String vobStgParentDir = CTInitArgUtils.getStgLoc(this.ctInitArgs);
        boolean useTripleSet = CTInitArgUtils.useTripleSet(this.ctInitArgs);
        ArrayList<String> cleartoolArgs = new ArrayList<String>(12);
        cleartoolArgs.add(MKVOB);
        cleartoolArgs.add("-nc");
        String vobTag = String.valueOf(vobPrefix) + vobBasename;
        String vobStg = ObjSelUtils.computeStgPath(false, vobBasename, vobStgParentDir);
        if (ucmProjectVob) {
            cleartoolArgs.add(_UCMPROJECT);
        }
        cleartoolArgs.add("-tag");
        cleartoolArgs.add(vobTag);
        if (useTripleSet) {
            String host = CTInitArgUtils.getHost(this.ctInitArgs);
            String hpathStgDir = CTInitArgUtils.getHpath(this.ctInitArgs);
            String gpathStgDir = CTInitArgUtils.getGpath(this.ctInitArgs);
            String hpath = ObjSelUtils.computeStgPath(false, vobBasename, hpathStgDir);
            String gpath = ObjSelUtils.computeStgPath(false, vobBasename, gpathStgDir);
            cleartoolArgs.addAll(Arrays.asList("-host", host, "-hpath", hpath, "-gpath", gpath));
        }
        if (schema != null) {
            cleartoolArgs.addAll(Arrays.asList(_SCHEMA, schema));
        }
        if (featureLevel != null) {
            cleartoolArgs.addAll(Arrays.asList(_FLEVEL, featureLevel));
        }
        cleartoolArgs.add(vobStg);
        this.ctProvider.execute(feedback, cleartoolArgs);
        if (!ucmProjectVob) {
            this.mount(vobTag, feedback);
        }
        return vobTag;
    }

    public void mount(String vobTag, SrvcFeedback feedback) throws WvcmException {
        boolean created;
        File mountPoint;
        if (!(CommandProvider.IS_WINDOWS || (mountPoint = new File(vobTag)).exists() || (created = mountPoint.mkdir()))) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_NO_MOUNT_POINT_ERROR, (Object)vobTag), WvcmException.ReasonCode.FORBIDDEN);
        }
        CommandResult r = this.ctProvider.executeGetResult(feedback, MOUNT, vobTag);
        if (r.getStat() != 1 || !r.getStdOut().equals(String.valueOf(vobTag) + " is already mounted.")) {
            r.assertSuccess(new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO));
        }
    }

    public void removeVobIgnoreFailures(String vTag, SrvcFeedback feedback) {
        this.unmountVobIgnoreFailures(vTag, feedback);
        try {
            String vobStorageDir = this.getStorageDirectory(vTag, true, feedback);
            this.ctProvider.execute(feedback, RMVOB, "-force", vobStorageDir);
            this.waitForItToBeGone(vobStorageDir);
        }
        catch (WvcmException wvcmException) {
            try {
                String vobStorageDir = this.getStorageDirectory(vTag, true, feedback);
                this.removeVobTagIgnoreFailures(vTag, feedback);
                this.unregisterStgDirIgnoreFailures(vobStorageDir, true, feedback);
                File stgDir = new File(vobStorageDir);
                if (stgDir.exists()) {
                    this.removeDir(stgDir);
                }
            }
            catch (WvcmException e2) {
                this.logIgnoredExceptionAsAlwaysVisible("CCaseLib.removeVobIgnoreFailures", "Ignored Exception: method \"{0}\" in an attempt to remove a VOB is ignoring exception: {1}", (Exception)((Object)e2));
            }
        }
    }

    private void removeDir(File dir) {
        File[] files;
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.removeDir(file);
            } else {
                file.delete();
            }
            ++n2;
        }
        dir.delete();
    }

    public void removeViewTagIgnoreFailures(String vTag, SrvcFeedback feedback) {
        try {
            this.ctProvider.execute(feedback, RMTAG, "-view", vTag);
        }
        catch (WvcmException wvcmException) {}
    }

    public void removeVobTagIgnoreFailures(String vTag, SrvcFeedback feedback) {
        this.unmountVobIgnoreFailures(vTag, feedback);
        try {
            this.ctProvider.execute(feedback, RMTAG, _VOB, vTag);
        }
        catch (WvcmException wvcmException) {}
    }

    public void removeViewIgnoreFailures(String viewTag, SrvcFeedback feedback) {
        try {
            this.removeView(viewTag, feedback);
        }
        catch (WvcmException wvcmException) {
            try {
                String viewStorageDir = this.getStorageDirectory(viewTag, false, feedback);
                this.removeViewTagIgnoreFailures(viewTag, feedback);
                this.unregisterStgDirIgnoreFailures(viewStorageDir, false, feedback);
                File stgDir = new File(viewStorageDir);
                if (stgDir.exists()) {
                    this.removeDir(stgDir);
                }
            }
            catch (WvcmException e2) {
                this.logIgnoredExceptionAsAlwaysVisible("CCaseLib.removeViewIgnoreFailures", Messages.CCaseLib_IGNORED_EXCEPTION_REMOVE_VIEW, (Exception)((Object)e2));
            }
        }
    }

    public void unmountVobIgnoreFailures(String vobTag, SrvcFeedback feedback) {
        try {
            this.ctProvider.execute(feedback, UMOUNT, vobTag);
        }
        catch (WvcmException e) {
            this.logIgnoredExceptionAsAlwaysVisible("CCaseLib.unmountVobIgnoreFailures", Messages.CCaseLib_IGNORED_EXCEPTION_UNMOUNT_VOB, (Exception)((Object)e));
        }
    }

    public void unregisterStgDirIgnoreFailures(String vobStorageDir, boolean isVobTag, SrvcFeedback feedback) {
        try {
            this.ctProvider.execute(feedback, UNREGISTER, isVobTag ? _VOB : "-view", vobStorageDir);
        }
        catch (WvcmException e) {
            this.logIgnoredExceptionAsAlwaysVisible("CCaseLib.unregisterStgDirIgnoreFailures", isVobTag ? "Ignored Exception: method \"{0}\" in an attempt to remove a VOB is ignoring exception: {1}" : Messages.CCaseLib_IGNORED_EXCEPTION_REMOVE_VIEW, (Exception)((Object)e));
        }
    }

    public String getBranchTypeName(String streamSel, SrvcFeedback feedback) throws WvcmException {
        return this.computeTypeNameFromHyperlink("IndependentGuard", streamSel, feedback);
    }

    public String getViewTextMode(String viewTag, SrvcFeedback feedback) throws WvcmException {
        String result = this.ctProvider.execute(feedback, "lsview", _PROP, _TEXTMODE, viewTag);
        if (result.contains("Text mode: unix")) {
            return "unix";
        }
        if (result.contains("Text mode: msdos")) {
            return "msdos";
        }
        if (result.contains("Text mode: strip_cr")) {
            return "strip_cr";
        }
        return null;
    }

    public String mkFolderGUITrtype(String trtypeName, String vobTag, SrvcFeedback feedback) throws WvcmException {
        String trtype = ObjSelUtils.formatSelector("trtype", trtypeName, vobTag);
        ArrayList<String> cleartoolArgs = new ArrayList<String>();
        cleartoolArgs.add(MKTRTYPE);
        cleartoolArgs.add(_UCMOBJECT);
        cleartoolArgs.add("-all");
        cleartoolArgs.add(_PREOP);
        cleartoolArgs.add(MKFOLDER);
        cleartoolArgs.add("-nc");
        cleartoolArgs.add(_EXEC);
        cleartoolArgs.add(CommandProvider.CP);
        cleartoolArgs.add(trtype);
        this.ctProvider.execute(feedback, cleartoolArgs);
        return trtype;
    }

    public void makeFolder(String folderSel, String parentFolderSel, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.makeFolderWithResult(folderSel, parentFolderSel, feedback);
        r.assertSuccess(IGNORE_Nothing);
    }

    public void removeFolder(String folderSel, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>();
        cleartoolArgs.add(RMFOLDER);
        cleartoolArgs.add("-nc");
        cleartoolArgs.add("-force");
        cleartoolArgs.add(folderSel);
        this.ctProvider.execute(feedback, cleartoolArgs);
    }

    public CommandResult makeFolderWithResult(String folderSel, String parentFolderSel, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>();
        cleartoolArgs.add(MKFOLDER);
        cleartoolArgs.add("-nc");
        cleartoolArgs.add("-in");
        cleartoolArgs.add(parentFolderSel);
        cleartoolArgs.add(folderSel);
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        return r;
    }

    public String mkFolderEvTrtype(String trtypeName, String vobTag, String scriptPath, SrvcFeedback feedback) throws WvcmException {
        String trtype = ObjSelUtils.formatSelector("trtype", trtypeName, vobTag);
        ArrayList<String> cleartoolArgs = new ArrayList<String>();
        cleartoolArgs.add(MKTRTYPE);
        cleartoolArgs.add(_UCMOBJECT);
        cleartoolArgs.add("-all");
        cleartoolArgs.add(_PREOP);
        cleartoolArgs.add(MKFOLDER);
        cleartoolArgs.add("-nc");
        if (CommandProvider.IS_WINDOWS) {
            cleartoolArgs.add(_EXECWIN);
        } else {
            cleartoolArgs.add(_EXECUNIX);
        }
        cleartoolArgs.add(String.valueOf(this.ctProvider.getRatlPerl(feedback)) + " " + scriptPath);
        cleartoolArgs.add(trtype);
        this.ctProvider.execute(feedback, cleartoolArgs);
        return trtype;
    }

    public void makeComponentNoRoot(String compSel, SrvcFeedback feedback) throws WvcmException {
        String[] cleartoolArgs = new String[]{"mkcomp", "-nc", _NROOT, compSel};
        this.ctProvider.execute(feedback, cleartoolArgs);
    }

    public final List<String> listVobs(String pvobTag, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.executeGetValues(feedback, Arrays.asList("lsvob", pvobTag));
    }

    public void makeElemTrtype(String trtypeSel, String preOrPostOp, String op, String executable, String execString, SrvcFeedback feedback) throws WvcmException {
        List<String> cleartoolArgs = Arrays.asList(MKTRTYPE, _ELEM, preOrPostOp, op, "-nc", _EXEC, String.valueOf(executable) + " " + execString, trtypeSel);
        this.ctProvider.execute(feedback, cleartoolArgs);
    }

    public void makeTrigger(String trtypeSel, String path, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, MKTRIGGER, trtypeSel, path);
    }

    public void removeTrigger(String trtypeSel, String path, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, RMTRIGGER, trtypeSel, path);
    }

    public void rename(String source, String target, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, RENAME, source, target);
    }

    public void rmelem(String path, boolean force, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, RMELEM, force ? "-force" : EMPTY_STRING, path);
    }

    public void makeUnlabeledBaselines(String viewTag, String baseName, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, "mkbl", _NLABEL, "-all", "-identical", "-view", viewTag, baseName);
    }

    public void makeUnlabeledBaselines(String viewTag, String compSel, String baseName, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, "mkbl", _NLABEL, "-component", compSel, "-identical", "-view", viewTag, baseName);
    }

    public final String describeTypeAndName(String universalSel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, "describe", "-fmt", "%m:%n", universalSel);
    }

    public void createBaseCcSubVobComponentAttype(String vobTag, SrvcFeedback feedback) throws WvcmException {
        String attypeSel = this.computeBaseCcSubVobComponentAttype(vobTag);
        try {
            this.removeType(attypeSel, feedback);
        }
        catch (WvcmException e) {
            this.logIgnoredExceptionAsAlwaysVisible("createBaseCcSubVobComponentAttype", "exception removing base CC Sub VOB component attype", (Exception)((Object)e));
        }
        this.ctProvider.execute(feedback, MKATTYPE, "-nc", attypeSel);
    }

    public String computeBaseCcSubVobComponentAttype(String vobTag) {
        String attypeSel = ObjSelUtils.formatSelector("attype", "com.ibm.rational.interop.ClearCase.subVOB_Component", vobTag);
        return attypeSel;
    }

    public void removeBaseCcSubVobComponentAttype(String vobTag, SrvcFeedback feedback) throws WvcmException {
        String attypeSel = this.computeBaseCcSubVobComponentAttype(vobTag);
        try {
            this.removeType(attypeSel, feedback);
        }
        catch (WvcmException e) {
            this.logIgnoredExceptionAsAlwaysVisible("createBaseCcSubVobComponentAttype", "exception removing base CC Sub VOB compnoent attype", (Exception)((Object)e));
        }
    }

    public void chmod(int i, String controlledPathname, SrvcFeedback fb) throws WvcmException {
        this.ctProvider.execute(fb, "protect", "-chmod", String.valueOf(i), controlledPathname);
    }

    public void makeAttypeWithStringValue(String attypeSel, SrvcFeedback feedback) throws WvcmException {
        this.makeAttypeWithTypedValue(attypeSel, true, feedback);
    }

    public void makeAttypeWithTypedValue(String attypeSel, boolean useStringValueType, SrvcFeedback feedback) throws WvcmException {
        String valueType = useStringValueType ? STRING : INTEGER;
        this.makeAttypeWithTypedValue(attypeSel, valueType, null, feedback);
    }

    public void makeAttypeWithTypedValue(String attypeSel, String valueType, String defaultValue, SrvcFeedback feedback) throws WvcmException {
        try {
            this.removeType(attypeSel, feedback);
        }
        catch (WvcmException e) {
            this.logIgnoredExceptionAsAlwaysVisible("createGlobalAttype", "exception removing attype", (Exception)((Object)e));
        }
        if (defaultValue != null) {
            this.ctProvider.execute(feedback, MKATTYPE, "-global", "-shared", "-nc", _VTYPE, valueType, _DEFAULT, defaultValue, attypeSel);
        } else {
            this.ctProvider.execute(feedback, MKATTYPE, "-global", "-shared", "-nc", _VTYPE, valueType, attypeSel);
        }
        this.vobTag2attrMap.clear();
    }

    public void makeLabel(String lbtype, String rootPath, SrvcFeedback feedback) throws WvcmException {
        if (ObjSelUtils.isFullyQualifiedSelector(lbtype)) {
            lbtype = ObjSelUtils.getObjSelName(lbtype);
        }
        this.ctProvider.execute(feedback, MKLABEL, "-recurse", "-replace", lbtype, rootPath);
    }

    public void setAttr(String attype, String objectSelector, int i, boolean replace, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(6);
        cleartoolArgs.add("mkattr");
        cleartoolArgs.add("-nc");
        if (replace) {
            cleartoolArgs.add("-replace");
        }
        cleartoolArgs.addAll(Arrays.asList(attype, String.valueOf(i), objectSelector));
        this.ctProvider.execute(feedback, cleartoolArgs);
    }

    public void makeElementType(String elemTypeSelector, String typeManager, String superTypeSelector, SrvcFeedback fb) throws WvcmException {
        this.ctProvider.execute(fb, MKELTYPE, "-nc", _SUPERTYPE, superTypeSelector, _MANAGER, typeManager, elemTypeSelector);
    }

    public String lsTypeShort(String typeSelector, SrvcFeedback fb) throws WvcmException {
        return this.ctProvider.execute(fb, "lstype", "-short", typeSelector);
    }

    public void clearStreamFoundationMap() {
        this.streamFoundationMap.clear();
        this.streamInitialFoundationMap.clear();
    }

    public boolean supportsSchema80(SrvcFeedback feedback) throws WvcmException {
        String version = this.getClearCaseVersion(feedback);
        return !version.contains("ClearCase version 7.");
    }

    public String removeVersionData(String path, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, RMVER, "-force", _DATA, path);
    }

    public void mkHlinkMerge(String fromSelector, String toSelector, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, MKHLINK, MERGE, fromSelector, toSelector);
    }

    public void addMultilineCommentsInBranch(String[] lines, String branchSelector, SrvcFeedback feedback) throws WvcmException {
        int count = 0;
        while (count < lines.length) {
            this.ctProvider.execute(feedback, "chevent", _APPEND, _COMMENT, lines[count], branchSelector);
            ++count;
        }
    }

    public void setNonStringAttr(String attype, String objectSelector, String value, boolean replace, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(6);
        cleartoolArgs.add("mkattr");
        cleartoolArgs.add("-nc");
        if (replace) {
            cleartoolArgs.add("-replace");
        }
        cleartoolArgs.addAll(Arrays.asList(attype, value, objectSelector));
        this.ctProvider.execute(feedback, cleartoolArgs);
    }
}

