/*
 * Decompiled with CFR 0.152.
 */
package org.xmlsoap.schemas.soap.envelope.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.xmlsoap.schemas.soap.envelope.Body;
import org.xmlsoap.schemas.soap.envelope.Detail;
import org.xmlsoap.schemas.soap.envelope.DocumentRoot;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.EnvelopeFactory;
import org.xmlsoap.schemas.soap.envelope.EnvelopePackage;
import org.xmlsoap.schemas.soap.envelope.Fault;
import org.xmlsoap.schemas.soap.envelope.Header;
import org.xmlsoap.schemas.soap.envelope.impl.BodyImpl;
import org.xmlsoap.schemas.soap.envelope.impl.DetailImpl;
import org.xmlsoap.schemas.soap.envelope.impl.DocumentRootImpl;
import org.xmlsoap.schemas.soap.envelope.impl.EnvelopeImpl;
import org.xmlsoap.schemas.soap.envelope.impl.FaultImpl;
import org.xmlsoap.schemas.soap.envelope.impl.HeaderImpl;

public class EnvelopeFactoryImpl
extends EFactoryImpl
implements EnvelopeFactory {
    public static EnvelopeFactory init() {
        try {
            EnvelopeFactory theEnvelopeFactory = (EnvelopeFactory)EPackage.Registry.INSTANCE.getEFactory("http://schemas.xmlsoap.org/soap/envelope/");
            if (theEnvelopeFactory != null) {
                return theEnvelopeFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new EnvelopeFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createBody();
            }
            case 1: {
                return this.createDetail();
            }
            case 2: {
                return this.createDocumentRoot();
            }
            case 3: {
                return this.createEnvelope();
            }
            case 4: {
                return this.createFault();
            }
            case 5: {
                return this.createHeader();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createEncodingStyleFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createMustUnderstandTypeFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createMustUnderstandTypeObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertEncodingStyleToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertMustUnderstandTypeToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertMustUnderstandTypeObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Body createBody() {
        BodyImpl body = new BodyImpl();
        return body;
    }

    @Override
    public Detail createDetail() {
        DetailImpl detail = new DetailImpl();
        return detail;
    }

    @Override
    public DocumentRoot createDocumentRoot() {
        DocumentRootImpl documentRoot = new DocumentRootImpl();
        return documentRoot;
    }

    @Override
    public Envelope createEnvelope() {
        EnvelopeImpl envelope = new EnvelopeImpl();
        return envelope;
    }

    @Override
    public Fault createFault() {
        FaultImpl fault = new FaultImpl();
        return fault;
    }

    @Override
    public Header createHeader() {
        HeaderImpl header = new HeaderImpl();
        return header;
    }

    public List<String> createEncodingStyleFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(initialValue);
        while (stringTokenizer.hasMoreTokens()) {
            String item = stringTokenizer.nextToken();
            result.add((String)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.ANY_URI, item));
        }
        return result;
    }

    public String convertEncodingStyleToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        List list = (List)instanceValue;
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (Object item : list) {
            result.append(XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.ANY_URI, item));
            result.append(' ');
        }
        return result.substring(0, result.length() - 1);
    }

    public Boolean createMustUnderstandTypeFromString(EDataType eDataType, String initialValue) {
        return (Boolean)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.BOOLEAN, initialValue);
    }

    public String convertMustUnderstandTypeToString(EDataType eDataType, Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.BOOLEAN, instanceValue);
    }

    public Boolean createMustUnderstandTypeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createMustUnderstandTypeFromString(EnvelopePackage.Literals.MUST_UNDERSTAND_TYPE, initialValue);
    }

    public String convertMustUnderstandTypeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertMustUnderstandTypeToString(EnvelopePackage.Literals.MUST_UNDERSTAND_TYPE, instanceValue);
    }

    @Override
    public EnvelopePackage getEnvelopePackage() {
        return (EnvelopePackage)this.getEPackage();
    }

    @Deprecated
    public static EnvelopePackage getPackage() {
        return EnvelopePackage.eINSTANCE;
    }
}

