/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.buildablesubset.client;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.buildablesubset.client.IBuildableSubsetClientAPI;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetServiceAPI;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableFileDesc2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubset2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubsetCriteria2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubsetSubsetCriteria2;
import com.ibm.team.enterprise.buildablesubset.common.dto.Visibility;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildableSubsetClientAPI
implements IBuildableSubsetClientAPI {
    private IClientLibraryContext context;

    public BuildableSubsetClientAPI(IClientLibraryContext context) {
        this.context = context;
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.context.getServiceInterface(clazz);
    }

    protected <T> T callCancelableService(IProgressMonitor monitor, IClientLibraryContext.IServiceRunnable<T> serviceRunnable) throws TeamRepositoryException {
        return (T)this.context.callCancelableService(serviceRunnable, monitor);
    }

    @Override
    public IBuildableSubset2 getBuildableSubset(final String name, final IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<IBuildableSubset2>(){

            public IBuildableSubset2 run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildableSubset2 subset = BuildableSubsetClientAPI.this.getService(IBuildableSubsetServiceAPI.class).getBuildableSubset(name, buildDefinitionHandle);
                BuildableSubsetClientAPI.this.resolveSubsetReferences(subset);
                return subset;
            }
        });
    }

    @Override
    public IBuildableSubset2 getBuildableSubset2(final String name, final IBuildDefinitionHandle buildDefinitionHandle, final boolean evaluateDynamicCriteria, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<IBuildableSubset2>(){

            public IBuildableSubset2 run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildableSubset2 subset = BuildableSubsetClientAPI.this.getService(IBuildableSubsetServiceAPI.class).getBuildableSubset2(name, buildDefinitionHandle, evaluateDynamicCriteria);
                BuildableSubsetClientAPI.this.resolveSubsetReferences(subset);
                return subset;
            }
        });
    }

    @Override
    public IBuildableSubset2 createBuildableSubsetFromWorkItems(final String name, final IContributorHandle owner, final Visibility visibility, final IBuildDefinitionHandle buildDefinitionHandle, final IWorkItemHandle[] workItemHandles, final boolean includeWorkItemChildren, final boolean includeImpacts, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<IBuildableSubset2>(){

            public IBuildableSubset2 run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildableSubset2 subset = BuildableSubsetClientAPI.this.getService(IBuildableSubsetServiceAPI.class).createBuildableSubsetFromWorkItems(name, owner, visibility, buildDefinitionHandle, workItemHandles, includeWorkItemChildren, includeImpacts);
                BuildableSubsetClientAPI.this.resolveSubsetReferences(subset);
                return subset;
            }
        });
    }

    @Override
    public IBuildableSubset2 createBuildableSubsetFromWorkItems2(final String name, final IContributorHandle owner, final Visibility visibility, final IBuildDefinitionHandle buildDefinitionHandle, final IWorkItemHandle[] workItemHandles, final IWorkItemHandle[] dynamicWorkItemHandles, final boolean includeWorkItemChildren, final boolean includeImpacts, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<IBuildableSubset2>(){

            public IBuildableSubset2 run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildableSubset2 subset = BuildableSubsetClientAPI.this.getService(IBuildableSubsetServiceAPI.class).createBuildableSubsetFromWorkItems2(name, owner, visibility, buildDefinitionHandle, workItemHandles, dynamicWorkItemHandles, includeWorkItemChildren, includeImpacts);
                BuildableSubsetClientAPI.this.resolveSubsetReferences(subset);
                return subset;
            }
        });
    }

    @Override
    public IBuildableSubset2 createBuildableSubset(final String name, final IContributorHandle owner, final Visibility visibility, final IBuildDefinitionHandle buildDefinitionHandle, final IBuildableFileDesc2[] buildableFileDescs, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<IBuildableSubset2>(){

            public IBuildableSubset2 run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildableSubset2 subset = BuildableSubsetClientAPI.this.getService(IBuildableSubsetServiceAPI.class).createBuildableSubset(name, owner, visibility, buildDefinitionHandle, buildableFileDescs);
                BuildableSubsetClientAPI.this.resolveSubsetReferences(subset);
                return subset;
            }
        });
    }

    @Override
    public String deleteBuildableSubset(final String name, final IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<String>(){

            public String run(IProgressMonitor monitor) throws TeamRepositoryException {
                return BuildableSubsetClientAPI.this.getService(IBuildableSubsetServiceAPI.class).deleteBuildableSubset(name, buildDefinitionHandle);
            }
        });
    }

    @Override
    public boolean exists(final String name, final IBuildDefinitionHandle buildDefinitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        Boolean rc = this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable<Boolean>(){

            public Boolean run(IProgressMonitor monitor) throws TeamRepositoryException {
                boolean rc = BuildableSubsetClientAPI.this.getService(IBuildableSubsetServiceAPI.class).exists(name, buildDefinitionHandle);
                return rc;
            }
        });
        return rc;
    }

    private void resolveSubsetReferences(IBuildableSubset2 subset) {
        if (subset != null) {
            this.resolveSubsetReferences(subset.getCriteria(), subset);
        }
    }

    private void resolveSubsetReferences(List<IBuildableSubsetCriteria2> criteria, IBuildableSubset2 subset) {
        for (IBuildableSubsetCriteria2 criterion : criteria) {
            criterion.setSubset(subset);
            if (!(criterion instanceof IBuildableSubsetSubsetCriteria2)) continue;
            this.resolveSubsetReferences(((IBuildableSubsetSubsetCriteria2)criterion).getChildCriteria(), subset);
        }
    }
}

