/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression.variables;

import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.workitem.common.expression.Expression;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;

public class ParameterVariableContext {
    private Map<String, Expression> fData;

    public ParameterVariableContext() {
        this.fData = new HashMap<String, Expression>();
    }

    public ParameterVariableContext(Map<String, Expression> parameterValues) throws AssertionFailedException {
        Assert.isNotNull(parameterValues);
        this.fData = parameterValues;
    }

    public boolean hasVariableValue(String variableName) {
        return this.fData.containsKey(variableName);
    }

    public Expression getVariableValue(String variableName) {
        return this.fData.get(variableName);
    }

    public void addVariableValue(String variableName, Expression valueExpression) {
        if (variableName != null) {
            this.fData.put(variableName, valueExpression);
        }
    }

    public Collection<Expression> getVariableValues() {
        return this.fData.values();
    }

    public JSONObject toJson() {
        JSONObject result = new JSONObject();
        if (!this.fData.isEmpty()) {
            for (String curName : this.fData.keySet()) {
                Expression curExpr = this.fData.get(curName);
                JSONObject curValue = curExpr != null ? curExpr.toJson() : null;
                result.put((Object)curName, (Object)curValue);
            }
        }
        return result;
    }
}

