/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.icu.util.ULocale;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.IQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.internal.AuditableCache;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.ServiceRunnable;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.Category;
import com.ibm.team.workitem.common.internal.util.DataQueryIterator;
import com.ibm.team.workitem.common.internal.util.DataRowQueryIterator;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AuditableCommon
implements IAuditableCommon {
    private ICommonServiceContext fServiceContext;
    private AuditableCache fCache = new AuditableCache();

    public AuditableCommon(ICommonServiceContext serviceContext) {
        this.fServiceContext = serviceContext;
    }

    protected ICommonServiceContext getServiceContext() {
        return this.fServiceContext;
    }

    @Override
    public IAuditable createAuditable(IItemType itemType) {
        return (IAuditable)(this.getOrigin() != null ? itemType.createItem(this.getOrigin()) : itemType.createItem());
    }

    @Override
    public IAuditableHandle createAuditableHandle(IItemType itemType, UUID itemUuid, UUID stateUuid) {
        return (IAuditableHandle)(this.getOrigin() != null ? itemType.createItemHandle(this.getOrigin(), itemUuid, stateUuid) : itemType.createItemHandle(itemUuid, stateUuid));
    }

    public <T extends IAuditable> T fetchCurrentAuditable(IAuditableHandle handle, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.resolveAuditable(handle, profile, monitor);
    }

    @Override
    public IDevelopmentLine findDefaultDevelopmentLine(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemCommon workItemCommon = (WorkItemCommon)this.getPeer(IWorkItemCommon.class);
        ItemProfile<ICategory> profile = ItemProfile.createProfile(ICategory.ITEM_TYPE, Category.DEFAULT_TEAM_AREA_PROPERTY);
        ICategory rootCategory = workItemCommon.findRootCategory(projectArea, profile, monitor);
        ITeamAreaHandle handle = ((Category)rootCategory).getDefaultTeamArea();
        if (handle == null) {
            ItemProfile projectAreaProfile = ItemProfile.createProfile(IProjectArea.ITEM_TYPE, ProcessCommon.getPropertyName(IProjectArea.class, (String)"projectDevelopmentLine"));
            IDevelopmentLineHandle devLineHandle = ((IProjectArea)this.resolveAuditable((IAuditableHandle)projectArea, projectAreaProfile, monitor)).getProjectDevelopmentLine();
            if (devLineHandle != null) {
                return (IDevelopmentLine)this.resolveAuditable((IAuditableHandle)devLineHandle, ItemProfile.createFullProfile(IDevelopmentLine.ITEM_TYPE), monitor);
            }
            return null;
        }
        return this.getDevelopmentLine(handle, monitor);
    }

    @Override
    public IItemQueryPage queryItems(IItemQuery itemQuery, Object[] parameters, int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.queryItemsInContext(itemQuery, parameters, pageSize, null, monitor);
    }

    @Override
    public IItemQueryPage queryItemsInContext(final IItemQuery itemQuery, final Object[] parameters, final int pageSize, final UUID[] contextIds, IProgressMonitor monitor) throws TeamRepositoryException {
        ServiceRunnable<IItemQueryPage> runnable = new ServiceRunnable<IItemQueryPage>(){

            @Override
            public IItemQueryPage run() throws TeamRepositoryException {
                IQueryService queryService = AuditableCommon.this.getServiceContext().getService(IQueryService.class);
                if (contextIds == null) {
                    return queryService.queryItems(itemQuery, parameters, pageSize);
                }
                return queryService.queryItemsInContext(itemQuery, parameters, pageSize, contextIds);
            }
        };
        return this.getServiceContext().callCancelableService(runnable, monitor);
    }

    @Override
    public IDataQueryPage queryData(IDataQuery dataQuery, Object[] parameters, int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.queryDataInContext(dataQuery, parameters, pageSize, null, monitor);
    }

    @Override
    public IDataQueryPage queryDataInContext(final IDataQuery dataQuery, final Object[] parameters, final int pageSize, final UUID[] contextIds, IProgressMonitor monitor) throws TeamRepositoryException {
        ServiceRunnable<IDataQueryPage> runnable = new ServiceRunnable<IDataQueryPage>(){

            @Override
            public IDataQueryPage run() throws TeamRepositoryException {
                IQueryService queryService = AuditableCommon.this.getServiceContext().getService(IQueryService.class);
                if (contextIds == null) {
                    return queryService.queryData(dataQuery, parameters, pageSize);
                }
                return queryService.queryDataInContext(dataQuery, parameters, pageSize, contextIds);
            }
        };
        return this.getServiceContext().callCancelableService(runnable, monitor);
    }

    @Override
    public IDataQueryPage uncommittedQueryData(final IDataQuery dataQuery, final Object[] parameters, final int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        ServiceRunnable<IDataQueryPage> runnable = new ServiceRunnable<IDataQueryPage>(){

            @Override
            public IDataQueryPage run() throws TeamRepositoryException {
                IQueryService queryService = AuditableCommon.this.getServiceContext().getService(IQueryService.class);
                return queryService.uncommittedQueryData(dataQuery, parameters, pageSize);
            }
        };
        return this.getServiceContext().callCancelableService(runnable, monitor);
    }

    @Override
    public IItemQueryPage uncommittedQueryItems(final IItemQuery itemQuery, final Object[] parameters, final int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        ServiceRunnable<IItemQueryPage> runnable = new ServiceRunnable<IItemQueryPage>(){

            @Override
            public IItemQueryPage run() throws TeamRepositoryException {
                IQueryService queryService = AuditableCommon.this.getServiceContext().getService(IQueryService.class);
                return queryService.uncommittedQueryItems(itemQuery, parameters, pageSize);
            }
        };
        return this.getServiceContext().callCancelableService(runnable, monitor);
    }

    @Override
    public <T extends IItemHandle> QueryIterator<T> getItemQueryIterator(IItemQuery itemQuery, Object[] parameters, UUID[] contextIds, QueryIterator.ReadMode readMode) {
        return new ItemQueryIterator(this, itemQuery, parameters, contextIds, readMode);
    }

    @Override
    public <T> QueryIterator<T> getDataQueryIterator(IDataQuery dataQuery, Object[] parameters, UUID[] contextIds, QueryIterator.ReadMode readMode) {
        return new DataQueryIterator(this, dataQuery, parameters, contextIds, readMode);
    }

    @Override
    public QueryIterator<IDataRow> getDataRowQueryIterator(IDataQuery dataQuery, Object[] parameters, UUID[] contextIds, QueryIterator.ReadMode readMode) {
        return new DataRowQueryIterator(this, dataQuery, parameters, contextIds, readMode);
    }

    @Override
    public IQueryPage fetchPage(final UUID token, final int startIndex, final int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        ServiceRunnable<IQueryPage> runnable = new ServiceRunnable<IQueryPage>(){

            @Override
            public IQueryPage run() throws TeamRepositoryException {
                IQueryService queryService = AuditableCommon.this.getServiceContext().getService(IQueryService.class);
                return queryService.fetchPage(token, startIndex, pageSize);
            }
        };
        return this.getServiceContext().callCancelableService(runnable, monitor);
    }

    public abstract IItem fetchItem(UUID var1, IProgressMonitor var2) throws TeamRepositoryException;

    @Override
    public Object resolveAccessContext(UUID contextId, IProgressMonitor monitor) {
        if (contextId == IContext.PUBLIC) {
            return contextId;
        }
        try {
            IAccessGroup accessGroup = this.getAccessGroupForGroupContextId(contextId, monitor);
            if (accessGroup != null) {
                return accessGroup;
            }
            IItem item = this.fetchItem(contextId, monitor);
            if (item instanceof IProcessAreaHandle || item instanceof IContributor) {
                return item;
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        return contextId;
    }

    public abstract List<ULocale> getUserLocales();

    public void addItemTypeCache(IItemType itemType, AuditableCache.IItemTypeCache<? extends IAuditable> typeCache) {
        this.getCache().addItemTypeCache(itemType, typeCache);
    }

    protected AuditableCache getCache() {
        return this.fCache;
    }

    public <T extends IAuditable> List<T> update(List<T> auditables, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IAuditable auditable : auditables) {
            if (auditable == null) continue;
            this.getCache().cache(auditable);
        }
        WorkItemCommon workItemCommon = (WorkItemCommon)this.getPeer(IWorkItemCommon.class);
        workItemCommon.update(auditables, monitor);
        return auditables;
    }

    @Override
    public boolean isInCluster() {
        return false;
    }

    @Override
    public AuditableCommon getInternal() {
        return this;
    }

    protected boolean isSet(int value, int flag) {
        return (value & flag) == flag;
    }
}

