/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.internal.model.SetAttributeType;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ContributorAttributeType
extends SetAttributeType {
    public ContributorAttributeType(String identifier) {
        super(identifier, IContributorHandle.class, ItemProfile.CONTRIBUTOR_DEFAULT, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS}, new String[]{"currentUser"});
    }

    @Override
    public Object getNullValue(IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableHandle handle = auditableCommon.createAuditableHandle(IContributor.ITEM_TYPE, DefaultModel.NULL_CONTRIBUTOR_ITEM_ID, null);
        return auditableCommon.resolveAuditable(handle, this.getDefaultProfile(), monitor);
    }

    @Override
    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle processArea = null;
        if (workItem == null) {
            if (attribute != null) {
                processArea = attribute.getProjectArea();
            }
        } else {
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            processArea = workItemCommon.findProcessArea(workItem, monitor);
        }
        if (processArea == null) {
            return new Object[0];
        }
        IContributorHandle[] handles = auditableCommon.resolveAuditable((IAuditableHandle)processArea, ItemProfile.PROCESS_AREA_DEFAULT, monitor).getMembers();
        List<? extends IAuditable> members = auditableCommon.resolveAuditablesPermissionAware(Arrays.asList(handles), this.getDefaultProfile(), monitor);
        Object[] values = new Object[members.size() + 1];
        values[0] = this.getNullValue(auditableCommon, monitor);
        int i = 1;
        while (i < values.length) {
            values[i] = members.get(i - 1);
            ++i;
        }
        return values;
    }
}

