/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.IterationSelectionAlgorithm;
import com.ibm.team.workitem.common.internal.model.SetAttributeType;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class IterationAttributeType
extends SetAttributeType {
    public IterationAttributeType(String identifier) {
        super(identifier, IIterationHandle.class, ItemProfile.ITERATION_DEFAULT, new AttributeOperation[]{AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS, AttributeOperation.PART_OF_INTERVAL, AttributeOperation.NOT_PART_OF_INTERVAL}, new String[]{"current milestone"});
    }

    @Override
    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getValueSet(auditableCommon, workItem, attribute, false, monitor);
    }

    @Override
    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getValueSet(auditableCommon, workItem, attribute, includeArchived, false, monitor);
    }

    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, boolean includeArchived, boolean includeIterationsWithoutDeliverables, IProgressMonitor monitor) throws TeamRepositoryException {
        Object nullValue;
        if (attribute == null) {
            return super.getValueSet(auditableCommon, workItem, attribute, monitor);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        List<IIteration> filteredValueSet = this.getFilteredValueSet(auditableCommon, workItem, monitor);
        if (filteredValueSet.size() > 0) {
            values.addAll(filteredValueSet);
        }
        if (!this.contains(values, nullValue = this.getNullValue(auditableCommon, attribute, monitor))) {
            values.add(nullValue);
        }
        List<IIteration> iterations = includeIterationsWithoutDeliverables ? IterationsHelper.findAllIterations(auditableCommon, attribute.getProjectArea(), this.getDefaultProfile(), includeArchived, monitor) : IterationsHelper.findIterations(auditableCommon, attribute.getProjectArea(), this.getDefaultProfile(), includeArchived, monitor);
        for (IIteration iteration : iterations) {
            if (this.contains(values, iteration)) continue;
            values.add(iteration);
        }
        return values.toArray();
    }

    private List<IIteration> getFilteredValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItem != null && workItem.getCategory() != null) {
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            ICategory unassignedCategory = workItemCommon.findUnassignedCategory(workItem.getProjectArea(), ICategory.DEFAULT_PROFILE, monitor);
            ICategory category = auditableCommon.resolveAuditable(workItem.getCategory(), ICategory.DEFAULT_PROFILE, monitor);
            if (!category.sameItemId((IItemHandle)unassignedCategory)) {
                return new IterationSelectionAlgorithm(auditableCommon).getIterations(workItem, monitor);
            }
        }
        return Collections.emptyList();
    }

    private boolean contains(List<Object> objects, Object object) {
        if (objects.contains(object)) {
            return true;
        }
        if (object instanceof IItemHandle) {
            for (Object obj : objects) {
                if (!(obj instanceof IItemHandle) || !((IItemHandle)obj).sameItemId((IItemHandle)object)) continue;
                return true;
            }
        }
        return false;
    }
}

