/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TypeAttributeType
extends AttributeType {
    public TypeAttributeType(String identifier, Class instanceType, AttributeOperation[] operations) {
        super(identifier, instanceType, operations);
    }

    @Override
    public Object getDefaultValue(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        Object[] valueSet = this.getValueSet(auditableCommon, workItem, attribute, monitor);
        if (valueSet.length == 0) {
            return null;
        }
        return valueSet[0];
    }

    @Override
    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        String oldWorkflowId;
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        if (workItem == null) {
            IProjectAreaHandle projectArea = attribute == null ? null : attribute.getProjectArea();
            return TypeAttributeType.findWorkItemTypes(auditableCommon, projectArea, monitor);
        }
        IProcessAreaHandle processArea = workItemCommon.findProcessArea(workItem, monitor);
        WorkflowManager workflowManager = (WorkflowManager)workItemCommon.getWorkflowManager();
        if (workItem.isNewItem()) {
            oldWorkflowId = null;
        } else if (workItem.isWorkingCopy()) {
            IProcessArea area = auditableCommon.resolveAuditable((IAuditableHandle)processArea, ItemProfile.PROCESS_AREA_DEFAULT, monitor);
            IWorkItem repoState = auditableCommon.resolveAuditable(workItem, IWorkItem.SMALL_PROFILE, monitor);
            oldWorkflowId = repoState.getProjectArea().sameItemId((IItemHandle)area.getProjectArea()) ? workflowManager.getWorkflowId(repoState, monitor) : null;
        } else {
            oldWorkflowId = workflowManager.getWorkflowId(workItem, monitor);
        }
        return ((WorkItemCommon)workItemCommon).findAvailableWorkItemTypes(processArea, oldWorkflowId, monitor);
    }

    @Override
    public boolean hasValueSet() {
        return true;
    }

    public static Object[] findWorkItemTypes(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        List<IWorkItemType> types = workItemCommon.findWorkItemTypes(projectArea, monitor);
        ArrayList<String> identifiers = new ArrayList<String>();
        for (IWorkItemType type : types) {
            identifiers.add(type.getIdentifier());
        }
        return identifiers.toArray();
    }
}

