/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.icu.util.TimeZone;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.ast.IBoolean;
import com.ibm.team.repository.common.query.ast.IBooleanField;
import com.ibm.team.repository.common.query.ast.IBooleanInputArg;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.IDateTimeField;
import com.ibm.team.repository.common.query.ast.IEnum;
import com.ibm.team.repository.common.query.ast.IEnumField;
import com.ibm.team.repository.common.query.ast.IEnumInputArg;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IFilterElement;
import com.ibm.team.repository.common.query.ast.IInListValueSource;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.repository.common.query.ast.IStringInputArg;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.query.ast.IUUIDField;
import com.ibm.team.repository.common.query.ast.IUUIDInputArg;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.expression.variables.TimeSpan;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.AttributeOperation;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

public class EqualsOperation
extends AttributeOperation {
    public static final String TAG_FORMAT_EXPR = "%%|%s|%%";
    private static final int IN_QUERY_ARGS_LIMIT = 1000;
    private final boolean fInvert;

    public EqualsOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    @Override
    public boolean evaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) {
        boolean result = this.internalEvaluate(left, right, context, monitor);
        return this.fInvert ? !result : result;
    }

    private boolean internalEvaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        if (left instanceof Collection) {
            Collection collection = (Collection)left;
            boolean equals = false;
            for (Object object : collection) {
                equals |= this.evaluate(object, right, context, monitor);
            }
            return equals;
        }
        if (right instanceof Collection) {
            Collection collection = (Collection)right;
            boolean equals = false;
            for (Object object : collection) {
                equals |= this.evaluate(left, object, context, monitor);
            }
            return equals;
        }
        return left.equals(right);
    }

    @Override
    public IPredicate getPredicate(ITransformationContext context, IProgressMonitor monitor) {
        if (context.getValue() == null) {
            return this.getNullPredicate(context);
        }
        if (context.isField()) {
            return this.getFieldPredicate(context, context.getField());
        }
        return this.getReferencePredicate(context);
    }

    private IPredicate getNullPredicate(ITransformationContext context) {
        IPredicate predicate = context.getAttribute().isStateExtension() ? context.getStateExtensionQueryModel()._isNullValue((IString)context.createStateExtensionKey()) : (context.isField() ? context.getField()._isNull() : context.getReference()._isNull());
        return this.isNegation() ? (predicate = predicate._not()) : predicate;
    }

    private IPredicate getFieldPredicate(ITransformationContext context, IField field) {
        if (field instanceof IStringField) {
            return this.getStringPredicate(context, (IStringField)field);
        }
        if (field instanceof IDateTimeField) {
            return this.getDateTimePredicate(context, (IDateTimeField)field);
        }
        if (field instanceof INumericField) {
            return this.getNumericPredicate(context, (INumericField)field);
        }
        if (field instanceof IBooleanField) {
            return this.getBooleanPredicate(context, (IBooleanField)field);
        }
        if (field instanceof IUUIDField) {
            return this.getUUIDPredicate(context, (IUUIDField)field);
        }
        if (field instanceof IEnumField) {
            return this.getEnumPredicate(context, (IEnumField)field);
        }
        throw new IllegalArgumentException("Unknown field type");
    }

    private IPredicate getReferencePredicate(ITransformationContext context) {
        Object value = context.getValue();
        IPredicate predicate = value instanceof Collection ? this.getReferencePredicate(context, (Collection)value) : this.getReferencePredicate(context, value);
        return this.nullAwareIfNegation(context, predicate);
    }

    private IPredicate getReferencePredicate(ITransformationContext context, Collection<?> values) {
        IPredicate predicate = null;
        Iterator<?> itr = values.iterator();
        int i = 0;
        while (itr.hasNext()) {
            IItemHandleInputArg[] inputArgs = new IItemHandleInputArg[values.size() - i > 1000 ? 1000 : values.size() - i];
            int j = 0;
            while (j < inputArgs.length) {
                inputArgs[j] = context.getQuery().newItemHandleArg();
                context.addParameter(itr.next());
                ++j;
                ++i;
            }
            IPredicate inPredicate = context.getAttribute().isStateExtension() ? this.createPredicateForStateExtension(context, (IFilterElement[])inputArgs) : this.createPredicateForReference(context, inputArgs);
            predicate = this.joinPredicates(predicate, inPredicate);
        }
        return predicate;
    }

    private IPredicate getReferencePredicate(ITransformationContext context, Object value) {
        IItemHandleInputArg inputArg = context.getQuery().newItemHandleArg();
        context.addParameter(value);
        return context.getAttribute().isStateExtension() ? this.createPredicateForStateExtension(context, (IFilterElement)inputArg) : this.createPredicateForReference(context, inputArg);
    }

    private IPredicate getStringPredicate(ITransformationContext context, IStringField field) {
        if ("tags".equals(context.getAttribute().getAttributeType())) {
            return this.getTagsPredicate(context, field);
        }
        return context.getValue() instanceof Collection ? this.getStringPredicate(context, field, (Collection)context.getValue()) : this.getStringPredicate(context, field, context.getValue().toString());
    }

    private IPredicate getStringPredicate(ITransformationContext context, IStringField field, Collection<?> values) {
        IPredicate predicate = null;
        Iterator<?> itr = values.iterator();
        int i = 0;
        while (itr.hasNext()) {
            IStringInputArg[] inputArgs = new IStringInputArg[values.size() - i > 1000 ? 1000 : values.size() - i];
            int j = 0;
            while (j < inputArgs.length) {
                inputArgs[j] = context.getQuery().newStringArg();
                context.addParameter(itr.next());
                ++j;
                ++i;
            }
            IPredicate inPredicate = context.getAttribute().isStateExtension() ? this.createPredicateForStateExtension(context, (IFilterElement[])inputArgs) : this.createPredicateForStringField(field, inputArgs);
            predicate = this.joinPredicates(predicate, inPredicate);
        }
        return this.nullAwareIfNegation(context, predicate);
    }

    private IPredicate getStringPredicate(ITransformationContext context, IStringField field, String value) {
        IStringInputArg inputArg = context.getQuery().newStringArg();
        context.addParameter(value);
        IPredicate predicate = context.getAttribute().isStateExtension() ? this.createPredicateForStateExtension(context, (IFilterElement)inputArg) : this.createPredicateForStringField(field, inputArg);
        return this.nullAwareIfNegation(context, predicate);
    }

    private IPredicate getTagsPredicate(ITransformationContext context, IStringField field) {
        String value;
        IPredicate predicate = null;
        predicate = context.getValue() instanceof Collection ? this.getTagsPredicate(context, field, (Collection)context.getValue()) : ((value = context.getValue().toString()).isEmpty() ? this.getStringPredicate(context, field, value) : this.getTagsPredicate(context, field, value));
        return predicate;
    }

    private IPredicate getTagsPredicate(ITransformationContext context, IStringField field, String value) {
        IPredicate predicate = context.getAttribute().isStateExtension() ? context.createLikePredicate('\\') : field._like((IString)context.getQuery().newStringArg(), '\\');
        context.addLikeParameter(TAG_FORMAT_EXPR, SeparatedStringList.escape(value));
        if (this.fInvert) {
            predicate = predicate._not();
            predicate = context.adaptLikePredicateForInversion(predicate);
        }
        return predicate;
    }

    private IPredicate getTagsPredicate(ITransformationContext context, IStringField field, Collection<?> values) {
        IPredicate predicate = null;
        Iterator<?> itr = values.iterator();
        while (itr.hasNext()) {
            IPredicate subPredicate = this.getTagsPredicate(context, field, itr.next().toString());
            predicate = this.joinPredicates(predicate, subPredicate);
        }
        return predicate;
    }

    private IPredicate getEnumPredicate(ITransformationContext context, IEnumField field) {
        IPredicate predicate = context.getValue() instanceof Collection ? this.getEnumPredicate(context, field, (Collection)context.getValue()) : this.getEnumPredicate(context, field, context.getValue());
        return this.nullAwareIfNegation(context, predicate);
    }

    private IPredicate getEnumPredicate(ITransformationContext context, IEnumField field, Collection<?> values) {
        IPredicate predicate = null;
        Iterator<?> itr = values.iterator();
        while (itr.hasNext()) {
            IPredicate subPredicate = this.getEnumPredicate(context, field, itr.next());
            predicate = this.joinPredicates(predicate, subPredicate);
        }
        return predicate;
    }

    private IPredicate getEnumPredicate(ITransformationContext context, IEnumField field, Object value) {
        IEnumInputArg inputArg = context.getQuery().newEnumArg();
        context.addParameter(value);
        return context.getAttribute().isStateExtension() ? this.createPredicateForStateExtension(context, (IFilterElement)inputArg) : this.createEnumPredicate(field, inputArg);
    }

    private IPredicate getUUIDPredicate(ITransformationContext context, IUUIDField field) {
        IPredicate predicate = context.getValue() instanceof Collection ? this.getUUIDPredicate(context, field, (Collection)context.getValue()) : this.getUUIDPredicate(context, field, context.getValue());
        return this.nullAwareIfNegation(context, predicate);
    }

    private IPredicate getUUIDPredicate(ITransformationContext context, IUUIDField field, Object value) {
        IUUIDInputArg inputArg = context.getQuery().newUUIDArg();
        context.addParameter(value);
        return context.getAttribute().isStateExtension() ? this.createPredicateForStateExtension(context, (IFilterElement)inputArg) : this.createPredicateForUUIDField(field, inputArg);
    }

    private IPredicate getUUIDPredicate(ITransformationContext context, IUUIDField field, Collection<?> values) {
        IPredicate predicate = null;
        final Iterator<?> itr = values.iterator();
        if (values.size() < 1000) {
            IUUIDInputArg[] inputArgs = new IUUIDInputArg[values.size()];
            int i = 0;
            while (i < inputArgs.length) {
                inputArgs[i] = context.getQuery().newUUIDArg();
                context.addParameter(itr.next());
                ++i;
            }
            predicate = context.getAttribute().isStateExtension() ? this.createPredicateForStateExtension(context, (IFilterElement[])inputArgs) : this.createPredicateForUUIDField(field, inputArgs);
        } else if (context.getAttribute().isStateExtension()) {
            int i = 0;
            while (itr.hasNext()) {
                IUUIDInputArg[] inputArgs = new IUUIDInputArg[values.size() - i > 1000 ? 1000 : values.size() - i];
                int j = 0;
                while (j < inputArgs.length) {
                    inputArgs[j] = context.getQuery().newUUIDArg();
                    context.addParameter(itr.next());
                    ++j;
                    ++i;
                }
                IPredicate inPredicate = this.createPredicateForStateExtension(context, (IFilterElement[])inputArgs);
                predicate = this.joinPredicates(predicate, inPredicate);
            }
        } else {
            predicate = field._inLargeList((IInListValueSource)new IInListValueSource<UUID>(){

                public UUID next() throws TeamRepositoryException {
                    return (UUID)itr.next();
                }

                public boolean hasNext() throws TeamRepositoryException {
                    return itr.hasNext();
                }
            });
            predicate = this.isNegation() ? predicate._not() : predicate;
        }
        return predicate;
    }

    private IPredicate getBooleanPredicate(ITransformationContext context, IBooleanField field) {
        IPredicate predicate = null;
        Object value = context.getValue();
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (values.size() > 1) {
                if (context.getAttribute().isStateExtension()) {
                    predicate = context.getStateExtensionQueryModel()._keyExists((IString)context.createStateExtensionKey());
                    predicate = this.isNegation() ? predicate._not() : predicate;
                } else if (this.isNegation()) {
                    predicate = field._isNull();
                }
            } else {
                predicate = this.getBooleanPredicate(context, field, values.iterator().next());
            }
        } else {
            predicate = this.getBooleanPredicate(context, field, value);
        }
        return predicate;
    }

    private IPredicate getBooleanPredicate(ITransformationContext context, IBooleanField field, Object value) {
        IBooleanInputArg inputArg = context.getQuery().newBooleanArg();
        context.addParameter(value);
        IPredicate predicate = context.getAttribute().isStateExtension() ? this.createPredicateForStateExtension(context, (IFilterElement)inputArg) : this.createPredicateForBooleanField(field, inputArg);
        return this.nullAwareIfNegation(context, predicate);
    }

    private IPredicate getNumericPredicate(ITransformationContext context, INumericField field) {
        IPredicate predicate;
        if (context.getValue() instanceof Collection) {
            predicate = this.getNumericPredicate(context, field, (Collection)context.getValue());
        } else {
            INumeric inputArg = this.createNumericInputArg(context);
            context.addParameter(context.getValue());
            predicate = context.getAttribute().isStateExtension() ? this.createPredicateForStateExtension(context, (IFilterElement)inputArg) : this.createPredicateForNumericField(field, inputArg);
        }
        return this.nullAwareIfNegation(context, predicate);
    }

    private IPredicate getNumericPredicate(ITransformationContext context, INumericField field, Collection<?> values) {
        IPredicate predicate = null;
        Iterator<?> itr = values.iterator();
        int i = 0;
        while (itr.hasNext()) {
            INumeric[] inputArgs = new INumeric[values.size() - i > 1000 ? 1000 : values.size() - i];
            int j = 0;
            while (j < inputArgs.length) {
                Object value = itr.next();
                inputArgs[j] = this.createNumericInputArg(context, value);
                context.addParameter(value);
                ++j;
                ++i;
            }
            IPredicate inPredicate = context.getAttribute().isStateExtension() ? this.createPredicateForStateExtension(context, (IFilterElement[])inputArgs) : this.createPredicateForNumericField(field, inputArgs);
            predicate = this.joinPredicates(predicate, inPredicate);
        }
        return predicate;
    }

    private IPredicate getDateTimePredicate(ITransformationContext context, IDateTimeField field) {
        Object value = context.getValue();
        if (value instanceof Collection) {
            return this.getDateTimePredicate(context, field, (Collection)value);
        }
        return this.getDateTimePredicate(context, field, value);
    }

    private IPredicate getDateTimePredicate(ITransformationContext context, IDateTimeField field, Collection<?> values) {
        IPredicate predicate = null;
        Iterator<?> itr = values.iterator();
        while (itr.hasNext()) {
            IPredicate subPredicate = this.getDateTimePredicate(context, field, itr.next());
            predicate = this.joinPredicates(predicate, subPredicate);
        }
        return predicate;
    }

    private IPredicate getDateTimePredicate(ITransformationContext context, IDateTimeField field, Object value) {
        TimeSpan timeSpan = this.createTimeSpan(value, context.getTimeZone());
        if (context.getAttribute().isStateExtension()) {
            if (this.fInvert) {
                IStringInputArg key1 = context.createStateExtensionKey();
                IPredicate lt = context.getStateExtensionQueryModel()._ltKeyValue((IString)key1, (IFilterElement)context.getQuery().newDateTimeArg());
                context.addParameter(timeSpan.getStart());
                IStringInputArg key2 = context.createStateExtensionKey();
                IPredicate gt = context.getStateExtensionQueryModel()._gtKeyValue((IString)key2, (IFilterElement)context.getQuery().newDateTimeArg());
                context.addParameter(timeSpan.getEnd());
                return lt._or(gt);
            }
            IStringInputArg key1 = context.createStateExtensionKey();
            IPredicate gtOrEq = context.getStateExtensionQueryModel()._gtOrEqKeyValue((IString)key1, (IFilterElement)context.getQuery().newDateTimeArg());
            context.addParameter(timeSpan.getStart());
            IStringInputArg key2 = context.createStateExtensionKey();
            IPredicate ltOrEq = context.getStateExtensionQueryModel()._ltOrEqKeyValue((IString)key2, (IFilterElement)context.getQuery().newDateTimeArg());
            context.addParameter(timeSpan.getEnd());
            return gtOrEq._and(ltOrEq);
        }
        context.addParameter(timeSpan.getStart());
        context.addParameter(timeSpan.getEnd());
        IPredicate predicate = field._gtOrEq((IDateTime)context.getQuery().newDateTimeArg())._and(field._ltOrEq((IDateTime)context.getQuery().newDateTimeArg()));
        return this.isNegation() ? (predicate = predicate._not()) : predicate;
    }

    private IPredicate createPredicateForReference(ITransformationContext context, IItemHandleInputArg inputArg) {
        IPredicate predicate = ((ISingleItemQueryModel)context.getReference())._eq(inputArg);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate createPredicateForReference(ITransformationContext context, IItemHandleInputArg[] inputArgs) {
        IPredicate predicate = ((ISingleItemQueryModel)context.getReference())._in(inputArgs);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate createPredicateForStringField(IStringField field, IStringInputArg inputArg) {
        IPredicate predicate = field._eq((IString)inputArg);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate createPredicateForStringField(IStringField field, IStringInputArg[] inputArgs) {
        IPredicate predicate = field._in((IString[])inputArgs);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate createEnumPredicate(IEnumField field, IEnumInputArg inputArg) {
        IPredicate predicate = field._eq((IEnum)inputArg);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate createPredicateForUUIDField(IUUIDField field, IUUIDInputArg inputArg) {
        IPredicate predicate = field._eq((IUUID)inputArg);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate createPredicateForUUIDField(IUUIDField field, IUUIDInputArg[] inputArgs) {
        IPredicate predicate = field._in((IUUID[])inputArgs);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate createPredicateForBooleanField(IBooleanField field, IBooleanInputArg inputArg) {
        IPredicate predicate = field._eq((IBoolean)inputArg);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate createPredicateForNumericField(INumericField field, INumeric inputArg) {
        IPredicate predicate = field._eq(inputArg);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate createPredicateForNumericField(INumericField field, INumeric[] inputArgs) {
        IPredicate predicate = field._in(inputArgs);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate createPredicateForStateExtension(ITransformationContext context, IFilterElement inputArg) {
        return this.isNegation() ? context.getStateExtensionQueryModel()._notEqKeyValue((IString)context.createStateExtensionKey(), inputArg) : context.getStateExtensionQueryModel()._eqKeyValue((IString)context.createStateExtensionKey(), inputArg);
    }

    private IPredicate createPredicateForStateExtension(ITransformationContext context, IFilterElement[] inputArgs) {
        IPredicate predicate = context.getStateExtensionQueryModel()._inValues((IString)context.createStateExtensionKey(), inputArgs);
        return this.isNegation() ? predicate._not() : predicate;
    }

    private IPredicate nullAwareIfNegation(ITransformationContext context, IPredicate predicate) {
        if (this.isNegation()) {
            predicate = context.getAttribute().isStateExtension() ? predicate._or(context.getStateExtensionQueryModel()._isNullValue((IString)context.createStateExtensionKey())) : predicate._or(context.isField() ? context.getField()._isNull() : context.getReference()._isNull());
        }
        return predicate;
    }

    private IPredicate joinPredicates(IPredicate predicate1, IPredicate predicate2) {
        return predicate1 != null ? (this.isNegation() ? predicate1._and(predicate2) : predicate1._or(predicate2)) : predicate2;
    }

    private TimeSpan createTimeSpan(Object value, TimeZone timeZone) {
        if (value instanceof Timestamp) {
            return TimeSpan.createTimeSpan((Timestamp)value, 5, timeZone);
        }
        return (TimeSpan)value;
    }

    @Override
    public boolean isNegation() {
        return this.fInvert;
    }

    @Override
    public boolean supportsMultiValuesPredicate(IQueryableAttribute attribute) {
        return true;
    }
}

