/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.instrument;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.util.ClassFilter;
import org.hibernate.bytecode.util.FieldFilter;
import org.hibernate.cfg.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptFieldClassFileTransformer
implements javax.persistence.spi.ClassTransformer {
    private ClassTransformer classTransformer;

    public InterceptFieldClassFileTransformer(List<String> entities) {
        final ArrayList<String> copyEntities = new ArrayList<String>(entities.size());
        copyEntities.addAll(entities);
        this.classTransformer = Environment.getBytecodeProvider().getTransformer(new ClassFilter(){

            public boolean shouldInstrumentClass(String className) {
                return copyEntities.contains(className);
            }
        }, new FieldFilter(){

            public boolean shouldInstrumentField(String className, String fieldName) {
                return true;
            }

            public boolean shouldTransformFieldAccess(String transformingClassName, String fieldOwnerClassName, String fieldName) {
                return true;
            }
        });
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            return this.classTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }
        catch (Exception e) {
            throw new IllegalClassFormatException(e.getMessage());
        }
    }
}

