/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common;

import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamData;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class RolePersistence {
    private static final String ROLES_KEY = "roles";
    private HashMap fRolesMap;

    public static String getPersistentRoleData(ITeamData teamData, IContributorHandle contributor) {
        return teamData.getContributorData(contributor, ROLES_KEY);
    }

    public static void setPersistedRoleData(ITeamData teamData, IContributorHandle contributor, String roleData) {
        teamData.setContributorData(contributor, ROLES_KEY, roleData);
    }

    public RolePersistence(IRole[] availableRoles) {
        this.fRolesMap = new HashMap(availableRoles.length);
        int i = 0;
        while (i < availableRoles.length) {
            this.fRolesMap.put(availableRoles[i].getId(), availableRoles[i]);
            ++i;
        }
    }

    public static String serialize(IRole[] roles) {
        return RolePersistence.append(null, roles);
    }

    public static String append(String roleData, IRole[] rolesToAppend) {
        StringBuffer buffer = new StringBuffer();
        if (roleData != null && roleData.trim().length() > 0) {
            buffer.append(roleData);
        }
        TreeSet<String> addedRoles = new TreeSet<String>();
        addedRoles.addAll(Arrays.asList(RolePersistence.getRoleIds(roleData)));
        int i = 0;
        while (i < rolesToAppend.length) {
            IRole role = rolesToAppend[i];
            String roleId = role.getId();
            if (!roleId.equals("default") && addedRoles.add(roleId)) {
                if (buffer.length() > 0) {
                    buffer.append('|');
                }
                buffer.append(roleId);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    public static String remove(String roleData, IRole[] rolesToRemove) {
        StringBuffer buffer = new StringBuffer();
        String[] roleIds = RolePersistence.getRoleIds(roleData);
        int i = 0;
        while (i < roleIds.length) {
            String previousRoleId = roleIds[i];
            if (!previousRoleId.equals("default") && !RolePersistence.containsRole(rolesToRemove, previousRoleId)) {
                if (buffer.length() > 0) {
                    buffer.append('|');
                }
                buffer.append(previousRoleId);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private static boolean containsRole(IRole[] roles, String roleId) {
        if (roleId != null) {
            int i = 0;
            while (i < roles.length) {
                if (roleId.equals(roles[i].getId())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public IRole[] deserialize(String roleData) {
        ArrayList<IRole> roles = new ArrayList<IRole>();
        String[] roleIds = RolePersistence.getRoleIds(roleData);
        int i = 0;
        while (i < roleIds.length) {
            String roleId = roleIds[i];
            IRole role = (IRole)this.fRolesMap.get(roleId);
            if (role != null) {
                roles.add(role);
            }
            ++i;
        }
        return roles.toArray(new IRole[roles.size()]);
    }

    public static String[] getRoleIds(String roleData) {
        ArrayList<String> roleIds = new ArrayList<String>();
        if (roleData != null) {
            StringTokenizer tokenizer = new StringTokenizer(roleData, "|");
            while (tokenizer.hasMoreTokens()) {
                String roleId = tokenizer.nextToken();
                roleIds.add(roleId);
            }
        }
        return roleIds.toArray(new String[roleIds.size()]);
    }
}

