/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def;

import com.urbancode.air.property.prop_def.AbstractPropDefEvent;
import com.urbancode.air.property.prop_def.AbstractPropDefEventListener;
import com.urbancode.air.property.prop_def.PropDefDeletedEvent;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.services.event.Event;
import com.urbancode.air.services.event.criteria.Criteria;
import java.util.ArrayList;
import java.util.Set;

public class PropDefDeletedListener
extends AbstractPropDefEventListener {
    public Criteria[] getCriteria() {
        return null;
    }

    public String[] getEventTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(PropDefDeletedEvent.class.getCanonicalName());
        return result.toArray(new String[result.size()]);
    }

    public void handleEvent(Event event) {
        PropDefDeletedEvent deletePropEvent = (PropDefDeletedEvent)event;
        this.updatePropSheets(deletePropEvent);
    }

    private void updatePropSheets(AbstractPropDefEvent deletePropEvent) {
        Set<PropSheet> propSheets = this.getAffectedPropSheets(deletePropEvent);
        for (PropSheet propSheet : propSheets) {
            this.updatePropSheet(deletePropEvent, propSheet);
        }
    }

    private void updatePropSheet(AbstractPropDefEvent deletePropEvent, PropSheet propSheet) {
        PropSheetDef psPSD;
        String propName = deletePropEvent.getPropDefName();
        String existingValue = propSheet.getPropValue(propName);
        PropSheetDef thisPSD = this.getPropSheetDef(deletePropEvent);
        if (this.isPropDefOverridden(propName, thisPSD, psPSD = propSheet.getPropSheetDef())) {
            return;
        }
        if (existingValue != null) {
            propSheet.removePropValue(propSheet.getPropValueObject(propName));
        }
    }
}

