/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.web.rest;

import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet.PropSheetFactoryRegistry;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroup;
import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.air.property.web.rest.PropSheetResource;
import com.urbancode.air.property.web.rest.PropValueResource;
import com.urbancode.commons.webext.util.AbstractResource;
import com.urbancode.commons.webext.util.JSONOutputType;
import com.urbancode.commons.webext.util.JSONUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Path;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="propSheetGroup")
public class PropSheetGroupResource
extends AbstractResource<PropSheetGroup> {
    private static PropSheetGroupResource instance = new PropSheetGroupResource();

    public static PropSheetGroupResource getInstance() {
        return instance;
    }

    protected JSONObject getBasicJSON(PropSheetGroup propSheetGroup) throws Exception {
        JSONObject result = new JSONObject();
        result.put("id", (Object)propSheetGroup.getId());
        if (propSheetGroup.isVersioned()) {
            result.put("path", (Object)propSheetGroup.getPersistenceData().getPath());
            result.put("version", propSheetGroup.getPersistenceData().getRelativeVersion());
            result.put("versionCount", propSheetGroup.getPersistenceData().getVersionCount());
            result.put("commit", propSheetGroup.getPersistenceData().getCommit());
            result.put("versioned", true);
        } else {
            result.put("versioned", false);
        }
        return result;
    }

    protected JSONObject getExtendedJSON(PropSheetGroup propSheetGroup) throws Exception {
        JSONObject result = new JSONObject();
        result.put("propSheets", (Object)PropSheetResource.getInstance().toJSON(propSheetGroup.getPropSheetSet(), new JSONOutputType[]{JSONOutputType.ALL}));
        return result;
    }

    protected JSONObject getExportJSON(PropSheetGroup group) throws Exception {
        JSONObject result = new JSONObject();
        result.put("propSheets", (Object)PropSheetResource.getInstance().toJSON(group.getPropSheetSet(), new JSONOutputType[]{JSONOutputType.EXPORT}));
        return result;
    }

    public JSONArray getPropertyValueArray(PropSheetGroup propSheetGroup) throws Exception {
        JSONArray result = new JSONArray();
        for (PropSheet propSheet : propSheetGroup.getPropSheetSet()) {
            for (PropValue propValue : propSheet.getPropValueList()) {
                JSONObject propValueObject = PropValueResource.getInstance().toJSON(propValue, new JSONOutputType[]{JSONOutputType.BASIC});
                propValueObject.put("name", (Object)(propSheet.getName() + "/" + propValue.getName()));
                result.put((Object)propValueObject);
            }
        }
        return result;
    }

    public void importPropSheetGroup(PropSheetGroup group, JSONObject json, boolean isUpgrade) throws Exception {
        this.importPropSheetGroup(group, json, isUpgrade, new ArrayList<String>());
    }

    public void importPropSheetGroup(PropSheetGroup group, JSONObject json, boolean isUpgrade, List<String> excludes) throws Exception {
        JSONArray propSheetJsons = JSONUtilities.getJsonArrayFromJsonObject((JSONObject)json, (String)"propSheets");
        for (int i = 0; i < propSheetJsons.length(); ++i) {
            JSONObject sheetJson = propSheetJsons.getJSONObject(i);
            String sheetName = JSONUtilities.getStringFromJsonObject((JSONObject)sheetJson, (String)"name");
            if (sheetName != null && excludes.contains(sheetName)) continue;
            PropSheet sheet = null;
            if (sheetName != null) {
                sheet = group.getPropSheet(sheetName);
            }
            if (sheet == null) {
                sheet = group.isVersioned() ? PropSheetFactoryRegistry.getFactory().createVersionedPropSheet(null, group, null) : PropSheetFactoryRegistry.getFactory().createPropSheet(group, null);
            }
            PropSheetResource.getInstance().importPropSheet(sheet, sheetJson, isUpgrade);
            group.addPropSheet(sheet);
        }
    }
}

