/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.IBackLinkUpdater;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.preview.CompactRenderingDocument;
import com.ibm.team.calm.foundation.common.internal.preview.ICompactRenderingRepresentation;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.OSLCResourcePreviewProperties;
import com.ibm.team.calm.foundation.common.preview.ResourcePreview;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ResourceUpdater
implements IBackLinkUpdater {
    private OSLCResourceDescription.ResourceVersion fResourceVersion;
    private Map<OSLCResourceDescription.ResourcePropertyDescription, List<LinkPropertyChange>> fChanges;
    private IHttpClient fHttpClient;
    private String fResourceURL;
    private ResourceContent fExistingContent;
    private ResourceContent fOldContent;

    protected ResourceUpdater() {
    }

    void init(OSLCResourceDescription.ResourceVersion resourceDescription, IHttpClient httpClient, String resourceURL) {
        this.fResourceVersion = resourceDescription;
        this.fHttpClient = httpClient;
        this.fResourceURL = resourceURL;
    }

    public String getResourceURL() {
        return this.fResourceURL;
    }

    protected IHttpClient getHttpClient() {
        return this.fHttpClient;
    }

    protected IHttpClient getHttpAccess() {
        return this.fHttpClient;
    }

    public OSLCResourceDescription.ResourceVersion getResourceVersion() {
        return this.fResourceVersion;
    }

    protected String evaluateLoadParameter(Set<OSLCResourceDescription.ResourcePropertyDescription> properties) {
        return null;
    }

    protected String evaluateWriteParameter(Set<OSLCResourceDescription.ResourcePropertyDescription> properties) {
        return null;
    }

    public void load(String ... propertyIds) throws TeamRepositoryException, UnsupportedVersionException {
        this.load((Map<String, String>)null, propertyIds);
    }

    public void load(Map<String, String> extraHeaders, String ... propertyIds) throws TeamRepositoryException, UnsupportedVersionException {
        Set<OSLCResourceDescription.ResourcePropertyDescription> allProperties = this.getAllProperties(propertyIds);
        HashMap<String, String> headers = new HashMap<String, String>(this.fResourceVersion.getHttpHeaders());
        if (extraHeaders != null) {
            headers.putAll(extraHeaders);
        }
        OSLCResource resource = OSLCResource.loadResource(this.fHttpClient, this.fResourceURL, this.evaluateLoadParameter(allProperties), this.fResourceVersion.getContentType(), headers, this.fResourceVersion.getOslcResource(), this.fResourceVersion.getVersion());
        this.fExistingContent = this.loadExistingContent(resource, allProperties);
        if (!this.verifyResourceTitle(allProperties)) {
            this.loadResourcePreviewContent(allProperties);
        }
    }

    public OSLCResource getLoadedResource() {
        if (this.fExistingContent == null) {
            throw new IllegalArgumentException("'getLoadedResource' must only be called after a successful load.");
        }
        return this.fExistingContent.getOSLCResource();
    }

    public List<LinkProperty> getLinks(String propertyId) {
        List<LinkProperty> list;
        if (this.fExistingContent == null) {
            throw new IllegalArgumentException("'getLinks' must only be called after a successful load.");
        }
        OSLCResourceDescription.ResourcePropertyDescription propertyDescription = this.getResourceVersion().getResourcePropertyDescription(propertyId);
        if (propertyDescription != null && (list = this.fExistingContent.getLinkProperties(propertyDescription)) != null && !list.isEmpty()) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public SimpleProperty getSimpleProperty(String propertyId) {
        if (this.fExistingContent == null) {
            throw new IllegalArgumentException("'getSimpleProperty' must only be called after a successful load.");
        }
        OSLCResourceDescription.ResourcePropertyDescription propertyDescription = this.getResourceVersion().getResourcePropertyDescription(propertyId);
        if (propertyDescription != null) {
            return this.fExistingContent.getSimpleProperty(propertyDescription);
        }
        return null;
    }

    private Set<OSLCResourceDescription.ResourcePropertyDescription> getAllProperties(String ... propertyIds) throws TeamRepositoryException {
        HashSet<OSLCResourceDescription.ResourcePropertyDescription> properties = new HashSet<OSLCResourceDescription.ResourcePropertyDescription>();
        if (propertyIds != null) {
            OSLCResourceDescription.ResourceVersion resourceVersion = this.getResourceVersion();
            String[] stringArray = propertyIds;
            int n = propertyIds.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyId = stringArray[n2];
                OSLCResourceDescription.ResourcePropertyDescription description = resourceVersion.getResourcePropertyDescription(propertyId);
                if (description != null) {
                    properties.add(description);
                }
                ++n2;
            }
        }
        if (this.fChanges != null) {
            properties.addAll(this.fChanges.keySet());
        }
        return properties;
    }

    private boolean verifyResourceTitle(Set<OSLCResourceDescription.ResourcePropertyDescription> allProperties) {
        SimpleProperty existingTitleProperty;
        boolean hasTitle = false;
        OSLCResourcePreviewProperties previewProperties = OSLCResourcePreviewProperties.getInstance();
        OSLCResourceDescription.ResourcePropertyDescription titleProperty = previewProperties.getTitleProperty();
        if (allProperties != null && allProperties.contains(titleProperty) && (existingTitleProperty = this.fExistingContent.getSimpleProperty(titleProperty)) != null && existingTitleProperty.getValue() != null && !existingTitleProperty.getValue().isEmpty()) {
            hasTitle = true;
        }
        return hasTitle;
    }

    private void loadResourcePreviewContent(Set<OSLCResourceDescription.ResourcePropertyDescription> allProperties) throws TeamRepositoryException {
        if (allProperties != null && !allProperties.isEmpty()) {
            ICompactRenderingRepresentation representation;
            OSLCResourcePreviewProperties previewProperties = OSLCResourcePreviewProperties.getInstance();
            ResourcePreview preview = null;
            boolean previewLoaded = false;
            if (allProperties.contains(previewProperties.getTitleProperty())) {
                if (!previewLoaded) {
                    representation = CompactRenderingDocument.getCompactRenderingRepresentation(this.getResourceURL(), this.getHttpClient());
                    preview = ResourcePreview.createPreview(representation);
                    previewLoaded = true;
                }
                if (preview != null && preview.getError() == null && preview.getTitle() != null) {
                    OSLCResourceDescription.ResourcePropertyDescription titleProperty = previewProperties.getTitleProperty();
                    this.fExistingContent.putSimpleProperty(titleProperty, new SimpleProperty(titleProperty.getId(), preview.getTitle().getPlainText()));
                }
            }
            if (allProperties.contains(previewProperties.getShortTitleProperty())) {
                if (!previewLoaded) {
                    representation = CompactRenderingDocument.getCompactRenderingRepresentation(this.getResourceURL(), this.getHttpClient());
                    preview = ResourcePreview.createPreview(representation);
                    previewLoaded = true;
                }
                if (preview != null && preview.getError() == null && preview.getAbbreviation() != null) {
                    OSLCResourceDescription.ResourcePropertyDescription shortTitleProperty = previewProperties.getShortTitleProperty();
                    this.fExistingContent.putSimpleProperty(shortTitleProperty, new SimpleProperty(shortTitleProperty.getId(), preview.getAbbreviation().getPlainText()));
                }
            }
        }
    }

    protected abstract ResourceContent loadExistingContent(OSLCResource var1, Set<OSLCResourceDescription.ResourcePropertyDescription> var2) throws TeamRepositoryException, UnsupportedVersionException;

    protected abstract String storeContent(ResourceContent var1) throws TeamRepositoryException;

    @Override
    public void write() throws TeamRepositoryException {
        if (this.fExistingContent == null) {
            throw new IllegalArgumentException("Write can only be called after a successful load.");
        }
        if (this.fChanges == null || this.fChanges.isEmpty()) {
            return;
        }
        ResourceContent changedContent = this.applyLinkChanged(this.fExistingContent, this.fChanges);
        Set<OSLCResourceDescription.ResourcePropertyDescription> changedParameters = this.getLinkChanges().keySet();
        String newContent = this.storeContent(changedContent);
        if (newContent != null) {
            this.performWrite(this.fExistingContent.getOSLCResource(), newContent, changedParameters);
        }
        this.fOldContent = this.fExistingContent;
        this.fExistingContent = changedContent;
    }

    @Override
    public void revert() throws TeamRepositoryException {
        if (this.fExistingContent == null || this.fOldContent == null) {
            throw new IllegalArgumentException("Revert can only be called after a successful write.");
        }
        Set<OSLCResourceDescription.ResourcePropertyDescription> changedParameters = this.getLinkChanges().keySet();
        String newContent = this.storeContent(this.fOldContent);
        if (newContent != null) {
            this.performWrite(this.fExistingContent.getOSLCResource(), newContent, changedParameters);
        }
        this.fExistingContent = this.fOldContent;
        this.fOldContent = null;
    }

    protected void performWrite(OSLCResource resource, String newContent, Set<OSLCResourceDescription.ResourcePropertyDescription> changedParameters) throws TeamRepositoryException {
        resource.write(this.fHttpClient, newContent, this.evaluateWriteParameter(changedParameters));
    }

    private ResourceContent applyLinkChanged(ResourceContent existingLinks, Map<OSLCResourceDescription.ResourcePropertyDescription, List<LinkPropertyChange>> changes) {
        ResourceContent result = new ResourceContent(existingLinks);
        for (OSLCResourceDescription.ResourcePropertyDescription property : changes.keySet()) {
            List<LinkPropertyChange> chs = changes.get(property);
            List<LinkProperty> currDescs = result.getLinkProperties(property);
            for (LinkPropertyChange ch : chs) {
                LinkProperty oldLink = ch.getOldValue();
                LinkProperty newLink = ch.getNewValue();
                if (oldLink != null || newLink != null) {
                    Iterator<LinkProperty> iterator = currDescs.iterator();
                    while (iterator.hasNext()) {
                        String linkUri = iterator.next().getLinkUri();
                        if ((oldLink == null || !oldLink.getLinkUri().equals(linkUri)) && (newLink == null || !newLink.getLinkUri().equals(linkUri))) continue;
                        iterator.remove();
                    }
                }
                if (newLink == null) continue;
                currDescs.add(newLink);
            }
        }
        return result;
    }

    @Override
    public void addLink(String propertyId, String targetURL, String comment) {
        this.processLinkChange(new LinkPropertyChange(null, new LinkProperty(propertyId, targetURL, comment)));
    }

    @Override
    public void removeLink(String propertyId, String targetURL) {
        this.processLinkChange(new LinkPropertyChange(new LinkProperty(propertyId, targetURL, new String()), null));
    }

    private void processLinkChange(LinkPropertyChange change) {
        LinkPropertyChange nullifiedChange;
        String propertyId = change.getPropertyId();
        OSLCResourceDescription.ResourcePropertyDescription description = this.getResourceVersion().getResourcePropertyDescription(propertyId);
        if (description == null) {
            return;
        }
        if (description.getType() == OSLCResourceDescription.PropertyType.SIMPLE) {
            throw new IllegalArgumentException("Modifications to simple properties not yet supported");
        }
        Map<OSLCResourceDescription.ResourcePropertyDescription, List<LinkPropertyChange>> changes = this.getLinkChanges();
        List<LinkPropertyChange> list = changes.get(description);
        if (list == null) {
            list = new ArrayList<LinkPropertyChange>();
            changes.put(description, list);
        }
        LinkPropertyChange linkPropertyChange = change.getNewValue() != null ? this.getNullifiedRemoveChange(change.getNewValue().getLinkUri(), list) : (nullifiedChange = change.getOldValue() != null ? this.getNullifiedAddChange(change.getOldValue().getLinkUri(), list) : null);
        if (nullifiedChange == null) {
            list.add(change);
        } else {
            list.remove(nullifiedChange);
            if (list.isEmpty()) {
                changes.remove(description);
            }
        }
    }

    private LinkPropertyChange getNullifiedRemoveChange(String targetUrl, List<LinkPropertyChange> changes) {
        for (LinkPropertyChange existingChange : changes) {
            if (existingChange.getOldValue() == null || !existingChange.getOldValue().getLinkUri().equals(targetUrl)) continue;
            return existingChange;
        }
        return null;
    }

    private LinkPropertyChange getNullifiedAddChange(String targetUrl, List<LinkPropertyChange> changes) {
        for (LinkPropertyChange existingChange : changes) {
            if (existingChange.getNewValue() == null || !existingChange.getNewValue().getLinkUri().equals(targetUrl)) continue;
            return existingChange;
        }
        return null;
    }

    private Map<OSLCResourceDescription.ResourcePropertyDescription, List<LinkPropertyChange>> getLinkChanges() {
        if (this.fChanges == null) {
            this.fChanges = new HashMap<OSLCResourceDescription.ResourcePropertyDescription, List<LinkPropertyChange>>();
        }
        return this.fChanges;
    }

    public List<LinkPropertyChange> getChanges(String propertyId) {
        OSLCResourceDescription.ResourcePropertyDescription description = this.getResourceVersion().getResourcePropertyDescription(propertyId);
        if (description == null) {
            return Collections.emptyList();
        }
        List<LinkPropertyChange> list = this.getLinkChanges().get(description);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static class AbstractProperty {
        private final String fPropertyId;

        public AbstractProperty(String propertyId) {
            this.fPropertyId = propertyId;
        }

        public String getPropertyId() {
            return this.fPropertyId;
        }
    }

    public static class LinkProperty
    extends AbstractProperty {
        private final String fComment;
        private final String fTarget;

        public LinkProperty(String propertyId, String targetURL, String comment) {
            super(propertyId);
            this.fTarget = targetURL;
            this.fComment = comment;
        }

        public String getLinkUri() {
            return this.fTarget;
        }

        public String getLinkComment() {
            return this.fComment;
        }

        public String toString() {
            return this.fTarget;
        }
    }

    public static class LinkPropertyChange {
        private final LinkProperty fOldLink;
        private final LinkProperty fNewLink;

        protected LinkPropertyChange(LinkProperty oldLink, LinkProperty newLink) {
            if (oldLink != null && newLink != null && !oldLink.getPropertyId().equals(newLink.getPropertyId())) {
                throw new IllegalArgumentException("Old and new link must be for the same property id");
            }
            if (oldLink == null && newLink == null) {
                throw new IllegalArgumentException("Either old and new link must not be null");
            }
            this.fOldLink = oldLink;
            this.fNewLink = newLink;
        }

        public LinkProperty getNewValue() {
            return this.fNewLink;
        }

        public LinkProperty getOldValue() {
            return this.fOldLink;
        }

        public String getPropertyId() {
            if (this.fOldLink != null) {
                return this.fOldLink.getPropertyId();
            }
            return this.fNewLink.getPropertyId();
        }
    }

    public static class ResourceContent {
        private final Map<OSLCResourceDescription.ResourcePropertyDescription, List<LinkProperty>> fLinkProperties = new LinkedHashMap<OSLCResourceDescription.ResourcePropertyDescription, List<LinkProperty>>();
        private final Map<OSLCResourceDescription.ResourcePropertyDescription, SimpleProperty> fSimpleProperties = new LinkedHashMap<OSLCResourceDescription.ResourcePropertyDescription, SimpleProperty>();
        private OSLCResource fOSLCResource;

        public ResourceContent(OSLCResource resource) {
            this.fOSLCResource = resource;
        }

        public ResourceContent(ResourceContent resourceContent) {
            this(resourceContent.getOSLCResource());
            for (Map.Entry<OSLCResourceDescription.ResourcePropertyDescription, List<LinkProperty>> entry : resourceContent.fLinkProperties.entrySet()) {
                this.fLinkProperties.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            this.fSimpleProperties.putAll(resourceContent.fSimpleProperties);
        }

        public OSLCResource getOSLCResource() {
            return this.fOSLCResource;
        }

        public List<LinkProperty> getLinkProperties(OSLCResourceDescription.ResourcePropertyDescription propertyDesc) {
            return this.fLinkProperties.get(propertyDesc);
        }

        public SimpleProperty getSimpleProperty(OSLCResourceDescription.ResourcePropertyDescription propertyDesc) {
            return this.fSimpleProperties.get(propertyDesc);
        }

        public void putLinkProperties(OSLCResourceDescription.ResourcePropertyDescription propertyDesc, List<LinkProperty> links) {
            this.fLinkProperties.put(propertyDesc, links);
        }

        public void putSimpleProperty(OSLCResourceDescription.ResourcePropertyDescription propertyDesc, SimpleProperty property) {
            this.fSimpleProperties.put(propertyDesc, property);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (Map.Entry<OSLCResourceDescription.ResourcePropertyDescription, List<LinkProperty>> entry : this.fLinkProperties.entrySet()) {
                buf.append(entry.getKey().getId()).append("\n");
                for (LinkProperty property : entry.getValue()) {
                    buf.append("    ").append(property.toString()).append("\n");
                }
            }
            for (Map.Entry<OSLCResourceDescription.ResourcePropertyDescription, Object> entry : this.fSimpleProperties.entrySet()) {
                buf.append(entry.getKey().getId()).append(((SimpleProperty)entry.getValue()).getValue()).append("\n");
            }
            return buf.toString();
        }

        public Set<Map.Entry<OSLCResourceDescription.ResourcePropertyDescription, List<LinkProperty>>> getLinkPropertySet() {
            return this.fLinkProperties.entrySet();
        }
    }

    public static class SimpleProperty
    extends AbstractProperty {
        private final String fValue;

        public SimpleProperty(String propertyId, String value) {
            super(propertyId);
            this.fValue = value;
        }

        public String getValue() {
            return this.fValue;
        }

        public String toString() {
            return this.fValue;
        }
    }
}

