/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.XPathQuery;
import com.ibm.team.calm.foundation.common.internal.CALMFoundationCommonPlugin;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLink;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.calm.foundation.common.internal.linking.Messages;
import com.ibm.team.calm.foundation.common.linking.CALMBackLinkUpdater;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QMBackLinkOperationV1
extends CALMBackLinkOperation {
    private CALMDocument fDocument;

    @Override
    public List<CALMBackLink> loadExistingLinks() throws TeamRepositoryException, UnsupportedVersionException {
        OSLCResource resource = super.loadResource(this.getBackLink().getSourceURL());
        this.fDocument = new CALMDocument(resource.getContent());
        XPathQuery path = new XPathQuery(this.getElementName()).add('/').addRef(this.getBackLinkElement().getQualifiedName());
        NodeList nodes = this.fDocument.getNodes(path);
        return this.parseBackLinks(nodes, this.fDocument);
    }

    @Override
    public void storeLinks(List<CALMBackLink> newLinks) throws TeamRepositoryException {
        String content = null;
        content = this.hasLinkRemoved() ? this.replaceResourceContent(newLinks) : this.addNewLinkToResource(this.getBackLink().getTargetURL(), this.getBackLink().getLinkComment());
        try {
            super.storeResource(content);
        }
        catch (IHttpClient.HttpAccessException e) {
            if (this.isUnsupportedPlanLinksInRQM201(e)) {
                CALMFoundationCommonPlugin.log(e.getMessage(), (Throwable)((Object)e));
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("QMBackLinkOperationV1_ERROR_CREATING_QM_BACKLINK_NOT_SUPPORTED"), (Object)this.getBackLink().getTargetURL(), (Object[])new Object[0]));
            }
            throw e;
        }
    }

    private boolean isUnsupportedPlanLinksInRQM201(IHttpClient.HttpAccessException e) {
        return e.getResponse().getStatusCode() == 409 && this.getOperationType() == CALMBackLinkUpdater.OperationType.ADD && OSLCResourceDescription.ID_QM_TEST_PLAN.equals(this.getBackLink().getLinkType().getTargetResourceId());
    }

    @Override
    public CALMBackLinkOperation clone() {
        QMBackLinkOperationV1 result = new QMBackLinkOperationV1();
        result.setVersion(this.getVersion());
        result.setContentType(this.getContentType());
        result.setElementName(this.getElementName());
        result.setHttpHeaders(this.getHttpHeaders());
        return result;
    }

    private List<CALMBackLink> parseBackLinks(NodeList xmlNodes, CALMDocument document) throws CALMDocument.DocumentParseException {
        ArrayList<CALMBackLink> result = new ArrayList<CALMBackLink>(xmlNodes.getLength());
        int idx = 0;
        while (idx < xmlNodes.getLength()) {
            Node curNode = xmlNodes.item(idx);
            XPathQuery resourcePath = new XPathQuery("./@").addRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
            XPathQuery labelPath = new XPathQuery("./@").addRef("http://open-services.net/xmlns/qm/1.0/", "label");
            String curTarget = document.getText(resourcePath, (Object)curNode);
            String curLabel = document.getText(labelPath, (Object)curNode);
            if (curTarget != null && curTarget.length() > 0 && curLabel != null) {
                result.add(this.createBackLink(curTarget, curLabel));
            }
            ++idx;
        }
        return result;
    }

    private String replaceResourceContent(List<CALMBackLink> newLinks) throws CALMDocument.DocumentParseException {
        if (this.fDocument != null) {
            NodeList roots = this.fDocument.getNodes(new XPathQuery(this.getElementName()));
            Assert.isTrue((roots.getLength() == 1 ? 1 : 0) != 0);
            Element root = (Element)roots.item(0);
            QName backLinkName = this.getBackLinkElement().getQualifiedName();
            NodeList nodes = root.getElementsByTagNameNS(backLinkName.getNamespaceURI(), backLinkName.getLocalPart());
            int idx = nodes.getLength() - 1;
            while (idx >= 0) {
                root.removeChild(nodes.item(idx));
                --idx;
            }
            for (CALMBackLink curLink : newLinks) {
                Element linkElem = this.fDocument.addNewElement(root, backLinkName.getNamespaceURI(), backLinkName.getLocalPart(), this.getNamespaces().getPrefix(backLinkName.getNamespaceURI()));
                CALMDocument.setAttribute(linkElem, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", "rdf", curLink.getTargetURL());
                CALMDocument.setAttribute(linkElem, "http://open-services.net/xmlns/qm/1.0/", "label", "oslc_qm", curLink.getLinkComment());
            }
            return this.writeDocumentContent(root.getOwnerDocument());
        }
        return null;
    }

    private String addNewLinkToResource(String targetURL, String linkLabel) throws CALMDocument.DocumentParseException {
        if (this.fDocument != null) {
            NodeList roots = this.fDocument.getNodes(new XPathQuery(this.getElementName()));
            Assert.isTrue((roots.getLength() == 1 ? 1 : 0) != 0);
            Element root = (Element)roots.item(0);
            QName backLinkName = this.getBackLinkElement().getQualifiedName();
            Element linkElem = this.fDocument.addNewElement(root, backLinkName.getNamespaceURI(), backLinkName.getLocalPart(), this.getNamespaces().getPrefix(backLinkName.getNamespaceURI()));
            CALMDocument.setAttribute(linkElem, "http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", "rdf", targetURL);
            CALMDocument.setAttribute(linkElem, "http://open-services.net/xmlns/qm/1.0/", "label", "oslc_qm", linkLabel);
            return this.writeDocumentContent(root.getOwnerDocument());
        }
        return null;
    }
}

