/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.querypath;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.Exists;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.InListStateExtension;
import com.ibm.team.repository.common.internal.queryast.IsEmpty;
import com.ibm.team.repository.common.internal.queryast.IsMemberOf;
import com.ibm.team.repository.common.internal.queryast.IsMissing;
import com.ibm.team.repository.common.internal.queryast.IsNull;
import com.ibm.team.repository.common.internal.queryast.IsNullStateExtension;
import com.ibm.team.repository.common.internal.queryast.IsTypeOf;
import com.ibm.team.repository.common.internal.queryast.ItemTypePseudoVariable;
import com.ibm.team.repository.common.internal.queryast.KeyExists;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.Predicate;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.queryast.impl.FeaturePathImpl;
import com.ibm.team.repository.common.internal.querypath.IInternalQueryModel;
import com.ibm.team.repository.common.internal.querypath.IQueryPath;
import com.ibm.team.repository.common.internal.querypath.PathIterator;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.query.BaseAuditableQueryModel;
import com.ibm.team.repository.common.model.query.BaseItemHandleQueryModel;
import com.ibm.team.repository.common.model.query.BaseItemQueryModel;
import com.ibm.team.repository.common.model.query.BaseSimpleItemQueryModel;
import com.ibm.team.repository.common.model.query.impl.AuditableQueryModelImpl;
import com.ibm.team.repository.common.model.query.impl.ItemHandleQueryModelImpl;
import com.ibm.team.repository.common.model.query.impl.ItemQueryModelImpl;
import com.ibm.team.repository.common.model.query.impl.SimpleItemQueryModelImpl;
import com.ibm.team.repository.common.query.QueryException;
import com.ibm.team.repository.common.query.ast.IDynamicItemQueryModel;
import com.ibm.team.repository.common.query.ast.IDynamicQueryModel;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IFilterElement;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IItemQueryModel;
import com.ibm.team.repository.common.query.ast.IItemTypeInputArg;
import com.ibm.team.repository.common.query.ast.IManyItemQueryModel;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IPseudoVariable;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.ISingleQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;

public abstract class AbstractQueryPathModel
implements ISingleItemQueryModel,
IManyItemQueryModel,
IInternalQueryModel {
    private static String ITEM_QM = ItemQueryModelImpl.class.getName();
    private static String SIMPLE_ITEM_QM = SimpleItemQueryModelImpl.class.getName();
    private static String ITEM_HANDLE_QM = ItemHandleQueryModelImpl.class.getName();
    private static String AUDITABLE_QM = AuditableQueryModelImpl.class.getName();
    private static final String OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES = "Operation only allowed on single valued references";
    private static final String OPERATION_ONLY_ALLOWED_ON_MANY_VALUED_REFERENCES = "Operation only allowed on many valued references";
    protected Implementation _implementation;

    public static Implementation getImplementation(IQueryModel model) {
        return ((IInternalQueryModel)((Object)model))._getImplementation();
    }

    public AbstractQueryPathModel(IQueryPath aModel, String aField) {
        this._implementation = new Implementation(aModel, aField);
        this.initProperties(this._implementation.allFieldNames, this._implementation.allReferenceNames, this._implementation.allFields);
    }

    protected void initProperties(List<String> allFieldNames, List<String> allReferenceNames, Map<String, IField> allFields) {
    }

    public AbstractQueryPathModel() {
        this(null, null);
    }

    @Override
    public IPredicate _isEmpty() {
        if (!this._implementation.isManyValuedRef()) {
            throw new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_MANY_VALUED_REFERENCES);
        }
        IsEmpty isEmpty = QueryastFactory.eINSTANCE.createIsEmpty();
        isEmpty.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        isEmpty.setNot(false);
        return isEmpty;
    }

    @Override
    public IPredicate _in(IItemHandleInputArg[] list) {
        if (!this._implementation.isSingleValueRef()) {
            throw new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES);
        }
        InList inList = QueryastFactory.eINSTANCE.createInList();
        FeaturePath p = QueryastFactory.eINSTANCE.createFeaturePath(this._implementation.getIdField());
        ((FeaturePathImpl)p).setExtended(true);
        inList.setField(p);
        IItemHandleInputArg[] iItemHandleInputArgArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandleInputArg arg = iItemHandleInputArgArray[n2];
            inList.getValues().add((Object)arg);
            ++n2;
        }
        return inList;
    }

    @Override
    public IPredicate _contains(ISingleQueryModel element) {
        if (!this._implementation.isManyValuedRef()) {
            throw new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_MANY_VALUED_REFERENCES);
        }
        Implementation elementPath = AbstractQueryPathModel.getImplementation(element);
        if (elementPath.getRoot() != this._implementation.getRoot()) {
            throw new IllegalArgumentException("A _contains query cannot span two different root types");
        }
        IsMemberOf isMemberOf = QueryastFactory.eINSTANCE.createIsMemberOf();
        isMemberOf.setCollectionPath(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        isMemberOf.setElementPath(QueryastFactory.eINSTANCE.createFeaturePath(elementPath));
        isMemberOf.setNot(false);
        return isMemberOf;
    }

    @Override
    public IPredicate _contains(IItemHandle handle) {
        if (!this._implementation.isManyValuedRef()) {
            throw new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_MANY_VALUED_REFERENCES);
        }
        IsMemberOf isMemberOf = QueryastFactory.eINSTANCE.createIsMemberOf();
        isMemberOf.setCollectionPath(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        isMemberOf.setElementPath(QueryastFactory.eINSTANCE.createUUIDLiteral(handle.getItemId()));
        isMemberOf.setNot(false);
        return isMemberOf;
    }

    @Override
    public IPredicate _contains(IItemHandleInputArg arg) {
        if (!this._implementation.isManyValuedRef()) {
            throw new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_MANY_VALUED_REFERENCES);
        }
        FilterElement argCopy = QueryastFactory.eINSTANCE.createFilterElement(arg);
        IsMemberOf isMemberOf = QueryastFactory.eINSTANCE.createIsMemberOf();
        isMemberOf.setCollectionPath(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        isMemberOf.setElementPath(argCopy);
        isMemberOf.setNot(false);
        return isMemberOf;
    }

    @Override
    public IPredicate _eq(IItemHandle handle) {
        if (!this._implementation.isSingleValueRef()) {
            throw new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES);
        }
        FilterElement lhs = QueryastFactory.eINSTANCE.createFilterElement(this._implementation.getIdField());
        ((FeaturePathImpl)lhs).setExtended(true);
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, lhs, handle.getItemId());
    }

    @Override
    public IPredicate _eq(IItemHandleInputArg inputArg) {
        if (!this._implementation.isSingleValueRef()) {
            throw new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES);
        }
        FilterElement lhs = QueryastFactory.eINSTANCE.createFilterElement(this._implementation.getIdField());
        ((FeaturePathImpl)lhs).setExtended(true);
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, lhs, inputArg);
    }

    @Override
    public IPredicate _isNull() {
        if (!this._implementation.isSingleValueRef()) {
            throw new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES);
        }
        IsNull isNull = QueryastFactory.eINSTANCE.createIsNull();
        isNull.setNot(false);
        FeaturePath p = QueryastFactory.eINSTANCE.createFeaturePath(this._implementation.getIdField());
        ((FeaturePathImpl)p).setExtended(true);
        isNull.setFeature(p);
        return isNull;
    }

    @Override
    public IPredicate _isMissing() {
        if (!this._implementation.isSingleValueRef()) {
            throw new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES);
        }
        IsMissing isMissing = QueryastFactory.eINSTANCE.createIsMissing();
        isMissing.setNot(false);
        isMissing.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        return isMissing;
    }

    @Override
    public IPredicate _isTypeOf(IItemType itemType) {
        IsTypeOf isTypeOf = QueryastFactory.eINSTANCE.createIsTypeOf();
        isTypeOf.setNot(false);
        isTypeOf.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        isTypeOf.setType(QueryastFactory.eINSTANCE.createItemTypeLiteral(itemType));
        return isTypeOf;
    }

    @Override
    public IPredicate _isTypeOf(IItemTypeInputArg itemType) {
        IsTypeOf isTypeOf = QueryastFactory.eINSTANCE.createIsTypeOf();
        isTypeOf.setNot(false);
        isTypeOf.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        FilterElement typeFilter = QueryastFactory.eINSTANCE.createFilterElement(itemType);
        isTypeOf.setType(typeFilter);
        return isTypeOf;
    }

    @Override
    public IPseudoVariable _itemType() {
        ItemTypePseudoVariable v = QueryastFactory.eINSTANCE.createItemTypePseudoVariable();
        v.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        return v;
    }

    protected AbstractQueryPathModel getReference(String name) {
        return null;
    }

    @Override
    public Implementation _getImplementation() {
        return this._implementation;
    }

    protected abstract boolean isItem();

    private boolean isGeneric(AbstractQueryPathModel aType) {
        String aName = aType.getClass().getName();
        return aName.equals(ITEM_HANDLE_QM) || aName.equals(ITEM_QM) || aName.equals(AUDITABLE_QM) || aName.equals(SIMPLE_ITEM_QM);
    }

    private boolean isSubclass(IItemQueryModel aModel) {
        IItemType targetType = ((AbstractQueryPathModel)aModel)._implementation.getItemType();
        return ItemUtil.isSubclass(this.getEClassFrom(this._implementation.getItemType()), this.getEClassFrom(targetType));
    }

    public EClass getEClassFrom(AbstractQueryPathModel aType) {
        if (aType instanceof BaseItemQueryModel.ItemQueryModel || aType instanceof BaseItemHandleQueryModel.ItemHandleQueryModel) {
            return RepositoryPackage.eINSTANCE.getItem();
        }
        if (aType instanceof BaseAuditableQueryModel.AuditableQueryModel) {
            return RepositoryPackage.eINSTANCE.getAuditable();
        }
        if (aType instanceof BaseSimpleItemQueryModel.SimpleItemQueryModel) {
            return RepositoryPackage.eINSTANCE.getSimpleItem();
        }
        String msg = NLS.bind("unknown generic query path model: {0}", aType.getClass().getName(), new Object[0]);
        throw new IllegalStateException(msg);
    }

    private EClass getEClassFrom(IItemType aType) {
        EClass aClass = ItemUtil.getEClass(aType.getName(), aType.getNamespaceURI());
        if (ItemUtil.isHandle(aClass)) {
            return ItemUtil.getItemEClass(aClass);
        }
        return aClass;
    }

    private void checkRetargetValidity(IItemQueryModel aModel) {
        if (aModel == null) {
            throw new UnsupportedOperationException("cannot target null!");
        }
        if (!this._implementation.isSingleValueRef()) {
            throw new UnsupportedOperationException("cannot re-target many valued references!");
        }
        if (this._implementation.isRetargeted()) {
            throw new UnsupportedOperationException("illegal target operation!");
        }
        if (!this.isGeneric(this) && !this.isSubclass(aModel)) {
            throw new UnsupportedOperationException("must be of generic type: ItemHandle, Item, Auditable, SimpleItem or target item must be a proper subclass!");
        }
        try {
            aModel.getClass().getField("ROOT");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new UnsupportedOperationException("can only target concrete item types!");
        }
        if (((AbstractQueryPathModel)aModel)._implementation.typeName == null) {
            throw new UnsupportedOperationException("can only target concrete item types!");
        }
    }

    public IItemQueryModel _target(IItemQueryModel aModel) {
        IItemQueryModel newModel;
        this.checkRetargetValidity(aModel);
        StringBuffer b = new StringBuffer();
        IItemType aType = ((AbstractQueryPathModel)aModel)._implementation.getItemType();
        b.append('(').append(aType.getNamespaceURI()).append('#').append(aType.getName()).append(')').append(this._implementation.parentField);
        try {
            newModel = (IItemQueryModel)aModel.getClass().getConstructor(IQueryPath.class, String.class).newInstance(this._implementation.parent, b.toString());
        }
        catch (Exception exception) {
            String msg = NLS.bind("Could not create new query model in _target: {0}", aModel.getClass().getSimpleName(), new Object[0]);
            throw new IllegalStateException(msg);
        }
        return (IItemQueryModel)aModel.getClass().cast(newModel);
    }

    @Override
    public IPredicate _exists(IItemQueryModel aQueryModel, IField lhs, IField rhs, IPredicate aPredicate) {
        Exists anExists = QueryastFactory.eINSTANCE.createExists();
        anExists.setModel(aQueryModel);
        anExists.setLhs(QueryastFactory.eINSTANCE.createFeaturePath(lhs));
        anExists.setRhs(QueryastFactory.eINSTANCE.createFeaturePath(rhs));
        anExists.filter((Predicate)aPredicate);
        return anExists;
    }

    public class Implementation
    implements IQueryPath,
    ISingleItemQueryModel,
    IManyItemQueryModel,
    IDynamicQueryModel,
    IDynamicItemQueryModel,
    IInternalQueryModel {
        private final IQueryPath parent;
        private final String parentField;
        private boolean isSingle = true;
        private String typeName;
        private String nsURI;
        private final List<String> allFieldNames = new ArrayList<String>(10);
        private final List<String> allReferenceNames = new ArrayList<String>(10);
        private final Map<String, IField> allFields = new HashMap<String, IField>(10);

        private Implementation(IQueryPath extent, String parentName) {
            this.parent = extent;
            this.parentField = parentName;
        }

        @Override
        public List getAllFields() {
            return Collections.unmodifiableList(this.allFieldNames);
        }

        @Override
        public List getAllReferences() {
            return Collections.unmodifiableList(this.allReferenceNames);
        }

        @Override
        public IField getField(String name) {
            IField aField = this.allFields.get(name);
            if (aField == null) {
                String msg = NLS.bind("Unknown queryable field: {0}", name, new Object[0]);
                throw new QueryException(msg);
            }
            return aField;
        }

        @Override
        public IDynamicQueryModel getReference(String name) {
            AbstractQueryPathModel aModel = AbstractQueryPathModel.this.getReference(name);
            if (aModel == null) {
                String msg = NLS.bind("Unknown queryable reference: {0}", name, new Object[0]);
                throw new QueryException(msg);
            }
            return aModel._implementation;
        }

        @Override
        public IPredicate _contains(ISingleQueryModel p) {
            return AbstractQueryPathModel.this._contains(p);
        }

        @Override
        public IPredicate _contains(IItemHandle handle) {
            return AbstractQueryPathModel.this._contains(handle);
        }

        @Override
        public IPredicate _contains(IItemHandleInputArg arg) {
            return AbstractQueryPathModel.this._contains(arg);
        }

        @Override
        public IPredicate _eq(IItemHandle handle) {
            return AbstractQueryPathModel.this._eq(handle);
        }

        @Override
        public IPredicate _eq(IItemHandleInputArg inputArg) {
            return AbstractQueryPathModel.this._eq(inputArg);
        }

        @Override
        public IPredicate _isNull() {
            return AbstractQueryPathModel.this._isNull();
        }

        @Override
        public IPredicate _in(IItemHandleInputArg[] list) {
            return AbstractQueryPathModel.this._in(list);
        }

        @Override
        public IPredicate _isTypeOf(IItemType itemType) {
            return AbstractQueryPathModel.this._isTypeOf(itemType);
        }

        @Override
        public IPseudoVariable _itemType() {
            return AbstractQueryPathModel.this._itemType();
        }

        @Override
        public IPredicate _isTypeOf(IItemTypeInputArg itemType) {
            return AbstractQueryPathModel.this._isTypeOf(itemType);
        }

        public IItemQueryModel _target(IItemQueryModel itemType) {
            return AbstractQueryPathModel.this._target(itemType);
        }

        @Override
        public IPredicate _exists(IItemQueryModel aQueryModel, IField lhs, IField rhs, IPredicate aPredicate) {
            return AbstractQueryPathModel.this._exists(aQueryModel, lhs, rhs, aPredicate);
        }

        @Override
        public IPredicate _isEmpty() {
            return AbstractQueryPathModel.this._isEmpty();
        }

        @Override
        public IPredicate _isMissing() {
            return AbstractQueryPathModel.this._isMissing();
        }

        public void setItemType(String name, String nsURI) {
            this.typeName = name;
            this.nsURI = nsURI;
        }

        @Override
        public IItemType getItemType() {
            String pattern = "The type name {0} and the namespace URI {1} do not resolve to an IItemType.";
            if (this.typeName == null || this.nsURI == null) {
                String message = NLS.bind(pattern, this.typeName, this.nsURI);
                throw new IllegalArgumentException(message);
            }
            IItemType itemType = IItemType.IRegistry.INSTANCE.getItemType(this.typeName, this.nsURI);
            if (itemType == null) {
                String message = NLS.bind(pattern, this.typeName, this.nsURI);
                throw new IllegalArgumentException(message);
            }
            return itemType;
        }

        @Override
        public String pathStep() {
            return this.parentField();
        }

        public String parentField() {
            return this.parentField;
        }

        @Override
        public IQueryPath parent() {
            return this.parent;
        }

        @Override
        public boolean isSingleValueRef() {
            return this.isSingle;
        }

        @Override
        public boolean isManyValuedRef() {
            return !this.isSingle;
        }

        public void setSingleValueRef(boolean isSingleValueRef) {
            this.isSingle = isSingleValueRef;
        }

        private boolean isRoot() {
            return this.parent == null;
        }

        @Override
        public IQueryModel getRoot() {
            if (this.isRoot()) {
                return this;
            }
            IQueryPath each = this;
            PathIterator it = this.iterator();
            while (it.hasNext()) {
                each = it.next();
            }
            return each;
        }

        private List getPath() {
            ArrayList<String> aList = new ArrayList<String>();
            if (this.isRoot()) {
                return aList;
            }
            PathIterator it = this.iterator();
            while (it.hasNext()) {
                IQueryPath each = it.next();
                if (each.pathStep() == null) continue;
                aList.add(each.pathStep());
            }
            Collections.reverse(aList);
            return aList;
        }

        @Override
        public String toPathString() {
            if (this.isRoot()) {
                return "";
            }
            StringBuffer b = new StringBuffer();
            Iterator it = this.getPath().iterator();
            while (it.hasNext()) {
                b.append(it.next());
                if (!it.hasNext()) continue;
                b.append('.');
            }
            return b.toString();
        }

        @Override
        public boolean isSingle() {
            if (this.isManyValuedRef()) {
                return false;
            }
            PathIterator it = this.iterator();
            while (it.hasNext()) {
                IQueryPath p = it.next();
                if (!(p instanceof IField) && !p.isManyValuedRef()) continue;
                return false;
            }
            return true;
        }

        private boolean isSameAs(IQueryPath p) {
            IQueryModel r1 = this.getRoot();
            IQueryModel r2 = p.getRoot();
            if (!r1.getClass().equals(r2.getClass())) {
                return false;
            }
            String s1 = this.toPathString();
            String s2 = p.toPathString();
            return s1.equals(s2);
        }

        @Override
        public PathIterator iterator() {
            return new PathIterator(this);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IQueryPath)) {
                return false;
            }
            return this.isSameAs((IQueryPath)obj);
        }

        public int hashCode() {
            Class<?> rootClass = this.getRoot().getClass();
            String pathString = this.toPathString();
            int result = 1;
            result = 31 * result + (rootClass == null ? 0 : rootClass.hashCode());
            result = 31 * result + (pathString == null ? 0 : pathString.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractQueryPathModel.Implementation(" + AbstractQueryPathModel.this.getClass().getSimpleName() + ')';
        }

        @Override
        public Implementation _getImplementation() {
            return this;
        }

        public IField getIdField() {
            if (AbstractQueryPathModel.this.isItem()) {
                return this.getField(RepositoryPackage.eINSTANCE.getItemHandle_ItemId().getName());
            }
            return this.getField(RepositoryPackage.eINSTANCE.getHelper_InternalId().getName());
        }

        public boolean isRetargeted() {
            if (this.parentField == null) {
                return true;
            }
            return this.parentField.charAt(0) == '(';
        }

        @Override
        public IPredicate _eqKeyValue(IString key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, key, string);
        }

        @Override
        public IPredicate _eqKeyValue(String key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, key, string);
        }

        @Override
        public IPredicate _notEqKeyValue(IString key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, key, string);
        }

        @Override
        public IPredicate _notEqKeyValue(String key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, key, string);
        }

        @Override
        public IPredicate _gtKeyValue(IString key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, key, string);
        }

        @Override
        public IPredicate _gtKeyValue(String key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, key, string);
        }

        @Override
        public IPredicate _gtOrEqKeyValue(IString key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, key, string);
        }

        @Override
        public IPredicate _gtOrEqKeyValue(String key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, key, string);
        }

        @Override
        public IPredicate _ltKeyValue(IString key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, key, string);
        }

        @Override
        public IPredicate _ltKeyValue(String key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, key, string);
        }

        @Override
        public IPredicate _ltOrEqKeyValue(IString key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, key, string);
        }

        @Override
        public IPredicate _ltOrEqKeyValue(String key, IFilterElement string) {
            return this.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, key, string);
        }

        @Override
        public IPredicate _isNullValue(String key) {
            IsNullStateExtension isNull = QueryastFactory.eINSTANCE.createIsNullStateExtension();
            Literal keyLit = QueryastFactory.eINSTANCE.createStringLiteral(key);
            isNull.setKey(keyLit);
            isNull.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this));
            return isNull;
        }

        @Override
        public IPredicate _isNullValue(IString key) {
            IsNullStateExtension isNull = QueryastFactory.eINSTANCE.createIsNullStateExtension();
            FilterElement keyElement = QueryastFactory.eINSTANCE.createFilterElement(key);
            isNull.setKey(keyElement);
            isNull.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this));
            return isNull;
        }

        @Override
        public IPredicate _keyExists(String key) {
            KeyExists keyExists = QueryastFactory.eINSTANCE.createKeyExists();
            Literal keyLit = QueryastFactory.eINSTANCE.createStringLiteral(key);
            keyExists.setKey(keyLit);
            keyExists.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this));
            return keyExists;
        }

        @Override
        public IPredicate _keyExists(IString key) {
            KeyExists keyExists = QueryastFactory.eINSTANCE.createKeyExists();
            FilterElement keyElement = QueryastFactory.eINSTANCE.createFilterElement(key);
            keyExists.setKey(keyElement);
            keyExists.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this));
            return keyExists;
        }

        @Override
        public IPredicate _inValues(IString key, IFilterElement[] values) {
            return this.internalInValues(key, values);
        }

        @Override
        public IPredicate _inValues(String key, IFilterElement[] values) {
            return this.internalInValues(key, values);
        }

        private IPredicate internalInValues(Object key, IFilterElement[] values) {
            FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
            InListStateExtension inList = QueryastFactory.eINSTANCE.createInListStateExtension();
            FilterElement keyElement = this.createStringFilterElement(key);
            inList.setField(field);
            inList.setKey(keyElement);
            IFilterElement[] iFilterElementArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                IFilterElement filterElement = iFilterElementArray[n2];
                inList.getValues().add((Object)filterElement);
                ++n2;
            }
            return inList;
        }

        protected FilterElement createStringFilterElement(Object string) {
            IString castString = null;
            if (string instanceof IString) {
                castString = (IString)string;
            } else if (string instanceof String) {
                castString = QueryastFactory.eINSTANCE.createStringLiteral((String)string);
            } else {
                throw new IllegalArgumentException("parameter must be String or IString");
            }
            return QueryastFactory.eINSTANCE.createFilterElement(castString);
        }

        private IPredicate createBasicComparison(ComparisonOp op, Object aKey, IFilterElement stringToCompare) {
            FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
            FilterElement keyElement = this.createStringFilterElement(aKey);
            FilterElement str = QueryastFactory.eINSTANCE.createFilterElement(stringToCompare);
            return QueryastFactory.eINSTANCE.createBasicComparisonStateExtension(op, keyElement, field, str);
        }
    }
}

