/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static String getCommonParentDirectory(List<String> canonicalPaths, char fileSeparator) {
        ArrayList<String[]> canonicalPathElements = new ArrayList<String[]>(canonicalPaths.size());
        for (String canonicalPath : canonicalPaths) {
            String[] pathElements = canonicalPath.split("[\\\\/]");
            canonicalPathElements.add(pathElements);
        }
        int minSize = -1;
        for (String[] pathElement : canonicalPathElements) {
            int pathElementCount = pathElement.length;
            if (minSize == -1) {
                minSize = pathElementCount;
                continue;
            }
            if (pathElementCount >= minSize) continue;
            minSize = pathElementCount;
        }
        StringBuffer commonParentDirectory = new StringBuffer();
        int i = 0;
        while (i < minSize) {
            String commonParentElement = null;
            boolean match = true;
            for (String[] pathElement : canonicalPathElements) {
                String element = pathElement[i];
                if (commonParentElement == null) {
                    commonParentElement = element;
                    continue;
                }
                if (element.equals(commonParentElement)) continue;
                match = false;
                break;
            }
            if (!match) break;
            commonParentDirectory.append(commonParentElement).append(fileSeparator);
            ++i;
        }
        String commonParentDirectoryString = commonParentDirectory.toString();
        int length = commonParentDirectoryString.length();
        if (length == 0) {
            commonParentDirectoryString = null;
        } else if (length > 1 && minSize > 1 && fileSeparator == commonParentDirectoryString.charAt(length - 1)) {
            commonParentDirectoryString = commonParentDirectoryString.substring(0, length - 1);
        }
        return commonParentDirectoryString;
    }
}

