/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate.interceptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.CallbackException;
import org.hibernate.EntityMode;
import org.hibernate.Interceptor;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedInterceptor
extends ArrayList<Interceptor>
implements Interceptor {
    private static final long serialVersionUID = 1L;

    private List<Object> buildList(Iterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("The parameter iterator must be non-null.");
        }
        ArrayList<Object> entities = new ArrayList<Object>();
        while (iterator.hasNext()) {
            entities.add(iterator.next());
        }
        return entities;
    }

    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        boolean result = false;
        for (Interceptor interceptor : this) {
            if (!interceptor.onLoad(entity, id, state, propertyNames, types)) continue;
            result = true;
        }
        return result;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) throws CallbackException {
        boolean result = false;
        for (Interceptor interceptor : this) {
            if (!interceptor.onFlushDirty(entity, id, currentState, currentState, propertyNames, types)) continue;
            result = true;
        }
        return result;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        boolean result = false;
        for (Interceptor interceptor : this) {
            if (!interceptor.onSave(entity, id, state, propertyNames, types)) continue;
            result = true;
        }
        return result;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        for (Interceptor interceptor : this) {
            interceptor.onDelete(entity, id, state, propertyNames, types);
        }
    }

    public void onCollectionRecreate(Object collection, Serializable key) throws CallbackException {
        for (Interceptor interceptor : this) {
            interceptor.onCollectionRecreate(collection, key);
        }
    }

    public void onCollectionRemove(Object collection, Serializable key) throws CallbackException {
        for (Interceptor interceptor : this) {
            interceptor.onCollectionRemove(collection, key);
        }
    }

    public void onCollectionUpdate(Object collection, Serializable key) throws CallbackException {
        for (Interceptor interceptor : this) {
            interceptor.onCollectionUpdate(collection, key);
        }
    }

    public void preFlush(Iterator iterator) throws CallbackException {
        List<Object> entities = this.buildList(iterator);
        for (Interceptor interceptor : this) {
            interceptor.preFlush(entities.iterator());
        }
    }

    public void postFlush(Iterator iterator) throws CallbackException {
        List<Object> entities = this.buildList(iterator);
        for (Interceptor interceptor : this) {
            interceptor.postFlush(entities.iterator());
        }
    }

    public Boolean isTransient(Object entity) {
        Interceptor interceptor;
        Boolean result = null;
        Iterator i$ = this.iterator();
        while (i$.hasNext() && (result = (interceptor = (Interceptor)i$.next()).isTransient(entity)) == null) {
        }
        return result;
    }

    public int[] findDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        Interceptor interceptor;
        int[] result = null;
        Iterator i$ = this.iterator();
        while (i$.hasNext() && (result = (interceptor = (Interceptor)i$.next()).findDirty(entity, id, currentState, currentState, propertyNames, types)) == null) {
        }
        return result;
    }

    public Object instantiate(String entityName, EntityMode entityMode, Serializable id) throws CallbackException {
        Interceptor interceptor;
        Object result = null;
        Iterator i$ = this.iterator();
        while (i$.hasNext() && (result = (interceptor = (Interceptor)i$.next()).instantiate(entityName, entityMode, id)) == null) {
        }
        return result;
    }

    public String getEntityName(Object object) throws CallbackException {
        Interceptor interceptor;
        String entityName = null;
        Iterator i$ = this.iterator();
        while (i$.hasNext() && (entityName = (interceptor = (Interceptor)i$.next()).getEntityName(object)) == null) {
        }
        return entityName;
    }

    public Object getEntity(String entityName, Serializable id) throws CallbackException {
        Interceptor interceptor;
        Object object = null;
        Iterator i$ = this.iterator();
        while (i$.hasNext() && (object = (interceptor = (Interceptor)i$.next()).getEntity(entityName, id)) == null) {
        }
        return object;
    }

    public void afterTransactionBegin(Transaction tx) {
        for (Interceptor interceptor : this) {
            interceptor.afterTransactionBegin(tx);
        }
    }

    public void beforeTransactionCompletion(Transaction tx) {
        for (Interceptor interceptor : this) {
            interceptor.beforeTransactionCompletion(tx);
        }
    }

    public void afterTransactionCompletion(Transaction tx) {
        for (Interceptor interceptor : this) {
            interceptor.afterTransactionCompletion(tx);
        }
    }

    public String onPrepareStatement(String sql) {
        Interceptor interceptor;
        String result = sql;
        Iterator i$ = this.iterator();
        while (i$.hasNext() && sql.equals(result = (interceptor = (Interceptor)i$.next()).onPrepareStatement(sql))) {
        }
        return result;
    }
}

