/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.sql;

import com.urbancode.sql.LoggingSynchronization;
import com.urbancode.sql.XADataSourceAdapter;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingTransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(XADataSourceAdapter.class);
    private final Transaction delegate;

    LoggingTransaction(Transaction delegate) {
        this.delegate = delegate;
    }

    Transaction getDelegate() {
        return this.delegate;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        if (log.isTraceEnabled()) {
            log.trace("commit()");
        }
        this.delegate.commit();
        if (log.isDebugEnabled()) {
            log.debug("Committed JTA Transaction");
        }
    }

    public boolean delistResource(XAResource xaRes, int flag) throws SystemException {
        if (log.isTraceEnabled()) {
            log.trace("delistResource()");
        }
        if (log.isDebugEnabled()) {
            log.debug("Delisting XA Resource \"" + xaRes + "\"");
        }
        return this.delegate.delistResource(xaRes, flag);
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, SystemException {
        if (log.isDebugEnabled()) {
            log.debug("Enlisting XA Resource \"" + xaRes + "\"");
        }
        return this.delegate.enlistResource(xaRes);
    }

    public int getStatus() throws SystemException {
        if (log.isTraceEnabled()) {
            log.trace("getStatus()");
        }
        return this.delegate.getStatus();
    }

    public void registerSynchronization(Synchronization synch) throws RollbackException, SystemException {
        if (log.isTraceEnabled()) {
            log.trace("registerSynchronization()");
        }
        synch = new LoggingSynchronization(synch);
        this.delegate.registerSynchronization(synch);
    }

    public void rollback() throws SystemException {
        if (log.isTraceEnabled()) {
            log.trace("rollback()");
        }
        this.delegate.rollback();
        if (log.isDebugEnabled()) {
            log.debug("Rolled-back JTA Transaction");
        }
    }

    public void setRollbackOnly() throws SystemException {
        if (log.isTraceEnabled()) {
            log.trace("setRollbackOnly()");
        }
        this.delegate.setRollbackOnly();
    }
}

