/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IHistoricBaselineIterator;
import com.ibm.team.scm.client.internal.BaselinesInHistoryIterator;
import com.ibm.team.scm.client.internal.ClientChangeHistoryProxy;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.client.internal.ConnectionBasedClientConfigurationProxy;
import com.ibm.team.scm.client.internal.ItemPermissionChangeEvent;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineHierarchyResult;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IGenericAttributes;
import com.ibm.team.scm.common.dto.IPermissionContextProvider;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.internal.Baseline;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ComponentHandle;
import com.ibm.team.scm.common.internal.dto.BaselinesInHistoryResult;
import com.ibm.team.scm.common.internal.dto.ServiceHistoryProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineConnection
extends Connection
implements IBaselineConnection {
    protected final IBaselineHandle baselineHandle;
    private final IBaseline baseline;
    private final ClientChangeHistoryProxy changeHistory;
    private final ConnectionBasedClientConfigurationProxy configuration;

    BaselineConnection(WorkspaceManager workspaceManager, IBaseline baseline) {
        super(workspaceManager);
        this.baselineHandle = (IBaselineHandle)baseline.getItemType().createItemHandle((Object)workspaceManager.teamRepository(), baseline.getItemId(), baseline.getStateId());
        this.baseline = baseline;
        this.changeHistory = new ClientChangeHistoryProxy(this, (ComponentHandle)baseline.getComponent(), false);
        this.configuration = new ConnectionBasedClientConfigurationProxy(this, baseline.getComponent());
    }

    @Override
    public IBaselineHandle getBaseline() {
        return this.baselineHandle;
    }

    @Override
    public int getId() {
        return this.baseline.getId();
    }

    @Override
    public IChangeHistory changeHistory() {
        return this.changeHistory;
    }

    @Override
    public IConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public String getName() {
        return this.baseline.getName();
    }

    @Override
    public void setName(String name, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setName(name, null, monitor);
    }

    public void setName(String name, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(5);
            IBaselineHandle handle = this.baselineHandle;
            IBaseline newBaseline = service.setBaselineName(handle, name, BaselineConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(75);
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newBaseline));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public String getComment() {
        return this.baseline.getComment();
    }

    @Override
    public void setComment(String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setComment(comment, null, monitor);
    }

    public void setComment(String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (comment == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(5);
            IBaselineHandle handle = this.baselineHandle;
            IBaseline newBaseline = service.setBaselineComment(handle, comment, BaselineConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(75);
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newBaseline));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IComponentHandle getComponent() {
        return this.baseline.getComponent();
    }

    @Override
    public IChangeHistorySyncReport compareTo(IBaselineHandle otherBaseline, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.compareTo(otherBaseline, null, monitor);
    }

    public IChangeHistorySyncReport compareTo(IBaselineHandle otherBaseline, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (otherBaseline == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IBaselineHandle handle = this.baselineHandle;
            monitor.worked(5);
            SCMClientUtil.checkMonitor(monitor);
            IChangeHistorySyncReport result = service.compareBaselines(handle, otherBaseline, BaselineConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(50);
            SCMClientUtil.checkMonitor(monitor);
            IChangeHistorySyncReport iChangeHistorySyncReport = result;
            return iChangeHistorySyncReport;
        }
        finally {
            monitor.done();
        }
    }

    ChangeHistoryHandle getHistoryHandle() {
        return ((Baseline)this.baseline).getHistory();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IBaselineConnection)) {
            return false;
        }
        IBaselineConnection o = (IBaselineConnection)obj;
        return this.teamRepository() == o.teamRepository() && this.getBaseline().sameItemId((IItemHandle)o.getBaseline());
    }

    public final int hashCode() {
        return this.getBaseline().getItemId().hashCode();
    }

    @Override
    public IBaseline getResolvedBaseline() {
        return this.baseline;
    }

    @Override
    public List changeSetsInHistory(List changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IBaselineHandle handle = this.baselineHandle;
            monitor.worked(5);
            SCMClientUtil.checkMonitor(monitor);
            IChangeSetHandle[] csHandles = changeSets.toArray(new IChangeSetHandle[changeSets.size()]);
            IChangeSetHandle[] result = service.changeSetsInBaseline(handle, csHandles, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(80);
            SCMClientUtil.checkMonitor(monitor);
            List<IChangeSetHandle> list = Arrays.asList(result);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IHistoricBaselineIterator getBaselinesInHistory(int max, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getBaselinesInHistory(max, null, monitor);
    }

    public IHistoricBaselineIterator getBaselinesInHistory(int max, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (max < 1) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(5);
            SCMClientUtil.checkMonitor(monitor);
            BaselinesInHistoryResult result = service.getBaselinesInHistory(ServiceHistoryProvider.FACTORY.create(this.getBaseline()), max, BaselineConnection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(90);
            SCMClientUtil.checkMonitor(monitor);
            BaselinesInHistoryIterator baselinesInHistoryIterator = new BaselinesInHistoryIterator(result, this.workspaceManager);
            return baselinesInHistoryIterator;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IContextHandle getContextHandle() {
        return this.getBaseline();
    }

    private IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }

    @Override
    public void setVersionablePermissions(IVersionableHandle[] versionables, IComponentHandle componentHandle, IPermissionContextProvider contextProvider, IProgressMonitor monitor) throws TeamRepositoryException {
        this.configuration.setVersionablePermissions(versionables, contextProvider, monitor);
        this.queueEvent((Object)new ItemPermissionChangeEvent(this, "item_permission_change_event", versionables, contextProvider.getReadContext()));
    }

    @Override
    public void setCustomAttributes(Map<String, Object> setCustomAttrs, String[] unsetCustomAttributes, IProgressMonitor mon) throws TeamRepositoryException {
        mon = SCMClientUtil.getMonitor(mon, 100);
        try {
            IScmService scm = this.workspaceManager.getServerConfigurationService();
            IGenericAttributes attrs = IGenericAttributes.FACTORY.newInstance(setCustomAttrs);
            IBaseline newBaseline = scm.setBaselineCustomAttributes(this.baselineHandle, attrs, unsetCustomAttributes, null, (IRepositoryProgressMonitorHandle)this.monitorFor(mon));
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newBaseline));
        }
        finally {
            mon.done();
        }
    }

    @Override
    public Map<String, Object> getCustomAttributes() {
        return this.baseline.getCustomAttributes();
    }

    @Override
    public IBaselineHierarchyResult getBaselineHierarchy(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.workspaceManager.getServerConfigurationService().getBaselineHierarchy((IBaselineHandle)this.baseline, (IRepositoryProgressMonitorHandle)this.monitorFor(SCMClientUtil.getMonitor(monitor)));
    }
}

